/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.completion.completers;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import se.ericsson.cello.ncli.server.completion.BaseCompleter;
import se.ericsson.cello.ncli.server.completion.Completer;
import se.ericsson.cello.ncli.server.completion.CompleterFactory;
import se.ericsson.cello.ncli.server.completion.util.CompletionHelper;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.logging.Log;

public class CommandCompleter
extends BaseCompleter {
    protected static final String EXCLMARK = "!";
    protected static final String ACTION = "action";
    protected static final String ALARMS = "alarms";
    protected static final String ALARMSEV = "alarmsev";
    protected static final String CREATE = "create";
    protected static final String EXIT = "exit";
    protected static final String HISTORY = "history";
    protected static final String SEARCH = "search";
    protected static final String SET = "set";
    protected static final String INFO = "info";
    protected static final String GROUP = "group";
    protected static final String MAN = "man";
    protected static final String HELP = "help";
    protected static final String DELETE = "delete";
    protected static final String RM = "rm";
    protected static final String GET = "get";
    protected static final String LS = "ls";
    protected static final String JUMP = "jump";
    protected static final String CD = "cd";
    protected static final String PWLDN = "pwldn";
    protected static final String PWD = "pwd";
    protected static final String DIFF = "diff";
    protected static final String TX = "tx";
    protected Hashtable cmdHashtable = new Hashtable();

    public CommandCompleter(NodeServices nodeServices) {
        super(nodeServices);
        this.cmdHashtable.put(EXCLMARK, CompleterFactory.createNotSupportedCompleter(this.nodeServices));
        this.cmdHashtable.put(ACTION, CompleterFactory.createCmdActionCompleter(this.nodeServices));
        this.cmdHashtable.put(ALARMS, CompleterFactory.createNotSupportedCompleter(this.nodeServices));
        this.cmdHashtable.put(CREATE, CompleterFactory.createCmdCreateCompleter(this.nodeServices));
        this.cmdHashtable.put(EXIT, CompleterFactory.createNotSupportedCompleter(this.nodeServices));
        this.cmdHashtable.put(INFO, CompleterFactory.createCmdInfoCompleter(this.nodeServices));
        this.cmdHashtable.put(HISTORY, CompleterFactory.createNotSupportedCompleter(this.nodeServices));
        this.cmdHashtable.put(SEARCH, CompleterFactory.createCmdSearchCompleter(this.nodeServices));
        this.cmdHashtable.put(SET, CompleterFactory.createCmdSetCompleter(this.nodeServices));
        this.cmdHashtable.put(GROUP, CompleterFactory.createCmdGroupCompleter(this.nodeServices));
        this.cmdHashtable.put(DIFF, CompleterFactory.createCmdDiffCompleter(this.nodeServices));
        this.cmdHashtable.put(TX, CompleterFactory.createTxCompleter(this.nodeServices));
        this.cmdHashtable.put(EXIT, CompleterFactory.createExitCompleter(this.nodeServices));
        this.cmdHashtable.put(MAN, CompleterFactory.createCmdManCompleter(this.nodeServices));
        this.cmdHashtable.put(HELP, CompleterFactory.createCmdManCompleter(this.nodeServices));
        this.cmdHashtable.put(DELETE, CompleterFactory.createCmdDeleteCompleter(this.nodeServices));
        this.cmdHashtable.put(RM, CompleterFactory.createCmdDeleteCompleter(this.nodeServices));
        this.cmdHashtable.put(GET, CompleterFactory.createCmdGetCompleter(this.nodeServices));
        this.cmdHashtable.put(LS, CompleterFactory.createCmdGetCompleter(this.nodeServices));
        this.cmdHashtable.put(JUMP, CompleterFactory.createCmdJumpCompleter(this.nodeServices));
        this.cmdHashtable.put(CD, CompleterFactory.createCmdJumpCompleter(this.nodeServices));
        this.cmdHashtable.put(PWLDN, CompleterFactory.createNotSupportedCompleter(this.nodeServices));
        this.cmdHashtable.put(PWD, CompleterFactory.createNotSupportedCompleter(this.nodeServices));
        this.cmdHashtable.put(ALARMSEV, CompleterFactory.createCmdAlarmSevCompleter(this.nodeServices));
    }

    public void completeString(String string) {
        Log.trace(CommandCompleter.class, "completeString(" + string + ")");
        this.completedString = "";
        this.completionOptionList = new ArrayList();
        if (string == null || string.length() == 0) {
            Enumeration enumeration = this.cmdHashtable.keys();
            while (enumeration.hasMoreElements()) {
                this.completionOptionList.add(enumeration.nextElement());
            }
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        String string2 = stringTokenizer.nextToken();
        Log.trace(CommandCompleter.class, "nrOfTokens=" + n);
        Log.trace(CommandCompleter.class, "firstToken=" + string2);
        if (n <= 1) {
            this.completeFirstAndOnlyToken(string2, string);
        } else {
            this.delegateCompletion(string2, string);
        }
    }

    protected void completeFirstAndOnlyToken(String string, String string2) {
        Log.trace(CommandCompleter.class, "completeFirstAndOnlyToken(). First token ='" + string + "'");
        if (string2.endsWith(" ")) {
            this.delegateCompletion(string, string2);
            return;
        }
        String string3 = string.toLowerCase();
        Enumeration enumeration = this.cmdHashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (!string4.startsWith(string3)) continue;
            this.completionOptionList.add(string4);
        }
        if (this.completionOptionList.size() == 0) {
            this.completedString = string2;
        } else if (this.completionOptionList.size() == 1) {
            this.completedString = ((String)this.completionOptionList.get(0)).concat(" ");
            this.completionOptionList.clear();
        } else if (this.completionOptionList.size() > 1) {
            this.completedString = CompletionHelper.getCommonStartStr(this.completionOptionList, string2);
        }
    }

    protected void delegateCompletion(String string, String string2) {
        Log.trace(CommandCompleter.class, "delegateCompletion(). First token ='" + string + "'");
        String string3 = string.toLowerCase();
        Completer completer = (Completer)this.cmdHashtable.get(string3);
        if (completer == null) {
            this.completedString = string2;
        } else {
            completer.completeString(string2);
            this.completedString = completer.getCompletedString();
            this.completionOptionList = completer.getCompletionOptionList();
        }
    }
}

