/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pdhsdhtrans;

import enea.ose.system.Signal;
import se.ericsson.cello.common.fropxy.FroLockInd;
import se.ericsson.cello.common.fropxy.MoNotifiable;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroNotLockedException;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoNotPossibleToReserveException;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.pdhsdhtrans.AtmPortBuildIF;
import se.ericsson.cello.pdhsdhtrans.Ds0BundleBuildIF;
import se.ericsson.cello.pdhsdhtrans.ExchangeTerminalMoImpl;
import se.ericsson.cello.pdhsdhtrans.ImaLinkBuildIF;
import se.ericsson.cello.pdhsdhtrans.ImaReservable;
import se.ericsson.cello.pdhsdhtrans.J1PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.PDHPhysPathTermInfo;
import se.ericsson.cello.pdhsdhtrans.PhysPathTermConstants;
import se.ericsson.cello.pdhsdhtrans.PhysPathTermRepositoryImpl;
import se.ericsson.cello.pdhsdhtrans.PhysValidator;
import se.ericsson.cello.pdhsdhtrans.TrafficReservable;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyJ1MiAutoLockInd;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyJ1MiCreateRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyJ1MiDeleteRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyJ1MiGetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyJ1MiLockRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyJ1MiSetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyJ1MiShutDownRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyJ1MiUnlockRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyJ1Proxy;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.sync.PDHSyncReference;
import se.ericsson.cello.sync.SyncReservable;
import se.ericsson.cello.transaction.Coordinator;

public class J1PhysPathTermMoImpl
extends CelloMao
implements J1PhysPathTermMo,
PhysPathTermConstants,
MoNotifiable,
PDHPhysPathTermInfo,
TrafficReservable,
SyncReservable,
ImaReservable,
PDHSyncReference {
    private static final Class[] reservedClassesForReserve = new Class[]{ImaLinkBuildIF.class};
    private static final Class[] reservedClassesForTrafficReserve = new Class[]{AtmPortBuildIF.class};
    private static final String PHY_PORT_FRO_ID = "phyPortFroId";
    private MoData data;
    private StringAttribute userLabel;
    private ReferenceAttribute reservedByTraffic;
    private ReferenceAttribute reservedBySync;
    private ReferenceAttribute reservedByImaLink;
    private IntegerAttribute phyPortFroId;
    private static PhyJ1Proxy phyJ1Proxy = PhyJ1Proxy.instance();
    private static NotificationSender notificationSender = NotificationSender.instance();
    private static PhysPathTermRepositoryImpl repository = PhysPathTermRepositoryImpl.instance();
    private static final int MO_DATA_REVISION_2_5_1 = 0;
    private static final int MO_DATA_REVISION_2_6 = 1;
    private static final int MO_DATA_REVISION_311 = 3000;
    private static final int MO_DATA_REVISION_3111 = 3001;
    private static final int MO_DATA_REVISION_3400 = 3400;
    private static final int MO_DATA_REVISION_3500 = 3500;
    private static final int MO_DATA_REVISION_LATEST = 3500;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"ExchangeTerminal");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"J1PhysPathTerm", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"lineNo", (AttrList)attrList, (boolean)true, (int)0, (int)0, (int)Integer.MAX_VALUE, (String)"J1PhysPathTerm");
        PhysValidator.checkPhysPath(managedObject, "J1PhysPathTerm", n, coordinator);
        J1PhysPathTermMoImpl.checkNumberOfPhysPaths();
        MoAttributeValidator.checkIdentity((String)"J1PhysPathTerm", (String)string);
        int n2 = J1PhysPathTermMoImpl.checkAndGetPhysicalLineType(attrList);
        int n3 = J1PhysPathTermMoImpl.checkAndGetDegThreshold(attrList);
        int n4 = J1PhysPathTermMoImpl.checkAndGetLoopback(attrList);
        int n5 = J1PhysPathTermMoImpl.checkAndGetAdministrativeState(attrList);
        int n6 = J1PhysPathTermMoImpl.checkAndGetIdlePattern(attrList);
        boolean bl = J1PhysPathTermMoImpl.checkAndGetRdiReporting(attrList);
        boolean bl2 = J1PhysPathTermMoImpl.checkAndGetAisReporting(attrList);
        int n7 = J1PhysPathTermMoImpl.checkAndGetShutDownTimeout(attrList);
        J1PhysPathTermMoImpl.checkOtherAttributes(attrList);
        return new J1PhysPathTermMoImpl(managedObject, string, string2, n, n2, n3, n4, n5, n6, bl, bl2, n7, coordinator);
    }

    private J1PhysPathTermMoImpl(ManagedObject managedObject, String string, String string2, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, int n7, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "J1PhysPathTerm", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedByTraffic = new ReferenceAttribute("reservedByTraffic", false);
        this.reservedByTraffic.setValue(null);
        this.data.registerPersistentAttr((Attribute)this.reservedByTraffic);
        this.reservedBySync = new ReferenceAttribute("reservedBySync", false);
        this.reservedBySync.setValue(null);
        this.data.registerPersistentAttr((Attribute)this.reservedBySync);
        this.reservedByImaLink = new ReferenceAttribute("reservedByImaLink", false);
        this.reservedByImaLink.setValue(null);
        this.data.registerPersistentAttr((Attribute)this.reservedByImaLink);
        if (n5 != 0 && n4 != 0) {
            throw new FroNotLockedException("J1PhysPathTerm", "AdministrativeState need to be locked when setting with loopback enabled");
        }
        PhysValidator.checkPhysPathIdlePattern(this, n6, "J1PhysPathTerm", coordinator);
        int n8 = ((ExchangeTerminalMoImpl)managedObject).getFroId(coordinator);
        int n9 = this.createPhyJ1PortFro(coordinator, n8, n, n2, n3, MaoFroTypeConverter.boolean2int((boolean)bl2), MaoFroTypeConverter.boolean2int((boolean)bl), n6, n4, n5, n7);
        this.phyPortFroId = new IntegerAttribute(PHY_PORT_FRO_ID, false, n9);
        this.data.registerPersistentAttr((Attribute)this.phyPortFroId);
        phyJ1Proxy.registerForNotifications(coordinator, this, this.phyPortFroId.getValue(coordinator));
        this.data.setRevision(3500);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        repository.register(n9, this, coordinator);
    }

    public J1PhysPathTermMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3500);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(PHY_PORT_FRO_ID);
        moDataRecoveryHelper.assertAttribute("reservedByTraffic");
        moDataRecoveryHelper.assertAttribute("reservedBySync");
        moDataRecoveryHelper.assertAttribute("reservedByImaLink");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.phyPortFroId = (IntegerAttribute)this.data.getAttribute(PHY_PORT_FRO_ID);
        this.reservedByTraffic = (ReferenceAttribute)this.data.getAttribute("reservedByTraffic");
        this.reservedBySync = (ReferenceAttribute)this.data.getAttribute("reservedBySync");
        this.reservedByImaLink = (ReferenceAttribute)this.data.getAttribute("reservedByImaLink");
        phyJ1Proxy.registerForNotifications(null, this, this.phyPortFroId.getValue(null));
        repository.register(this.phyPortFroId.getValue(null), this);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.reservedByTraffic.getValue(coordinator) != null || this.reservedBySync.getValue(coordinator) != null || this.reservedByImaLink.getValue(coordinator) != null) {
            throw new MoReservedNotDeletableException("J1PhysPathTerm");
        }
        this.sendDelete(coordinator);
        phyJ1Proxy.deregisterForNotifications(coordinator, this.phyPortFroId.getValue(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
        repository.remove(this.phyPortFroId.getValue(coordinator), coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"J1PhysPathTerm", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getLineNo(Coordinator coordinator) throws MoAccessException {
        return this.getPhyJ1Attribute(coordinator, 21) + 1;
    }

    public int getPhysicalLineType(Coordinator coordinator) throws MoAccessException {
        return this.getPhyJ1Attribute(coordinator, 31);
    }

    public void setPhysicalLineType(int n, Coordinator coordinator) throws MoAccessException {
        if (n < 0 || n > 1) {
            throw new ValueOutOfRangeException("physicalLineType", "J1PhysPathTerm");
        }
        this.setPhyJ1Attributes(coordinator, 31, n);
        String[] stringArray = new String[]{"physicalLineType"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return this.getPhyJ1Attribute(coordinator, 2);
    }

    public int getSyncState(Coordinator coordinator) throws MoAccessException {
        return this.getPhyJ1Attribute(coordinator, 34);
    }

    public ManagedObject getReservedByTraffic(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedByTraffic.getValue(coordinator);
    }

    public ManagedObject getReservedBySync(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedBySync.getValue(coordinator);
    }

    public ManagedObject getReservedByImaLink(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedByImaLink.getValue(coordinator);
    }

    public int getDegThreshold(Coordinator coordinator) throws MoAccessException {
        return this.getPhyJ1Attribute(coordinator, 30);
    }

    public void setDegThreshold(int n, Coordinator coordinator) throws MoAccessException {
        if (n < 3 || n > 9) {
            throw new ValueOutOfRangeException("degThreshold", "J1PhysPathTerm");
        }
        this.setPhyJ1Attributes(coordinator, 30, n);
        String[] stringArray = new String[]{"degThreshold"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getLoopback(Coordinator coordinator) throws MoAccessException {
        return this.getPhyJ1Attribute(coordinator, 22);
    }

    public void setLoopback(int n, Coordinator coordinator) throws MoAccessException {
        if (this.getAdministrativeState(coordinator) != 0 && n != 0) {
            throw new FroNotLockedException("J1PhysPathTerm", "AdministrativeState need to be locked when setting with loopback enabled");
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new ValueOutOfRangeException("loopback", "J1PhysPathTerm");
        }
        this.setPhyJ1Attributes(coordinator, 22, n);
        String[] stringArray = new String[]{"loopback"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return this.getPhyJ1Attribute(coordinator, 1);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n == 0) {
            this.lockJ1PhyPort(coordinator);
        } else if (n == 1) {
            this.unlockJ1PhyPort(coordinator);
        } else if (n == 2) {
            this.shutDownJ1PhyPort(coordinator);
        } else {
            throw new ValueOutOfRangeException("administrativeState", "J1PhysPathTerm");
        }
        String[] stringArray = new String[]{"administrativeState"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return AvailConverter.convert((int)this.getPhyJ1Attribute(coordinator, 3));
    }

    public int getPmEs(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmEs", coordinator);
    }

    public int getPmSes(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmSes", coordinator);
    }

    public int getPmUas(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmUas", coordinator);
    }

    public int getIdlePattern(Coordinator coordinator) throws MoAccessException {
        return this.getPhyJ1Attribute(coordinator, 29);
    }

    public void setIdlePattern(int n, Coordinator coordinator) throws MoAccessException {
        if (n != 0 && n != 1 && n != 2) {
            throw new ValueOutOfRangeException("idlePattern", "J1PhysPathTerm");
        }
        if (n != 0) {
            PhysValidator.checkPhysPathIdlePattern(this, n, "J1PhysPathTerm", coordinator);
        }
        this.setPhyJ1Attributes(coordinator, 29, n);
        String[] stringArray = new String[]{"idlePattern"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public boolean getRdiReporting(Coordinator coordinator) throws MoAccessException {
        return MaoFroTypeConverter.int2boolean((int)this.getPhyJ1Attribute(coordinator, 27));
    }

    public void setRdiReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setPhyJ1Attributes(coordinator, 27, MaoFroTypeConverter.boolean2int((boolean)bl));
        String[] stringArray = new String[]{"rdiReporting"};
        Object[] objectArray = new Object[]{bl};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public boolean getAisReporting(Coordinator coordinator) throws MoAccessException {
        return MaoFroTypeConverter.int2boolean((int)this.getPhyJ1Attribute(coordinator, 26));
    }

    public void setAisReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setPhyJ1Attributes(coordinator, 26, MaoFroTypeConverter.boolean2int((boolean)bl));
        String[] stringArray = new String[]{"aisReporting"};
        Object[] objectArray = new Object[]{bl};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getShutDownTimeout(Coordinator coordinator) throws MoAccessException {
        return this.getPhyJ1Attribute(coordinator, 35);
    }

    public void setShutDownTimeout(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkIntegerAttribute((String)"shutDownTimeout", (int)n, (int)0, (int)100000, (String)"J1PhysPathTerm");
        this.setPhyJ1Attributes(coordinator, 35, n);
        String[] stringArray = new String[]{"shutDownTimeout"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public String getType() {
        return "J1PhysPathTerm";
    }

    private static void checkNumberOfPhysPaths() throws MoAccessException {
        String[] stringArray = new String[]{"E1PhysPathTerm", "J1PhysPathTerm", "T1PhysPathTerm"};
        MoAttributeValidator.checkNumberOfMoTypes((String)"J1PhysPathTerm", (String[])stringArray, (int)900);
    }

    private static int checkAndGetPhysicalLineType(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("physicalLineType");
        if (n == -1) {
            return 0;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("physicalLineType", "J1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 != 0 && n2 != 1) {
            throw new ValueOutOfRangeException("physicalLineType", "J1PhysPathTerm");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static int checkAndGetDegThreshold(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("degThreshold");
        if (n == -1) {
            return 6;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("degThreshold", "J1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 < 3 || n2 > 9) {
            throw new ValueOutOfRangeException("degThreshold", "J1PhysPathTerm");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static int checkAndGetLoopback(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("loopback");
        if (n == -1) {
            return 0;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("loopback", "J1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new ValueOutOfRangeException("loopback", "J1PhysPathTerm");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static int checkAndGetAdministrativeState(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("administrativeState");
        if (n == -1) {
            return 0;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("administrativeState", "J1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new ValueOutOfRangeException("administrativeState", "J1PhysPathTerm");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static int checkAndGetIdlePattern(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("idlePattern");
        if (n == -1) {
            return 0;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("idlePattern", "J1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 != 0 && n2 != 2 && n2 != 1) {
            throw new ValueOutOfRangeException("idlePattern", "J1PhysPathTerm");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static boolean checkAndGetRdiReporting(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("rdiReporting");
        if (n == -1) {
            return false;
        }
        if (!(attrList.getValue(n) instanceof Boolean)) {
            throw new WrongAttributeTypeException("rdiReporting", "J1PhysPathTerm");
        }
        boolean bl = (Boolean)attrList.getValue(n);
        attrList.removeElementAt(n);
        return bl;
    }

    private static boolean checkAndGetAisReporting(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("aisReporting");
        if (n == -1) {
            return false;
        }
        if (!(attrList.getValue(n) instanceof Boolean)) {
            throw new WrongAttributeTypeException("aisReporting", "J1PhysPathTerm");
        }
        boolean bl = (Boolean)attrList.getValue(n);
        attrList.removeElementAt(n);
        return bl;
    }

    private static int checkAndGetShutDownTimeout(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("shutDownTimeout");
        if (n == -1) {
            return 1800;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("shutDownTimeout", "J1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        MoAttributeValidator.checkIntegerAttribute((String)"shutDownTimeout", (int)n2, (int)0, (int)100000, (String)"J1PhysPathTerm");
        attrList.removeElementAt(n);
        return n2;
    }

    private static void checkOtherAttributes(AttrList attrList) throws NoSuchAttributeException {
        long l = attrList.size();
        if (l != 0L) {
            throw new NoSuchAttributeException(attrList.getName(0), "J1PhysPathTerm");
        }
    }

    private void sendDelete(Coordinator coordinator) throws MoAccessException {
        PhyJ1MiDeleteRsp phyJ1MiDeleteRsp = phyJ1Proxy.sendPhyJ1MiDeleteReq(coordinator.getTransactionID(), this.phyPortFroId.getValue(coordinator));
        this.checkSignal((Signal)phyJ1MiDeleteRsp);
        if (phyJ1MiDeleteRsp.getResult() != 0) {
            throw new FroRequestFailedException("J1PhysPathTerm", "J1PhysicalPortFro", "DeleteFroReq: " + phyJ1Proxy.getResultMsg(phyJ1MiDeleteRsp.getResult()), phyJ1MiDeleteRsp.getResult());
        }
    }

    private int getPhyJ1Attribute(Coordinator coordinator, int n) throws MoAccessException {
        int n2 = 0;
        if (coordinator != null) {
            n2 = coordinator.getTransactionID();
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyJ1MiGetAttributeRsp phyJ1MiGetAttributeRsp = phyJ1Proxy.sendPhyJ1MiGetAttributeReq(n2, this.phyPortFroId.getValue(coordinator), n);
        this.checkSignal((Signal)phyJ1MiGetAttributeRsp);
        if (phyJ1MiGetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("J1PhysPathTerm", "J1PhysicalPortFro", "GetAttrReq: " + phyJ1Proxy.getResultMsg(phyJ1MiGetAttributeRsp.getResult()), phyJ1MiGetAttributeRsp.getResult());
        }
        return phyJ1MiGetAttributeRsp.getValue();
    }

    private void setPhyJ1Attributes(Coordinator coordinator, int n, int n2) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PhyJ1MiSetAttributeRsp phyJ1MiSetAttributeRsp = phyJ1Proxy.sendPhyJ1MiSetAttributeReq(coordinator.getTransactionID(), this.phyPortFroId.getValue(coordinator), n, n2);
        this.checkSignal((Signal)phyJ1MiSetAttributeRsp);
        if (phyJ1MiSetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("J1PhysPathTerm", "J1PhysicalPortFro", "GetAttrReq: " + phyJ1Proxy.getResultMsg(phyJ1MiSetAttributeRsp.getResult()), phyJ1MiSetAttributeRsp.getResult());
        }
    }

    private void lockJ1PhyPort(Coordinator coordinator) throws MoAccessException {
        PhyJ1MiLockRsp phyJ1MiLockRsp = phyJ1Proxy.sendPhyJ1MiLockReq(coordinator.getTransactionID(), this.phyPortFroId.getValue(coordinator));
        this.checkSignal((Signal)phyJ1MiLockRsp);
        if (phyJ1MiLockRsp.getResult() != 0) {
            throw new FroRequestFailedException("J1PhysPathTerm", "J1PhysicalPortFro", "ActionReq: " + phyJ1Proxy.getResultMsg(phyJ1MiLockRsp.getResult()), phyJ1MiLockRsp.getResult());
        }
    }

    private void unlockJ1PhyPort(Coordinator coordinator) throws MoAccessException {
        PhyJ1MiUnlockRsp phyJ1MiUnlockRsp = phyJ1Proxy.sendPhyJ1MiUnlockReq(coordinator.getTransactionID(), this.phyPortFroId.getValue(coordinator));
        this.checkSignal((Signal)phyJ1MiUnlockRsp);
        if (phyJ1MiUnlockRsp.getResult() != 0) {
            throw new FroRequestFailedException("J1PhysPathTerm", "J1PhysicalPortFro", "ActionReq: " + phyJ1Proxy.getResultMsg(phyJ1MiUnlockRsp.getResult()), phyJ1MiUnlockRsp.getResult());
        }
    }

    private void shutDownJ1PhyPort(Coordinator coordinator) throws MoAccessException {
        PhyJ1MiShutDownRsp phyJ1MiShutDownRsp = phyJ1Proxy.sendPhyJ1MiShutDownReq(coordinator.getTransactionID(), this.phyPortFroId.getValue(coordinator));
        this.checkSignal((Signal)phyJ1MiShutDownRsp);
        if (phyJ1MiShutDownRsp.getResult() != 0) {
            throw new FroRequestFailedException("J1PhysPathTerm", "J1PhysicalPortFro", "ActionReq: " + phyJ1Proxy.getResultMsg(phyJ1MiShutDownRsp.getResult()), phyJ1MiShutDownRsp.getResult());
        }
    }

    public void trafficReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        if (managedObject == null) {
            MessageLog.traceError(this.getClass(), (String)"trafficReserve: userId == null()", null);
            throw new InvalidReferenceException("J1PhysPathTerm", "Refered MO is null");
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.reservedByImaLink.getValue(coordinator) != null) {
            throw new MoNotPossibleToReserveException("has been reserved by ImaLink", this.getType());
        }
        if (this.getChildren().hasMoreElements()) {
            throw new MoNotPossibleToReserveException("has Ds0Bundle children", this.getType());
        }
        this.reservedByTraffic = ReservableImpl.trafficReserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"J1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedByTraffic, (Class[])reservedClassesForTrafficReserve);
    }

    public void trafficRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reservedByTraffic = ReservableImpl.trafficRelease((ManagedObject)managedObject, (Coordinator)coordinator, (String)"J1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedByTraffic, (Class[])reservedClassesForTrafficReserve);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.phyPortFroId.getValue(coordinator);
    }

    private boolean checkChildren(Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!(managedObject instanceof Ds0BundleBuildIF)) continue;
            if (((Ds0BundleBuildIF)managedObject).getReservedBy(coordinator) != null) {
                ManagedObject managedObject2 = ((Ds0BundleBuildIF)managedObject).getReservedBy(coordinator);
                return !(managedObject2 instanceof AtmPortBuildIF);
            }
            return true;
        }
        return false;
    }

    public void syncReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reservedBySync = ReservableImpl.syncReserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"J1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedBySync);
    }

    public void syncRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reservedBySync = ReservableImpl.syncRelease((ManagedObject)managedObject, (Coordinator)coordinator, (String)"J1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedBySync);
    }

    public synchronized void parameterChanged(FroLockInd froLockInd, String string) {
        if (froLockInd instanceof PhyJ1MiAutoLockInd) {
            String[] stringArray = new String[]{"administrativeState"};
            Object[] objectArray = new Object[]{new Integer(0)};
            notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray);
            AlarmManager.getReporter().reportEvent(38, (ManagedObject)this, "", "", null);
        }
    }

    private int createPhyJ1PortFro(Coordinator coordinator, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PhyJ1MiCreateRsp phyJ1MiCreateRsp = phyJ1Proxy.sendPhyJ1MiCreateReq(coordinator.getTransactionID(), n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
        this.checkSignal((Signal)phyJ1MiCreateRsp);
        if (phyJ1MiCreateRsp.getResult() != 0) {
            throw new FroRequestFailedException("J1PhysPathTerm", "J1PhysicalPortFro", "CreateFroReq: " + phyJ1Proxy.getResultMsg(phyJ1MiCreateRsp.getResult()), phyJ1MiCreateRsp.getResult());
        }
        return phyJ1MiCreateRsp.getFroId();
    }

    private void checkSignal(Signal signal) throws MoAccessException {
        if (signal == null) {
            throw new FroNotAccessibleException("J1PhysPathTerm", "J1PhysPathTermMo");
        }
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject == null) {
            MessageLog.traceError(this.getClass(), (String)"reserve: userId is null", null);
            throw new InvalidReferenceException("J1PhysPathTerm", "Referred MO is null");
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.reservedByTraffic.getValue(coordinator) != null) {
            throw new MoNotPossibleToReserveException("has been reserved by AtmPort", this.getType());
        }
        if (this.checkChildren(coordinator)) {
            throw new MoNotPossibleToReserveException("has Ds0Bundle children", this.getType());
        }
        this.reservedByImaLink = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"J1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedByImaLink, (Class[])reservedClassesForReserve);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedByImaLink = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"J1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedByImaLink, (Class[])reservedClassesForReserve);
    }
}

