/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pdhsdhtrans;

import se.ericsson.cello.common.fropxy.FroLockInd;
import se.ericsson.cello.common.fropxy.MoNotifiable;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.FroNotLockedException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.pdhsdhtrans.AtmPortBuildIF;
import se.ericsson.cello.pdhsdhtrans.ExchangeTerminalMoImpl;
import se.ericsson.cello.pdhsdhtrans.PhysPathTermInfo;
import se.ericsson.cello.pdhsdhtrans.PhysPathTermRepositoryImpl;
import se.ericsson.cello.pdhsdhtrans.PhysValidator;
import se.ericsson.cello.pdhsdhtrans.T3PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.TrafficReservable;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT3MiAutoLockInd;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT3MiCreateRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT3MiDeleteRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT3MiGetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT3MiSetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT3Proxy;
import se.ericsson.cello.sync.PDHSyncReference;
import se.ericsson.cello.sync.SyncReservable;
import se.ericsson.cello.sync.SynchronizationMo;
import se.ericsson.cello.transaction.Coordinator;

public class T3PhysPathTermMoImpl
extends CelloMao
implements T3PhysPathTermMo,
TrafficReservable,
SyncReservable,
PhysPathTermInfo,
MoNotifiable,
FroInfo,
PDHSyncReference {
    private static final int PHY_HPDH_EQUIPMENT_ID = 0;
    private static final int PHY_HPDH_LINE_NUMBER = 1;
    private static final int PHY_HPDH_LOOPBACK_MODE = 2;
    private static final int PHY_HPDH_ADMIN_STATE = 3;
    private static final int PHY_HPDH_DEG_DEGTHR = 4;
    private static final int PHY_HPDH_DEG_DEGM = 5;
    private static final int PHY_HPDH_AIS_REPORTING = 6;
    private static final int PHY_HPDH_RDI_REPORTING = 7;
    private static final int PHY_HPDH_OPER_STATE = 8;
    private static final int PHY_HPDH_AVAIL_STATE = 9;
    private static final int PHY_HPDH_SYNC_STATE = 10;
    private static final int PHY_HPDH_TIMEOUT = 11;
    private static final int SHUT_DOWN_TIMEOUT_MIN = 0;
    private static final int SHUT_DOWN_TIMEOUT_DEFAULT = 1800;
    private static final int SHUT_DOWN_TIMEOUT_MAX = 100000;
    private static final int LINE_NO_MIN = 1;
    private static final int LINE_NO_MAX = 2;
    private static final int PHY_HPDHRESULT_OK = 0;
    private static final Class[] atmPortReserver = new Class[]{AtmPortBuildIF.class};
    private static final Class[] syncReserver = new Class[]{SynchronizationMo.class};
    private MoData data;
    private static final int MO_DATA_REVISION_43 = 4300;
    private static final int MO_DATA_REVISION_LATEST = 4300;
    private static PhyT3Proxy phyT3Proxy = PhyT3Proxy.instance();
    private static NotificationSender notificationSender = NotificationSender.instance();
    private static PhysPathTermRepositoryImpl repository = PhysPathTermRepositoryImpl.instance();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"ExchangeTerminal");
        MoAttributeValidator.checkIdentity((String)"T3PhysPathTerm", (String)string);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)2, (String)"T3PhysPathTerm");
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"shutDownTimeout", (AttrList)attrList, (boolean)false, (int)1800, (int)0, (int)100000, (String)"T3PhysPathTerm");
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"lineNo", (AttrList)attrList, (boolean)true, (int)0, (int)0, (int)Integer.MAX_VALUE, (String)"T3PhysPathTerm");
        PhysValidator.checkPhysPath(managedObject, "T3PhysPathTerm", n3, coordinator);
        int n4 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"loopback", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)2, (String)"T3PhysPathTerm");
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"aisReporting", (AttrList)attrList, (boolean)false, (boolean)false, (String)"T3PhysPathTerm");
        boolean bl2 = MoAttributeValidator.checkAndGetBooleanAttribute((String)"rdiReporting", (AttrList)attrList, (boolean)false, (boolean)false, (String)"T3PhysPathTerm");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"T3PhysPathTerm", (int)128, (int)0);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"T3PhysPathTerm");
        return new T3PhysPathTermMoImpl(managedObject, string, n, n2, n3, n4, bl, bl2, string2, coordinator);
    }

    private T3PhysPathTermMoImpl(ManagedObject managedObject, String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2, String string2, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "T3PhysPathTerm", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        if (n != 0 && n4 != 0) {
            throw new FroNotLockedException("T3PhysPathTerm", "AdministrativeState need to be locked when setting with loopback enabled");
        }
        int n5 = this.createT3PhysPathTermFro(coordinator, n3, bl, bl2, n4, n, n2);
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n5));
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("reservedByTraffic", false, null));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("reservedBySync", false, null));
        phyT3Proxy.registerForNotifications(coordinator, this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator));
        this.data.setRevision(4300);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        repository.register(n5, this, coordinator);
    }

    public T3PhysPathTermMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(4300);
        moDataRecoveryHelper.assertAttribute("reservedByTraffic");
        moDataRecoveryHelper.assertAttribute("reservedBySync");
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("userLabel");
        int n = ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null);
        phyT3Proxy.registerForNotifications(null, this, n);
        repository.register(n, this);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedByTraffic(coordinator) != null || this.getReservedBySync(coordinator) != null) {
            throw new MoReservedNotDeletableException("T3PhysPathTerm");
        }
        phyT3Proxy.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        this.deleteT3PhysPathTermFro(coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
        repository.remove(this.getFroId(coordinator), coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("administrativeState", new Integer(n), coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public String getT3PhysPathTermId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute(this.getType() + "Id", coordinator);
    }

    public int getShutDownTimeout(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("shutDownTimeout", coordinator);
    }

    public void setShutDownTimeout(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("shutDownTimeout", new Integer(n), coordinator);
    }

    public int getLoopback(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("loopback", coordinator);
    }

    public void setLoopback(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("loopback", new Integer(n), coordinator);
    }

    public boolean getAisReporting(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("aisReporting", coordinator);
    }

    public void setAisReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("aisReporting", bl, coordinator);
    }

    public boolean getRdiReporting(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("rdiReporting", coordinator);
    }

    public void setRdiReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("rdiReporting", bl, coordinator);
    }

    public int getPmEsCpp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmEsCpp", coordinator);
    }

    public int getPmSesCpp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSesCpp", coordinator);
    }

    public int getPmUas(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUas", coordinator);
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute("currentPmRegister", coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedByTraffic")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("reservedByTraffic")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBySync")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("reservedBySync")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("froId")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                objectArray[i] = new Integer(this.getT3PhysAttributes(coordinator, 3));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                objectArray[i] = new Integer(this.getT3PhysAttributes(coordinator, 8));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                objectArray[i] = new Integer(AvailConverter.convert((int)this.getT3PhysAttributes(coordinator, 9)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("shutDownTimeout")) {
                objectArray[i] = new Integer(this.getT3PhysAttributes(coordinator, 11));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("lineNo")) {
                objectArray[i] = new Integer(this.getT3PhysAttributes(coordinator, 1) + 1);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("loopback")) {
                objectArray[i] = new Integer(this.getT3PhysAttributes(coordinator, 2));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aisReporting")) {
                objectArray[i] = MaoFroTypeConverter.int2boolean((int)this.getT3PhysAttributes(coordinator, 6));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("rdiReporting")) {
                objectArray[i] = MaoFroTypeConverter.int2boolean((int)this.getT3PhysAttributes(coordinator, 7));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmEsCpp")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmEsCpp", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSesCpp")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmSesCpp", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUas")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmUas", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("currentPmRegister")) {
                objectArray[i] = super.getCurrentPmRegister(coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "T3PhysPathTerm");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            Object[] objectArray2;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? T3PhysPathTermMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "T3PhysPathTerm");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"T3PhysPathTerm", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? T3PhysPathTermMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("administrativeState", "T3PhysPathTerm");
                }
                n = (Integer)objectArray[i];
                if (n != 0 && n != 1 && n != 2) {
                    throw new ValueOutOfRangeException("administrativeState", "T3PhysPathTerm");
                }
                this.setPhyT3MiAttributes(coordinator, 3, n);
                String[] stringArray2 = new String[]{"administrativeState"};
                objectArray2 = new Object[]{new Integer(n)};
                notificationSender.pushAVC((ManagedObject)this, stringArray2, objectArray2, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aisReporting")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Boolean == null ? T3PhysPathTermMoImpl.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    throw new WrongAttributeTypeException("aisReporting", "T3PhysPathTerm");
                }
                this.setPhyT3MiAttributes(coordinator, 6, MaoFroTypeConverter.boolean2int((boolean)((Boolean)objectArray[i])));
                String[] stringArray3 = new String[]{"aisReporting"};
                objectArray2 = new Object[]{(Boolean)objectArray[i]};
                notificationSender.pushAVC((ManagedObject)this, stringArray3, objectArray2, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("loopback")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? T3PhysPathTermMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("loopback", "T3PhysPathTerm");
                }
                n = (Integer)objectArray[i];
                if (n != 0 && n != 1 && n != 2) {
                    throw new ValueOutOfRangeException("loopback", "T3PhysPathTerm");
                }
                int n2 = this.getT3PhysAttributes(coordinator, 3);
                if (n2 != 0 && n != 0) {
                    throw new FroNotLockedException("T3PhysPathTerm", "AdministrativeState need to be locked when setting with loopback enabled");
                }
                this.setPhyT3MiAttributes(coordinator, 2, n);
                objectArray2 = new String[]{"loopback"};
                Object[] objectArray3 = new Object[]{new Integer(n)};
                notificationSender.pushAVC((ManagedObject)this, (String[])objectArray2, objectArray3, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("rdiReporting")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Boolean == null ? T3PhysPathTermMoImpl.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    throw new WrongAttributeTypeException("rdiReporting", "T3PhysPathTerm");
                }
                this.setPhyT3MiAttributes(coordinator, 7, MaoFroTypeConverter.boolean2int((boolean)((Boolean)objectArray[i])));
                String[] stringArray4 = new String[]{"rdiReporting"};
                objectArray2 = new Object[]{(Boolean)objectArray[i]};
                notificationSender.pushAVC((ManagedObject)this, stringArray4, objectArray2, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("shutDownTimeout")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? T3PhysPathTermMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("shutDownTimeout", "T3PhysPathTerm");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"shutDownTimeout", (int)n, (int)0, (int)100000, (String)"T3PhysPathTerm");
                this.setPhyT3MiAttributes(coordinator, 11, n);
                String[] stringArray5 = new String[]{"shutDownTimeout"};
                objectArray2 = new Object[]{new Integer(n)};
                notificationSender.pushAVC((ManagedObject)this, stringArray5, objectArray2, coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "T3PhysPathTerm");
        }
    }

    public void trafficReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedByTraffic", (Class[])atmPortReserver);
    }

    public void trafficRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedByTraffic", (Class[])atmPortReserver);
    }

    public void syncReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBySync", (Class[])syncReserver);
    }

    public void syncRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBySync", (Class[])syncReserver);
    }

    public ManagedObject getReservedByTraffic(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((ReferenceAttribute)this.data.getAttribute("reservedByTraffic")).getValue(coordinator);
    }

    public ManagedObject getReservedBySync(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((ReferenceAttribute)this.data.getAttribute("reservedBySync")).getValue(coordinator);
    }

    public String getType() {
        return "T3PhysPathTerm";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    public int getLineNo(Coordinator coordinator) throws MoAccessException {
        return this.getT3PhysAttributes(coordinator, 1) + 1;
    }

    public synchronized void parameterChanged(FroLockInd froLockInd, String string) {
        if (froLockInd.getClass().equals(PhyT3MiAutoLockInd.class)) {
            String[] stringArray = new String[]{"administrativeState"};
            Object[] objectArray = new Object[]{new Integer(0)};
            notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray);
        }
    }

    private int createT3PhysPathTermFro(Coordinator coordinator, int n, boolean bl, boolean bl2, int n2, int n3, int n4) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n5 = ((ExchangeTerminalMoImpl)this.getParent()).getFroId(coordinator);
        PhyT3MiCreateRsp phyT3MiCreateRsp = phyT3Proxy.sendPhyT3MiCreateReq(coordinator.getTransactionID(), n5, n - 1, MaoFroTypeConverter.boolean2int((boolean)bl), MaoFroTypeConverter.boolean2int((boolean)bl2), n2, n3, n4);
        if (phyT3MiCreateRsp == null) {
            throw new FroNotAccessibleException("T3PhysPathTerm", "PhyT3MiCreateReq");
        }
        if (phyT3MiCreateRsp.getResult() != 0) {
            throw new FroRequestFailedException("T3PhysPathTerm", "T3PhysicalPortFro", "CreateFroReq: " + phyT3Proxy.getResultMsg(phyT3MiCreateRsp.getResult()), phyT3MiCreateRsp.getResult());
        }
        return phyT3MiCreateRsp.getFroId();
    }

    private void deleteT3PhysPathTermFro(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PhyT3MiDeleteRsp phyT3MiDeleteRsp = phyT3Proxy.sendPhyT3MiDeleteReq(coordinator.getTransactionID(), this.getFroId(coordinator));
        if (phyT3MiDeleteRsp == null) {
            throw new FroNotAccessibleException("T3PhysPathTerm", "PhyT3MiDeleteReq");
        }
        if (phyT3MiDeleteRsp.getResult() != 0) {
            throw new FroRequestFailedException("T3PhysPathTerm", "T3PhysicalPortFro", "DeleteFroReq: " + phyT3Proxy.getResultMsg(phyT3MiDeleteRsp.getResult()), phyT3MiDeleteRsp.getResult());
        }
    }

    private int getT3PhysAttributes(Coordinator coordinator, int n) throws MoAccessException {
        PhyT3MiGetAttributeRsp phyT3MiGetAttributeRsp;
        int n2 = 0;
        if (coordinator != null) {
            n2 = coordinator.getTransactionID();
        }
        if ((phyT3MiGetAttributeRsp = phyT3Proxy.sendPhyT3MiGetAttributeReq(n2, this.getFroId(coordinator), n)) == null) {
            throw new FroNotAccessibleException("T3PhysPathTerm", "PhyT3MiGetAttributeReq");
        }
        if (phyT3MiGetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("T3PhysPathTerm", "T3PhysicalPortFro", "GetAttrReq: " + phyT3Proxy.getResultMsg(phyT3MiGetAttributeRsp.getResult()), phyT3MiGetAttributeRsp.getResult());
        }
        return phyT3MiGetAttributeRsp.getValue();
    }

    private void setPhyT3MiAttributes(Coordinator coordinator, int n, int n2) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PhyT3MiSetAttributeRsp phyT3MiSetAttributeRsp = phyT3Proxy.sendPhyT3MiSetAttributeReq(coordinator.getTransactionID(), this.getFroId(coordinator), n, n2);
        if (phyT3MiSetAttributeRsp == null) {
            throw new FroNotAccessibleException("T3PhysPathTerm", "T3PhysicalPortFro");
        }
        if (phyT3MiSetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("T3PhysPathTerm", "T3PhysicalPortFro", "SetAttrReq: " + phyT3Proxy.getResultMsg(phyT3MiSetAttributeRsp.getResult()), phyT3MiSetAttributeRsp.getResult());
        }
    }
}

