/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.emnotification;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import se.ericsson.security.launcher.emnotification.EmEventInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationListenerInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationServiceInterface;
import se.ericsson.security.utils.EmLogger;

public class EmNotificationService
implements EmNotificationServiceInterface {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private Collection<EmNotificationListenerInterface> emNotificationListeners = Collections.synchronizedSet(new HashSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEmNotificationListener(EmNotificationListenerInterface listener) {
        if (null != listener) {
            Collection<EmNotificationListenerInterface> collection = this.emNotificationListeners;
            synchronized (collection) {
                LOG.info("Will add EM listener to EM events : " + listener, new Object[0]);
                this.emNotificationListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEmNotificationListener(EmNotificationListenerInterface listener) {
        if (null != listener) {
            Collection<EmNotificationListenerInterface> collection = this.emNotificationListeners;
            synchronized (collection) {
                LOG.info("Will remove listener to EM events : " + listener, new Object[0]);
                this.emNotificationListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(final EmEventInterface note) {
        if (null == note) {
            LOG.warning("EM Notification got an empty (null) notification!", new Object[0]);
            return;
        }
        Collection<EmNotificationListenerInterface> collection = this.emNotificationListeners;
        synchronized (collection) {
            LOG.info("Will distribute EM event: " + note.getType() + " with message: " + note.getMessage(), new Object[0]);
            for (final EmNotificationListenerInterface listener : this.emNotificationListeners) {
                LOG.fine("Will notify " + listener.toString() + " about " + note.getMessage(), new Object[0]);
                new Thread(new Runnable(){

                    public void run() {
                        listener.notificationFromEM(note);
                    }
                }, "EM Notification").start();
            }
        }
    }
}

