/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.eprops;

import se.ericsson.security.launcher.eprops.EKEY;
import se.ericsson.security.launcher.eprops.EKey;
import se.ericsson.security.launcher.eprops.EPrinter;
import se.ericsson.security.launcher.eprops.EProps;

public class ErrorPopUpPrinter {
    static final String POPUP_VALUE_INDENTION = "    ";
    private final EProps myEProps;
    private final EPrinter mainPrinter;
    private final EPrinter detailsPrinter;
    private String mainMessage;
    private String detailsMessage;

    public ErrorPopUpPrinter(Throwable throwable) {
        this(throwable, new EPrinter.ErrorPopUpMain(), new EPrinter.ErrorPopUpDetails());
    }

    public ErrorPopUpPrinter(Throwable throwable, EPrinter mainPrinter, EPrinter detailsPrinter) {
        this.myEProps = EProps.valueOf(throwable);
        this.mainPrinter = mainPrinter;
        this.detailsPrinter = detailsPrinter;
        this.fixProperties(this.myEProps, throwable);
    }

    protected void fixProperties(EProps ep, Throwable throwable) {
        ep.setStackTrace(EKEY.CAUGHT_EXCEPTION, throwable);
        EKey firstKey = (EKey)ep.firstKey();
        if (EKEY.AL_PROFESIONAL_USER.compareTo(firstKey.ABSTRACTION_LEVEL) < 0) {
            Throwable t = EProps.getDeepestException(throwable);
            String value = t == null ? "" : t.toString();
            ep.put(EKEY.INTERNAL_ERROR, value);
        }
        ep.putAll(EProps.getRevisionProperties());
        String jars = ep.getProperty(EKEY.REV_JAR_FILES);
        if (jars != null) {
            jars.trim();
            ep.set(EKEY.REV_JAR_FILES, jars);
        }
    }

    public synchronized String getPopUpMessge() {
        if (this.mainMessage == null) {
            this.mainMessage = this.mainPrinter.print(this.myEProps);
            this.mainPrinter.freeBuffer();
        }
        return this.mainMessage;
    }

    public synchronized String getPopUpDetails() {
        if (this.detailsMessage == null) {
            this.detailsMessage = this.detailsPrinter.print(this.myEProps);
            this.detailsPrinter.freeBuffer();
        }
        return this.detailsMessage;
    }
}

