/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.security.launcher.parser.NameValue;
import se.ericsson.security.launcher.parser.ParserException;
import se.ericsson.security.utils.EmLogger;

class ParseXml {
    private static String DISALLOW_DOCTYPE = "http://apache.org/xml/features/disallow-doctype-decl";
    private static String ERROR_INFO = "Illegal DOCTYPE tag is detected. Can't parse configuration XML file";
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    MyHandler handler = new MyHandler();
    SAXParser saxParser;
    boolean fileWasParsed = false;
    boolean partial;
    InputSource inputSourceForTotalParsing;
    String inputForParsing;

    ParseXml() {
        this.fileWasParsed = false;
        this.partial = false;
        this.inputForParsing = null;
    }

    ParseXml(boolean partial, String inputForParsing) {
        this.partial = partial;
        this.inputForParsing = inputForParsing;
        this.fileWasParsed = false;
    }

    ParseXml(InputSource inputSourceForTotalParsing) {
        this.inputSourceForTotalParsing = inputSourceForTotalParsing;
        this.partial = false;
        this.fileWasParsed = false;
    }

    ArrayList parse(String name) throws ParserException {
        if (this.partial) {
            this.handler = new MyHandler(this.partial);
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setFeature(DISALLOW_DOCTYPE, true);
                this.saxParser = factory.newSAXParser();
                this.handler.setElementName(name);
                this.saxParser.parse(new InputSource(new StringReader(this.inputForParsing)), (DefaultHandler)this.handler);
                return this.handler.getResult();
            }
            catch (SAXException e) {
                LOG.info("have SAXException : " + e, new Object[0]);
                throw new ParserException(e);
            }
            catch (IOException e) {
                LOG.info("have IOException : " + e, new Object[0]);
                throw new ParserException(e);
            }
            catch (ParserConfigurationException e) {
                LOG.info("have ParserConfigurationException : " + e, new Object[0]);
                throw new ParserException(e);
            }
            catch (NullPointerException e) {
                LOG.info("have NullPointerException : " + e, new Object[0]);
                throw new ParserException(ERROR_INFO);
            }
        }
        if (!this.fileWasParsed) {
            this.parseAll(this.inputSourceForTotalParsing);
            this.fileWasParsed = true;
        }
        return this.handler.getElement(name);
    }

    void parseAll(InputSource is) throws ParserException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature(DISALLOW_DOCTYPE, true);
            this.saxParser = factory.newSAXParser();
            this.saxParser.parse(is, (DefaultHandler)this.handler);
        }
        catch (SAXException e) {
            LOG.info("have SAXException : " + e, new Object[0]);
            throw new ParserException(e);
        }
        catch (IOException e) {
            LOG.info("have IOException : " + e, new Object[0]);
            throw new ParserException(e);
        }
        catch (ParserConfigurationException e) {
            LOG.info("have ParserConfigurationException : " + e, new Object[0]);
            throw new ParserException(e);
        }
        catch (NullPointerException e) {
            LOG.info("have NullPointerException : " + e, new Object[0]);
            throw new ParserException(ERROR_INFO);
        }
    }

    static class MyHandler
    extends DefaultHandler {
        ArrayList partialResult;
        Hashtable theParsedFile;
        String elementName = null;

        public MyHandler() {
            this.theParsedFile = new Hashtable();
        }

        MyHandler(boolean partial) {
            if (partial) {
                this.partialResult = new ArrayList(20);
            }
        }

        ArrayList getElement(String name) {
            ArrayList res = (ArrayList)this.theParsedFile.get(name);
            if (res == null) {
                return new ArrayList(20);
            }
            return res;
        }

        void setElementName(String elementName) {
            this.elementName = elementName;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            ArrayList<NameValue> tmpRes = new ArrayList<NameValue>(10);
            ArrayList elements = null;
            if ((this.elementName == null || this.elementName.equals(qName)) && attrs != null) {
                int size = attrs.getLength();
                for (int i = 0; i < size; ++i) {
                    String aName = attrs.getLocalName(i);
                    if ("".equals(aName)) {
                        aName = attrs.getQName(i);
                    }
                    tmpRes.add(new NameValue(aName, attrs.getValue(i)));
                }
                if (this.elementName == null) {
                    elements = (ArrayList)this.theParsedFile.get(qName);
                    if (elements == null) {
                        elements = new ArrayList(20);
                    }
                    elements.add(tmpRes);
                } else {
                    this.partialResult.add(tmpRes);
                }
            }
            if (this.elementName == null) {
                this.theParsedFile.put(qName, elements);
            }
        }

        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        }

        public void error(SAXParseException spe) throws SAXException {
            String errorMsg = "Error in file \"" + spe.getSystemId() + "\"" + ", line #" + spe.getLineNumber() + ": " + spe.toString();
            if (spe.getSystemId().equals("file:H:/xmlTest.xml")) {
                throw new SAXException(errorMsg);
            }
        }

        public void warning(SAXParseException spe) {
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String errorMsg = "Fatal Error in file \"" + spe.getSystemId() + "\"" + ", line #" + spe.getLineNumber() + ": " + spe.toString();
            throw new SAXException(errorMsg);
        }

        ArrayList getResult() {
            return this.partialResult;
        }
    }
}

