/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import se.ericsson.security.launcher.util.Localizer;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AboutDialog
extends JDialog {
    private static final long serialVersionUID = 5076795264431858911L;
    private static final EmLogger LOG = EmLogger.HELP_SERVICE;
    static final String ERICSSON_LOGO_FILE_NAME = "About.png";
    private static final String NEWLINE = System.getProperties().getProperty("line.separator", "\n");
    private JTextArea myTextArea;
    private final JFrame myFrame;

    public AboutDialog(JFrame frame, String title) {
        super((Frame)frame, Localizer.getString("about") + " " + title);
        this.myFrame = frame;
    }

    public void initAboutDialog() {
        this.setAlwaysOnTop(null == this.myFrame || !this.myFrame.isShowing());
        JPanel theDialogPanel = (JPanel)this.getContentPane();
        theDialogPanel.setLayout(new BorderLayout(10, 0));
        theDialogPanel.setOpaque(true);
        theDialogPanel.setBackground(Color.WHITE);
        JButton closeButton = new JButton("Close");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setOpaque(true);
        this.addCloseListenerToAbout(this, closeButton);
        buttonPanel.add(closeButton);
        JPanel ericIconP = this.constructPanelAndEricssonIcon();
        this.myTextArea = new JTextArea();
        Font font = new JLabel().getFont();
        this.myTextArea.setEditable(false);
        this.myTextArea.setOpaque(true);
        this.myTextArea.setBackground(Color.WHITE);
        this.myTextArea.setFont(font);
        this.myTextArea.setBorder(BorderFactory.createEmptyBorder(8, 5, 5, 5));
        this.myTextArea.setColumns(24);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.getContentPane().add((Component)this.myTextArea, "Center");
        this.getContentPane().add((Component)new JLabel(""), "East");
        if (ericIconP != null) {
            this.getContentPane().add((Component)ericIconP, "West");
        }
        this.setResizable(false);
    }

    public JTextArea getTextArea() {
        return this.myTextArea;
    }

    private JPanel constructPanelAndEricssonIcon() {
        ImageIcon ericssonIcon = null;
        JPanel ericIconP = null;
        try {
            URL imageUrl = AboutDialog.class.getResource(ERICSSON_LOGO_FILE_NAME);
            if (null != imageUrl) {
                Image ericssonImage = Toolkit.getDefaultToolkit().createImage(imageUrl);
                ericssonIcon = new ImageIcon(ericssonImage);
            } else {
                LOG.info("About window could not create the Ericsson logotype", new Object[0]);
            }
        }
        catch (Throwable ex) {
            LOG.warning("About window could not create the pictures. " + ex.getMessage(), new Object[0]);
        }
        JLabel ericIconLabel = null;
        if (null != ericssonIcon) {
            ericIconLabel = new JLabel("", ericssonIcon, 2);
            ericIconP = new JPanel();
            ericIconP.setOpaque(true);
            ericIconP.setBackground(new Color(0, 40, 94));
            ericIconP.add(ericIconLabel);
        }
        return ericIconP;
    }

    private void addCloseListenerToAbout(AboutDialog theAboutDialog, JButton closeButton) {
        final AboutDialog theDialog = theAboutDialog;
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                theDialog.dispose();
            }
        });
    }

    public void fillAboutTextAreaWithContents(String firstLine, String additionalText, String copyRightYear, String thirdPartyText, Collection<String> executingAppRows) {
        if (firstLine != null && firstLine.length() != 0) {
            this.myTextArea.append(firstLine);
            this.myTextArea.append(NEWLINE);
            this.myTextArea.append(NEWLINE);
        }
        if (null != additionalText && additionalText.trim().length() > 0) {
            this.myTextArea.append(additionalText);
            this.myTextArea.append(NEWLINE);
            this.myTextArea.append(NEWLINE);
        }
        this.myTextArea.append("Currently executing products and versions:");
        this.myTextArea.append(NEWLINE);
        Iterator<String> rowIter = executingAppRows.iterator();
        while (rowIter.hasNext()) {
            this.myTextArea.append(rowIter.next());
            this.myTextArea.append(NEWLINE);
        }
        this.myTextArea.append(NEWLINE);
        char copyr = '\u00a9';
        StringBuilder copyrightInfo = new StringBuilder();
        copyrightInfo.append(NEWLINE);
        copyrightInfo.append(copyr);
        copyrightInfo.append(" Ericsson AB ");
        copyrightInfo.append(copyRightYear);
        copyrightInfo.append(". All rights reserved.");
        this.myTextArea.append(copyrightInfo.toString());
        if (thirdPartyText != null && thirdPartyText.trim().length() > 0) {
            this.myTextArea.append(NEWLINE);
            this.myTextArea.append(NEWLINE);
            this.myTextArea.append(thirdPartyText);
        }
        LOG.info("Displaying the following information in About window:" + NEWLINE + this.myTextArea.getText(), new Object[0]);
    }
}

