/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSorter
extends DefaultTableModel {
    private static final long serialVersionUID = -7077563559584402830L;
    protected TableModel tableM;
    public static final int DESCEND = -1;
    public static final int UNSORTED = 0;
    public static final int ASCEND = 1;
    private static Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
    public static final Comparator COMPARABLE_COMPARATOR = new Comparator(){

        public int compare(Object object1, Object object2) {
            int result = ((Comparable)object1).compareTo(object2);
            return result;
        }
    };
    public static final Comparator LEXICAL_AND_NUMBER_COMPARATOR = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            boolean ready = false;
            int returnValue = 0;
            if (obj1 instanceof String && obj2 instanceof String) {
                String s1 = ((String)obj1).trim();
                String s2 = ((String)obj2).trim();
                if (0 == s1.length() && 0 == s2.length()) {
                    ready = true;
                }
                if (!ready) {
                    String revS1 = ReverseString.reverseIt(s1).trim();
                    String revS2 = ReverseString.reverseIt(s2).trim();
                    String regex = "(^[0-9]*)([a-zA-Z0-9#_\\s-]*)";
                    Pattern p = Pattern.compile(regex);
                    Matcher m1 = p.matcher(revS1);
                    Matcher m2 = p.matcher(revS2);
                    if (m1.find() && m2.find() && m1.group(2).equals(m2.group(2)) && m1.group(1).length() > 0 && m2.group(1).length() > 0) {
                        String s1Index = ReverseString.reverseIt(m1.group(1));
                        String s2Index = ReverseString.reverseIt(m2.group(1));
                        try {
                            Integer i1 = Integer.valueOf(s1Index);
                            Integer i2 = Integer.valueOf(s2Index);
                            returnValue = i1.compareTo(i2);
                            ready = true;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (!ready) {
                    returnValue = s1.toLowerCase().compareTo(s2.toLowerCase());
                }
            }
            return returnValue;
        }
    };
    private transient Row[] viewToM;
    private int[] modelToV;
    private JTableHeader jTableHeader;
    private transient MouseListener mouseListener;
    private TableModelListener tableMListener;
    private Map columnComparator = new HashMap();
    private List sortColumns = new ArrayList();

    public TableSorter() {
        this.mouseListener = new MouseHandler();
        this.tableMListener = new TableModelHandler();
    }

    public TableSorter(TableModel model) {
        this();
        this.setTableModel(model);
    }

    public TableSorter(TableModel model, JTableHeader header) {
        this();
        this.setTableHeader(header);
        this.setTableModel(model);
    }

    private void clearSortState() {
        this.viewToM = null;
        this.modelToV = null;
    }

    public TableModel getTableModel() {
        return this.tableM;
    }

    public void setTableModel(TableModel tableM) {
        if (this.tableM != null) {
            this.tableM.removeTableModelListener(this.tableMListener);
        }
        this.tableM = tableM;
        if (this.tableM != null) {
            this.tableM.addTableModelListener(this.tableMListener);
        }
        this.clearSortState();
        this.fireTableStructureChanged();
    }

    public JTableHeader getTableHeader() {
        return this.jTableHeader;
    }

    public void setTableHeader(JTableHeader jtableHeader) {
        if (this.jTableHeader != null) {
            this.jTableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer defaultRenderer = this.jTableHeader.getDefaultRenderer();
            if (defaultRenderer instanceof SortableHeaderRenderer) {
                TableCellRenderer tableCellRenderer = ((SortableHeaderRenderer)defaultRenderer).tableRenderer;
                this.jTableHeader.setDefaultRenderer(tableCellRenderer);
            }
        }
        this.jTableHeader = jtableHeader;
        if (this.jTableHeader != null) {
            this.jTableHeader.addMouseListener(this.mouseListener);
            SortableHeaderRenderer sortableHeaderRenderer = new SortableHeaderRenderer(this.jTableHeader.getDefaultRenderer());
            this.jTableHeader.setDefaultRenderer(sortableHeaderRenderer);
        }
        this.getTableHeader().setReorderingAllowed(false);
    }

    public boolean isSort() {
        return this.sortColumns.size() != 0;
    }

    private Directive getDirective(int column) {
        for (int i = 0; i < this.sortColumns.size(); ++i) {
            Directive directive = (Directive)this.sortColumns.get(i);
            if (directive.col != column) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    public int getSortingStatus(int columns) {
        int status = this.getDirective(columns).dire;
        return status;
    }

    private void sortStatusChanged() {
        this.clearSortState();
        this.fireTableDataChanged();
        if (this.jTableHeader != null) {
            this.jTableHeader.repaint();
        }
    }

    public void setSortingStatus(int columns, int status) {
        Directive directive = this.getDirective(columns);
        if (directive != EMPTY_DIRECTIVE) {
            this.sortColumns.remove(directive);
        }
        if (status != 0) {
            Directive directives = new Directive(columns, status);
            this.sortColumns.add(directives);
        }
        this.sortStatusChanged();
    }

    protected Icon getHeaderRendererIcon(int columns, int size) {
        Directive directives = this.getDirective(columns);
        if (directives == EMPTY_DIRECTIVE) {
            return null;
        }
        Arrow arrow = new Arrow(directives.dire == -1, size, this.sortColumns.indexOf(directives));
        return arrow;
    }

    private void cancelSort() {
        this.sortColumns.clear();
        this.sortStatusChanged();
    }

    public void setColumnComparator(Class types, Comparator comparators) {
        if (comparators == null) {
            this.columnComparator.remove(types);
        } else {
            this.columnComparator.put(types, comparators);
        }
    }

    protected Comparator getComparator(int columns) {
        Class<?> type = this.tableM.getColumnClass(columns);
        Comparator comp = (Comparator)this.columnComparator.get(type);
        if (comp != null) {
            return comp;
        }
        if (Comparable.class.isAssignableFrom(type)) {
            return COMPARABLE_COMPARATOR;
        }
        return LEXICAL_AND_NUMBER_COMPARATOR;
    }

    private Row[] getViewToModel() {
        if (this.viewToM == null) {
            int tableModelRowCount = this.tableM.getRowCount();
            this.viewToM = new Row[tableModelRowCount];
            for (int row = 0; row < tableModelRowCount; ++row) {
                this.viewToM[row] = new Row(row);
            }
            if (this.isSort()) {
                Arrays.sort(this.viewToM);
            }
        }
        return this.viewToM;
    }

    public int modelIndex(int index) {
        int modelIndex = this.getViewToModel()[index].mIndex;
        return modelIndex;
    }

    private int[] getModelToView() {
        if (this.modelToV == null) {
            int n = this.getViewToModel().length;
            this.modelToV = new int[n];
            for (int i = 0; i < n; ++i) {
                this.modelToV[this.modelIndex((int)i)] = i;
            }
        }
        return this.modelToV;
    }

    public int getRowCount() {
        int rowCount = this.tableM == null ? 0 : this.tableM.getRowCount();
        return rowCount;
    }

    public int getColumnCount() {
        int columnCount = this.tableM == null ? 0 : this.tableM.getColumnCount();
        return columnCount;
    }

    public String getColumnName(int col) {
        return this.tableM == null ? "" : this.tableM.getColumnName(col);
    }

    public Class getColumnClass(int col) {
        return this.tableM == null ? null : this.tableM.getColumnClass(col);
    }

    public boolean isCellEditable(int row, int col) {
        return this.tableM == null ? false : this.tableM.isCellEditable(this.modelIndex(row), col);
    }

    public Object getValueAt(int row, int col) {
        return this.tableM == null ? null : this.tableM.getValueAt(this.modelIndex(row), col);
    }

    public void setValueAt(Object aValue, int row, int col) {
        if (this.tableM != null) {
            this.tableM.setValueAt(aValue, this.modelIndex(row), col);
        }
    }

    private static class Directive {
        private int col;
        private int dire;

        public Directive(int col, int dire) {
            this.col = col;
            this.dire = dire;
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableRenderer) {
            this.tableRenderer = tableRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean isSelected, boolean hasFocus, int r, int col) {
            Component component = this.tableRenderer.getTableCellRendererComponent(jTable, obj, isSelected, hasFocus, r, col);
            if (component instanceof JLabel) {
                JLabel l = (JLabel)component;
                l.setHorizontalTextPosition(2);
                int modelColumn = jTable.convertColumnIndexToModel(col);
                Icon icon = TableSorter.this.getHeaderRendererIcon(modelColumn, l.getFont().getSize());
                l.setIcon(icon);
            }
            return component;
        }
    }

    private static class Arrow
    implements Icon {
        private boolean descend;
        private int size;
        private int priority;

        public Arrow(boolean descend, int size, int priority) {
            this.descend = descend;
            this.size = size;
            this.priority = priority;
        }

        public void paintIcon(Component component, Graphics graphics, int x, int y) {
            Color color = component == null ? Color.GRAY : component.getBackground();
            int dx = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
            int dy = this.descend ? dx : -dx;
            y = y + 5 * this.size / 6 + (this.descend ? -dy : 0);
            int shift = this.descend ? 1 : -1;
            graphics.translate(x, y);
            graphics.setColor(color.darker());
            graphics.drawLine(dx / 2, dy, 0, 0);
            graphics.drawLine(dx / 2, dy + shift, 0, shift);
            graphics.setColor(color.brighter());
            graphics.drawLine(dx / 2, dy, dx, 0);
            graphics.drawLine(dx / 2, dy + shift, dx, shift);
            if (this.descend) {
                Color co = color.darker().darker();
                graphics.setColor(co);
            } else {
                Color co = color.brighter().brighter();
                graphics.setColor(co);
            }
            graphics.drawLine(dx, 0, 0, 0);
            graphics.setColor(color);
            graphics.translate(-x, -y);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent event) {
            int viewColumn;
            JTableHeader jTableHeader = (JTableHeader)event.getSource();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            int column = tableColumnModel.getColumn(viewColumn = tableColumnModel.getColumnIndexAtX(event.getX())).getModelIndex();
            if (column != -1) {
                int s = TableSorter.this.getSortingStatus(column);
                if (!event.isControlDown()) {
                    TableSorter.this.cancelSort();
                }
                s += event.isShiftDown() ? -1 : 1;
                s = (s + 4) % 3 - 1;
                TableSorter.this.setSortingStatus(column, s);
            }
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent event) {
            if (!TableSorter.this.isSort()) {
                TableSorter.this.clearSortState();
                TableSorter.this.fireTableChanged(event);
                return;
            }
            if (event.getFirstRow() == -1) {
                TableSorter.this.cancelSort();
                TableSorter.this.fireTableChanged(event);
                return;
            }
            int col = event.getColumn();
            if (event.getFirstRow() == event.getLastRow() && col != -1 && TableSorter.this.getSortingStatus(col) == 0 && TableSorter.this.modelToV != null) {
                int viewIndex = TableSorter.this.getModelToView()[event.getFirstRow()];
                TableModelEvent tableModelEvent = new TableModelEvent(TableSorter.this, viewIndex, viewIndex, col, event.getType());
                TableSorter.this.fireTableChanged(tableModelEvent);
                return;
            }
            TableSorter.this.clearSortState();
            TableSorter.this.fireTableDataChanged();
        }
    }

    private class Row
    implements Comparable {
        private int mIndex;

        public Row(int index) {
            this.mIndex = index;
        }

        public int compareTo(Object obj) {
            int row1 = this.mIndex;
            int row2 = ((Row)obj).mIndex;
            for (Directive dire : TableSorter.this.sortColumns) {
                int column = dire.col;
                Object obj1 = TableSorter.this.tableM.getValueAt(row1, column);
                Object obj2 = TableSorter.this.tableM.getValueAt(row2, column);
                int comparison = 0;
                if (obj1 == null && obj2 == null) {
                    comparison = 0;
                } else if (obj1 == null) {
                    comparison = -1;
                } else if (obj2 == null) {
                    comparison = 1;
                } else {
                    Comparator compar = TableSorter.this.getComparator(column);
                    comparison = compar.compare(obj1, obj2);
                }
                if (comparison == 0) continue;
                int result = dire.dire == -1 ? -comparison : comparison;
                return result;
            }
            return 0;
        }
    }

    private static class ReverseString {
        private ReverseString() {
        }

        public static String reverseIt(String source) {
            int len = source.length();
            StringBuffer dest = new StringBuffer(len);
            for (int i = len - 1; i >= 0; --i) {
                dest.append(source.charAt(i));
            }
            return dest.toString();
        }
    }
}

