/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.starter;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ArrayList;
import se.ericsson.security.launcher.util.EmasUtilities;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.starter.investigator.EmApplicationInfo;
import se.ericsson.security.starter.investigator.EmApplicationInfoFactory;
import se.ericsson.security.starter.investigator.NodeTypeInvestigator;
import se.ericsson.security.starter.investigator.resource.ResourceInfo;
import se.ericsson.security.starter.investigator.resource.ResourceInfoFactory;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLocator {
    private static final EmLogger LOG = EmLogger.STARTER;
    private ArrayList<ResourceInfo> currentResourceInfos;
    private NodeTypeInvestigator nodeTypeInvestigator = new NodeTypeInvestigator();
    private transient PropertyManager pm;
    private volatile ArrayList<EmApplicationInfo> currentEmAppInfos;

    public ResourceLocator() {
        this.nodeTypeInvestigator.init();
        this.pm = PropertyManager.getInstance(this.getClass().getClassLoader());
    }

    public byte[] getIconBytesForEmApplicationInfo(EmApplicationInfo emApp, ArrayList<ResourceInfo> resourceInfos, URL hostUrl) {
        LOG.finer("getIconBytesForEmApplicationInfo, hostUrl: " + hostUrl + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        byte[] iconAsBytes = new byte[]{};
        String jarFilePath = this.getIconJarFilePath(emApp, resourceInfos, hostUrl);
        if (jarFilePath.length() > 0) {
            iconAsBytes = this.nodeTypeInvestigator.getFileInJarAsByteArray(emApp.getIconResourcePath() + "/" + emApp.getIconResourceName(), jarFilePath);
        }
        return iconAsBytes;
    }

    public String getIconJarFilePath(EmApplicationInfo emApp, ArrayList<ResourceInfo> resourceInfos, URL hostUrl) {
        LOG.finer("getIconJarFilePath, hostUrl: " + hostUrl + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        String jarFilePath = "";
        jarFilePath = emApp.getIconResourceRefSee().equalsIgnoreCase("launcher.jar") ? this.nodeTypeInvestigator.getJarFilePathForThisLauncherJar() : this.getIconJarFilePathInCache(emApp, resourceInfos, hostUrl);
        return jarFilePath;
    }

    private String getIconJarFilePathInCache(EmApplicationInfo emApp, ArrayList<ResourceInfo> resourceInfos, URL hostUrl) {
        LOG.finer("getIconJarFilePathInCache, hostUrl: " + hostUrl + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        String iconRefSee = emApp.getIconResourceRefSee();
        String dirPath = "";
        String cxc = "";
        String rev = "";
        String jarFilePath = "";
        for (ResourceInfo iconResource : resourceInfos) {
            if (!iconResource.getResourceFileName().equalsIgnoreCase(iconRefSee)) continue;
            dirPath = iconResource.getDirectoryPath();
            cxc = iconResource.getProductNumber();
            rev = iconResource.getProductRevision();
        }
        if (cxc.length() > 0 && rev.length() > 0) {
            try {
                String host = hostUrl.toExternalForm();
                if (host.endsWith("/") && dirPath.startsWith("/")) {
                    host = host.substring(0, host.length() - 1);
                }
                URL url = new URL(host + dirPath + "/" + iconRefSee);
                jarFilePath = this.nodeTypeInvestigator.getFile(url, iconRefSee, cxc, rev, this.pm);
            }
            catch (Exception e) {
                LOG.finer("getIconJarFilePathInCache did not find jar file path in cache to a resource file containing an icon.", new Object[0]);
            }
        }
        return jarFilePath;
    }

    public String getSelectedEmApplicationIconFilePath(String defaultPath, URL hostUrl) {
        LOG.finer("getSelectedEmApplicationIconFilePath defaultPath: " + defaultPath + " hostUrl:" + hostUrl + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        String theIconPath = defaultPath;
        EmApplicationInfo app = this.getSelectedEmApplication(true);
        if (this.currentEmAppInfos == null || this.currentResourceInfos == null || app == null) {
            return theIconPath;
        }
        byte[] iconbytes = this.getIconBytesForEmApplicationInfo(app, this.currentResourceInfos, hostUrl);
        String jarfilePath = this.getIconJarFilePath(app, this.currentResourceInfos, hostUrl);
        int filenamePlace = jarfilePath.indexOf(app.getIconResourceRefSee());
        LOG.finer("getSelectedEmApplicationIconFilePath jarfilePath : " + jarfilePath, new Object[0]);
        LOG.finer("getSelectedEmApplicationIconFilePath jfilenamePlace : " + filenamePlace, new Object[0]);
        if (filenamePlace == -1 || "".equals(app.getIconResourceRefSee()) || "".equals(app.getIconResourceName())) {
            return theIconPath;
        }
        String dir = jarfilePath.substring(0, filenamePlace);
        File iconFile = new File(dir + File.separator + app.getIconResourceName());
        if (iconFile.exists()) {
            theIconPath = iconFile.getAbsolutePath();
            LOG.finer("Icon file exists already: " + theIconPath, new Object[0]);
        } else {
            try {
                FileOutputStream outStream = new FileOutputStream(iconFile);
                outStream.write(iconbytes);
                outStream.flush();
                outStream.close();
                theIconPath = iconFile.getAbsolutePath();
                if (!EmasUtilities.runningOnWindows()) {
                    Runtime rt = Runtime.getRuntime();
                    rt.exec("chmod a+r " + iconFile.toString());
                }
            }
            catch (Exception e) {
                LOG.finer("getSelectedEmApplicationIconFilePath, something got wrong when writing or chmodding icon file: " + e.getMessage(), new Object[0]);
            }
        }
        return theIconPath;
    }

    public String getSelectedEmApplicationConfigFilePath(String defaultPath, boolean includeDefaultApp) {
        LOG.finer("getSelectedEmApplicationConfigFilePath, default: " + defaultPath, new Object[0]);
        String theAppPath = defaultPath;
        EmApplicationInfo app = this.getSelectedEmApplication(includeDefaultApp);
        if (app != null) {
            theAppPath = app.getConfigFileName();
            LOG.finer("getSelectedEmApplicationConfigFilePath, found: " + theAppPath, new Object[0]);
        }
        return theAppPath;
    }

    private EmApplicationInfo getSelectedEmApplication(boolean includeDefaultApp) {
        if (this.currentEmAppInfos != null) {
            int i;
            LOG.finer("getSelectedEmApplication, currentEmAppInfos size = " + this.currentEmAppInfos.size(), new Object[0]);
            for (i = 0; i < this.currentEmAppInfos.size(); ++i) {
                if (!this.currentEmAppInfos.get(i).isSelected()) continue;
                return this.currentEmAppInfos.get(i);
            }
            if (includeDefaultApp) {
                for (i = 0; i < this.currentEmAppInfos.size(); ++i) {
                    if (!this.currentEmAppInfos.get(i).isDefault()) continue;
                    return this.currentEmAppInfos.get(i);
                }
            }
        }
        return null;
    }

    public ArrayList<ResourceInfo> getCurrentResourceInfos() {
        return this.currentResourceInfos;
    }

    public void setCurrentResourceInfos(ArrayList<ResourceInfo> currentResourceInfos) {
        this.currentResourceInfos = currentResourceInfos;
    }

    public ArrayList<EmApplicationInfo> getCurrentEmAppInfos() {
        return this.currentEmAppInfos;
    }

    public void setCurrentEmAppInfos(ArrayList<EmApplicationInfo> currentEmAppInfos) {
        this.currentEmAppInfos = currentEmAppInfos;
    }

    public void updateCurrentInfos(URL hostAddress) throws Exception {
        String fileContents = this.nodeTypeInvestigator.getEmApplicationsFileContentsFromNode(hostAddress, "/em/emapplications.xml");
        if (!"".equals(fileContents)) {
            LOG.finest("emapplications.xml file contents:\n" + fileContents, new Object[0]);
            this.currentEmAppInfos = EmApplicationInfoFactory.constructEmAppInfos(fileContents);
            this.currentResourceInfos = ResourceInfoFactory.constructResourceInfos(fileContents);
        }
    }
}

