/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CliArguments {
    CLI_ARGUMENTS;

    private ArrayList<String> cliArguments;
    private Properties cliProperties = new Properties();
    private String iconPath = null;

    public void initArguments(String[] argv) {
        this.cliArguments = new ArrayList<String>(Arrays.asList(argv));
        for (String arg : this.cliArguments) {
            if (arg.contains("=")) {
                String[] keyValue = arg.split("=", 2);
                this.cliProperties.setProperty(keyValue[0], keyValue.length < 2 ? "" : keyValue[1]);
                continue;
            }
            if (this.isImage(arg)) {
                this.iconPath = arg;
                continue;
            }
            this.cliProperties.setProperty("applPath", arg);
        }
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public boolean iconPathExist() {
        return this.iconPath != null;
    }

    public Properties getProperties() {
        return this.cliProperties;
    }

    public void setProperty(String key, String value) {
        this.cliProperties.setProperty(key, value);
    }

    public void removeProperties(Collection<String> keys) {
        for (String key : keys) {
            this.cliProperties.remove(key);
        }
    }

    public void removeProperty(String key) {
        this.cliProperties.remove(key);
    }

    public String toString() {
        return this.cliArguments.toString();
    }

    private boolean isImage(String str) {
        return str.endsWith(".gif") || str.endsWith(".png") || str.endsWith(".jpg") || str.endsWith(".ico") || str.endsWith(".bmp");
    }
}

