/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imrutility.imr.Repository;
import org.jacorb.imrutility.imr.Server;
import org.jacorb.imrutility.imr.ServerHelper;
import org.jacorb.imrutility.imr.ServerPOA;
import org.jacorb.orb.ORB;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public class ServerImpl
extends ServerPOA {
    private long id = -1L;
    private int heartbeat = 0;
    private ORB orb = null;
    private Timer timer = null;
    private final Logger logger;

    public ServerImpl(ORB orb) {
        this.orb = orb;
        this.logger = orb.getConfiguration().getNamedLogger("jacorb.imr");
    }

    public long id() {
        return this.id;
    }

    public void id(long value) {
        boolean isFirstID;
        boolean bl = isFirstID = this.id == -1L;
        if (value == -1L) {
            this.stopTimer();
        }
        this.id = value;
        if (isFirstID) {
            this.startTimer();
        }
    }

    public int heartbeat() {
        return this.heartbeat;
    }

    public void heartbeat(int interval) {
        if (interval != this.heartbeat) {
            this.stopTimer();
            this.heartbeat = interval;
            this.startTimer();
        }
    }

    public void ping(long from) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Got pinged by imr " + from);
        }
    }

    public void shutdown(boolean wait) {
        this.orb.shutdown(wait);
    }

    public Server installOnRootPOA() {
        Object obj = null;
        try {
            obj = this.orb.getRootPOA().servant_to_reference(this);
        }
        catch (ServantNotActive e2) {
            throw new INTERNAL("Failed to activate Server handler" + e2);
        }
        catch (WrongPolicy e3) {
            throw new INTERNAL("Failed to activate Server handler" + e3);
        }
        return ServerHelper.narrow(obj);
    }

    private void startTimer() {
        if (this.heartbeat != 0 && this.orb != null && this.id != -1L) {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new PingImR(), this.heartbeat, (long)this.heartbeat);
        }
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private class PingImR
    extends TimerTask {
        private PingImR() {
        }

        public void run() {
            Repository imr = ServerImpl.this.orb.getImR();
            try {
                imr.ping(ServerImpl.this.id);
            }
            catch (Exception e2) {
                ServerImpl.this.orb.imrDead(imr);
            }
        }
    }
}

