/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.imrutility.imr.persistence.ActivatorData;

public class ActFilePersistence {
    protected Logger logger;
    private String dataFile;

    public ActFilePersistence(Configuration configuration) throws ConfigurationException {
        this.logger = configuration.getNamedLogger("jacorb.activator");
        this.dataFile = configuration.getAttribute("jacorb.imr.act_data_file", null);
    }

    public ActivatorData read() {
        ActivatorData actData;
        block9: {
            actData = null;
            if (this.dataFile != null) {
                File f2 = new File(this.dataFile);
                try {
                    if (f2.exists()) {
                        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f2));
                        actData = (ActivatorData)ois.readObject();
                    }
                    break block9;
                }
                catch (IOException ioe) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.warn("WARNING: Unable to read Activator data file " + this.dataFile + "! ");
                    }
                    break block9;
                }
                catch (ClassNotFoundException cnfe) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.warn("WARNING: Activator data file " + this.dataFile + " does not contain valid object" + "! ");
                    }
                    break block9;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("WARNING: Activator data file name not configured! ");
            }
        }
        if (actData == null) {
            actData = new ActivatorData();
        }
        return actData;
    }

    public void write(ActivatorData actData) {
        if (this.dataFile == null && this.logger.isDebugEnabled()) {
            this.logger.warn("WARNING: Activator data file name not configured creating \"actdata.dat\" in current directory, ");
            this.dataFile = "actdata.dat";
        }
        File f2 = new File(this.dataFile);
        this.write(f2, actData);
    }

    public void backup(ActivatorData actData) {
        if (this.dataFile != null) {
            File f2 = new File(this.dataFile);
            this.write(f2, actData);
        }
    }

    private void write(File file, ActivatorData actData) {
        block2: {
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
                oos.writeObject(actData);
                oos.flush();
                oos.close();
            }
            catch (IOException ioe) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.warn("Unable to write Activator data to file " + file.getName() + " :: " + ioe.getMessage());
            }
        }
    }
}

