/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.util.StringTokenizer;
import org.jacorb.util.ObjectUtil;
import org.jacorb.util.ValueHandler;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.StringValueHelper;
import org.omg.CORBA.WStringValueHelper;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.IDLEntity;

public class RepositoryID {
    public static String className(String repId, ClassLoader loader) {
        return RepositoryID.className(repId, null, loader);
    }

    public static String className(String repId, String suffix, ClassLoader loader) {
        if (repId.startsWith("RMI:")) {
            repId = RepositoryID.convertFromISOLatin1(repId);
            return repId.substring(4, repId.indexOf(58, 4)) + (suffix != null ? suffix : "");
        }
        if (repId.startsWith("IDL:")) {
            if (repId.equals(WStringValueHelper.id())) {
                return "java.lang.String";
            }
            if (repId.equals(StringValueHelper.id())) {
                return "java.lang.String";
            }
            String id = repId.substring(4, repId.lastIndexOf(58)) + (suffix != null ? suffix : "");
            int firstSlash = id.indexOf("/");
            String prefix = firstSlash == -1 ? "" : id.substring(0, firstSlash);
            if (prefix.equals("omg.org")) {
                return RepositoryID.ir2scopes("org.omg", id.substring(firstSlash + 1), loader);
            }
            if (prefix.indexOf(46) != -1) {
                return RepositoryID.ir2scopes(RepositoryID.reversePrefix(prefix), id.substring(firstSlash + 1), loader);
            }
            return RepositoryID.ir2scopes("", id, loader);
        }
        throw new INTF_REPOS("Unrecognized RepositoryID: " + repId);
    }

    private static String convertFromISOLatin1(String id) {
        StringBuffer dest = new StringBuffer(id.length());
        int pos = 0;
        int index = -1;
        while ((index = id.indexOf("\\U", pos)) != -1) {
            dest.append(id.substring(pos, index));
            pos = index + 6;
            char theChar = (char)Integer.parseInt(id.substring(index + 2, index + 6), 16);
            dest.append(theChar);
        }
        if (pos < id.length()) {
            dest.append(id.substring(pos));
        }
        return dest.toString();
    }

    private static final String reversePrefix(String prefix) {
        StringTokenizer tok = new StringTokenizer(prefix, ".");
        String result = tok.nextToken();
        while (tok.hasMoreTokens()) {
            result = tok.nextToken() + '.' + result;
        }
        return result;
    }

    private static String ir2scopes(String prefix, String s2, ClassLoader loader) {
        if (s2.indexOf("/") < 0) {
            return s2;
        }
        StringTokenizer strtok = new StringTokenizer(s2, "/");
        int count = strtok.countTokens();
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        int i2 = 0;
        while (strtok.hasMoreTokens()) {
            String sc = strtok.nextToken();
            Class c2 = null;
            c2 = sb.toString().length() > 0 ? RepositoryID.loadClass(sb.toString() + "." + sc, loader) : RepositoryID.loadClass(sc, loader);
            if (c2 == null) {
                if (sb.toString().length() > 0) {
                    sb.append("." + sc);
                } else {
                    sb.append(sc);
                }
            } else if (i2 < count - 1) {
                sb.append("." + sc + "Package");
            } else {
                sb.append("." + sc);
            }
            ++i2;
        }
        return sb.toString();
    }

    public static String repId(Class c2) {
        if (IDLEntity.class.isAssignableFrom(c2)) {
            String className = c2.getName();
            String body = "";
            if (className.startsWith("org.omg") || className.startsWith("org/omg")) {
                if (className.length() > 7) {
                    body = className.substring(7);
                }
                return "IDL:omg.org/" + RepositoryID.scopesToIR(body) + ":1.0";
            }
            return "IDL:" + RepositoryID.scopesToIR(className) + ":1.0";
        }
        return ValueHandler.getRMIRepositoryID(c2);
    }

    private static String scopesToIR(String s2) {
        if (s2.indexOf(".") < 0) {
            return s2;
        }
        StringTokenizer strtok = new StringTokenizer(s2, ".");
        String[] scopes = new String[strtok.countTokens()];
        int i2 = 0;
        while (strtok.hasMoreTokens()) {
            String sc = strtok.nextToken();
            scopes[i2] = sc.endsWith("Package") ? sc.substring(0, sc.indexOf("Package")) : sc;
            ++i2;
        }
        StringBuffer sb = new StringBuffer();
        if (scopes.length > 1) {
            for (int i3 = 0; i3 < scopes.length - 1; ++i3) {
                sb.append(scopes[i3] + "/");
            }
        }
        sb.append(scopes[scopes.length - 1]);
        return sb.toString();
    }

    public static String toRepositoryID(String className, boolean resolveClass, ClassLoader loader) {
        if (className.equals("") || className.startsWith("IDL:") || className.startsWith("RMI:")) {
            return className;
        }
        if (resolveClass) {
            Class c2 = RepositoryID.loadClass(className, loader);
            if (c2 == null) {
                throw new IllegalArgumentException("cannot find class: " + className);
            }
            return RepositoryID.repId(c2);
        }
        return "IDL:" + className + ":1.0";
    }

    public static String toRepositoryID(String className, ClassLoader loader) {
        return RepositoryID.toRepositoryID(className, true, loader);
    }

    private static Class loadClass(String name, ClassLoader loader) {
        try {
            if (loader != null) {
                return loader.loadClass(name);
            }
            return ObjectUtil.classForName(name);
        }
        catch (ClassNotFoundException e2) {
            return null;
        }
    }

    public static BoxedValueHelper createBoxedValueHelper(String repId, ClassLoader loader) {
        String className = RepositoryID.className(repId, "Helper", loader);
        Class clazz = RepositoryID.loadClass(className, loader);
        if (clazz != null) {
            try {
                return (BoxedValueHelper)clazz.newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return null;
    }
}

