/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStreamConfiguration;
import org.jacorb.orb.DataOutputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.EncapsInfo;
import org.jacorb.orb.IBufferManager;
import org.jacorb.orb.IORMutator;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ORBSingleton;
import org.jacorb.orb.TypeCode;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.typecode.DelegatingTypeCodeWriter;
import org.jacorb.orb.typecode.TypeCodeCompactor;
import org.jacorb.util.ObjectUtil;
import org.jacorb.util.Stack;
import org.jacorb.util.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.StringValueHelper;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.WStringValueHelper;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedProfile;

public class CDROutputStream
extends org.omg.CORBA_2_3.portable.OutputStream {
    private static final IOR null_ior = new IOR("", new TaggedProfile[0]);
    private int index;
    private int pos;
    private int deferred_writes;
    private final IBufferManager bufMgr;
    protected byte[] buffer;
    private boolean closed;
    private int codeSet = CodeSet.getTCSDefault();
    private int codeSetW = CodeSet.getTCSWDefault();
    private int encaps_start = -1;
    private Stack encaps_stack;
    private Map valueMap;
    private Map repIdMap;
    private Map codebaseMap;
    private Map repeatedTCMap;
    private Map recursiveTCMap;
    private int chunk_size_tag_pos = -1;
    private int chunk_size_tag_index;
    private int chunk_octets_pos;
    private int valueNestingLevel = 0;
    private int writeValueNestingLevel = 0;
    private boolean writeReplaceCalled = false;
    private List deferredArrayQueue;
    protected final ORBSingleton orb;
    protected int giop_minor = 2;
    private int chunkingFlag = 0;
    private IORMutator mutator;
    private boolean isMutatorEnabled;
    private boolean codesetEnabled;
    private boolean useBOM = false;
    private boolean chunkCustomRmiValuetypes = false;
    private boolean useIndirection = true;
    private boolean enableNullString = false;
    private final TypeCodeCompactor typeCodeCompactor;
    private static final DelegatingTypeCodeWriter typeCodeWriter = new DelegatingTypeCodeWriter();

    private void configure(Configuration configuration) throws ConfigurationException {
        org.jacorb.config.Configuration jconfig = (org.jacorb.config.Configuration)configuration;
        CDROutputStreamConfiguration cdrOutConfig = (CDROutputStreamConfiguration)jconfig.getAttributeAsObject("jacorb.orb.cdr.out.config", CDROutputStreamConfiguration.CONFIG_DEFAULT);
        this.codesetEnabled = cdrOutConfig.codesetEnabled;
        this.useBOM = cdrOutConfig.useBOM;
        this.chunkCustomRmiValuetypes = cdrOutConfig.chunkCustomRmiValuetypes;
        this.useIndirection = cdrOutConfig.useIndirection;
        this.isMutatorEnabled = cdrOutConfig.isMutatorEnabled;
        this.enableNullString = cdrOutConfig.enableNullString;
        if (this.isMutatorEnabled) {
            this.mutator = (IORMutator)jconfig.getAttributeAsObject("jacorb.iormutator");
        }
    }

    private CDROutputStream(org.omg.CORBA.ORB orb, int bufferSize) {
        if (!(orb instanceof ORBSingleton)) {
            throw new BAD_PARAM("don't pass in a non JacORB ORB");
        }
        this.orb = (ORBSingleton)orb;
        this.bufMgr = this.orb.getBufferManager();
        this.typeCodeCompactor = this.orb.getTypeCodeCompactor();
        this.buffer = bufferSize == -1 ? this.bufMgr.getPreferredMemoryBuffer() : this.bufMgr.getBuffer(bufferSize);
    }

    public CDROutputStream(org.omg.CORBA.ORB orb) {
        this(orb, -1);
        if (orb instanceof ORB) {
            try {
                this.configure(((ORB)orb).getConfiguration());
            }
            catch (ConfigurationException e2) {
                throw new INTERNAL(e2.getMessage());
            }
        }
    }

    public CDROutputStream() {
        this(ORB.init());
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    private Stack getEncapsStack() {
        if (this.encaps_stack == null) {
            this.encaps_stack = new Stack();
        }
        return this.encaps_stack;
    }

    private Map getValueMap() {
        if (this.valueMap == null) {
            this.valueMap = new IdentityHashMap();
        }
        return this.valueMap;
    }

    private Map getRepIdMap() {
        if (this.repIdMap == null) {
            this.repIdMap = new HashMap();
        }
        return this.repIdMap;
    }

    private Map getCodebaseMap() {
        if (this.codebaseMap == null) {
            this.codebaseMap = new HashMap();
        }
        return this.codebaseMap;
    }

    public void write(OutputStream out, int start, int length) throws IOException {
        int deferredWriteFrameCount;
        int stop = start + length;
        int write_idx = start;
        int read_idx = start;
        int skip_count = 0;
        int list_idx = 0;
        DeferredWriteFrame next_frame = null;
        int n2 = deferredWriteFrameCount = this.deferredArrayQueue == null ? -1 : this.deferredArrayQueue.size();
        if (deferredWriteFrameCount > 0) {
            next_frame = (DeferredWriteFrame)this.deferredArrayQueue.get(list_idx++);
            while (next_frame.write_pos < start && list_idx < deferredWriteFrameCount) {
                skip_count += next_frame.length;
                next_frame = (DeferredWriteFrame)this.deferredArrayQueue.get(list_idx++);
            }
            if (next_frame.write_pos < start && list_idx >= deferredWriteFrameCount) {
                skip_count += next_frame.length;
                next_frame = null;
            }
        }
        while (write_idx < stop) {
            if (next_frame != null && write_idx == next_frame.write_pos) {
                if (next_frame.length > stop - write_idx) {
                    throw new MARSHAL("Deferred array does not fit");
                }
                out.write(next_frame.buf, next_frame.start, next_frame.length);
                write_idx += next_frame.length;
                next_frame = null;
                if (list_idx < deferredWriteFrameCount) {
                    next_frame = (DeferredWriteFrame)this.deferredArrayQueue.get(list_idx++);
                    if (next_frame.write_pos > stop) {
                        next_frame = null;
                    }
                }
            }
            if (write_idx >= stop) continue;
            int write_now = Math.min(stop, next_frame != null ? next_frame.write_pos : stop);
            out.write(this.buffer, read_idx - skip_count, write_now -= write_idx);
            read_idx += write_now;
            write_idx += write_now;
        }
    }

    public void setCodeSet(int codeSet, int codeSetWide) {
        this.codeSet = codeSet;
        this.codeSetW = codeSetWide;
    }

    public void setGIOPMinor(int giop_minor) {
        this.giop_minor = giop_minor;
    }

    public int getGIOPMinor() {
        return this.giop_minor;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.bufMgr.returnBuffer(this.buffer, true);
        this.buffer = null;
        this.closed = true;
        this.deferredArrayQueue = null;
        this.deferred_writes = 0;
    }

    public final void check(int i2, int align) {
        int remainder = align - this.index % align;
        this.check(i2 + remainder);
        if (remainder != align) {
            int blp = this.buffer.length - this.pos;
            int topad = blp <= 8 ? blp : 8;
            Arrays.fill(this.buffer, this.pos, this.pos + topad, (byte)0);
            this.index += remainder;
            this.pos += remainder;
        }
    }

    private final void check(int i2) {
        int requiredSize = this.pos + i2 + 2;
        if (this.buffer == null || requiredSize > this.buffer.length) {
            byte[] new_buf = this.bufMgr.getExpandedBuffer(requiredSize);
            if (this.buffer != null) {
                System.arraycopy(this.buffer, 0, new_buf, 0, this.pos);
            }
            this.bufMgr.returnBuffer(this.buffer, true);
            this.buffer = new_buf;
        }
    }

    private static final void _write4int(byte[] buf, int _pos, int value) {
        buf[_pos] = (byte)(value >> 24 & 0xFF);
        buf[_pos + 1] = (byte)(value >> 16 & 0xFF);
        buf[_pos + 2] = (byte)(value >> 8 & 0xFF);
        buf[_pos + 3] = (byte)(value & 0xFF);
    }

    public final void beginEncapsulation() {
        this.check(8, 4);
        this.pos += 4;
        this.index += 4;
        this.getEncapsStack().push(new EncapsInfo(this.index, this.encaps_start, this.getValueMap(), this.getRepIdMap(), this.getCodebaseMap()));
        this.valueMap = new IdentityHashMap();
        this.repIdMap = new HashMap();
        this.codebaseMap = new HashMap();
        this.encaps_start = this.pos;
        this.beginEncapsulatedArray();
    }

    public final void beginEncapsulatedArray() {
        this.index = 0;
        this.buffer[this.pos++] = 0;
        ++this.index;
    }

    public final void endEncapsulation() {
        if (this.encaps_start == -1) {
            throw new MARSHAL("Too many end-of-encapsulations");
        }
        if (this.encaps_stack == null) {
            throw new MARSHAL("Internal Error - closeEncapsulation failed");
        }
        int encaps_size = this.pos - this.encaps_start;
        this.buffer[this.encaps_start - 4] = (byte)(encaps_size >>> 24 & 0xFF);
        this.buffer[this.encaps_start - 3] = (byte)(encaps_size >>> 16 & 0xFF);
        this.buffer[this.encaps_start - 2] = (byte)(encaps_size >>> 8 & 0xFF);
        this.buffer[this.encaps_start - 1] = (byte)(encaps_size & 0xFF);
        EncapsInfo ei = (EncapsInfo)this.getEncapsStack().pop();
        this.encaps_start = ei.start;
        this.index = ei.index + encaps_size;
        this.valueMap = ei.valueMap;
        this.repIdMap = ei.repIdMap;
        this.codebaseMap = ei.codebaseMap;
    }

    public byte[] getBufferCopy() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.size());
        try {
            this.write(bos, 0, this.size());
        }
        catch (IOException e2) {
            throw new INTERNAL("should not happen: " + e2.toString());
        }
        return bos.toByteArray();
    }

    public int size() {
        return this.pos + this.deferred_writes;
    }

    public final void skip(int step) {
        this.pos += step;
        this.index += step;
    }

    public final void reduceSize(int amount) {
        this.pos -= amount;
    }

    public final void increaseSize(int amount) {
        this.check(amount);
        this.pos += amount;
    }

    public void setBuffer(byte[] b2) {
        this.bufMgr.returnBuffer(this.buffer, true);
        this.buffer = b2;
        if (this.deferredArrayQueue != null) {
            this.deferredArrayQueue.clear();
        }
        this.pos = 0;
        this.deferred_writes = 0;
        this.index = 0;
    }

    public org.omg.CORBA.portable.InputStream create_input_stream() {
        if (this.deferred_writes > 0) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.index + 1);
            try {
                this.write(baos, 0, this.index);
            }
            catch (IOException e2) {
                throw new MARSHAL(e2.toString());
            }
            return new CDRInputStream(this.orb(), baos.toByteArray());
        }
        byte[] result = new byte[this.index];
        System.arraycopy(this.buffer, 0, result, 0, result.length);
        return new CDRInputStream(this.orb, result);
    }

    public final void write_any(Any value) {
        this.write_TypeCode(value.type());
        value.write_value(this);
    }

    public final void write_boolean(boolean value) {
        this.check(1);
        this.buffer[this.pos++] = value ? (byte)1 : 0;
        ++this.index;
    }

    public final void write_boolean_array(boolean[] value, int offset, int length) {
        if (value == null) {
            return;
        }
        this.check(length);
        if (length == 0) {
            return;
        }
        int max = offset + length;
        int i2 = offset;
        do {
            this.buffer[this.pos] = value[i2] ? (byte)1 : 0;
            ++this.pos;
        } while (++i2 < max);
        this.index += length;
    }

    public final void write_char(char c2) {
        if (c2 > '\u00ff') {
            throw new DATA_CONVERSION("Char " + c2 + " out of range");
        }
        this.check(1);
        this.buffer[this.pos++] = (byte)c2;
        ++this.index;
    }

    public final void write_char_array(char[] value, int start, int length) {
        if (value == null) {
            throw new MARSHAL("Cannot marshall null array.");
        }
        if (start + length > value.length || length < 0 || start < 0) {
            throw new MARSHAL("Cannot marshall as indices for array are out bounds.");
        }
        this.check(length);
        if (length == 0) {
            return;
        }
        int stop = start + length;
        int i2 = start;
        do {
            if (value[i2] > '\u00ff') {
                throw new DATA_CONVERSION("Char " + value[i2] + " out of range");
            }
            this.buffer[this.pos++] = (byte)value[i2];
        } while (++i2 < stop);
        this.index += length;
    }

    public final void write_string(String value) {
        if (value == null) {
            if (this.enableNullString) {
                this.write_long(0);
                return;
            }
            throw new MARSHAL("Cannot marshall null string.");
        }
        int valueLength = value.length();
        if (valueLength == 0) {
            this.write_long(1);
            this.write_octet((byte)0);
        } else {
            int size = this.codesetEnabled ? 4 + 3 * valueLength + 1 : 4 + valueLength + 1;
            this.check(size, 4);
            int sizePosition = this.pos;
            this.pos += 4;
            this.index += 4;
            int i2 = 0;
            do {
                if (this.codesetEnabled) {
                    this.write_char_i(value.charAt(i2), false, false, this.codeSet);
                    continue;
                }
                this.buffer[this.pos++] = (byte)value.charAt(i2);
                ++this.index;
            } while (++i2 < valueLength);
            this.buffer[this.pos++] = 0;
            ++this.index;
            size = this.pos - (sizePosition + 4);
            CDROutputStream._write4int(this.buffer, sizePosition, size);
        }
    }

    public final void write_wchar(char c2) {
        this.check(3);
        this.write_char_i(c2, this.useBOM, true, this.codeSetW);
    }

    private final void write_char_i(char c2, boolean write_bom, boolean write_length_indicator, int cs) {
        switch (cs) {
            case 65537: {
                this.buffer[this.pos++] = (byte)c2;
                ++this.index;
                break;
            }
            case 0x5010001: {
                if (c2 <= '\u007f') {
                    if (this.giop_minor == 2 && write_length_indicator) {
                        this.buffer[this.pos++] = 1;
                        ++this.index;
                    }
                    this.buffer[this.pos++] = (byte)c2;
                    ++this.index;
                    break;
                }
                if (c2 > '\u07ff') {
                    if (this.giop_minor == 2 && write_length_indicator) {
                        this.buffer[this.pos++] = 3;
                        ++this.index;
                    }
                    this.buffer[this.pos++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                    this.buffer[this.pos++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                    this.buffer[this.pos++] = (byte)(0x80 | c2 >> 0 & 0x3F);
                    this.index += 3;
                    break;
                }
                if (this.giop_minor == 2 && write_length_indicator) {
                    this.buffer[this.pos++] = 2;
                    ++this.index;
                }
                this.buffer[this.pos++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                this.buffer[this.pos++] = (byte)(0x80 | c2 >> 0 & 0x3F);
                this.index += 2;
                break;
            }
            case 65801: {
                if (this.giop_minor == 2) {
                    if (write_length_indicator) {
                        this.buffer[this.pos++] = 2;
                        ++this.index;
                    }
                    if (write_bom) {
                        this.buffer[this.pos++] = -2;
                        this.buffer[this.pos++] = -1;
                        this.index += 2;
                    }
                    this.buffer[this.pos++] = (byte)(c2 >> 8 & 0xFF);
                    this.buffer[this.pos++] = (byte)(c2 & 0xFF);
                    this.index += 2;
                    break;
                }
                this.write_short((short)c2);
                break;
            }
            default: {
                throw new CODESET_INCOMPATIBLE("Bad codeset: " + this.codeSet);
            }
        }
    }

    public final void write_wchar_array(char[] value, int offset, int length) {
        if (value == null) {
            throw new MARSHAL("Null References");
        }
        this.check(length * 3);
        for (int i2 = offset; i2 < offset + length; ++i2) {
            this.write_wchar(value[i2]);
        }
    }

    public final void write_wstring(String s2) {
        if (s2 == null) {
            throw new MARSHAL("Null References");
        }
        this.check(4 + s2.length() * 3 + 3, 4);
        int startPos = this.pos;
        this.pos += 4;
        this.index += 4;
        if (this.giop_minor == 2 && this.useBOM && s2.length() > 0) {
            this.buffer[this.pos++] = -2;
            this.buffer[this.pos++] = -1;
            this.index += 2;
        }
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            this.write_char_i(s2.charAt(i2), false, false, this.codeSetW);
        }
        if (this.giop_minor < 2) {
            this.write_char_i('\u0000', false, false, this.codeSetW);
        }
        int str_size = 0;
        if (this.giop_minor == 2) {
            str_size = this.pos - startPos - 4;
        } else if (this.codeSetW == 0x5010001) {
            str_size = this.pos - startPos - 4;
        } else if (this.codeSetW == 65801) {
            str_size = s2.length() + 1;
        }
        CDROutputStream._write4int(this.buffer, startPos, str_size);
    }

    public final void write_double(double value) {
        this.write_longlong(Double.doubleToLongBits(value));
    }

    public final void write_double_array(double[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.check(7 + length * 8, 8);
        if (value != null) {
            for (int i2 = offset; i2 < offset + length; ++i2) {
                long d2 = Double.doubleToLongBits(value[i2]);
                this.buffer[this.pos] = (byte)(d2 >>> 56 & 0xFFL);
                this.buffer[this.pos + 1] = (byte)(d2 >>> 48 & 0xFFL);
                this.buffer[this.pos + 2] = (byte)(d2 >>> 40 & 0xFFL);
                this.buffer[this.pos + 3] = (byte)(d2 >>> 32 & 0xFFL);
                this.buffer[this.pos + 4] = (byte)(d2 >>> 24 & 0xFFL);
                this.buffer[this.pos + 5] = (byte)(d2 >>> 16 & 0xFFL);
                this.buffer[this.pos + 6] = (byte)(d2 >>> 8 & 0xFFL);
                this.buffer[this.pos + 7] = (byte)(d2 & 0xFFL);
                this.pos += 8;
            }
            this.index += 8 * length;
        }
    }

    public void write_fixed(BigDecimal value, short digits, short scale) {
        int b2;
        byte[] representation;
        String v = value.unscaledValue().toString();
        if (v.startsWith("-")) {
            v = v.substring(1);
        }
        if (v.length() % 2 == 0) {
            representation = new byte[v.length() / 2 + 1];
            representation[0] = 0;
            for (int i2 = 0; i2 < v.length(); ++i2) {
                int c2 = Character.digit(v.charAt(i2), 10);
                b2 = representation[(1 + i2) / 2] << 4;
                representation[(1 + i2) / 2] = (byte)(b2 |= c2);
            }
        } else {
            representation = new byte[(v.length() + 1) / 2];
            for (int i3 = 0; i3 < v.length(); ++i3) {
                int c3 = Character.digit(v.charAt(i3), 10);
                b2 = representation[i3 / 2] << 4;
                representation[i3 / 2] = (byte)(b2 |= c3);
            }
        }
        b2 = representation[representation.length - 1] << 4;
        representation[representation.length - 1] = (byte)(value.signum() < 0 ? b2 | 0xD : b2 | 0xC);
        this.check(representation.length);
        System.arraycopy(representation, 0, this.buffer, this.pos, representation.length);
        this.index += representation.length;
        this.pos += representation.length;
    }

    public void write_fixed(BigDecimal value) {
        this.write_fixed(value, (short)-1, (short)-1);
    }

    public final void write_float(float value) {
        this.write_long(Float.floatToIntBits(value));
    }

    public final void write_float_array(float[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.check(3 + length * 4, 4);
        if (value != null) {
            for (int i2 = offset; i2 < offset + length; ++i2) {
                CDROutputStream._write4int(this.buffer, this.pos, Float.floatToIntBits(value[i2]));
                this.pos += 4;
            }
            this.index += 4 * length;
        }
    }

    public final void write_long(int value) {
        this.check(7, 4);
        CDROutputStream._write4int(this.buffer, this.pos, value);
        this.pos += 4;
        this.index += 4;
    }

    public final void write_long_array(int[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.check(3 + length * 4, 4);
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (value != null) {
            for (int i2 = offset; i2 < offset + length; ++i2) {
                CDROutputStream._write4int(this.buffer, this.pos, value[i2]);
                this.pos += 4;
            }
            this.index += 4 * length;
        }
    }

    public final void write_longlong(long value) {
        this.check(15, 8);
        this.buffer[this.pos] = (byte)(value >>> 56 & 0xFFL);
        this.buffer[this.pos + 1] = (byte)(value >>> 48 & 0xFFL);
        this.buffer[this.pos + 2] = (byte)(value >>> 40 & 0xFFL);
        this.buffer[this.pos + 3] = (byte)(value >>> 32 & 0xFFL);
        this.buffer[this.pos + 4] = (byte)(value >>> 24 & 0xFFL);
        this.buffer[this.pos + 5] = (byte)(value >>> 16 & 0xFFL);
        this.buffer[this.pos + 6] = (byte)(value >>> 8 & 0xFFL);
        this.buffer[this.pos + 7] = (byte)(value & 0xFFL);
        this.index += 8;
        this.pos += 8;
    }

    public final void write_longlong_array(long[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.check(7 + length * 8, 8);
        if (value != null) {
            for (int i2 = offset; i2 < offset + length; ++i2) {
                this.buffer[this.pos] = (byte)(value[i2] >>> 56 & 0xFFL);
                this.buffer[this.pos + 1] = (byte)(value[i2] >>> 48 & 0xFFL);
                this.buffer[this.pos + 2] = (byte)(value[i2] >>> 40 & 0xFFL);
                this.buffer[this.pos + 3] = (byte)(value[i2] >>> 32 & 0xFFL);
                this.buffer[this.pos + 4] = (byte)(value[i2] >>> 24 & 0xFFL);
                this.buffer[this.pos + 5] = (byte)(value[i2] >>> 16 & 0xFFL);
                this.buffer[this.pos + 6] = (byte)(value[i2] >>> 8 & 0xFFL);
                this.buffer[this.pos + 7] = (byte)(value[i2] & 0xFFL);
                this.pos += 8;
            }
            this.index += 8 * length;
        }
    }

    public void write_Object(Object value) {
        if (value == null) {
            IORHelper.write(this, null_ior);
        } else {
            if (value instanceof LocalObject) {
                throw new MARSHAL("Attempt to serialize a locality-constrained object.");
            }
            ObjectImpl obj = (ObjectImpl)value;
            IOR intermediary = ((Delegate)obj._get_delegate()).getIOR();
            if (this.isMutatorEnabled) {
                intermediary = this.mutator.mutateOutgoing(intermediary);
            }
            IORHelper.write(this, intermediary);
        }
    }

    public void write_IOR(IOR ior) {
        if (ior == null) {
            IORHelper.write(this, null_ior);
        } else {
            IORHelper.write(this, ior);
        }
    }

    public final void write_octet(byte value) {
        this.check(1);
        ++this.index;
        this.buffer[this.pos++] = value;
    }

    public final void write_octet_array(byte[] value, int offset, int length) {
        if (value != null) {
            if (length > 4000) {
                if (this.deferredArrayQueue == null) {
                    this.deferredArrayQueue = new ArrayList();
                }
                this.deferredArrayQueue.add(new DeferredWriteFrame(this.index, offset, length, value));
                this.index += length;
                this.deferred_writes += length;
            } else {
                this.check(length);
                System.arraycopy(value, offset, this.buffer, this.pos, length);
                this.index += length;
                this.pos += length;
            }
        }
    }

    public final void write_Principal(Principal value) {
        throw new NO_IMPLEMENT("Principal deprecated");
    }

    public final void write_short(short value) {
        this.check(3, 2);
        this.buffer[this.pos++] = (byte)(value >>> 8);
        this.buffer[this.pos++] = (byte)value;
        this.index += 2;
    }

    public final void write_short_array(short[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.check(2 * length + 3);
        int remainder = 2 - this.index % 2;
        if (remainder != 2) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (value != null) {
            for (int i2 = offset; i2 < offset + length; ++i2) {
                this.buffer[this.pos++] = (byte)(value[i2] >>> 8);
                this.buffer[this.pos++] = (byte)value[i2];
            }
            this.index += 2 * length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write_TypeCode(org.omg.CORBA.TypeCode typeCode) {
        if (typeCode == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        typeCode = this.typeCodeCompactor.getCompactTypeCode(typeCode);
        if (this.repeatedTCMap == null) {
            this.repeatedTCMap = new HashMap();
        }
        if (this.recursiveTCMap == null) {
            this.recursiveTCMap = new HashMap();
        }
        try {
            this.write_TypeCode(typeCode, this.recursiveTCMap, this.repeatedTCMap);
        }
        finally {
            this.repeatedTCMap.clear();
            this.recursiveTCMap.clear();
        }
    }

    public final void write_TypeCode(org.omg.CORBA.TypeCode typeCode, Map recursiveTCMap, Map repeatedTCMap) {
        typeCodeWriter.writeTypeCode(typeCode, this, recursiveTCMap, repeatedTCMap);
    }

    public final void write_ulong(int value) {
        this.write_long(value);
    }

    public final void write_ulong_array(int[] value, int offset, int length) {
        this.write_long_array(value, offset, length);
    }

    public final void write_ulonglong(long value) {
        this.write_longlong(value);
    }

    public final void write_ulonglong_array(long[] value, int offset, int length) {
        this.write_longlong_array(value, offset, length);
    }

    public final void write_ushort(short value) {
        this.write_short(value);
    }

    public final void write_ushort_array(short[] value, int offset, int length) {
        this.write_short_array(value, offset, length);
    }

    public final void write_value(org.omg.CORBA.TypeCode typeCode, org.omg.CORBA.portable.InputStream input) {
        if (typeCode == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        int kind = typeCode.kind().value();
        try {
            switch (kind) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    this.write_short(input.read_short());
                    break;
                }
                case 3: {
                    this.write_long(input.read_long());
                    break;
                }
                case 4: {
                    this.write_ushort(input.read_ushort());
                    break;
                }
                case 5: {
                    this.write_ulong(input.read_ulong());
                    break;
                }
                case 6: {
                    this.write_float(input.read_float());
                    break;
                }
                case 7: {
                    this.write_double(input.read_double());
                    break;
                }
                case 8: {
                    this.write_boolean(input.read_boolean());
                    break;
                }
                case 9: {
                    this.write_char(input.read_char());
                    break;
                }
                case 10: {
                    this.write_octet(input.read_octet());
                    break;
                }
                case 11: {
                    this.write_any(input.read_any());
                    break;
                }
                case 12: {
                    this.write_TypeCode(input.read_TypeCode());
                    break;
                }
                case 13: {
                    throw new NO_IMPLEMENT("Principal deprecated");
                }
                case 14: {
                    this.write_Object(input.read_Object());
                    break;
                }
                case 15: {
                    for (int i2 = 0; i2 < typeCode.member_count(); ++i2) {
                        this.write_value(typeCode.member_type(i2), input);
                    }
                    break;
                }
                case 16: {
                    org.omg.CORBA.TypeCode disc = typeCode.discriminator_type();
                    disc = TypeCode.originalType(disc);
                    int def_idx = typeCode.default_index();
                    int member_idx = -1;
                    block33 : switch (disc.kind().value()) {
                        case 2: {
                            short s2 = input.read_short();
                            this.write_short(s2);
                            for (int i3 = 0; i3 < typeCode.member_count(); ++i3) {
                                if (i3 == def_idx || s2 != typeCode.member_label(i3).extract_short()) continue;
                                member_idx = i3;
                                break block33;
                            }
                            break;
                        }
                        case 3: {
                            int s3 = input.read_long();
                            this.write_long(s3);
                            for (int i4 = 0; i4 < typeCode.member_count(); ++i4) {
                                if (i4 == def_idx || s3 != typeCode.member_label(i4).extract_long()) continue;
                                member_idx = i4;
                                break block33;
                            }
                            break;
                        }
                        case 4: {
                            short s4 = input.read_ushort();
                            this.write_ushort(s4);
                            for (int i5 = 0; i5 < typeCode.member_count(); ++i5) {
                                if (i5 == def_idx || s4 != typeCode.member_label(i5).extract_ushort()) continue;
                                member_idx = i5;
                                break block33;
                            }
                            break;
                        }
                        case 5: {
                            int s5 = input.read_ulong();
                            this.write_ulong(s5);
                            for (int i6 = 0; i6 < typeCode.member_count(); ++i6) {
                                if (i6 == def_idx || s5 != typeCode.member_label(i6).extract_ulong()) continue;
                                member_idx = i6;
                                break block33;
                            }
                            break;
                        }
                        case 6: 
                        case 7: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                        case 8: {
                            boolean s6 = input.read_boolean();
                            this.write_boolean(s6);
                            for (int i7 = 0; i7 < typeCode.member_count(); ++i7) {
                                if (i7 == def_idx || s6 != typeCode.member_label(i7).extract_boolean()) continue;
                                member_idx = i7;
                                break block33;
                            }
                            break;
                        }
                        case 9: {
                            char s7 = input.read_char();
                            this.write_char(s7);
                            for (int i8 = 0; i8 < typeCode.member_count(); ++i8) {
                                if (i8 == def_idx || s7 != typeCode.member_label(i8).extract_char()) continue;
                                member_idx = i8;
                                break block33;
                            }
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                        case 17: {
                            int s8 = input.read_long();
                            this.write_long(s8);
                            for (int i9 = 0; i9 < typeCode.member_count(); ++i9) {
                                int label;
                                if (i9 == def_idx || s8 != (label = typeCode.member_label(i9).create_input_stream().read_long())) continue;
                                member_idx = i9;
                                break block33;
                            }
                            break;
                        }
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                        case 23: {
                            long s9 = input.read_longlong();
                            this.write_longlong(s9);
                            for (int i10 = 0; i10 < typeCode.member_count(); ++i10) {
                                if (i10 == def_idx || s9 != typeCode.member_label(i10).extract_longlong()) continue;
                                member_idx = i10;
                                break block33;
                            }
                            break;
                        }
                        case 24: {
                            long s10 = input.read_ulonglong();
                            this.write_ulonglong(s10);
                            for (int i11 = 0; i11 < typeCode.member_count(); ++i11) {
                                if (i11 == def_idx || s10 != typeCode.member_label(i11).extract_ulonglong()) continue;
                                member_idx = i11;
                                break block33;
                            }
                            break;
                        }
                        default: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                    }
                    if (member_idx != -1) {
                        this.write_value(typeCode.member_type(member_idx), input);
                        break;
                    }
                    if (def_idx != -1) {
                        this.write_value(typeCode.member_type(def_idx), input);
                    }
                    break;
                }
                case 17: {
                    this.write_long(input.read_long());
                    break;
                }
                case 18: {
                    this.write_string(input.read_string());
                    break;
                }
                case 19: {
                    int len = input.read_long();
                    this.write_long(len);
                    org.omg.CORBA.TypeCode content_tc = typeCode.content_type();
                    for (int i12 = 0; i12 < len; ++i12) {
                        this.write_value(content_tc, input);
                    }
                    break;
                }
                case 20: {
                    int length = typeCode.length();
                    if (typeCode.content_type().kind().value() == 10) {
                        this.check(length);
                        input.read_octet_array(this.buffer, this.pos, length);
                        this.index += length;
                        this.pos += length;
                        break;
                    }
                    for (int i13 = 0; i13 < length; ++i13) {
                        this.write_value(typeCode.content_type(), input);
                    }
                    break;
                }
                case 21: {
                    this.write_value(typeCode.content_type(), input);
                    break;
                }
                case 22: {
                    this.write_string(input.read_string());
                    for (int i14 = 0; i14 < typeCode.member_count(); ++i14) {
                        this.write_value(typeCode.member_type(i14), input);
                    }
                    break;
                }
                case 23: {
                    this.write_longlong(input.read_longlong());
                    break;
                }
                case 24: {
                    this.write_ulonglong(input.read_ulonglong());
                    break;
                }
                case 25: {
                    throw new BAD_TYPECODE("type longdouble not supported in java");
                }
                case 26: {
                    this.write_wchar(input.read_wchar());
                    break;
                }
                case 27: {
                    this.write_wstring(input.read_wstring());
                    break;
                }
                case 28: {
                    short digits = typeCode.fixed_digits();
                    short scale = typeCode.fixed_scale();
                    BigDecimal value = input instanceof CDRInputStream ? ((CDRInputStream)input).read_fixed(digits, scale) : input.read_fixed();
                    this.write_fixed(value, digits, scale);
                    break;
                }
                case 29: {
                    Serializable val = ((InputStream)input).read_value();
                    this.write_value(val, typeCode.id());
                    break;
                }
                case 30: {
                    String id = typeCode.id();
                    BoxedValueHelper helper = ((ORB)this.orb()).getBoxedValueHelper(id);
                    if (helper == null) {
                        throw new MARSHAL("No BoxedValueHelper for id " + id);
                    }
                    Serializable value = ((InputStream)input).read_value(helper);
                    this.write_value(value, helper);
                    break;
                }
                default: {
                    throw new MARSHAL("Cannot handle TypeCode with kind " + kind);
                }
            }
        }
        catch (BadKind ex) {
            throw new MARSHAL("When processing TypeCode with kind: " + kind + " caught " + ex);
        }
        catch (Bounds ex) {
            throw new MARSHAL("When processing TypeCode with kind: " + kind + " caught " + ex);
        }
    }

    public void write_value(Serializable value) {
        if (!this.write_special_value(value)) {
            this.write_value_internal(value, ValueHandler.getRMIRepositoryID(value.getClass()));
        }
    }

    public void write_value(Serializable value, BoxedValueHelper factory) {
        if (!this.write_special_value(value)) {
            this.check(7, 4);
            this.getValueMap().put(value, ObjectUtil.newInteger(this.size()));
            this.write_previous_chunk_size();
            if (value instanceof IDLEntity || this.isSimpleString(value, factory)) {
                this.write_long(0x7FFFFF00 | this.chunkingFlag);
            } else {
                this.write_long(0x7FFFFF02 | this.chunkingFlag);
                String repId = factory.get_id();
                this.write_repository_id(repId);
            }
            this.start_chunk();
            factory.write_value(this, value);
            this.end_chunk();
        }
    }

    private boolean isSimpleString(Serializable value, BoxedValueHelper factory) {
        if (!(value instanceof String)) {
            return false;
        }
        if (factory.get_id().equals(StringValueHelper.id())) {
            return false;
        }
        return !factory.get_id().equals(WStringValueHelper.id());
    }

    public void write_value(Serializable value, Class clazz) {
        if (!this.write_special_value(value)) {
            Class<?> _clazz = value.getClass();
            String repId = ValueHandler.getRMIRepositoryID(_clazz);
            if (_clazz == clazz && !repId.startsWith("RMI:")) {
                this.write_value_internal(value, null);
            } else if (clazz.isInstance(value)) {
                this.write_value_internal(value, repId);
            } else {
                throw new BAD_PARAM();
            }
        }
    }

    public void write_value(Serializable value, String repository_id) {
        if (!this.write_special_value(value)) {
            this.write_value_internal(value, repository_id);
        }
    }

    private boolean write_special_value(Serializable value) {
        if (value == null) {
            this.write_long(0);
            return true;
        }
        Integer index = (Integer)this.getValueMap().get(value);
        if (index != null) {
            this.write_long(-1);
            this.write_long(index - this.size());
            return true;
        }
        return false;
    }

    private void write_repository_id(String repository_id) {
        Integer _index = (Integer)this.getRepIdMap().get(repository_id);
        if (_index == null) {
            int remainder = 4 - this.index % 4;
            if (remainder != 4) {
                this.index += remainder;
                this.pos += remainder;
            }
            this.getRepIdMap().put(repository_id, ObjectUtil.newInteger(this.size()));
            this.write_string(repository_id);
        } else {
            this.write_long(-1);
            this.write_long(_index - this.size());
        }
    }

    private void write_codebase(String codebase) {
        Integer _index = null;
        if (this.codebaseMap == null) {
            this.codebaseMap = new HashMap();
        } else {
            _index = (Integer)this.getCodebaseMap().get(codebase);
        }
        if (_index == null) {
            int remainder = 4 - this.index % 4;
            if (remainder != 4) {
                this.index += remainder;
                this.pos += remainder;
            }
            this.getCodebaseMap().put(codebase, ObjectUtil.newInteger(this.size()));
            this.write_string(codebase);
        } else {
            this.write_long(-1);
            this.write_long(_index - this.size());
        }
    }

    private void write_value_header(String[] repository_ids) {
        this.write_previous_chunk_size();
        if (repository_ids != null) {
            if (repository_ids.length > 1) {
                this.chunkingFlag = 8;
                this.write_long(0x7FFFFF06 | this.chunkingFlag);
                this.write_long(repository_ids.length);
                for (int i2 = 0; i2 < repository_ids.length; ++i2) {
                    this.write_repository_id(repository_ids[i2]);
                }
            } else {
                this.write_long(0x7FFFFF02 | this.chunkingFlag);
                this.write_repository_id(repository_ids[0]);
            }
        } else {
            this.write_long(0x7FFFFF00 | this.chunkingFlag);
        }
    }

    private void write_value_header(String[] repository_ids, String codebase) {
        if (codebase != null) {
            this.write_previous_chunk_size();
            if (repository_ids != null) {
                if (repository_ids.length > 1) {
                    this.chunkingFlag = 8;
                    this.write_long(0x7FFFFF07 | this.chunkingFlag);
                    this.write_codebase(codebase);
                    this.write_long(repository_ids.length);
                    for (int i2 = 0; i2 < repository_ids.length; ++i2) {
                        this.write_repository_id(repository_ids[i2]);
                    }
                } else {
                    this.write_long(0x7FFFFF03 | this.chunkingFlag);
                    this.write_codebase(codebase);
                    this.write_repository_id(repository_ids[0]);
                }
            } else {
                this.write_long(0x7FFFFF01 | this.chunkingFlag);
                this.write_codebase(codebase);
            }
        } else {
            this.write_value_header(repository_ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write_value_internal(Serializable value, String repository_id) {
        this.check(7, 4);
        this.getValueMap().put(value, ObjectUtil.newInteger(this.size()));
        if (value.getClass() == String.class) {
            String[] stringArray;
            if (repository_id == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = repository_id;
            }
            String[] repository_ids = stringArray;
            this.write_value_header(repository_ids);
            this.start_chunk();
            this.write_wstring((String)((java.lang.Object)value));
            this.end_chunk();
        } else if (value.getClass() == Class.class) {
            Class clazz;
            try {
                clazz = ObjectUtil.classForName("javax.rmi.CORBA.ClassDesc");
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            String[] repository_ids = new String[]{ValueHandler.getRMIRepositoryID(clazz)};
            this.write_value_header(repository_ids);
            this.start_chunk();
            this.write_value((Serializable)((java.lang.Object)ValueHandler.getCodebase((Class)value)));
            this.write_value((Serializable)((java.lang.Object)ValueHandler.getRMIRepositoryID((Class)value)));
            this.end_chunk();
        } else if (value instanceof StreamableValue) {
            StreamableValue streamable = (StreamableValue)value;
            this.write_value_header(streamable._truncatable_ids());
            this.start_chunk();
            ((StreamableValue)value)._write(this);
            this.end_chunk();
        } else if (value instanceof CustomValue) {
            DataOutputStream outputStream = new DataOutputStream(this);
            this.write_value_header(((CustomValue)value)._truncatable_ids());
            ((CustomValue)value).marshal(outputStream);
        } else {
            String[] stringArray;
            if (repository_id == null) {
                stringArray = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = repository_id;
            }
            String[] repository_ids = stringArray;
            Class<?> clazz = value.getClass();
            String codebase = ValueHandler.getCodebase(clazz);
            if (value instanceof IDLEntity) {
                Method writeMethod = null;
                if (clazz != Any.class) {
                    String helperClassName = clazz.getName() + "Helper";
                    try {
                        Class<?> helperClass = clazz.getClassLoader() != null ? clazz.getClassLoader().loadClass(helperClassName) : ObjectUtil.classForName(helperClassName);
                        Class[] paramTypes = new Class[]{org.omg.CORBA.portable.OutputStream.class, clazz};
                        writeMethod = helperClass.getMethod("write", paramTypes);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new MARSHAL("Error loading class " + helperClassName + ": " + e3);
                    }
                    catch (NoSuchMethodException e4) {
                        throw new MARSHAL("No write method in helper class " + helperClassName + ": " + e4);
                    }
                }
                this.write_value_header(repository_ids, codebase);
                this.start_chunk();
                if (writeMethod == null) {
                    this.write_any((Any)value);
                } else {
                    try {
                        writeMethod.invoke(null, this, value);
                    }
                    catch (IllegalAccessException e5) {
                        throw new MARSHAL("Internal error: " + e5);
                    }
                    catch (InvocationTargetException e6) {
                        throw new MARSHAL("Exception marshaling IDLEntity: " + e6.getTargetException());
                    }
                }
                this.end_chunk();
            } else {
                try {
                    ++this.writeValueNestingLevel;
                    if (this.chunkCustomRmiValuetypes && ValueHandler.isCustomMarshaled(clazz)) {
                        this.chunkingFlag = 8;
                    }
                    Serializable newValue = value;
                    if (!this.writeReplaceCalled) {
                        newValue = ValueHandler.writeReplace(value);
                        this.writeReplaceCalled = true;
                    }
                    if (newValue != value) {
                        String[] stringArray4;
                        String new_rep_id = ValueHandler.getRMIRepositoryID(newValue.getClass());
                        if (new_rep_id == null) {
                            stringArray4 = null;
                        } else {
                            String[] stringArray5 = new String[1];
                            stringArray4 = stringArray5;
                            stringArray5[0] = new_rep_id;
                        }
                        repository_ids = stringArray4;
                        clazz = newValue.getClass();
                        codebase = ValueHandler.getCodebase(clazz);
                    }
                    this.write_value_header(repository_ids, codebase);
                    this.start_chunk();
                    if (newValue != value) {
                        Integer index = (Integer)this.getValueMap().get(newValue);
                        if (index != null) {
                            this.write_long(-1);
                            this.write_long(index - this.size());
                        } else if (newValue instanceof Object) {
                            this.write_Object((Object)((java.lang.Object)newValue));
                        } else {
                            ValueHandler.writeValue(this, newValue);
                        }
                    } else {
                        ValueHandler.writeValue(this, value);
                    }
                    this.end_chunk();
                    java.lang.Object var11_22 = null;
                    if (--this.writeValueNestingLevel == 0) {
                        this.writeReplaceCalled = false;
                    }
                }
                catch (Throwable throwable) {
                    java.lang.Object var11_23 = null;
                    if (--this.writeValueNestingLevel == 0) {
                        this.writeReplaceCalled = false;
                    }
                    throw throwable;
                }
            }
        }
    }

    private void start_chunk() {
        if (this.chunkingFlag > 0) {
            this.write_previous_chunk_size();
            ++this.valueNestingLevel;
            this.skip_chunk_size_tag();
        }
    }

    private void end_chunk() {
        if (this.chunkingFlag > 0) {
            this.write_previous_chunk_size();
            this.write_long(-this.valueNestingLevel);
            if (--this.valueNestingLevel == 0) {
                this.chunkingFlag = 0;
            } else {
                this.skip_chunk_size_tag();
            }
        }
    }

    private void write_previous_chunk_size() {
        if (this.chunk_size_tag_pos != -1) {
            if (this.pos != this.chunk_octets_pos) {
                this.rewrite_long(this.chunk_size_tag_pos, this.chunk_size_tag_index, this.pos - this.chunk_octets_pos);
            }
            this.chunk_size_tag_pos = -1;
        }
    }

    private void skip_chunk_size_tag() {
        this.chunk_size_tag_pos = this.pos;
        this.chunk_size_tag_index = this.index;
        this.write_long(0);
        this.chunk_octets_pos = this.pos;
    }

    private final void rewrite_long(int write_pos, int write_index, int value) {
        int align = 4;
        int remainder = 4 - write_index % 4;
        if (remainder != 4) {
            write_index += remainder;
            write_pos += remainder;
        }
        CDROutputStream._write4int(this.buffer, write_pos, value);
    }

    public void write_abstract_interface(java.lang.Object object) {
        if (object instanceof Object) {
            this.write_boolean(true);
            this.write_Object((Object)object);
        } else {
            this.write_boolean(false);
            this.write_value((Serializable)object);
        }
    }

    public void updateMutatorConnection(GIOPConnection connection) {
        if (this.isMutatorEnabled) {
            this.mutator.updateConnection(connection.getTransport());
        }
    }

    public int get_pos() {
        return this.pos;
    }

    public boolean isIndirectionEnabled() {
        return this.useIndirection;
    }

    private static class DeferredWriteFrame {
        public final int write_pos;
        public final int start;
        public final int length;
        public final byte[] buf;

        public DeferredWriteFrame(int write_pos, int start, int length, byte[] buf) {
            this.write_pos = write_pos;
            this.start = start;
            this.length = length;
            this.buf = buf;
        }
    }
}

