/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imrutility.imr.Repository;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.OriginalRememberingRebindRetryStrategy;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.ParsedIOROperations;
import org.jacorb.orb.RebindRetryStrategy;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.ETF.Profile;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;

public class DefaultRebindRetryStrategy
extends OriginalRememberingRebindRetryStrategy {
    private final ORB orb;
    private final boolean isImR;

    public DefaultRebindRetryStrategy(ORB orb, String typeId, Logger logger) {
        super(logger);
        this.orb = orb;
        this.isImR = DefaultRebindRetryStrategy.checkIfImR(typeId);
    }

    private static boolean checkIfImR(String typeId) {
        return "IDL:org/jacorb/imr/ImplementationRepository:1.0".equals(typeId) || "IDL:imr/Repository:1.0".equals(typeId) || "IDL:imr/RepositoryAdmin:1.0".equals(typeId);
    }

    public void pushIOR(ParsedIOROperations ior) {
    }

    public boolean doTryRebind(RebindRetryStrategy.RebindCallback callback, ParsedIOROperations failingIOR, SystemException cause, List serviceContexts) {
        if (this.getOriginalIOR() != null && !this.getOriginalIOR().equals(failingIOR)) {
            boolean rebound = callback.rebind(this.getOriginalIOR());
            return rebound;
        }
        if (this.orb.useIMR() && !this.isImR) {
            ParsedIOR imrIOR;
            Integer orbTypeId = failingIOR.getORBTypeId();
            if (orbTypeId == null || orbTypeId != 1245790976) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Delegate: foreign IOR detected");
                }
                return false;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Delegate: JacORB IOR detected");
            }
            byte[] object_key = failingIOR.get_object_key();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Delegate: attempting to contact ImR");
            }
            Repository imr = null;
            while (true) {
                try {
                    imr = this.orb.getImR();
                    long serverID = -1L;
                    if (this.orb.getImRServerImpl() != null) {
                        serverID = this.orb.getImRServerImpl().id();
                    }
                    imr.ping(serverID);
                }
                catch (Exception e2) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Delegate: failed to contact ImR");
                    if (this.orb.imrDead(imr = null)) continue;
                }
                break;
            }
            if (imr == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("unable to rebind as no ImR could be located.");
                }
                return false;
            }
            try {
                imrIOR = ((Delegate)((ObjectImpl)((Object)imr))._get_delegate()).getParsedIOR();
            }
            catch (ClassCastException e3) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Delegate: Unexpected IMR Stub format", e3);
                }
                return false;
            }
            List imrProfiles = imrIOR.getProfiles();
            TaggedProfile[] newTaggedProfiles = new TaggedProfile[imrProfiles.size()];
            TaggedProfileHolder taggedProfileHolder = new TaggedProfileHolder();
            for (int i2 = 0; i2 < imrProfiles.size(); ++i2) {
                Profile etfProfile = ((Profile)imrProfiles.get(i2)).copy();
                etfProfile.set_object_key(object_key);
                etfProfile.marshal(taggedProfileHolder, null);
                newTaggedProfiles[i2] = taggedProfileHolder.value;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("rebind to server object hosted at the ImR");
            }
            return callback.rebind(new ParsedIOR(this.orb, new IOR(failingIOR.getTypeId(), newTaggedProfiles)));
        }
        if (cause instanceof COMM_FAILURE) {
            this.logger.debug("Delegate: try rebind to IOR that failed before because of COMM_FAILURE");
            boolean rebound = callback.rebind(failingIOR, true);
            return rebound;
        }
        this.logger.debug("Delegate: nothing to rebind to");
        return false;
    }

    protected boolean checkExceptionStatus(SystemException e2) {
        return e2.completed == CompletionStatus.COMPLETED_NO;
    }
}

