/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.config.Configuration;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.util.CorbaLoc;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Object;

public class ObjectKeyMap {
    private final ORB orb;
    private final Map objectKeyMap = new HashMap();

    public ObjectKeyMap(ORB orb) {
        this.orb = orb;
    }

    public synchronized byte[] mapObjectKey(byte[] originalKey) {
        String origKey;
        java.lang.Object found;
        byte[] result = originalKey;
        if (this.objectKeyMap.size() > 0 && (found = this.objectKeyMap.get(origKey = new String(originalKey))) != null) {
            if (found instanceof String) {
                if (ParsedIOR.isParsableProtocol((String)found)) {
                    try {
                        ParsedIOR ior = new ParsedIOR(this.orb, (String)found);
                        result = ior.get_object_key();
                    }
                    catch (IllegalArgumentException e2) {
                        throw new BAD_PARAM("could not extract object_key from IOR: " + e2);
                    }
                } else {
                    result = CorbaLoc.parseKey((String)found);
                }
                this.objectKeyMap.put(origKey, result);
            } else {
                result = (byte[])found;
            }
        }
        return result;
    }

    public synchronized void configureObjectKeyMap(Configuration config) {
        String prefix = "jacorb.orb.objectKeyMap.";
        List names = config.getAttributeNamesWithPrefix("jacorb.orb.objectKeyMap.");
        try {
            Iterator i2 = names.iterator();
            while (i2.hasNext()) {
                String property = (String)i2.next();
                String key_name = property.substring("jacorb.orb.objectKeyMap.".length());
                String full_path = config.getAttribute(property);
                this.addObjectKey(key_name, full_path);
            }
        }
        catch (ConfigurationException e2) {
            throw new RuntimeException("should never happen", e2);
        }
    }

    public synchronized void addObjectKey(String key_name, String full_path) {
        this.objectKeyMap.put(key_name, full_path);
    }

    public void addObjectKey(String key_name, Object object) {
        this.addObjectKey(key_name, this.orb.object_to_string(object));
    }
}

