/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ServiceContextTransportingInputStream;
import org.jacorb.orb.miop.MulticastUtil;
import org.jacorb.orb.miop.ServerMIOPConnection;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.PrincipalHelper;
import org.omg.GIOP.LocateRequestHeader_1_0;
import org.omg.GIOP.LocateRequestHeader_1_0Helper;
import org.omg.GIOP.LocateRequestHeader_1_2;
import org.omg.GIOP.LocateRequestHeader_1_2Helper;
import org.omg.GIOP.RequestHeader_1_2;
import org.omg.GIOP.RequestHeader_1_2Helper;
import org.omg.GIOP.TargetAddress;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHelper;
import org.omg.IOP.TaggedProfile;
import org.omg.MIOP.UIPMC_ProfileBody;
import org.omg.MIOP.UIPMC_ProfileBodyHelper;

public class RequestInputStream
extends ServiceContextTransportingInputStream {
    private static final byte[] reserved = new byte[3];
    private final boolean is_locate_request;
    public final RequestHeader_1_2 req_hdr;

    public RequestInputStream(org.omg.CORBA.ORB orb, GIOPConnection connection, byte[] buf) {
        super(orb, buf);
        boolean isMIOP;
        boolean bl = isMIOP = connection != null && connection.getTransport() instanceof ServerMIOPConnection;
        if (Messages.getMsgType(this.buffer) == 0) {
            switch (this.giop_minor) {
                case 0: 
                case 1: {
                    TargetAddress addr = new TargetAddress();
                    this.req_hdr = new RequestHeader_1_2();
                    this.req_hdr.service_context = ServiceContextListHelper.read(this);
                    this.req_hdr.request_id = this.read_ulong();
                    this.req_hdr.response_flags = Messages.responseFlags(this.read_boolean());
                    if (this.giop_minor == 1) {
                        this.req_hdr.reserved = new byte[3];
                        this.read_octet_array(this.req_hdr.reserved, 0, 3);
                    }
                    if (isMIOP) {
                        char[] marker = new char[4];
                        this.read_char_array(marker, 0, 4);
                        if (!MulticastUtil.matchMIOPMagic(marker)) {
                            throw new MARSHAL("MIOP magic marker does not match");
                        }
                        int tag = this.read_ulong();
                        if (tag != 3) {
                            throw new MARSHAL("TAG_UIPMC marker does not match (" + tag + ')');
                        }
                        this.openEncapsulation();
                        UIPMC_ProfileBody upb = UIPMC_ProfileBodyHelper.read(this);
                        this.closeEncapsulation();
                        TaggedProfile uipmc = new TaggedProfile(3, MulticastUtil.getEncapsulatedUIPMCProfile((ORB)orb, upb));
                        addr.profile(uipmc);
                    } else {
                        int l2 = this.read_long();
                        int x = this.available();
                        if (x > 0 && l2 > x) {
                            throw new MARSHAL("Sequence length too large. Only " + x + " available and trying to assign " + l2);
                        }
                        byte[] object_key = new byte[l2];
                        this.read_octet_array(object_key, 0, l2);
                        addr.object_key(object_key);
                    }
                    this.req_hdr.operation = this.read_string();
                    PrincipalHelper.read(this);
                    this.req_hdr.target = addr;
                    break;
                }
                case 2: {
                    this.req_hdr = RequestHeader_1_2Helper.read(this);
                    this.skipHeaderPadding();
                    break;
                }
                default: {
                    throw new MARSHAL("Unknown GIOP minor version: " + this.giop_minor);
                }
            }
            this.is_locate_request = false;
        } else if (Messages.getMsgType(this.buffer) == 3) {
            switch (this.giop_minor) {
                case 0: 
                case 1: {
                    LocateRequestHeader_1_0 locate_req_hdr = LocateRequestHeader_1_0Helper.read(this);
                    TargetAddress addr = new TargetAddress();
                    addr.object_key(locate_req_hdr.object_key);
                    this.req_hdr = new RequestHeader_1_2(locate_req_hdr.request_id, 3, reserved, addr, "_non_existent", Messages.service_context);
                    break;
                }
                case 2: {
                    LocateRequestHeader_1_2 locate_req_hdr = LocateRequestHeader_1_2Helper.read(this);
                    this.req_hdr = new RequestHeader_1_2(locate_req_hdr.request_id, 3, reserved, locate_req_hdr.target, "_non_existent", Messages.service_context);
                    break;
                }
                default: {
                    throw new MARSHAL("Unknown GIOP minor version: " + this.giop_minor);
                }
            }
            this.is_locate_request = true;
        } else {
            throw new MARSHAL("Error: not a request!");
        }
    }

    public ServiceContext getServiceContext(int id) {
        for (int i2 = 0; i2 < this.req_hdr.service_context.length; ++i2) {
            if (this.req_hdr.service_context[i2].context_id != id) continue;
            return this.req_hdr.service_context[i2];
        }
        return null;
    }

    public boolean isLocateRequest() {
        return this.is_locate_request;
    }
}

