/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.alarmlist.view.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import se.ericsson.cello.em.fm.common.model.impl.EventType;
import se.ericsson.cello.em.fm.common.model.impl.Severity;
import se.ericsson.cello.em.fm.common.utils.ifc.ToolService;
import se.ericsson.cello.em.fm.common.utils.impl.LogPart;
import se.ericsson.cello.em.fm.common.view.impl.AbstractView;
import se.ericsson.cello.em.fm.common.view.impl.Menu;
import se.ericsson.cello.em.fm.common.view.impl.Utils;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlarmListView
extends AbstractView {
    private static final EmLogger LOG = EmLogger.TROUBLE_SHOOTING;
    private static final long serialVersionUID = 3404150524771735328L;
    private static final Utils UTILS = new Utils();
    private static final ArrayList<String> RIGHT_ALIGNED_COLUMNS = new ArrayList<String>(Arrays.asList(LogPart.MANAGED_OBJECT_INSTANCE.COLUMN_TITLE));
    private JLabel noOfAlarmsValue;
    private JLabel changedValue;
    private JLabel criticalValue;
    private JLabel majorValue;
    private JLabel minorValue;
    private JLabel warningValue;
    private JLabel indeterminateValue;
    private JLabel alarmSuppressionLabel;
    private JLabel noAlarmSuppressionLabel;
    private JPanel alarmSuppressionAndCounterPanel;
    private static String AS_TOOLTIP = "Alarm suppressed mode";
    private static String imageFileName = "AlarmSuppressed.png";
    private JComponent counterPanel;
    private JPanel status;

    public AlarmListView(ToolService toolService) {
        super(toolService);
    }

    @Override
    protected EnumMap<Menu, JMenuItem[]> getToolMenus() {
        LOG.entering(new Object[0]);
        EnumMap<Menu, JMenuItem[]> menus = new EnumMap<Menu, JMenuItem[]>(Menu.class);
        menus.put(Menu.NETWORK_ELEMENT, new JMenuItem[]{this.printMenuItem, this.pageSetupMenuItem, this.exportMenuItem, null, this.closeMenuItem});
        JMenu alarmTypeMenuItem = UTILS.createMenu(Menu.ALARM_TYPE, new JMenuItem[]{this.communicationMenuItem, this.environmentalMenuItem, this.equipmentMenuItem, this.processingErrorMenuItem, this.qosMenuItem});
        menus.put(Menu.VIEW, new JMenuItem[]{alarmTypeMenuItem, this.refreshMenuItem});
        JMenuItem[] hyperItemsArr = new JMenuItem[this.hyperToolMenuItems.size()];
        int place = 0;
        for (JMenuItem item : this.hyperToolMenuItems) {
            JMenuItem menuItem;
            hyperItemsArr[place] = menuItem = new JMenuItem(item.getAction());
            ++place;
        }
        this.openInMenu = UTILS.createMenu(Menu.OPEN_IN, hyperItemsArr);
        menus.put(Menu.ALARM_LIST, new JMenuItem[]{this.detailsMenuItem, this.openInMenu, this.helpOnAlarmMenuItem, this.soundMenuItem});
        return menus;
    }

    @Override
    protected List<JMenuItem> getTablePopUpMenuItems() {
        LOG.entering(new Object[0]);
        ArrayList<JMenuItem> menus = new ArrayList<JMenuItem>();
        menus.add(this.detailsPopUpMenuItem);
        JMenu openInPopUpMenuItem = UTILS.createMenu(Menu.OPEN_IN, this.hyperToolMenuItems.toArray(new JMenuItem[this.hyperToolMenuItems.size()]));
        menus.add(openInPopUpMenuItem);
        menus.add(this.helpOnAlarmPopUpMenuItem);
        return menus;
    }

    @Override
    protected JComponent createToolSpecificPanel() {
        LOG.entering(new Object[0]);
        JPanel toolSpecific = new JPanel(new BorderLayout());
        toolSpecific.add((Component)UTILS.createUserPanel(), "North");
        toolSpecific.add((Component)this.createStatusPanel(), "South");
        return toolSpecific;
    }

    @Override
    protected String getHelpOnWindowSection() {
        return "AlarmList";
    }

    @Override
    protected ArrayList<String> getRightAlignedColumns() {
        return RIGHT_ALIGNED_COLUMNS;
    }

    public void setAlarmSummary(EnumMap<Severity, Integer> summary) {
        LOG.entering(new Object[0]);
        this.criticalValue.setText(Integer.toString(summary.get((Object)Severity.CRITICAL)));
        this.majorValue.setText(Integer.toString(summary.get((Object)Severity.MAJOR)));
        this.minorValue.setText(Integer.toString(summary.get((Object)Severity.MINOR)));
        this.warningValue.setText(Integer.toString(summary.get((Object)Severity.WARNING)));
        this.indeterminateValue.setText(Integer.toString(summary.get((Object)Severity.INDETERMINATE)));
    }

    public void setNoOfAlarms(int noOfAlarms, int noOfVisibleAlarms) {
        this.noOfAlarmsValue.setText(UTILS.getCounterText(noOfVisibleAlarms, noOfAlarms));
    }

    public void setTimeStamp(String timeStamp) {
        this.changedValue.setText(timeStamp);
    }

    public EnumSet<EventType> getFilter() {
        LOG.entering(new Object[0]);
        EnumSet<EventType> filter = EnumSet.noneOf(EventType.class);
        if (this.communicationMenuItem.isSelected()) {
            filter.add(EventType.COMMUNICATIONS_ALARM);
        }
        if (this.environmentalMenuItem.isSelected()) {
            filter.add(EventType.ENVIRONMENTAL_ALARM);
        }
        if (this.equipmentMenuItem.isSelected()) {
            filter.add(EventType.EQUIPMENT_ALARM);
        }
        if (this.processingErrorMenuItem.isSelected()) {
            filter.add(EventType.PROCESSING_ERROR_ALARM);
        }
        if (this.qosMenuItem.isSelected()) {
            filter.add(EventType.QUALITY_OF_SERVICE_ALARM);
        }
        return filter;
    }

    private JComponent createStatusPanel() {
        LOG.entering(new Object[0]);
        this.status = new JPanel(new BorderLayout(10, 0));
        this.status.setBorder(BorderFactory.createEtchedBorder(1));
        this.noOfAlarmsValue = new JLabel();
        this.changedValue = new JLabel();
        this.changedValue.setName("changedValue");
        this.criticalValue = new JLabel();
        this.criticalValue.setName("summaryCriticalCounter");
        this.majorValue = new JLabel();
        this.majorValue.setName("summaryMajorCounter");
        this.minorValue = new JLabel();
        this.minorValue.setName("summaryMinorCounter");
        this.warningValue = new JLabel();
        this.warningValue.setName("summaryWarningCounter");
        this.indeterminateValue = new JLabel();
        this.indeterminateValue.setName("summaryIndeterminateCounter");
        this.counterPanel = UTILS.createCounterPanel("Alarms:", this.noOfAlarmsValue, "Visible/Total");
        JComponent changedPanel = UTILS.createChangedPanel("Changed:", this.changedValue);
        JComponent summaryPanel = this.createSummaryPanel("Alarm summary:", this.criticalValue, this.majorValue, this.minorValue, this.warningValue, this.indeterminateValue);
        this.noAlarmSuppressionLabel = this.readEmptyLabel();
        this.alarmSuppressionAndCounterPanel = new JPanel(new BorderLayout(5, 8));
        this.alarmSuppressionAndCounterPanel.add((Component)this.noAlarmSuppressionLabel, "West");
        this.alarmSuppressionAndCounterPanel.add((Component)this.counterPanel, "Center");
        this.status.add((Component)this.alarmSuppressionAndCounterPanel, "West");
        this.status.add((Component)changedPanel, "Center");
        this.status.add((Component)summaryPanel, "East");
        return this.status;
    }

    private JComponent createSummaryPanel(String summaryText, JLabel criticalValue, JLabel majorValue, JLabel minorValue, JLabel warningValue, JLabel indeterminateValue) {
        LOG.entering(new Object[0]);
        JPanel summary = new JPanel(new GridBagLayout());
        Border blackBorder = BorderFactory.createLineBorder(Color.black);
        Border paddingBorder = BorderFactory.createEmptyBorder(0, 5, 0, 5);
        CompoundBorder border = BorderFactory.createCompoundBorder(blackBorder, paddingBorder);
        JLabel text = new JLabel(summaryText);
        text.setName("summaryText");
        text.setForeground(Color.black);
        criticalValue.setText("0");
        criticalValue.setBorder(border);
        criticalValue.setOpaque(true);
        criticalValue.setBackground(Color.red);
        criticalValue.setForeground(Color.black);
        criticalValue.setToolTipText(Severity.CRITICAL.PRESENTATION_STRING);
        majorValue.setText("0");
        majorValue.setBorder(border);
        majorValue.setOpaque(true);
        majorValue.setBackground(new Color(255, 153, 0));
        majorValue.setForeground(Color.black);
        majorValue.setToolTipText(Severity.MAJOR.PRESENTATION_STRING);
        minorValue.setText("0");
        minorValue.setBorder(border);
        minorValue.setOpaque(true);
        minorValue.setBackground(Color.yellow);
        minorValue.setForeground(Color.black);
        minorValue.setToolTipText(Severity.MINOR.PRESENTATION_STRING);
        warningValue.setText("0");
        warningValue.setBorder(border);
        warningValue.setOpaque(true);
        warningValue.setBackground(new Color(51, 153, 204));
        warningValue.setForeground(Color.black);
        warningValue.setToolTipText(Severity.WARNING.PRESENTATION_STRING);
        indeterminateValue.setText("0");
        indeterminateValue.setBorder(border);
        indeterminateValue.setOpaque(true);
        indeterminateValue.setBackground(new Color(153, 204, 204));
        indeterminateValue.setForeground(Color.black);
        indeterminateValue.setToolTipText(Severity.INDETERMINATE.PRESENTATION_STRING);
        summary.add((Component)text, new GridBagConstraints(0, 0, 1, 1, 4.0, 1.0, 10, 0, new Insets(0, 0, 0, 7), 0, 0));
        summary.add((Component)criticalValue, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        summary.add((Component)majorValue, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        summary.add((Component)minorValue, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        summary.add((Component)warningValue, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        summary.add((Component)indeterminateValue, new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 7), 0, 0));
        return summary;
    }

    @Override
    protected MenuListener getMenuListener() {
        return new AlarmListMenuListener();
    }

    public JLabel readAlarmSuppressedImageIcon() {
        if (this.alarmSuppressionLabel == null) {
            JLabel iconLabel;
            Image ericssonImage = Toolkit.getDefaultToolkit().getImage(AlarmListView.class.getResource(imageFileName));
            ImageIcon ericssonIcon = new ImageIcon(ericssonImage);
            this.alarmSuppressionLabel = iconLabel = new JLabel("", ericssonIcon, 4);
            this.alarmSuppressionLabel.setToolTipText(AS_TOOLTIP);
        }
        return this.alarmSuppressionLabel;
    }

    public JLabel readEmptyLabel() {
        if (this.noAlarmSuppressionLabel == null) {
            JLabel iconLabel;
            this.noAlarmSuppressionLabel = iconLabel = new JLabel("  ", 4);
        }
        return this.noAlarmSuppressionLabel;
    }

    public void setAlarmSuppressionLabel(JLabel aLabel) {
        this.alarmSuppressionAndCounterPanel.removeAll();
        this.alarmSuppressionAndCounterPanel.add((Component)aLabel, "West");
        this.alarmSuppressionAndCounterPanel.add((Component)this.counterPanel, "Center");
        this.alarmSuppressionAndCounterPanel.invalidate();
        this.alarmSuppressionAndCounterPanel.repaint();
        this.alarmSuppressionAndCounterPanel.validate();
        this.status.invalidate();
        this.status.repaint();
        this.status.validate();
    }

    private class AlarmListMenuListener
    implements MenuListener {
        private AlarmListMenuListener() {
        }

        public void menuSelected(MenuEvent e) {
            if (AlarmListView.this.getTable().getSelectedRows().length == 1) {
                AlarmListView.this.detailsMenuItem.setEnabled(true);
                if (AlarmListView.this.hyperToolMenuItems.size() > 0) {
                    AlarmListView.this.openInMenu.setEnabled(true);
                }
                AlarmListView.this.helpOnAlarmMenuItem.setEnabled(true);
            } else {
                AlarmListView.this.detailsMenuItem.setEnabled(false);
                AlarmListView.this.openInMenu.setEnabled(false);
                AlarmListView.this.helpOnAlarmMenuItem.setEnabled(false);
            }
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    }
}

