/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.availability.view.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import se.ericsson.cello.em.fm.availability.model.impl.LogToolAttributeRecord;
import se.ericsson.cello.em.fm.availability.view.impl.Filterator;
import se.ericsson.cello.em.fm.availability.view.impl.SortFilterModel;
import se.ericsson.cello.em.fm.common.view.ifc.TablePrintable;
import se.ericsson.cello.emt.utils.guihelper.IconHelper;
import se.ericsson.cello.emt.utils.guihelper.MessageDialog;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.security.utils.EmLogger;

public class LogToolView {
    private static final EmLogger LOG = EmLogger.TROUBLE_SHOOTING;
    private static final String DETAILS_TITLE_PREFIX = "Details";
    private static final String DETAILS_MENU_ITEMTEXT = "Details";
    private static final String REFRESH_TABLE = "Refresh";
    private static final String EXPORT_DELIMITER = ";";
    private JFrame logToolView;
    private JTable table;
    private JButton refreshButton;
    private JButton closeButton;
    private JButton helpButton;
    private JButton filterButton;
    private JButton showButton;
    private JCheckBox[] checkBoxes;
    private JTextField regText;
    private JCheckBox nonEvents;
    private JMenuItem openItem;
    private JMenuItem exitItem;
    private ProgressMonitor progressMonitor = null;
    private JMenuItem refreshItem;
    private SortFilterModel sortFilterModel = null;
    private Map<String, JDialog> openedDetailDialogs = null;

    public LogToolView(String title, String icon) {
        this.initGUI(title, icon);
    }

    private void initGUI(String title, String icon) {
        this.logToolView = new JFrame(title);
        IconHelper helper = new IconHelper();
        Image iconImage = helper.getIconImage(icon);
        this.logToolView.setIconImage(iconImage);
        JMenuBar menuBar = this.initMenuBar();
        Container contentP = this.createContentPane();
        this.logToolView.setJMenuBar(menuBar);
        this.logToolView.setContentPane(contentP);
        this.logToolView.pack();
        this.logToolView.setLocationRelativeTo(null);
        this.logToolView.setVisible(true);
        this.openedDetailDialogs = new HashMap<String, JDialog>();
    }

    private Container createContentPane() {
        LOG.fine("Creating ContentPane", new Object[0]);
        JPanel content = new JPanel(new BorderLayout());
        JPanel buttons = this.initMainButtons();
        JPanel filter = this.getFilterPanel();
        filter.setBorder(BorderFactory.createEtchedBorder(1));
        this.table = this.createTable();
        content.add((Component)filter, "North");
        content.add((Component)buttons, "South");
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setPreferredSize(new Dimension(1100, 400));
        content.add(scroll);
        LOG.fine("Creating ContentPane done", new Object[0]);
        return content;
    }

    private JPanel getFilterPanel() {
        LOG.fine("Creating filterPanel", new Object[0]);
        JPanel filterSearchPanel = new JPanel(new BorderLayout());
        TitledBorder filterBorder = new TitledBorder("Filter");
        JPanel center = this.getCriteriaPanel();
        center.setBorder(filterBorder);
        filterSearchPanel.add(center);
        return filterSearchPanel;
    }

    private JPanel getCriteriaPanel() {
        LOG.fine("Creating CriteriaPanel", new Object[0]);
        JPanel criteria = new JPanel(new BorderLayout());
        JPanel filterEventPanel = this.getEventFilterPanel();
        criteria.add((Component)this.getSearchPanel(), "North");
        criteria.add((Component)filterEventPanel, "Center");
        criteria.add((Component)new JPanel(), "West");
        return criteria;
    }

    private JPanel getSearchPanel() {
        LOG.fine("Creating SearchPanel", new Object[0]);
        FlowLayout flow = new FlowLayout();
        flow.setAlignment(0);
        JPanel search = new JPanel(flow);
        this.regText = new JTextField(20);
        this.regText.setName("filterField");
        this.regText.getDocument().addDocumentListener(new StatusFilterListener());
        search.add(this.regText);
        this.filterButton = new JButton("Filter");
        this.filterButton.setMnemonic('i');
        this.filterButton.addActionListener(new FilterListener());
        this.filterButton.setEnabled(false);
        search.add(this.filterButton);
        this.showButton = new JButton("Show All");
        this.showButton.setMnemonic('o');
        this.showButton.addActionListener(new ShowAllListener());
        search.add(this.showButton);
        return search;
    }

    private JPanel getEventFilterPanel() {
        LOG.fine("Creating EventFilterPanel", new Object[0]);
        FlowLayout flow = new FlowLayout();
        flow.setAlignment(3);
        JPanel filter = new JPanel(flow);
        String[] eventTypes = LogToolAttributeRecord.EVENT_TYPES;
        this.checkBoxes = new JCheckBox[eventTypes.length];
        StatusFilterListener actionListener = new StatusFilterListener();
        for (int i = 0; i < eventTypes.length; ++i) {
            this.checkBoxes[i] = new JCheckBox(eventTypes[i]);
            this.checkBoxes[i].setSelected(true);
            this.checkBoxes[i].addActionListener(actionListener);
            filter.add(this.checkBoxes[i]);
        }
        this.nonEvents = new JCheckBox("Non Events");
        this.nonEvents.setSelected(true);
        this.nonEvents.addActionListener(actionListener);
        filter.add(this.nonEvents);
        return filter;
    }

    private JMenuBar initMenuBar() {
        LOG.fine("Creating MenuBars", new Object[0]);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('f');
        this.openItem = new JMenuItem("Open...");
        this.openItem.setMnemonic('O');
        menu.add(this.openItem);
        JMenuItem printItem = new JMenuItem("Print...");
        printItem.addActionListener(new PrintListener());
        printItem.setMnemonic('p');
        menu.add(printItem);
        JMenuItem exportItem = new JMenuItem("Export...");
        exportItem.addActionListener(new ExportListener());
        exportItem.setMnemonic('E');
        menu.add(exportItem);
        menu.addSeparator();
        this.exitItem = new JMenuItem("Exit");
        this.exitItem.setMnemonic('x');
        menu.add(this.exitItem);
        menuBar.add(menu);
        menu = new JMenu("View");
        menu.setMnemonic('v');
        JMenuItem item = new JMenuItem("Show Event Details");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = LogToolView.this.table.getSelectionModel().getLeadSelectionIndex();
                LogToolView.this.showDetails(row);
            }
        });
        menu.add(item);
        this.refreshItem = new JMenuItem(REFRESH_TABLE);
        menu.add(this.refreshItem);
        menuBar.add(menu);
        return menuBar;
    }

    private JPanel initMainButtons() {
        LOG.fine("Creating Main Buttons", new Object[0]);
        FlowLayout flow = new FlowLayout();
        flow.setAlignment(2);
        JPanel buttonPanel = new JPanel(flow);
        this.refreshButton = new JButton(REFRESH_TABLE);
        this.refreshButton.setMnemonic('r');
        this.closeButton = new JButton("Close");
        this.closeButton.setMnemonic('c');
        this.helpButton = new JButton("Help");
        this.helpButton.setMnemonic('h');
        buttonPanel.add(this.refreshButton);
        buttonPanel.add(this.closeButton);
        buttonPanel.add(this.helpButton);
        return buttonPanel;
    }

    protected void setModel(TableModel model) {
        LOG.fine("Setting a new model", new Object[0]);
        if (this.sortFilterModel == null) {
            this.sortFilterModel = new SortFilterModel(model);
            this.table.setModel(this.sortFilterModel);
            this.setColumnWidths(this.table);
            this.setColumnRenders(this.table);
            this.setTableHeaderListener();
        } else {
            this.sortFilterModel.setModel(model);
            this.table.setModel(this.sortFilterModel);
            this.filter();
        }
    }

    private void setColumnRenders(JTable table) {
        int nrOfColumns = table.getModel().getColumnCount();
        for (int i = 0; i < nrOfColumns; ++i) {
            String colName = table.getColumnName(i);
            TableColumn column = table.getColumnModel().getColumn(i);
            if (colName.equals("Service")) {
                column.setCellRenderer(new ColorColumnRenderer(table.getBackground()));
                continue;
            }
            column.setCellRenderer(new TooltipCellRenderer());
        }
    }

    private JTable createTable() {
        LOG.fine("Creating the Table", new Object[0]);
        this.table = new JTable();
        this.setTableHeaderListener();
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.getTableHeader().setReorderingAllowed(true);
        this.setColumnWidths(this.table);
        this.table.setName("logTable");
        this.setupPopUpMenuTable();
        return this.table;
    }

    private void setColumnWidths(JTable table) {
        TableColumnModel tableColMod = table.getColumnModel();
        for (int i = 0; i < tableColMod.getColumnCount(); ++i) {
            String header = table.getColumnName(i);
            tableColMod.getColumn(i).setPreferredWidth(new JTextField((String)header).getPreferredSize().width);
            JTextField defaultSize = new JTextField();
            if (table.getColumnName(i).equals("Time")) {
                defaultSize = new JTextField("2007-23-23 23:23:23 ");
                tableColMod.getColumn(i).setPreferredWidth(defaultSize.getPreferredSize().width);
                continue;
            }
            if (table.getColumnName(i).equals("Type")) {
                defaultSize = new JTextField("PlugInUnit ");
                tableColMod.getColumn(i).setPreferredWidth(defaultSize.getPreferredSize().width);
                continue;
            }
            if (table.getColumnName(i).equals("Reason")) {
                defaultSize = new JTextField("ShutDownCommand ");
                tableColMod.getColumn(i).setPreferredWidth(defaultSize.getPreferredSize().width);
                continue;
            }
            if (!table.getColumnName(i).equals("Board")) continue;
            defaultSize = new JTextField("xx:xx:xx ");
            tableColMod.getColumn(i).setPreferredWidth(defaultSize.getPreferredSize().width);
        }
    }

    private void setTableHeaderListener() {
        TableModel sortedMod = this.table.getModel();
        if (sortedMod instanceof SortFilterModel) {
            ((SortFilterModel)sortedMod).addMouseListener(this.table);
        }
    }

    public JFrame getComponent() {
        return this.logToolView;
    }

    protected void setRefreshListener(ActionListener listener) {
        this.refreshButton.addActionListener(listener);
        this.refreshItem.addActionListener(listener);
    }

    protected void removeRefreshListener(ActionListener listener) {
        this.refreshButton.removeActionListener(listener);
    }

    protected void addFilterListener(ActionListener listener) {
        this.filterButton.addActionListener(listener);
    }

    protected void removeFilterListener(ActionListener listener) {
        this.filterButton.removeActionListener(listener);
    }

    private String[] getCheckedValues() {
        ArrayList<String> eventName = new ArrayList<String>();
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            if (!this.checkBoxes[i].isSelected()) continue;
            String checkBoxEventName = this.checkBoxes[i].getText();
            checkBoxEventName = checkBoxEventName.substring(0, checkBoxEventName.indexOf("Event"));
            eventName.add(checkBoxEventName);
        }
        return eventName.toArray(new String[eventName.size()]);
    }

    private void filter() {
        LOG.fine("Filtering data", new Object[0]);
        TableModel mods = this.table.getModel();
        int[] rows = this.table.getSelectedRows();
        if (mods instanceof SortFilterModel) {
            int[] realRows = ((SortFilterModel)mods).getRealIndexes(rows);
            ((SortFilterModel)mods).filter(this.getFilterator());
            this.filterButton.setEnabled(false);
            Integer[] newFaked = ((SortFilterModel)mods).getFakedIndexes(realRows);
            for (int i = 0; i < newFaked.length; ++i) {
                this.table.getSelectionModel().addSelectionInterval(newFaked[i], newFaked[i]);
            }
        }
    }

    private Filterator getFilterator() {
        TableModel mods = this.table.getModel();
        Filterator filter = new Filterator();
        if (mods instanceof SortFilterModel) {
            filter.addColumnFilter("Type", this.getCheckedValues());
            if (this.nonEvents.isSelected()) {
                String[] empty = new String[]{""};
                filter.addColumnFilter("Type", empty);
            }
            filter.setRegText(this.regText.getText());
        }
        return filter;
    }

    private void resetFilterCrit() {
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            if (this.checkBoxes[i].isSelected()) continue;
            this.checkBoxes[i].setSelected(true);
        }
        this.regText.setText("");
        this.nonEvents.setSelected(true);
    }

    public void setCloseListener(ActionListener closeListener) {
        this.closeButton.addActionListener(closeListener);
    }

    public void clearAllListenerNow() {
        this.removeActionListenersButton(this.refreshButton.getActionListeners(), this.refreshButton);
        this.removeActionListenersButton(this.filterButton.getActionListeners(), this.filterButton);
        this.removeActionListenersButton(this.showButton.getActionListeners(), this.showButton);
        this.removeActionListenersButton(this.closeButton.getActionListeners(), this.closeButton);
    }

    private void removeActionListenersButton(ActionListener[] listeners, JButton button) {
        for (int i = 0; i < listeners.length; ++i) {
            button.removeActionListener(listeners[i]);
        }
    }

    protected void setupPopUpMenuTable() {
        LOG.fine("Adding Popup menu", new Object[0]);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Point point = e.getPoint();
                int row = LogToolView.this.table.rowAtPoint(point);
                if (SwingUtilities.isRightMouseButton(e)) {
                    ListSelectionModel model = LogToolView.this.table.getSelectionModel();
                    model.setSelectionInterval(row, row);
                    this.showTablePopUp(row, e);
                } else {
                    super.mouseClicked(e);
                }
            }

            private void showTablePopUp(final int row, MouseEvent e) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem item = new JMenuItem("Details");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        LogToolView.this.showDetails(row);
                    }
                });
                popup.add(item);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    private void showDetails(int row) {
        if (row > -1) {
            int length = this.table.getModel().getColumnCount();
            int col = -1;
            for (int i = 0; i < length; ++i) {
                if (!this.table.getColumnName(i).equals("LogRecord")) continue;
                col = i;
                break;
            }
            Object windowNumber = "";
            if (col != -1) {
                windowNumber = this.table.getValueAt(row, col);
            }
            this.createDetailDialog(row, windowNumber.toString());
        } else {
            LOG.severe("Could not open details window, row=" + row, new Object[0]);
        }
    }

    private void createDetailDialog(int row, String number) {
        String title = "Details LogRecord " + number;
        final JDialog openedDialogWindow = this.openedDetailDialogs.get(title);
        if (openedDialogWindow != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    openedDialogWindow.setVisible(true);
                    openedDialogWindow.requestFocusInWindow();
                }
            });
        } else {
            JOptionPane detailsPane = new JOptionPane();
            String details = ((TablePrintable)((Object)this.table.getModel())).getDetails(row);
            detailsPane.setMessage(details);
            JButton closeDialogButton = new JButton("Close");
            detailsPane.setOptions(new Object[]{closeDialogButton});
            final JDialog detailDialog = detailsPane.createDialog(this.logToolView, title);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    detailDialog.setModal(false);
                    detailDialog.setVisible(true);
                    detailDialog.requestFocusInWindow();
                }
            });
            this.openedDetailDialogs.put(title, detailDialog);
            closeDialogButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    detailDialog.dispose();
                    LogToolView.this.openedDetailDialogs.remove(detailDialog.getTitle());
                }
            });
            detailDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    LogToolView.this.openedDetailDialogs.remove(detailDialog.getTitle());
                }
            });
        }
    }

    public void setWindowListener(WindowListener winAdapt) {
        this.logToolView.addWindowListener(winAdapt);
    }

    public void setOpenListener(ActionListener listener) {
        this.openItem.addActionListener(listener);
    }

    public void setExitListenerMenu(ActionListener listener) {
        this.exitItem.addActionListener(listener);
    }

    public void setHelpListener(ActionListener helpListener) {
        this.helpButton.addActionListener(helpListener);
    }

    public void createProgressMonitor(Object message, String note, int nMin, int nMax) {
        this.progressMonitor = new ProgressMonitor(this.getComponent(), message, note, nMin, nMax);
        this.progressMonitor.setMillisToDecideToPopup(1);
        this.progressMonitor.setMillisToPopup(1);
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void showError(final String mainMessage, final Exception exception, final boolean severe) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    LogToolView.this.showError(mainMessage, exception, severe);
                }
            };
            SwingUtilities.invokeLater(runner);
            return;
        }
        MessageDialog msgDlg = MessageDialogFactory.createMessageDialog((String)mainMessage, (Exception)exception, (boolean)severe, (JFrame)this.getComponent());
        if (null != msgDlg) {
            msgDlg.setVisible(true);
        }
    }

    class TooltipCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String colName = table.getColumnName(column);
            if (colName.equals("Board")) {
                String[] values = value.toString().split(":");
                StringBuilder result = new StringBuilder();
                if (values.length > 1) {
                    result.append("Subrack: " + values[0] + " Slot: " + values[1]);
                    if (values.length > 2) {
                        result.append(" " + values[2]);
                    }
                }
                if (result.toString().equals("")) {
                    this.setToolTipText(value.toString());
                } else {
                    this.setToolTipText(result.toString());
                }
            } else {
                this.setToolTipText(value.toString());
            }
            return cell;
        }
    }

    class ColorColumnRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private Color orig;

        public ColorColumnRenderer(Color orig) {
            this.orig = orig;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                if (value.equals("IN")) {
                    cell.setBackground(Color.GREEN);
                } else if (value.equals("OUT")) {
                    cell.setBackground(Color.RED);
                } else if (value.equals("PART")) {
                    cell.setBackground(Color.YELLOW);
                } else {
                    cell.setBackground(this.orig);
                }
            }
            this.setToolTipText(value.toString());
            return cell;
        }
    }

    public class ExportListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            LOG.fine("Exporting shown content", new Object[0]);
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showSaveDialog(LogToolView.this.logToolView);
            if (returnVal == 0) {
                File file = chooser.getSelectedFile();
                try {
                    FileWriter writer = new FileWriter(file);
                    int nrOfRows = LogToolView.this.table.getModel().getRowCount();
                    int nrOfCols = LogToolView.this.table.getColumnCount();
                    for (int i = 0; i < nrOfCols; ++i) {
                        writer.write(LogToolView.this.table.getColumnName(i));
                        writer.write(LogToolView.EXPORT_DELIMITER);
                    }
                    writer.write("\n");
                    for (int row = 0; row < nrOfRows; ++row) {
                        StringBuilder rowData = new StringBuilder();
                        for (int col = 0; col < nrOfCols; ++col) {
                            rowData.append(LogToolView.this.table.getValueAt(row, col) + LogToolView.EXPORT_DELIMITER);
                        }
                        writer.write(rowData.toString() + "\n");
                        LOG.fine("Exported content to " + file.getAbsolutePath(), new Object[0]);
                    }
                    writer.flush();
                    writer.close();
                }
                catch (IOException e1) {
                    LOG.warning("Could not export the availability log data to " + file.getAbsolutePath(), new Object[0]);
                    LogToolView.this.showError("Could not save the exported data", e1, false);
                }
            }
        }
    }

    public class PrintListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            LOG.info("Print availability log", new Object[0]);
            boolean printedOk = false;
            try {
                JTable.PrintMode printMode = JTable.PrintMode.FIT_WIDTH;
                String title = LogToolView.this.logToolView.getTitle();
                MessageFormat headerFormat = new MessageFormat(title);
                MessageFormat footerFormat = new MessageFormat("Page {0}");
                boolean interactive = true;
                boolean showPrintDialog = true;
                HashPrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
                attr.add(OrientationRequested.LANDSCAPE);
                printedOk = LogToolView.this.table.print(printMode, headerFormat, footerFormat, showPrintDialog, attr, interactive);
                if (printedOk) {
                    LOG.fine("Print availability log done", new Object[0]);
                } else {
                    LOG.info("User aborted the printing", new Object[0]);
                }
            }
            catch (PrinterException pe) {
                LOG.info("Printing failed in JTable.print()", new Object[0]);
            }
        }
    }

    class StatusFilterListener
    implements ActionListener,
    DocumentListener {
        StatusFilterListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!LogToolView.this.filterButton.isEnabled()) {
                LogToolView.this.filterButton.setEnabled(true);
            }
        }

        public void changedUpdate(DocumentEvent e) {
            if (!LogToolView.this.filterButton.isEnabled()) {
                LogToolView.this.filterButton.setEnabled(true);
            }
        }

        public void insertUpdate(DocumentEvent e) {
            if (!LogToolView.this.filterButton.isEnabled()) {
                LogToolView.this.filterButton.setEnabled(true);
            }
        }

        public void removeUpdate(DocumentEvent e) {
            if (!LogToolView.this.filterButton.isEnabled()) {
                LogToolView.this.filterButton.setEnabled(true);
            }
        }
    }

    class ShowAllListener
    implements ActionListener {
        ShowAllListener() {
        }

        public void actionPerformed(ActionEvent e) {
            LOG.fine("Show all", new Object[0]);
            TableModel mods = LogToolView.this.table.getModel();
            if (mods instanceof SortFilterModel) {
                int[] rows = LogToolView.this.table.getSelectedRows();
                int[] realRows = ((SortFilterModel)mods).getRealIndexes(rows);
                LogToolView.this.resetFilterCrit();
                ((SortFilterModel)mods).filter(LogToolView.this.getFilterator());
                Integer[] newFaked = ((SortFilterModel)mods).getFakedIndexes(realRows);
                for (int i = 0; i < newFaked.length; ++i) {
                    LogToolView.this.table.getSelectionModel().addSelectionInterval(newFaked[i], newFaked[i]);
                }
                LogToolView.this.filterButton.setEnabled(false);
            }
        }
    }

    class FilterListener
    implements ActionListener {
        FilterListener() {
        }

        public void actionPerformed(ActionEvent e) {
            LogToolView.this.filter();
        }
    }
}

