/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.model.impl;

import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EventType {
    COMMUNICATIONS_ALARM("x1", "Communications alarm"),
    ENVIRONMENTAL_ALARM("x3", "Environmental alarm"),
    EQUIPMENT_ALARM("x5", "Equipment alarm"),
    FM_EVENT("0", "FM Event"),
    PROCESSING_ERROR_ALARM("x2", "Processing error alarm"),
    QUALITY_OF_SERVICE_ALARM("x4", "Quality of service alarm"),
    UNKNOWN_EVENT_TYPE("", "Unknown event type");

    private static final EmLogger LOG;
    public final String STATE;
    public final String PRESENTATION_STRING;

    private EventType(String state, String presentationStr) {
        this.STATE = state;
        this.PRESENTATION_STRING = presentationStr;
    }

    public static EventType getEventType(String state) {
        for (EventType eventType : EventType.values()) {
            if (!eventType.STATE.equals(state)) continue;
            return eventType;
        }
        LOG.warning("Unknown event type: " + state, new Object[0]);
        return UNKNOWN_EVENT_TYPE;
    }

    public String toString() {
        return this.PRESENTATION_STRING;
    }

    static {
        LOG = EmLogger.TROUBLE_SHOOTING;
    }
}

