/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.view.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import se.ericsson.cello.em.fm.common.config.ifc.PrintingService;
import se.ericsson.cello.em.fm.common.model.ifc.FmTableModel;
import se.ericsson.cello.em.fm.common.model.impl.AdditionalInformation;
import se.ericsson.cello.em.fm.common.model.impl.CorrelatedNotification;
import se.ericsson.cello.em.fm.common.model.impl.RecordContent;
import se.ericsson.cello.em.fm.common.utils.ifc.ToolService;
import se.ericsson.cello.em.fm.common.utils.impl.FmError;
import se.ericsson.cello.em.fm.common.utils.impl.FmType;
import se.ericsson.cello.em.fm.common.utils.impl.LogPart;
import se.ericsson.cello.em.fm.common.view.impl.AbstractView;

public interface AbstractActions {

    public static abstract class AbstractUsingHelpAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AbstractUsingHelpAction() {
            super("Using Help");
            this.putValue("MnemonicKey", 85);
            this.putValue("ShortDescription", "Explanation of the help configuration");
        }
    }

    public static abstract class AbstractSystemLibraryAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AbstractSystemLibraryAction() {
            super("System Library");
            this.putValue("MnemonicKey", 76);
            this.putValue("ShortDescription", "Display ALEX library for this node");
        }
    }

    public static abstract class AbstractSoundAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AbstractSoundAction() {
            super("Sound");
            this.putValue("MnemonicKey", 83);
            this.putValue("ShortDescription", "Sound an alarm for Critical alarms of type Communications and Environmental alarms");
        }
    }

    public static abstract class AbstractRefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AbstractRefreshAction() {
            super("Refresh");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
            this.putValue("MnemonicKey", 82);
            this.putValue("ShortDescription", "Refresh...");
        }
    }

    public static abstract class AbstractPrintAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AbstractPrintAction() {
            super("Print...");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 128));
            this.putValue("MnemonicKey", 80);
            this.putValue("ShortDescription", "Print...");
        }

        protected void print(JTable table, ToolService toolService) {
            new Thread((Runnable)new PrintRunner(table, toolService), "Printing alarm logs").start();
        }

        public class PrintRunner
        implements Runnable {
            JTable table;
            ToolService toolService;

            public PrintRunner(JTable table, ToolService toolService) {
                this.table = table;
                this.toolService = toolService;
            }

            public void run() {
                PrintingService printingService = this.toolService.getPrintingService();
                String printoutTitle = this.toolService.getConfiguration().getTitleForWindow();
                printingService.print(this.table, printoutTitle);
            }
        }
    }

    public static abstract class AbstractPageSetupAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AbstractPageSetupAction() {
            super("Page Setup...");
            this.putValue("MnemonicKey", 76);
            this.putValue("ShortDescription", "Page Setup...");
        }

        protected void pageSetup(AbstractView view, ToolService toolService) {
            PageSetupRunner pageSetupRunner = new PageSetupRunner(view, toolService);
            Thread thread = new Thread((Runnable)pageSetupRunner, "Page setup of alarm logs");
            thread.start();
        }

        public class PageSetupRunner
        implements Runnable {
            AbstractView view;
            ToolService toolService;

            public PageSetupRunner(AbstractView view, ToolService toolService) {
                this.view = view;
                this.toolService = toolService;
            }

            public void run() {
                PrintingService printingService = this.toolService.getPrintingService();
                printingService.pageLayout();
            }
        }
    }

    public static abstract class AbstractHyperToolAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected String cfgFileName = null;
        protected String toolName;

        public AbstractHyperToolAction(String name, String cfgFileName) {
            super(name);
            this.cfgFileName = cfgFileName;
            this.toolName = name;
            this.putValue("ShortDescription", "Open in " + name);
        }
    }

    public static abstract class AbstractHelpOnWindowAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AbstractHelpOnWindowAction() {
            super("On Window");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 0));
            this.putValue("MnemonicKey", 72);
            this.putValue("ShortDescription", "Element Manager User Guide");
        }
    }

    public static abstract class AbstractHelpOnAlarmAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AbstractHelpOnAlarmAction() {
            super("Help on Alarm");
            this.putValue("ShortDescription", "View help for selected alarm");
        }
    }

    public static abstract class AbstractFilterAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AbstractFilterAction(String name) {
            super(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractExportAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AbstractExportAction() {
            super("Export...");
            this.putValue("MnemonicKey", 88);
            this.putValue("ShortDescription", "Export...");
        }

        protected void export(FmType logToolType, AbstractView view, FmTableModel model) {
            File file = this.getFile(view);
            if (file != null) {
                Vector<String> lines = new Vector<String>();
                lines.addElement(this.getHeaderLine(logToolType));
                int rows = model.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    lines.addElement(this.getLineForWriting(logToolType, model.getRow(i)));
                }
                try {
                    this.write(file, lines);
                }
                catch (Exception e) {
                    FmError.EXPORT.displayError(view.getView(), e, new Object[0]);
                }
            }
        }

        private File getFile(JPanel view) {
            String currentDirectoryPath = System.getProperty("user.home");
            JFileChooser fileChooser = new JFileChooser(currentDirectoryPath);
            int status = fileChooser.showSaveDialog(view);
            File file = null;
            if (status == 0) {
                file = fileChooser.getSelectedFile();
            }
            return file;
        }

        private void write(File file, Vector<String> lines) throws IOException {
            FileWriter filewriter = new FileWriter(file);
            for (String line : lines) {
                filewriter.write(line, 0, line.length());
            }
            filewriter.close();
        }

        private String getHeaderLine(FmType logToolType) {
            StringBuffer strBuf = new StringBuffer();
            TreeSet<LogPart> tmpDetails = LogPart.getDetails(logToolType);
            for (LogPart part : tmpDetails) {
                strBuf.append(part.DETAILS_TITLE);
                strBuf.append(";");
            }
            strBuf.append("\n");
            return strBuf.toString();
        }

        private String getLineForWriting(FmType logToolType, RecordContent row) {
            StringBuffer strBuf = new StringBuffer();
            TreeSet<LogPart> tmpDetails = LogPart.getDetails(logToolType);
            block4: for (LogPart part : tmpDetails) {
                switch (part) {
                    case CORRELATED_NOTIFICATIONS: {
                        this.addCorrelatedNotification(row, strBuf, part);
                        continue block4;
                    }
                    case ADDITIONAL_INFORMATION: {
                        this.addAdditionalInformation(row, strBuf, part);
                        continue block4;
                    }
                }
                strBuf.append(row.get((Object)part));
                strBuf.append(";");
            }
            strBuf.append("\n");
            return strBuf.toString();
        }

        private void addAdditionalInformation(RecordContent row, StringBuffer strBuf, LogPart part) {
            List additionalInformations = (List)row.get((Object)part);
            for (int i = 0; i < additionalInformations.size(); ++i) {
                AdditionalInformation additionalInformation = (AdditionalInformation)additionalInformations.get(i);
                strBuf.append(additionalInformation.getType());
                strBuf.append(": ");
                String tmp1 = additionalInformation.getValue();
                tmp1 = tmp1.replace('\n', ' ');
                tmp1 = tmp1.replace('\t', ' ');
                tmp1 = tmp1.replace('\r', ' ');
                strBuf.append(tmp1);
                strBuf.append(" | ");
            }
            if (!additionalInformations.isEmpty()) {
                int lastPos = strBuf.length() - 1;
                strBuf.delete(lastPos - 2, lastPos);
            }
            strBuf.append(";");
        }

        private void addCorrelatedNotification(RecordContent row, StringBuffer strBuf, LogPart part) {
            List correlatedNotifications = (List)row.get((Object)part);
            for (int i = 0; i < correlatedNotifications.size(); ++i) {
                CorrelatedNotification correlatedNotification = (CorrelatedNotification)correlatedNotifications.get(i);
                strBuf.append(((CorrelatedNotification)correlatedNotifications.get(i)).getMoi());
                strBuf.append("   ");
                strBuf.append(correlatedNotification.getNotificationId());
                strBuf.append(" | ");
            }
            if (!correlatedNotifications.isEmpty()) {
                int lastPos = strBuf.length() - 1;
                strBuf.delete(lastPos - 2, lastPos);
            }
            strBuf.append(";");
        }
    }

    public static abstract class AbstractDetailsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AbstractDetailsAction() {
            super("Details");
            this.putValue("MnemonicKey", 68);
            this.putValue("ShortDescription", "View details for selected row");
        }
    }

    public static abstract class AbstractCopyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AbstractCopyAction() {
            super("Copy");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 128));
            this.putValue("ShortDescription", "Copy selected text");
        }
    }

    public static abstract class AbstractCloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AbstractCloseAction() {
            super("Close");
            this.putValue("MnemonicKey", 67);
            this.putValue("ShortDescription", "Close Window");
        }
    }

    public static abstract class AbstractAlarmTypeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AbstractAlarmTypeAction() {
            super("Alarm Type");
            this.putValue("MnemonicKey", 84);
            this.putValue("ShortDescription", "Filtering the alarm list");
        }
    }

    public static abstract class AbstractAboutAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AbstractAboutAction() {
            super("About");
            this.putValue("MnemonicKey", 65);
            this.putValue("ShortDescription", "Display product numbers and versions");
        }
    }
}

