/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.view.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.UIManager;

public class BevelArrowIcon
implements Icon {
    public static final int UPdirection = 0;
    public static final int DOWNdirection = 1;
    private static final int DEFAULT_SIZES = 11;
    private Color edgeColor1;
    private Color edgeColor2;
    private Color fillColor;
    private int sizes;
    private int directions;

    public BevelArrowIcon(int direction, boolean isRaiseView, boolean isPressView) {
        if (isRaiseView) {
            if (isPressView) {
                this.init(UIManager.getColor("controlLtHighlight"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlShadow"), 11, direction);
            } else {
                this.init(UIManager.getColor("controlHighlight"), UIManager.getColor("controlShadow"), UIManager.getColor("control"), 11, direction);
            }
        } else if (isPressView) {
            this.init(UIManager.getColor("controlDkShadow"), UIManager.getColor("controlLtHighlight"), UIManager.getColor("controlShadow"), 11, direction);
        } else {
            this.init(UIManager.getColor("controlShadow"), UIManager.getColor("controlHighlight"), UIManager.getColor("control"), 11, direction);
        }
    }

    public BevelArrowIcon(Color edgeColor1, Color edgeColor2, Color fillColor, int size, int direction) {
        this.init(edgeColor1, edgeColor2, fillColor, size, direction);
    }

    public void paintIcon(Component c, Graphics gra, int x, int y) {
        switch (this.directions) {
            case 1: {
                this.drawDownArrow(gra, x, y);
                break;
            }
            case 0: {
                this.drawUpArrow(gra, x, y);
            }
        }
    }

    public int getIconWidth() {
        return this.sizes;
    }

    public int getIconHeight() {
        return this.sizes;
    }

    private void init(Color edgeColor1, Color edgeColor2, Color fillColor, int size, int direction) {
        this.edgeColor1 = edgeColor1;
        this.edgeColor2 = edgeColor2;
        this.fillColor = fillColor;
        this.sizes = size;
        this.directions = direction;
    }

    private void drawDownArrow(Graphics g, int xo, int yo) {
        g.setColor(this.edgeColor1);
        g.drawLine(xo, yo, xo + this.sizes - 1, yo);
        g.drawLine(xo, yo + 1, xo + this.sizes - 3, yo + 1);
        g.setColor(this.edgeColor2);
        g.drawLine(xo + this.sizes - 2, yo + 1, xo + this.sizes - 1, yo + 1);
        int a = xo + 1;
        int b = yo + 2;
        int dx = this.sizes - 6;
        while (b + 1 < yo + this.sizes) {
            g.setColor(this.edgeColor1);
            g.drawLine(a, b, a + 1, b);
            g.drawLine(a, b + 1, a + 1, b + 1);
            if (0 < dx) {
                g.setColor(this.fillColor);
                g.drawLine(a + 2, b, a + 1 + dx, b);
                g.drawLine(a + 2, b + 1, a + 1 + dx, b + 1);
            }
            g.setColor(this.edgeColor2);
            g.drawLine(a + dx + 2, b, a + dx + 3, b);
            g.drawLine(a + dx + 2, b + 1, a + dx + 3, b + 1);
            ++a;
            b += 2;
            dx -= 2;
        }
        g.setColor(this.edgeColor1);
        g.drawLine(xo + this.sizes / 2, yo + this.sizes - 1, xo + this.sizes / 2, yo + this.sizes - 1);
    }

    private void drawUpArrow(Graphics g, int xo, int yo) {
        g.setColor(this.edgeColor1);
        int a = xo + this.sizes / 2;
        g.drawLine(a, yo, a, yo);
        --a;
        int b = yo + 1;
        int dx = 0;
        while (b + 3 < yo + this.sizes) {
            g.setColor(this.edgeColor1);
            g.drawLine(a, b, a + 1, b);
            g.drawLine(a, b + 1, a + 1, b + 1);
            if (0 < dx) {
                g.setColor(this.fillColor);
                g.drawLine(a + 2, b, a + 1 + dx, b);
                g.drawLine(a + 2, b + 1, a + 1 + dx, b + 1);
            }
            g.setColor(this.edgeColor2);
            g.drawLine(a + dx + 2, b, a + dx + 3, b);
            g.drawLine(a + dx + 2, b + 1, a + dx + 3, b + 1);
            --a;
            b += 2;
            dx += 2;
        }
        g.setColor(this.edgeColor1);
        g.drawLine(xo, yo + this.sizes - 3, xo + 1, yo + this.sizes - 3);
        g.setColor(this.edgeColor2);
        g.drawLine(xo + 2, yo + this.sizes - 2, xo + this.sizes - 1, yo + this.sizes - 2);
        g.drawLine(xo, yo + this.sizes - 1, xo + this.sizes, yo + this.sizes - 1);
    }
}

