/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.view.impl;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import se.ericsson.cello.em.fm.common.model.impl.Severity;

public class ColorCodedColumns
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = -2809488034577814572L;
    private static final String acknowledgementState = "Acknowledgement State Changed";
    private int columnNum = -1;
    private Color background = Color.WHITE;

    public ColorCodedColumns() {
        this.setOpaque(true);
    }

    public ColorCodedColumns(int columnNum, Color background) {
        this.columnNum = columnNum;
        this.background = background;
        this.setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setText(value.toString());
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(this.background);
            if (-1 != this.columnNum) {
                for (int j = 0; j < this.columnNum; ++j) {
                    if (!table.getValueAt(row, j).toString().equals(acknowledgementState)) continue;
                    this.setBackground(Color.lightGray);
                }
            }
            if (value instanceof Severity) {
                this.setBackground(this.getAlarmSeverityClrCode((Severity)((Object)value)));
            }
        }
        return this;
    }

    private Color getAlarmSeverityClrCode(Severity severity) {
        Color clr;
        switch (severity) {
            case CRITICAL: {
                clr = Color.red;
                break;
            }
            case MAJOR: {
                clr = new Color(255, 153, 0);
                break;
            }
            case MINOR: {
                clr = Color.yellow;
                break;
            }
            case WARNING: {
                clr = new Color(51, 153, 204);
                break;
            }
            case INDETERMINATE: {
                clr = new Color(153, 204, 204);
                break;
            }
            default: {
                clr = Color.white;
            }
        }
        return clr;
    }
}

