/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.eventlog.controller.impl;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import se.ericsson.cello.em.fm.common.config.ifc.LogConfiguration;
import se.ericsson.cello.em.fm.common.config.ifc.PrintingService;
import se.ericsson.cello.em.fm.common.controller.ifc.LogToolController;
import se.ericsson.cello.em.fm.common.details.controller.impl.DetailsController;
import se.ericsson.cello.em.fm.common.model.ifc.SelectedObjectInterface;
import se.ericsson.cello.em.fm.common.model.impl.NonEditableSortedTableModel;
import se.ericsson.cello.em.fm.common.model.impl.RecordContent;
import se.ericsson.cello.em.fm.common.utils.ifc.ToolService;
import se.ericsson.cello.em.fm.common.utils.impl.FmType;
import se.ericsson.cello.em.fm.common.utils.impl.TimeConverter;
import se.ericsson.cello.em.fm.common.view.impl.AbstractActions;
import se.ericsson.cello.em.fm.eventlog.EventLog;
import se.ericsson.cello.em.fm.eventlog.view.impl.EventLogView;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.utils.EmLogger;

public class EventLogController
implements SelectedObjectInterface,
LogToolController {
    private static final EmLogger LOG = EmLogger.TROUBLE_SHOOTING;
    private static final Dimension DEFAULT_DIMENSION = new Dimension(800, 500);
    private EventLogView view;
    private DetailsController detailsController = null;
    private NonEditableSortedTableModel model;
    private ToolService toolService;
    private LogConfiguration logConfiguration;
    protected PrintingService printingService = null;
    private Launchable eventLog = null;

    public EventLogController(Launchable launchable, ToolService toolService, LogConfiguration logConfig) {
        this.toolService = toolService;
        this.eventLog = launchable;
        this.logConfiguration = logConfig;
    }

    public void init() {
        LOG.info("Initializing event log controller and view...", new Object[0]);
        this.model = new NonEditableSortedTableModel(FmType.EVENT);
        SwingUtilities.invokeLater(new GuiThread(Action.CREATE_VIEW));
        this.processLog();
        SwingUtilities.invokeLater(new GuiThread(Action.UPDATE_TABLE));
    }

    public void bringGuiToFront() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.view.bringToFront();
        } else {
            SwingUtilities.invokeLater(new GuiThread(Action.BRING2FRONT));
        }
    }

    public RecordContent getSelectedObject() {
        return this.model.getRow(this.view.getSelectedRow());
    }

    public void disposeDetailWindow() {
        this.detailsController = null;
    }

    public JFrame getView() {
        return this.view == null ? null : this.view.getView();
    }

    public void rowSelected() {
    }

    /*
     * Exception decompiling
     */
    private int processLog() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateTable() {
        this.view.sortTable();
        this.view.setNoOfEvents(this.model.getRowCount());
        this.view.setTimeStamp(new TimeConverter().getCurrentTime());
        if (this.eventLog instanceof EventLog) {
            ((EventLog)this.eventLog).sendEmNotification(GuiTestEventTypes.EVENTLOG_UPDATED, null, this);
        }
    }

    private void exit() {
        LOG.info("Closing EventLogTool main window...", new Object[0]);
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.detailsController != null) {
                this.detailsController.exit();
            }
            this.view.disposeWindow();
            this.detailsController = null;
            this.view = null;
            this.eventLog.exit();
            LOG.info("Event Log Tool closed.", new Object[0]);
        } else {
            SwingUtilities.invokeLater(new GuiThread(Action.EXIT));
        }
    }

    class RefreshAction
    extends AbstractActions.AbstractRefreshAction {
        private static final long serialVersionUID = 1L;

        RefreshAction() {
        }

        public void actionPerformed(ActionEvent event) {
            EventLogController.this.model.removeAllRows();
            EventLogController.this.processLog();
            EventLogController.this.updateTable();
        }
    }

    class PrintAction
    extends AbstractActions.AbstractPrintAction {
        private static final long serialVersionUID = 1L;

        PrintAction() {
        }

        public void actionPerformed(ActionEvent event) {
            super.print(EventLogController.this.view.getTable(), EventLogController.this.toolService);
        }
    }

    class PageSetupAction
    extends AbstractActions.AbstractPageSetupAction {
        private static final long serialVersionUID = 1L;

        PageSetupAction() {
        }

        public void actionPerformed(ActionEvent event) {
            super.pageSetup(EventLogController.this.view, EventLogController.this.toolService);
        }
    }

    class ExportAction
    extends AbstractActions.AbstractExportAction {
        private static final long serialVersionUID = 1L;

        ExportAction() {
        }

        public void actionPerformed(ActionEvent event) {
            super.export(FmType.EVENT, EventLogController.this.view, EventLogController.this.model);
        }
    }

    class DetailsAction
    extends AbstractActions.AbstractDetailsAction {
        private static final long serialVersionUID = 1L;

        DetailsAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if (EventLogController.this.detailsController == null) {
                EventLogController.this.detailsController = new DetailsController(FmType.EVENT, EventLogController.this, EventLogController.this.toolService);
                EventLogController.this.detailsController.createView();
            } else {
                EventLogController.this.detailsController.refreshView();
            }
        }
    }

    class CloseAction
    extends AbstractActions.AbstractCloseAction {
        private static final long serialVersionUID = 1L;

        CloseAction() {
        }

        public void actionPerformed(ActionEvent event) {
            EventLogController.this.exit();
        }
    }

    class WindowClosingListener
    extends WindowAdapter {
        WindowClosingListener() {
        }

        public void windowClosing(WindowEvent e) {
            EventLogController.this.exit();
        }
    }

    class GuiThread
    implements Runnable {
        private Action action;

        GuiThread(Action action) {
            this.action = action;
        }

        public void run() {
            switch (this.action) {
                case BRING2FRONT: {
                    EventLogController.this.bringGuiToFront();
                    break;
                }
                case CREATE_VIEW: {
                    EventLogController.this.view = new EventLogView(EventLogController.this.toolService);
                    EventLogController.this.view.init(DEFAULT_DIMENSION);
                    EventLogController.this.view.addWindowClosingListener(new WindowClosingListener());
                    EventLogController.this.view.addCloseAction(new CloseAction());
                    EventLogController.this.view.addDetailsAction(new DetailsAction());
                    EventLogController.this.view.addExportAction(new ExportAction());
                    EventLogController.this.view.addPageSetupAction(new PageSetupAction());
                    EventLogController.this.view.addPrintAction(new PrintAction());
                    EventLogController.this.view.addRefreshAction(new RefreshAction());
                    EventLogController.this.view.setModel(EventLogController.this.model);
                    LOG.info("Event log controller and view are initialized.", new Object[0]);
                    break;
                }
                case EXIT: {
                    EventLogController.this.exit();
                    break;
                }
                case UPDATE_TABLE: {
                    EventLogController.this.updateTable();
                    break;
                }
                default: {
                    LOG.severe("Unhandled GUI action: " + this.action.name(), new Object[0]);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        BRING2FRONT,
        CREATE_VIEW,
        EXIT,
        UPDATE_TABLE;

    }
}

