/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.FindMoDataByLDNFilter;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Handler;

public class HandleMaoCascadedAction
implements MoDataAction {
    private static final Class THIS_CLASS = HandleMaoCascadedAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String FRO_ID_ATTR_NAME = "froId";
    private static final String IS_CASCADED = "isCascaded";
    private static final int SECOND_CABINET_FRO_ID = 1;
    private static final String DEFAULT_CABINET_LDN = "ManagedElement=1,Equipment=1,Cabinet=1";
    private static final String DUALBOX_CABINET_LDN = "ManagedElement=1,Equipment=1,Cabinet=2";
    private static final int FANGROUP_FRO_ID = 1;
    private static final String OLD_FANGROUP_LDN = "ManagedElement=1,Equipment=1,Cabinet=1,FanGroup=2";
    private static final String FANGROUP_LDN = "ManagedElement=1,Equipment=1,Cabinet=2,FanGroup=1";
    private static final String CABINET_IS_CREATED = "cabinetIsCreated";
    private static final String FANGROUP_IS_CREATED = "fangroupIsCreated";
    private static final String FANGROUP_IS_DELETED = "fangroupIsDeleted";
    private static final String TRUE = "true";
    private static final String CABINET_ATT_CLIMATE_SYSTEM = "climateSystem";
    private static final String CABINET_ATT_CABPARAM_EXTENDED = "cabinetParametersProfileExtended";
    private static final String CABINET_ATT_CABPARAM_STANDARD = "cabinetParametersProfileStandard";
    private static final int PARAMETERS_ARRAY_LENGHT = 100;
    private static final String ATT_RESERVEDBY = "reservedBy";
    private static final String ECPORT_ATT_ECBUSREF = "ecBusRef";
    private static final String HWUNIT_ATT_POSREF = "positionRef";
    private static final String HW_UNIT = "HwUnit";
    private static final String EMPTY_LDN = "emptyLdn";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        logger.traceGeneral(THIS_CLASS, "perform(): Check AUE persistency (step1) if configuration is DualBox");
        Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        String string = step2Handler.retrieveFromAuePersistency("", IS_CASCADED);
        if (string.equals(TRUE)) {
            logger.traceGeneral(THIS_CLASS, "perform(): DualBox is detected");
            logger.traceGeneral(THIS_CLASS, "perform(): Retrive configuration data from AUE persistency (step1)");
            String string2 = step2Handler.retrieveFromAuePersistency("", CABINET_IS_CREATED);
            String string3 = step2Handler.retrieveFromAuePersistency("", FANGROUP_IS_CREATED);
            String string4 = step2Handler.retrieveFromAuePersistency("", FANGROUP_IS_DELETED);
            if (string2.equals(TRUE)) {
                logger.traceGeneral(THIS_CLASS, "perform(): Cabinet=2 has been created in step 1, creating cabinet in MAO");
                this.createCabinetMo(converterContext, DUALBOX_CABINET_LDN, 1, coordinator);
            }
            logger.traceGeneral(THIS_CLASS, "perform(): Change MO Cabinet attribute, ClimateSystem, to Standard (0) ");
            this.changeClimateSystem(converterContext, coordinator);
            this.setPosRef(converterContext, coordinator);
            if (string3.equals(TRUE)) {
                logger.traceGeneral(THIS_CLASS, "perform(): FanGroup under Cabinet=2 has been created in step 1, creating FanGroup in MAO");
                this.createMo(converterContext, FANGROUP_LDN, 1, coordinator);
            }
            if (string4.equals(TRUE)) {
                logger.traceGeneral(THIS_CLASS, "perform(): FanGroup under Cabinet=1 has been deleted in step 1, delete FanGroup in MAO");
                this.deleteMo(converterContext, OLD_FANGROUP_LDN, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private void setPosRef(ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        if (moDataAccessor == null) {
            logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
        } else {
            Collection collection = moDataAccessor.getByType(HW_UNIT);
            if (collection != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    CrbsAueException crbsAueException;
                    MoDataWrapper moDataWrapper = (MoDataWrapper)iterator.next();
                    try {
                        String string = this.getPosRefFromStep1(moDataWrapper, converterContext);
                        if (string.equals(EMPTY_LDN)) continue;
                        crbsAueException = new ReferenceAttribute(HWUNIT_ATT_POSREF, string, true);
                        moDataWrapper.deregisterAttribute(HWUNIT_ATT_POSREF);
                        moDataWrapper.registerPersistentAttr((Attribute)crbsAueException);
                        moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                    }
                    catch (AueException aueException) {
                        crbsAueException = new CrbsAueException(aueException.getMessage());
                        crbsAueException.setStackTrace(aueException.getStackTrace());
                        throw crbsAueException;
                    }
                }
            } else {
                logger.traceGeneral(THIS_CLASS, "No EcPort MOs found.");
            }
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private String getPosRefFromStep1(MoDataWrapper moDataWrapper, ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getPosRefFromStep1()");
        String string = moDataWrapper.getLocalDistinguishedName();
        if (string.toLowerCase().endsWith("sup-1") || string.toLowerCase().endsWith("sup-2")) {
            String string2;
            Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
            try {
                string2 = step2Handler.retrieveFromAuePersistency(string, HWUNIT_ATT_POSREF);
                logger.traceGeneral(THIS_CLASS, "Found PosRef passed from step1: " + string2);
            }
            catch (Exception exception) {
                throw new CrbsAueException("Can not read ecBusRef from AuePersistency database table for ldn=" + string + " Exception=" + exception.toString(), (Throwable)exception);
            }
            logger.traceReturn(THIS_CLASS, "getPosRefFromStep1()");
            return string2;
        }
        return EMPTY_LDN;
    }

    private void changeClimateSystem(ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "changeClimateSystem()");
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        try {
            logger.traceGeneral(THIS_CLASS, "changeClimateSystem(): Get all Cabinets in MAO");
            Collection collection = moDataAccessor.find((MoDataFilter)new FindMoDataByLDNFilter(DEFAULT_CABINET_LDN));
            Iterator iterator = collection.iterator();
            logger.traceGeneral(THIS_CLASS, "changeClimateSystem(): Find Default Cabinet and set climateSystem to Standard(0)");
            while (iterator.hasNext()) {
                MoDataWrapper moDataWrapper = (MoDataWrapper)iterator.next();
                moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                IntegerAttribute integerAttribute = (IntegerAttribute)moDataWrapper.getAttribute(CABINET_ATT_CLIMATE_SYSTEM);
                integerAttribute.setValue(0);
            }
        }
        catch (AueException aueException) {
            CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
            crbsAueException.setStackTrace(aueException.getStackTrace());
            throw crbsAueException;
        }
        logger.traceReturn(THIS_CLASS, "changeClimateSystem()");
    }

    private void createMo(ConverterContext converterContext, String string, int n, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createMo()");
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        try {
            logger.traceGeneral(THIS_CLASS, "createMo(): Creating new MO with LDN: " + string);
            MoDataWrapper moDataWrapper = moDataAccessor.create(string, coordinator);
            moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            this.addFroIdAttribute(moDataWrapper, n);
        }
        catch (AueException aueException) {
            CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
            crbsAueException.setStackTrace(aueException.getStackTrace());
            throw crbsAueException;
        }
        logger.traceReturn(THIS_CLASS, "createMo()");
    }

    private void createCabinetMo(ConverterContext converterContext, String string, int n, Coordinator coordinator) throws CrbsAueException {
        Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        logger.traceEnter(THIS_CLASS, "createCabinetMo()");
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        try {
            logger.traceGeneral(THIS_CLASS, "createEcBusMo(): Creating new MO with LDN: " + string);
            MoDataWrapper moDataWrapper = moDataAccessor.create(string, coordinator);
            moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            this.addFroIdAttribute(moDataWrapper, n);
            this.addStringAttribute(moDataWrapper, "userLabel", "");
            this.addIntAttribute(moDataWrapper, CABINET_ATT_CLIMATE_SYSTEM, 0);
            logger.traceGeneral(THIS_CLASS, "createCabinetMo(): Adding reservedBy");
            SequenceAttribute sequenceAttribute = new SequenceAttribute(ATT_RESERVEDBY, false);
            logger.traceGeneral(THIS_CLASS, "createCabinetMo(): Adding Cabinet Parameters for Extended and Standard");
            SequenceAttribute sequenceAttribute2 = new SequenceAttribute(CABINET_ATT_CABPARAM_EXTENDED, false);
            SequenceAttribute sequenceAttribute3 = new SequenceAttribute(CABINET_ATT_CABPARAM_STANDARD, false);
            moDataWrapper.registerPersistentAttr((Attribute)sequenceAttribute);
            moDataWrapper.registerPersistentAttr((Attribute)sequenceAttribute2);
            moDataWrapper.registerPersistentAttr((Attribute)sequenceAttribute3);
            String string2 = step2Handler.retrieveFromAuePersistency(string, CABINET_ATT_CABPARAM_STANDARD);
            String string3 = step2Handler.retrieveFromAuePersistency(string, CABINET_ATT_CABPARAM_EXTENDED);
            logger.traceGeneral(THIS_CLASS, "createCabinetMo(): Set sequenceAttributes for Cabinet Parameters for Extended and Standard");
            boolean bl = string2 != null && !"".equals(string2);
            boolean bl2 = string3 != null && !"".equals(string3);
            logger.traceGeneral(THIS_CLASS, "createCabinetMo(): Set sequenceAttributes for Cabinet Parameters for Extended and Standard");
            if (bl) {
                this.setSequenceParameters(moDataWrapper, CABINET_ATT_CABPARAM_STANDARD, string2);
            }
            if (bl2) {
                this.setSequenceParameters(moDataWrapper, CABINET_ATT_CABPARAM_EXTENDED, string3);
            } else if (bl) {
                this.setSequenceParameters(moDataWrapper, CABINET_ATT_CABPARAM_EXTENDED, string2);
            }
        }
        catch (AueException aueException) {
            CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
            crbsAueException.setStackTrace(aueException.getStackTrace());
            throw crbsAueException;
        }
        logger.traceReturn(THIS_CLASS, "createCabinetMo()");
    }

    private void deleteMo(ConverterContext converterContext, final String string, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "deleteMo()");
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        try {
            logger.traceGeneral(THIS_CLASS, "deleteMo(): Delete Mo with ldn: " + string);
            MoDataWrapper moDataWrapper = moDataAccessor.findFirst(new MoDataFilter(){

                public boolean accept(MoDataWrapper moDataWrapper) {
                    String string2 = HandleMaoCascadedAction.this.trimLdn(moDataWrapper.getLocalDistinguishedName());
                    return string2.equals(string);
                }
            });
            if (moDataAccessor != null) {
                moDataAccessor.delete(moDataWrapper, coordinator);
            }
        }
        catch (AueException aueException) {
            CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
            crbsAueException.setStackTrace(aueException.getStackTrace());
            throw crbsAueException;
        }
        logger.traceReturn(THIS_CLASS, "deleteMo()");
    }

    private void addFroIdAttribute(MoDataWrapper moDataWrapper, int n) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addFroIdAttribute()");
        IntegerAttribute integerAttribute = new IntegerAttribute(FRO_ID_ATTR_NAME, false, n);
        moDataWrapper.registerPersistentAttr((Attribute)integerAttribute);
        logger.traceReturn(THIS_CLASS, "addFroIdAttribute()");
    }

    private void setSequenceParameters(MoDataWrapper moDataWrapper, String string, String string2) {
        logger.traceEnter(THIS_CLASS, "setSequenceParameters()");
        SequenceAttribute sequenceAttribute = (SequenceAttribute)moDataWrapper.getAttribute(string);
        Attribute[] attributeArray = this.getSequenceContent(string, string2);
        sequenceAttribute.setValue(attributeArray);
        logger.traceReturn(THIS_CLASS, "setSequenceParameters()");
    }

    private void addStringAttribute(MoDataWrapper moDataWrapper, String string, String string2) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addFroIdAttribute()");
        StringAttribute stringAttribute = new StringAttribute(string, false, string2);
        moDataWrapper.registerPersistentAttr((Attribute)stringAttribute);
        logger.traceReturn(THIS_CLASS, "addFroIdAttribute()");
    }

    private void addIntAttribute(MoDataWrapper moDataWrapper, String string, int n) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addIntAttribute()");
        IntegerAttribute integerAttribute = new IntegerAttribute(string, false, n);
        moDataWrapper.registerPersistentAttr((Attribute)integerAttribute);
        logger.traceReturn(THIS_CLASS, "addFroIdAttribute()");
    }

    private String trimLdn(String string) {
        return AueUtil.replaceInString((String)string, (String)" ", (String)"");
    }

    private Attribute[] getSequenceContent(String string, String string2) {
        String string3;
        logger.traceEnter(THIS_CLASS, "getSequenceContent()");
        IntegerAttribute[] integerAttributeArray = new IntegerAttribute[100];
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            string3 = stringTokenizer.nextElement().toString();
            IntegerAttribute integerAttribute = new IntegerAttribute(string, false);
            integerAttribute.setValue(Integer.parseInt(string3));
            integerAttributeArray[n++] = integerAttribute;
        }
        while (n < integerAttributeArray.length) {
            string3 = new IntegerAttribute(string, false);
            string3.setValue(0);
            integerAttributeArray[n] = string3;
            ++n;
        }
        logger.traceReturn(THIS_CLASS, "getSequenceContent()");
        return integerAttributeArray;
    }
}

