/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Handler;

public class UpdateReservedByOnCabinetAction
implements MoDataAction {
    private static final Class THIS_CLASS = UpdateReservedByOnCabinetAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String HWUNIT_ATT_POSREF = "positionRef";
    private static final String CABINET_ATT_RESERVEDBY = "reservedBy";
    private static final String CABINET_MO_TYPE = "Cabinet";
    private static final String HWUNIT_MO_TYPE = "HwUnit";
    private static final String IS_DUALBOX = "isDualBox";
    private static final String IS_CASCADED = "isCascaded";
    private static final String TRUE = "true";
    private static final String SUP_LDN = "managedelement=1,equipment=1,hwunit=sup";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        String string = step2Handler.retrieveFromAuePersistency("", IS_CASCADED);
        String string2 = step2Handler.retrieveFromAuePersistency("", IS_DUALBOX);
        if (string.equals(TRUE) || string2.equals(TRUE)) {
            MoDataWrapper moDataWrapper2 = null;
            MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
            if (moDataAccessor == null) {
                logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
            } else {
                logger.traceGeneral(THIS_CLASS, "Accessing MOs of type Cabinet");
                Collection collection = moDataAccessor.getByType(CABINET_MO_TYPE);
                if (collection != null) {
                    Iterator iterator = collection.iterator();
                    logger.traceGeneral(THIS_CLASS, "Iterate over all MOs of type Cabinet");
                    while (iterator.hasNext()) {
                        moDataWrapper2 = (MoDataWrapper)iterator.next();
                        logger.traceGeneral(THIS_CLASS, "Creating ReservedBy attribute");
                        SequenceAttribute sequenceAttribute = (SequenceAttribute)moDataWrapper2.getAttribute(CABINET_ATT_RESERVEDBY);
                        if (sequenceAttribute == null) {
                            sequenceAttribute = new SequenceAttribute(CABINET_ATT_RESERVEDBY, true);
                        }
                        try {
                            logger.traceGeneral(THIS_CLASS, "Find and Assert ReservedBy Attribute");
                            SequenceAttribute sequenceAttribute2 = this.updateReservedByAttribute(converterContext, sequenceAttribute, moDataWrapper2.getLocalDistinguishedName());
                            logger.traceGeneral(THIS_CLASS, "deregister and register Attribute: reservedBy");
                            moDataWrapper2.deregisterAttribute(CABINET_ATT_RESERVEDBY);
                            moDataWrapper2.registerPersistentAttr((Attribute)sequenceAttribute2);
                            moDataWrapper2.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                        }
                        catch (AueException aueException) {
                            CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
                            crbsAueException.setStackTrace(aueException.getStackTrace());
                            throw crbsAueException;
                        }
                    }
                } else {
                    logger.traceAbnormal(THIS_CLASS, "ecBusMosCollection  is null");
                }
            }
        }
    }

    private SequenceAttribute updateReservedByAttribute(ConverterContext converterContext, SequenceAttribute sequenceAttribute, String string) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "updateReservedByAttribute()");
        MoDataWrapper moDataWrapper = null;
        boolean bl = false;
        SequenceAttribute sequenceAttribute2 = new SequenceAttribute(CABINET_ATT_RESERVEDBY, true);
        if (sequenceAttribute != null) {
            MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
            if (moDataAccessor == null) {
                logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
            } else {
                logger.traceGeneral(THIS_CLASS, "Accessing MOs of type HwUnit");
                Collection collection = moDataAccessor.getByType(HWUNIT_MO_TYPE);
                if (collection != null) {
                    logger.traceGeneral(THIS_CLASS, "Iterate over MOs");
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        String string2;
                        ReferenceAttribute referenceAttribute;
                        bl = false;
                        moDataWrapper = (MoDataWrapper)iterator.next();
                        logger.traceGeneral(THIS_CLASS, "Extract attribute positionRef where ldn match the Cabinet: " + string);
                        if ((moDataWrapper == null || !moDataWrapper.getLocalDistinguishedName().toLowerCase().endsWith("sup-1")) && !moDataWrapper.getLocalDistinguishedName().toLowerCase().endsWith("sup-2") || (referenceAttribute = (ReferenceAttribute)moDataWrapper.getAttribute(HWUNIT_ATT_POSREF)) == null || !(string2 = referenceAttribute.getReferenceAsLDN()).toLowerCase().equals(string.toLowerCase())) continue;
                        Enumeration enumeration = sequenceAttribute.elements();
                        while (enumeration.hasMoreElements()) {
                            ReferenceAttribute referenceAttribute2 = (ReferenceAttribute)enumeration.nextElement();
                            String string3 = referenceAttribute2.getReferenceAsLDN();
                            logger.traceGeneral(THIS_CLASS, "checkExistenceOfRefAttr(): Reference exist in sequence attribut");
                            if (string3.toLowerCase().equals(string2.toLowerCase())) {
                                sequenceAttribute2.addElement((Attribute)referenceAttribute2);
                                bl = true;
                                continue;
                            }
                            if (string3.toLowerCase().startsWith(SUP_LDN)) continue;
                            sequenceAttribute2.addElement((Attribute)referenceAttribute2);
                        }
                        if (bl) continue;
                        sequenceAttribute2.addElement((Attribute)new ReferenceAttribute("", moDataWrapper.getLocalDistinguishedName(), true));
                    }
                } else {
                    logger.traceAbnormal(THIS_CLASS, "hwUnitMoCollection is null");
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "updateEcBusReservedBy()");
        return sequenceAttribute2;
    }
}

