/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.common;

import java.util.Date;

public class JvmHelper {
    public static String getAllThreadNames() {
        return JvmHelper.getAllThreadNames(Thread.currentThread());
    }

    public static String getAllThreadNames(Thread thread) {
        ThreadGroup aThreadGroup = thread.getThreadGroup();
        while (aThreadGroup.getParent() != null) {
            aThreadGroup = aThreadGroup.getParent();
        }
        Thread[] allThreads = new Thread[aThreadGroup.activeCount() * 2];
        int length = aThreadGroup.enumerate(allThreads);
        StringBuffer strBuffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            strBuffer.append("Thread[").append(Integer.toString(i)).append("] = ").append(allThreads[i].toString()).append("  (").append(Long.toString(allThreads[i].hashCode())).append(")\n");
        }
        return strBuffer.toString();
    }

    public static int getNumberOfThreads() {
        return JvmHelper.getNumberOfThreads(Thread.currentThread());
    }

    public static int getNumberOfThreads(Thread thread) {
        ThreadGroup aThreadGroup = thread.getThreadGroup();
        while (aThreadGroup.getParent() != null) {
            aThreadGroup = aThreadGroup.getParent();
        }
        Thread[] allThreads = new Thread[aThreadGroup.activeCount() * 2];
        return aThreadGroup.enumerate(allThreads);
    }

    public static long getUsedMemory() {
        System.gc();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        return totalMemory - freeMemory;
    }

    public static double getUsedMemoryInMegaBytes() {
        long usedMemoryInBytes = JvmHelper.getUsedMemory();
        return (double)usedMemoryInBytes / 1000000.0;
    }

    public static String getThreadsAndUsedMemory() {
        StringBuffer result = new StringBuffer("Time: ").append(new Date().toString()).append("\nNumber of threads: ").append(Integer.toString(JvmHelper.getNumberOfThreads(Thread.currentThread()))).append("\nUsed memory: ").append(Double.toString(JvmHelper.getUsedMemoryInMegaBytes())).append(" MB\n").append(JvmHelper.getAllThreadNames());
        return result.toString();
    }

    public static String getNumberOfThreadsAndUsedMemory() {
        return JvmHelper.getNumberOfThreadsAndUsedMemory(Thread.currentThread());
    }

    public static String getNumberOfThreadsAndUsedMemory(Thread thread) {
        StringBuffer result = new StringBuffer("Number of threads: ").append(Integer.toString(JvmHelper.getNumberOfThreads(thread))).append(", Used memory: ").append(Double.toString(JvmHelper.getUsedMemoryInMegaBytes())).append(" MB");
        return result.toString();
    }
}

