/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1;

import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.CollectorGraph;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.xml.MomInfo;
import se.ericsson.crbs.omf.aue.step1.RbsCollectorHandler;

public class RbsCollectorHandlerImpl
implements RbsCollectorHandler {
    private static final Class THIS_CLASS = RbsCollectorHandlerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final CollectorGraph graph;
    private final MomInfo fromMomInfo;
    private final MomInfo toMomInfo;
    private final MomInfo toMomInfoExcludingLastCollectorEdge;

    public RbsCollectorHandlerImpl(CollectorGraph graph, MomInfo fromMomInfo, MomInfo toMomInfo, MomInfo toMomInfoExcludingLastCollectorEdge) {
        this.graph = graph;
        this.fromMomInfo = fromMomInfo;
        this.toMomInfo = toMomInfo;
        this.toMomInfoExcludingLastCollectorEdge = toMomInfoExcludingLastCollectorEdge;
    }

    public void collect(CollectorContext collectorcontext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "collect()");
        try {
            this.graph.traverse(this.fromMomInfo.toString(), this.toMomInfo.toString(), collectorcontext);
        }
        catch (AueException ae) {
            CrbsAueException cae = new CrbsAueException(ae.getMessage());
            cae.setStackTrace(ae.getStackTrace());
            throw cae;
        }
        logger.traceReturn(THIS_CLASS, "collect()");
    }

    public MomInfo getFromVersion() {
        return this.fromMomInfo;
    }

    public MomInfo getToVersion() {
        return this.toMomInfo;
    }

    public MomInfo getToVersionExcludingLastCollectorEdge() {
        return this.toMomInfoExcludingLastCollectorEdge;
    }
}

