/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import java.util.Arrays;
import java.util.List;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.MoAccessor;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CopyMaoAttributeToFroAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$CopyMaoAttributeToFroAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$CopyMaoAttributeToFroAction = CopyMaoAttributeToFroAction.class$("se.ericsson.crbs.omf.aue.step1.actions.CopyMaoAttributeToFroAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$CopyMaoAttributeToFroAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$CopyMaoAttributeToFroAction;

    public void convert(AueContext context) throws CrbsAueException, NoSuchTableException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String froTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type, to copy to, is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String maoAttr = this.getAndCheckParamMapString("fromAttr", this.paramMap, "No attribute to copy from is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String maoTypeName = this.getAndCheckParamMapString("fromMo", this.paramMap, "The Mo type, to copy from, is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String froAttr = this.getAndCheckParamMapString("toAttr", this.paramMap, "No attribute to copy to is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String froAttrType = this.getAndCheckParamMapString("type", this.paramMap, "No attribute type is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String froDefaultValue = this.getWithoutCheckParamMapString("defaultValue", this.paramMap);
        TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            TableData tableData = tableHandler.getTableData(froTypeName);
            if (tableData.isNotEmpty()) {
                List<String> attributeNames = Arrays.asList(tableData.getAttributeNames());
                MoAccessor accessor = ((CollectorContext)context).getMoAccessor();
                if (accessor == null) {
                    logger.traceDebug(THIS_CLASS, "MoAccessor accessor is null. No MO instance of type " + maoTypeName + "exist.");
                    if (!attributeNames.contains(froAttr)) {
                        tableData.addAttribute(froAttr, froAttrType, froDefaultValue != null ? froDefaultValue : this.getDefaultValueIfNoDeafultValueSpecified(froAttrType));
                    }
                } else {
                    Object[] ldns = tableData.getAttributeValues("ldn");
                    int noOfLdns = ldns.length;
                    boolean alreadyAddedColumn = false;
                    for (int instance = 0; instance < noOfLdns; ++instance) {
                        ManagedObject maoMo = accessor.lookup((String)ldns[instance]);
                        Object value = maoMo.getAttribute(maoAttr, null);
                        if (!attributeNames.contains(froAttr) && !alreadyAddedColumn) {
                            String momType = this.getMomType(value);
                            tableData.addAttribute(froAttr, momType, froDefaultValue != null ? froDefaultValue : this.getDefaultValueIfNoDeafultValueSpecified(momType));
                            alreadyAddedColumn = true;
                        }
                        tableData.setAttributeValue(instance, froAttr, value);
                    }
                }
            } else {
                logger.traceDebug(THIS_CLASS, "Table data for MO " + froTypeName + " is empty. No need to continue this action.");
            }
        }
        catch (Exception exc) {
            String errorMsg = "Could not copy attribute, " + AueUtil.doubleQuote(maoAttr) + ", from Mo " + AueUtil.doubleQuote(maoTypeName) + ", to FRO " + AueUtil.doubleQuote(froTypeName);
            logger.traceAbnormal(THIS_CLASS, errorMsg);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private String getMomType(Object attrObj) {
        String momType = "";
        if (attrObj instanceof Struct) {
            momType = "struct";
        } else if (attrObj instanceof Integer) {
            momType = "S32";
        } else if (attrObj instanceof String) {
            momType = "STRING";
        } else if (attrObj instanceof ManagedObject) {
            momType = "moref";
        } else if (attrObj instanceof Object[]) {
            momType = "array";
        }
        return momType;
    }

    private String getDefaultValueIfNoDeafultValueSpecified(String momType) {
        String defaultValue = "";
        if (momType.equalsIgnoreCase("S32") || momType.equalsIgnoreCase("U32")) {
            defaultValue = "0";
        }
        return defaultValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

