/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.MoAccessor;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroArray;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroMoRef;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroStruct;

public class MoveAttributeFromMaoToFroAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$MoveAttributeFromMaoToFroAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$MoveAttributeFromMaoToFroAction = MoveAttributeFromMaoToFroAction.class$("se.ericsson.crbs.omf.aue.step1.actions.MoveAttributeFromMaoToFroAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$MoveAttributeFromMaoToFroAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$MoveAttributeFromMaoToFroAction;

    public void convert(AueContext context) throws CrbsAueException, NoSuchTableException {
        block8: {
            String maoAttr;
            logger.traceEnter(THIS_CLASS, "convert()");
            String froTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type, to copy from, is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
            String froAttr = maoAttr = this.getAndCheckParamMapString("maoAttr", this.paramMap, "No attribute to copy from is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
            TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
            try {
                MoAccessor accessor = ((CollectorContext)context).getMoAccessor();
                if (accessor == null) {
                    throw new CrbsAueException("MoAccessor accessor is null. No MO instance of type " + froTypeName + "exist. Can not copy attribute from MAO layer to FRO layer");
                }
                MoIterator moIterator = accessor.lookupType(froTypeName);
                boolean tableUpdatedFromStart = false;
                if (moIterator == null) break block8;
                TableData tableData = tableHandler.getTableData(froTypeName);
                tableUpdatedFromStart = tableData.isTableDataUpdated();
                try {
                    tableData.getAttributeValues(froAttr);
                }
                catch (TableDataException tde) {
                    ManagedObject fromMo = moIterator.nextMo();
                    Object attrObj = fromMo.getAttribute(froAttr, null);
                    AttributeHolder attributeHolder = this.handleAttribute(tableHandler, froAttr, attrObj);
                    tableData.addAttribute(froAttr, attributeHolder.momType, attributeHolder.defaultValue);
                }
                moIterator.reset();
                while (moIterator.hasMoreElements()) {
                    ManagedObject fromMo = moIterator.nextMo();
                    Object attrObj = fromMo.getAttribute(froAttr, null);
                    AttributeHolder attributeHolder = this.handleAttribute(tableHandler, froAttr, attrObj);
                    Object[] ldnColumnData = tableData.getAttributeValues("ldn");
                    String ldn = fromMo.getLocalDistinguishedName();
                    int rowIndex = -1;
                    for (int i = 0; i < ldnColumnData.length; ++i) {
                        if (!ldnColumnData[i].toString().equalsIgnoreCase(ldn)) continue;
                        rowIndex = i;
                        break;
                    }
                    tableData.setAttributeValue(rowIndex, froAttr, attributeHolder.attributeValue);
                    logger.traceGeneral(THIS_CLASS, "Attribute, " + AueUtil.doubleQuote(maoAttr) + ", copied from layer MAO to layer FRO. Value set to: " + AueUtil.doubleQuote(attributeHolder.attributeValue));
                }
                tableHandler.checkAndDropIfNotUpdated(tableUpdatedFromStart, tableData);
            }
            catch (MoAccessException mae) {
                String errorMsg = "Could not move attribute, " + AueUtil.doubleQuote(maoAttr) + ", in, " + AueUtil.doubleQuote(froTypeName) + ", from layer MAO to layer FRO";
                logger.traceDebug(THIS_CLASS, AueUtil.appendReason(errorMsg, mae));
                throw new CrbsAueException(errorMsg, mae);
            }
            catch (TableDataException tde) {
                String errorMsg = "Could not move attribute, " + AueUtil.doubleQuote(maoAttr) + ", in, " + AueUtil.doubleQuote(froTypeName) + ", from layer MAO to layer FRO";
                logger.traceDebug(THIS_CLASS, AueUtil.appendReason(errorMsg, tde));
                throw new CrbsAueException(errorMsg, tde);
            }
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private AttributeHolder handleAttribute(TableHandler tableHandler, String attributeName, Object attrObj) throws CrbsAueException, MoAccessException {
        String attributeValue = "";
        AttributeHolder attributeHolder = new AttributeHolder("", "");
        if (attrObj instanceof Struct) {
            attributeValue = this.handleStructAttribute(tableHandler, attributeName, (Struct)attrObj);
            attributeHolder = new AttributeHolder("struct", attributeValue);
        } else if (attrObj instanceof Integer) {
            attributeValue = this.handleIntegerAttribute(attributeName, (Integer)attrObj);
            attributeHolder = new AttributeHolder("S32", attributeValue);
        } else if (attrObj instanceof String) {
            attributeValue = this.handleStringAttribute(attributeName, (String)attrObj);
            attributeHolder = new AttributeHolder("STRING", attributeValue);
        } else if (attrObj instanceof ManagedObject) {
            attributeValue = this.handleManagedObjectAttribute(tableHandler, attributeName, (ManagedObject)attrObj);
            attributeHolder = new AttributeHolder("moref", attributeValue);
        } else if (attrObj instanceof Object[]) {
            attributeValue = this.handleArrayAttribute(tableHandler, attributeName, (Object[])attrObj);
            attributeHolder = new AttributeHolder("array", attributeValue);
        }
        return attributeHolder;
    }

    private String handleManagedObjectAttribute(TableHandler tableHandler, String attributeName, ManagedObject attributeVale) {
        FroMoRef froMoRef = new FroMoRef(tableHandler);
        froMoRef.convertManagedObjectToXml(attributeName, attributeVale);
        String moRefValue = froMoRef.toXmlString();
        logger.traceGeneral(THIS_CLASS, "MO ref. value for, " + AueUtil.doubleQuote(attributeName) + " is: " + AueUtil.doubleQuote(moRefValue));
        return moRefValue;
    }

    private String handleArrayAttribute(TableHandler tableHandler, String attributeName, Object[] attributeValue) throws CrbsAueException {
        FroArray froArray = new FroArray(tableHandler);
        String arrayValue = froArray.convertObjectArrayToXml(attributeName, attributeValue);
        logger.traceGeneral(THIS_CLASS, "Array value for, " + AueUtil.doubleQuote(attributeName) + " is: " + AueUtil.doubleQuote(arrayValue));
        return arrayValue;
    }

    private String handleStringAttribute(String attributeName, String attributeValue) {
        logger.traceGeneral(THIS_CLASS, "String value for, \"" + attributeName + "\" is: " + attributeValue);
        return attributeValue;
    }

    private String handleIntegerAttribute(String attributeName, Integer attributeValue) {
        logger.traceGeneral(THIS_CLASS, "Integer value for, \"" + attributeName + "\" is: " + attributeValue);
        return attributeValue.toString();
    }

    private String handleStructAttribute(TableHandler tableHandler, String attributeName, Struct attributeValue) throws CrbsAueException {
        FroStruct froStruct = new FroStruct(tableHandler);
        froStruct.convertStructToXml(attributeName, attributeValue);
        String structValue = froStruct.toXmlString();
        logger.traceGeneral(THIS_CLASS, "Struct value for, " + AueUtil.doubleQuote(attributeName) + " is: " + AueUtil.doubleQuote(structValue));
        return structValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AttributeHolder {
        public String defaultValue = null;
        public String momType = null;
        public String attributeValue = null;

        public AttributeHolder(String momType, String attributeValue) {
            this.momType = momType;
            this.attributeValue = attributeValue;
            this.defaultValue = momType.equalsIgnoreCase("S32") || momType.equalsIgnoreCase("U32") ? "0" : "";
        }
    }
}

