/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.sequencer;

import com.polyhedra.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.CollectorHandler;
import se.ericsson.cello.aueframework.collector.DataCollectorMopplet;
import se.ericsson.cello.aueframework.collector.WriteableCollectorContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandlerImpl;
import se.ericsson.crbs.omf.aue.step1.common.RbsDataCollector;
import se.ericsson.crbs.omf.aue.step1.common.UpgradeTriggers;
import se.ericsson.crbs.omf.aue.step1.sequencer.RbsAueStep1Sequencer;
import se.ericsson.crbs.omf.aue.step1.sequencer.RbsAueStep1SequencerFactoryImpl;

public class RbsAueStep1SequencerImpl
extends DataCollectorMopplet
implements RbsAueStep1Sequencer,
CollectorHandler {
    private static final Class THIS_CLASS = RbsAueStep1SequencerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private static final String COLLECTOR_NAME_PREFIX = "RbsAueStep1Sequencer";
    private final List tablesToUpdate;
    private final SortedSet participants;

    public RbsAueStep1SequencerImpl() {
        logger.traceEnter(THIS_CLASS, "RbsAueStep1SequencerImpl()");
        this.participants = new TreeSet();
        this.tablesToUpdate = new ArrayList();
        RbsAueStep1SequencerFactoryImpl.getInstance().setRbsAueStep1Sequencer(this);
        logger.traceReturn(THIS_CLASS, "RbsAueStep1SequencerImpl()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String converterName, RbsDataCollector rbsDataCollector, Integer[] wantedSequenceNumbers, String[] inputTablesToUpdate) {
        StringBuffer message = new StringBuffer("Step1 participant " + converterName + " has successfully subscribed for upgrade with triggers: ");
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            for (int index = 0; index < wantedSequenceNumbers.length; ++index) {
                message.append(wantedSequenceNumbers[index]).append(',');
                this.participants.add(new Participant(converterName, rbsDataCollector, wantedSequenceNumbers[index]));
            }
        }
        this.tablesToUpdate.addAll(Arrays.asList(inputTablesToUpdate));
        message.deleteCharAt(message.length() - 1).append('.');
        logger.traceDebug(THIS_CLASS, message.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(CollectorContext collectorContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "collect()");
        if (collectorContext.getCurrentTrigger().toString().equals("CONVERT")) {
            logger.traceGeneral(THIS_CLASS, "The current trigger is: " + collectorContext.getCurrentTrigger() + " and the collector graph will be traversed.");
            collectorContext.setAttribute("BEFORE_REBOOT_KEY", (Object)Boolean.TRUE);
            Participant currentParticipant = null;
            logger.traceDebug(THIS_CLASS, "Number or Participators: " + this.participants.size());
            Class clazz = THIS_CLASS;
            synchronized (clazz) {
                if (!this.participants.isEmpty()) {
                    Iterator participantsIterator = this.participants.iterator();
                    while (participantsIterator.hasNext()) {
                        currentParticipant = (Participant)participantsIterator.next();
                        if (!this.matchTriggers(currentParticipant.getTriggers(), "CONVERT".toString())) continue;
                        logger.traceDebug(THIS_CLASS, "Calling participant: " + currentParticipant.participantConverterName + " with sequence number:  " + currentParticipant.participantWantedSequenceNumber);
                        try {
                            currentParticipant.collect(collectorContext);
                        }
                        catch (CrbsAueException crbsAueException) {
                            throw new CrbsAueException("Exception caught executing trigger " + currentParticipant.getWantedSequenceNumber() + " on converter participant " + currentParticipant.getConverterName(), (Throwable)((Object)crbsAueException));
                        }
                    }
                    DbWrapper dbWrapper = null;
                    try {
                        dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
                        dbWrapper.openConnection();
                        this.renameTables(dbWrapper);
                        AueUtil.deleteUpgradeLogFile();
                    }
                    catch (TableDataException tde) {
                        throw new CrbsAueException(tde.getMessage());
                    }
                    catch (SQLException sqle) {
                        throw new CrbsAueException(AueUtil.appendReason("Failed to open databse connection.", sqle), sqle);
                    }
                    finally {
                        try {
                            dbWrapper.closeConnection(1);
                        }
                        catch (Exception ignore) {}
                    }
                }
            }
        }
        collectorContext.setAttribute("BEFORE_REBOOT_KEY", (Object)Boolean.TRUE);
        this.callCollectOnParticipants(collectorContext);
        logger.traceReturn(THIS_CLASS, "collect()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callCollectOnParticipants(CollectorContext collectorContext) throws CrbsAueException {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            if (this.participants != null && !this.participants.isEmpty()) {
                Iterator participantsIterator = this.participants.iterator();
                while (participantsIterator.hasNext()) {
                    Participant currentParticipant = (Participant)participantsIterator.next();
                    if (!this.matchTriggers(currentParticipant.getTriggers(), collectorContext.getCurrentTrigger().toString())) continue;
                    logger.traceDebug(THIS_CLASS, "Calling participant: " + currentParticipant.participantConverterName + " with sequence number:  " + currentParticipant.participantWantedSequenceNumber + " on trigger: " + collectorContext.getCurrentTrigger().toString());
                    try {
                        currentParticipant.collect(collectorContext);
                    }
                    catch (CrbsAueException crbsAueException) {
                        throw new CrbsAueException("Exception caught executing trigger " + currentParticipant.getWantedSequenceNumber() + " on participant " + currentParticipant.getConverterName(), (Throwable)((Object)crbsAueException));
                    }
                }
            }
        }
    }

    private boolean matchTriggers(String[] triggers, String trigger) {
        boolean isMatched = false;
        if (triggers != null && trigger != null) {
            for (int i = 0; i < triggers.length; ++i) {
                if (!triggers[i].equals(trigger)) continue;
                isMatched = true;
                break;
            }
        }
        return isMatched;
    }

    private void renameTables(DbWrapper dbWrapper) throws TableDataException {
        String suffix = "_new".toLowerCase(Locale.getDefault());
        Iterator iterator = this.tablesToUpdate.iterator();
        while (iterator.hasNext()) {
            String correctTableName = (String)iterator.next();
            String temporaryTableName = correctTableName + suffix;
            TableHandlerImpl.replaceTable(correctTableName, temporaryTableName, dbWrapper);
        }
    }

    public CollectorHandler getCollectorHandler(WriteableCollectorContext notUsed) {
        logger.traceEnter(THIS_CLASS, "getCollectorHandler()");
        logger.traceEnter(THIS_CLASS, "getCollectorHandler()");
        return this;
    }

    public String getCollectorNamePrefix() {
        return COLLECTOR_NAME_PREFIX;
    }

    private class Participant
    implements Comparable {
        private final RbsDataCollector participantRbsDataCollector;
        private final Integer participantWantedSequenceNumber;
        private final String participantConverterName;

        protected Participant(String converterName, RbsDataCollector rbsDataCollector, Integer wantedSequenceNumber) {
            this.participantConverterName = converterName;
            this.participantRbsDataCollector = rbsDataCollector;
            this.participantWantedSequenceNumber = wantedSequenceNumber;
        }

        protected String[] getTriggers() {
            String[] stringArray;
            if (this.participantRbsDataCollector instanceof UpgradeTriggers) {
                stringArray = ((UpgradeTriggers)((Object)this.participantRbsDataCollector)).getTriggers();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "CONVERT".toString();
            }
            return stringArray;
        }

        protected void collect(CollectorContext context) throws CrbsAueException {
            this.participantRbsDataCollector.collect(context, this.participantWantedSequenceNumber);
        }

        protected String getConverterName() {
            return this.participantConverterName;
        }

        protected Integer getWantedSequenceNumber() {
            return this.participantWantedSequenceNumber;
        }

        public int compareTo(Object otherObj) {
            int result;
            if (otherObj instanceof Participant) {
                Participant otherParticipant = (Participant)otherObj;
                Integer secondWantedSequenceNumber = otherParticipant.getWantedSequenceNumber();
                int comparedSequenceNumber = this.participantWantedSequenceNumber.compareTo(secondWantedSequenceNumber);
                if (comparedSequenceNumber == 0) {
                    String secondName = otherParticipant.getConverterName();
                    result = this.participantConverterName.compareTo(secondName);
                } else {
                    result = comparedSequenceNumber;
                }
            } else {
                result = -1;
            }
            return result;
        }
    }
}

