/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.maofro.proxy;

import enea.ose.io.SignalInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericException;
import se.ericsson.cello.maofro.proxy.MaoFroGenericSignalReader;
import se.ericsson.cello.maofro.proxy.ParameterSizeCounter;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.maofro.proxy.TagNameDictionaryException;
import se.ericsson.cello.support.debug.MessageLog;

public class ParameterReceiver {
    private byte[] bytes = null;

    public void receiveParameters(SignalInputStream signalInputStream) throws IOException, MaoFroGenericException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (signalInputStream.available() > 0) {
            byteArrayOutputStream.write(signalInputStream.read());
        }
        this.bytes = byteArrayOutputStream.toByteArray();
    }

    public Map decodeParameters(TagNameDictionary tagNameDictionary) throws TagNameDictionaryException, IllegalParameterValueException {
        HashMap<String, Parameter> hashMap = new HashMap<String, Parameter>();
        try {
            SignalInputStream signalInputStream = new SignalInputStream((InputStream)new ByteArrayInputStream(this.bytes));
            MaoFroGenericSignalReader maoFroGenericSignalReader = new MaoFroGenericSignalReader(tagNameDictionary);
            ParameterSizeCounter parameterSizeCounter = new ParameterSizeCounter();
            long l = signalInputStream.readU32();
            Parameter parameter = null;
            for (long i = 0L; i < l; i += (long)parameterSizeCounter.getStructCount()) {
                parameter = maoFroGenericSignalReader.readParameter(signalInputStream);
                hashMap.put(parameter.getName(), parameter);
                parameterSizeCounter.reset();
                parameter.accept(parameterSizeCounter);
            }
        }
        catch (TagNameDictionaryException tagNameDictionaryException) {
            throw tagNameDictionaryException;
        }
        catch (IllegalParameterValueException illegalParameterValueException) {
            MessageLog.traceError(this.getClass(), (String)"Unable to read parameter from signal stream", (Throwable)((Object)illegalParameterValueException));
            throw illegalParameterValueException;
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)"Unable to read parameters from internal buffer", (Throwable)exception);
        }
        return hashMap;
    }
}

