/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.units;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.Command;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.ExitCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.FanCountCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.FanTempCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.TeLogReadCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.colicommands.ViiCommand;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.units.AuxiliaryUnitHandler;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coliHandler.units.DeviceBoardHandler;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Utils;

public class AuxiliaryUnit
implements AuxiliaryUnitHandler {
    private static final String fanRDN = "FanDeviceGroup";
    private static final String subrackRDN = "Subrack=";
    private static final String[] logicalFan = new String[]{"0", "1", "2"};
    private String ldn;
    private String auxLdn;
    private String serialNo;
    private String auServer;
    private String atfProcess;
    private DeviceBoardHandler atfBoard;
    private List logCommandNameList = new ArrayList();
    private String coliSerialNo;
    private String[] commands;
    final Map commandMap = new HashMap();
    private Command[] allCommands;
    private String unitType;
    private String subrackId;
    private String subrackLDN;

    public AuxiliaryUnit(String string) {
        this(string, new ArrayList());
    }

    public AuxiliaryUnit(String string, List list) {
        this.logCommandNameList = list;
        this.ldn = string;
        this.calculateAuxLdn();
        this.calculateType();
        this.subrackId = this.calculateSubrackId();
        this.subrackLDN = this.calculateSubrackLDN();
        this.prepareAllColiCommands();
    }

    private void calculateAuxLdn() {
        int n = this.ldn.lastIndexOf(",");
        this.auxLdn = this.ldn.substring(0, n) + ";";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getCommands() {
        AuxiliaryUnit auxiliaryUnit = this;
        synchronized (auxiliaryUnit) {
            return this.commands;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Command[] getAllCommands() {
        AuxiliaryUnit auxiliaryUnit = this;
        synchronized (auxiliaryUnit) {
            return this.allCommands;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getCommandTable() {
        AuxiliaryUnit auxiliaryUnit = this;
        synchronized (auxiliaryUnit) {
            return this.commandMap;
        }
    }

    @Override
    public String getLdn() {
        return this.ldn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAuxLdn() {
        AuxiliaryUnit auxiliaryUnit = this;
        synchronized (auxiliaryUnit) {
            return this.auxLdn;
        }
    }

    @Override
    public String getSubrackId() {
        return this.subrackId;
    }

    @Override
    public String getSubrackLDN() {
        return this.subrackLDN;
    }

    @Override
    public void setAtfProcess(String string) {
        this.atfProcess = string;
    }

    @Override
    public String getAtfProcess() {
        return this.atfProcess;
    }

    @Override
    public void setAtfBoard(DeviceBoardHandler deviceBoardHandler) {
        this.atfBoard = deviceBoardHandler;
    }

    @Override
    public DeviceBoardHandler getAtfBoard() {
        return this.atfBoard;
    }

    @Override
    public void setAuServer(String string) {
        this.auServer = string;
    }

    @Override
    public String getAuServer() {
        return this.auServer;
    }

    @Override
    public void setNodeStoredSerialNo(String string) {
        this.serialNo = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNodeStoredSerialNo() {
        AuxiliaryUnit auxiliaryUnit = this;
        synchronized (auxiliaryUnit) {
            return this.serialNo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setColiFetchedSerialNo(String string) {
        AuxiliaryUnit auxiliaryUnit = this;
        synchronized (auxiliaryUnit) {
            this.coliSerialNo = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColiFetchedSerialNo() {
        AuxiliaryUnit auxiliaryUnit = this;
        synchronized (auxiliaryUnit) {
            return this.coliSerialNo;
        }
    }

    private void calculateType() {
        String string;
        int n = this.ldn.lastIndexOf(",");
        int n2 = this.ldn.lastIndexOf("=");
        this.unitType = string = this.ldn.substring(n + 1, n2);
    }

    @Override
    public String getType() {
        return this.unitType;
    }

    private String calculateSubrackId() {
        int n = this.ldn.indexOf(subrackRDN);
        if (n == -1) {
            return null;
        }
        String string = this.ldn.substring(n);
        int n2 = string.indexOf(",");
        int n3 = string.indexOf("=");
        String string2 = string.substring(n3 + 1, n2);
        return string2;
    }

    private String calculateSubrackLDN() {
        int n = this.ldn.indexOf(subrackRDN);
        if (n == -1) {
            return null;
        }
        String string = this.ldn.substring(n);
        int n2 = string.indexOf(",");
        String string2 = this.ldn.substring(0, n + n2) + ";";
        return string2;
    }

    private void prepareAllColiCommands() {
        List list = this.buildCommandList();
        this.buildCommandMap(list);
        this.buildCommandArray(list);
        this.buildCommandNameArray(list);
    }

    private List buildCommandList() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.logCommandNameList.isEmpty()) {
            object = new ViiCommand(Utils.UNIT_TYPE[1], this.ldn);
            arrayList.add(object);
            int n = this.ldn.lastIndexOf(",");
            String string = this.ldn.substring(n + 1);
            int n2 = string.indexOf("=");
            string = string.substring(0, n2);
            FanTempCommand fanTempCommand = null;
            FanCountCommand fanCountCommand = null;
            if (string.equalsIgnoreCase(fanRDN)) {
                fanTempCommand = new FanTempCommand(this.ldn);
                arrayList.add(fanTempCommand);
                for (int i = 0; i < logicalFan.length; ++i) {
                    fanCountCommand = new FanCountCommand(logicalFan[i], this.ldn);
                    arrayList.add(fanCountCommand);
                }
            }
        } else {
            for (String string : this.logCommandNameList) {
                if (!string.equals(Utils.LOG_COMMANDS[1])) continue;
                TeLogReadCommand teLogReadCommand = new TeLogReadCommand(this.ldn);
                arrayList.add(teLogReadCommand);
            }
        }
        object = new ExitCommand(this.ldn);
        arrayList.add(object);
        return arrayList;
    }

    private void buildCommandMap(List list) {
        for (Command command : list) {
            if (command instanceof FanCountCommand) {
                this.commandMap.put(command.getCommand(), command);
                continue;
            }
            if (command instanceof TeLogReadCommand) {
                this.commandMap.put(command.getCommand(), command);
                continue;
            }
            this.commandMap.put(command.getCommandType(), command);
        }
    }

    private void buildCommandArray(List list) {
        Object[] objectArray = list.toArray();
        this.allCommands = new Command[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this.allCommands[i] = (Command)objectArray[i];
        }
    }

    private void buildCommandNameArray(List list) {
        this.commands = new String[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Command command = (Command)iterator.next();
            this.commands[n] = command instanceof FanCountCommand ? command.getCommand() : command.getCommandType();
            ++n;
        }
    }
}

