/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import javax.swing.SwingUtilities;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;

public class AdminStateHelper
extends Thread {
    private static final int MAX_CHECKS = 5;
    private static final int SLEEP_TIME = 2000;
    final Mo mo;
    final int state;
    final Operable operable;

    public AdminStateHelper(Mo mo, int n, Operable operable) {
        this.mo = mo;
        this.state = n;
        this.operable = operable;
    }

    @Override
    public void run() {
        this.waitForStateChange();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AdminStateHelper.this.operable.forcedRefresh();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void waitForStateChange() {
        NameValue nameValue = null;
        for (int i = 0; i < 5; ++i) {
            try {
                nameValue = this.mo.getAttribute("administrativeState", null);
                if (nameValue.getIntValue() != this.state) {
                    Trace.observation(this, "Finished waiting for admin state: " + this.mo.getLdn());
                    break;
                }
                Trace.observation(this, "Waiting for admin state to change: " + this.mo.getLdn());
                Thread.sleep(2000L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

