/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.security.launcher.download.DownloadException;
import se.ericsson.security.launcher.download.DownloadListener;
import se.ericsson.security.launcher.download.DownloadManager;
import se.ericsson.security.launcher.download.StubbedDownloadListener;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coli.ColiCongestionException;
import se.ericsson.wcdma.rbs.cabinetviewer.com.io.ftp.FtpFactory;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Utils;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.CabinetViewerAction;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.DisplayLogs;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.FileChooser;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.LogListener;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.log.ProgressDialog;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.log.availability.AvailabilityLogFetcher;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.log.availability.AvailabilityLogListener;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.log.availability.LogFetchEvent;
import se.ericsson.wcdma.rbs.cabinetviewer.session.CvSession;

public class SaveLogs
extends CabinetViewerAction
implements LogListener,
AvailabilityLogListener {
    private static final String ACTION_DISPLAY_NAME_SAVE_LOGS = "Save logs";
    private static final String ALARM_FILE_IN_RBS = "logfiles/alarm_log.xml";
    private static final String ALARM_FILE_IN_VOB = "file:" + Utils.BLOCK_ROOT + "/cabinetViewerBl/applicationSwu/tools/stubsrc/launcher/src/cabvstub/logs/1-RBS-alarm-log.xml";
    private static final String EVENT_FILE_IN_RBS = "logfiles/event_log.xml";
    private static final String EVENT_FILE_IN_VOB = "file:" + Utils.BLOCK_ROOT + "/cabinetViewerBl/applicationSwu/tools/stubsrc/launcher/src/cabvstub/logs/1-RBS-event-log.xml";
    private static final String AVAILABILITY_LOG = "CELLO_AVAILABILITY2_LOG.xml";
    protected Mo mo = null;
    protected String ldn = null;
    final FileChooser fileChooser;
    protected JCheckBox traceAndErrorCheckBox = null;
    protected JCheckBox postMortemCheckBox = null;
    protected JCheckBox alarmCheckBox = null;
    protected JCheckBox eventCheckBox = null;
    protected JCheckBox availabilityCheckBox = null;
    private boolean isTraceAndErrorLogRequested = false;
    final DisplayLogs displayLogs;
    static final String HEADER_SAVE_POST_MORTEM_LOG = "Save post mortem log";
    static final String DEFAULT_SUFFIX_POST_MORTEM_LOG = "-post-mortem-log.txt";
    static final String HEADER_SAVE_TRACE_AND_ERROR_LOG = "Save trace & error log";
    static final String DEFAULT_SUFFIX_SAVE_TRACE_AND_ERROR_LOG = "-trace-and-error-log.txt";
    static final String HEADER_SAVE_RESTART_LOG = "Save restart log";
    static final String DEFAULT_SUFFIX_RESTART_LOG = "-restart-log.txt";
    static final String HEADER_SAVE_ALARM_LOG = "Save alarm log";
    static final String DEFAULT_SUFFIX_ALARM_LOG = "-alarm-log.xml";
    static final String HEADER_SAVE_EVENT_LOG = "Save event log";
    static final String DEFAULT_SUFFIX_EVENT_LOG = "-event-log.xml";
    static final Integer HTTPS = 1;
    private AvailabilityLogFetcher fetcher;
    private ProgressDialog progressDialog;

    public SaveLogs(FileChooser fileChooser) {
        super(ACTION_DISPLAY_NAME_SAVE_LOGS, "");
        this.fileChooser = fileChooser;
        this.displayLogs = new DisplayLogs(this);
    }

    public SaveLogs(FileChooser fileChooser, CvSession cvSession) {
        super(ACTION_DISPLAY_NAME_SAVE_LOGS, "");
        this.fileChooser = fileChooser;
        this.displayLogs = new DisplayLogs(this, cvSession);
    }

    @Override
    public void setOperable(Operable operable) {
        super.setOperable(operable);
        this.ldn = operable.getTargetMoLdnForSaveLogs();
        if (this.ldn != null) {
            this.mo = this.cmService.getMo(this.ldn);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.displayGui(ACTION_DISPLAY_NAME_SAVE_LOGS);
    }

    @Override
    protected void addOptions(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.traceAndErrorCheckBox = new JCheckBox("Trace & error log");
        this.postMortemCheckBox = new JCheckBox("Post mortem log");
        this.alarmCheckBox = new JCheckBox("Alarm log");
        this.eventCheckBox = new JCheckBox("Event log");
        this.availabilityCheckBox = new JCheckBox("Availability log");
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.traceAndErrorCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.alarmCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.eventCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)this.availabilityCheckBox, gridBagConstraints);
        this.disableUnsupportedCheckboxes();
    }

    @Override
    protected String getText() {
        return "Please choose the log(s) you wish to save!";
    }

    @Override
    protected void performTheAction() {
        if (this.alarmCheckBox.isSelected()) {
            this.obtainHttpLog(ALARM_FILE_IN_RBS, ALARM_FILE_IN_VOB, DEFAULT_SUFFIX_ALARM_LOG);
        }
        if (this.eventCheckBox.isSelected()) {
            this.obtainHttpLog(EVENT_FILE_IN_RBS, EVENT_FILE_IN_VOB, DEFAULT_SUFFIX_EVENT_LOG);
        }
        this.isTraceAndErrorLogRequested = this.traceAndErrorCheckBox.isSelected();
        try {
            if (this.isTraceAndErrorLogRequested) {
                this.obtainBoardLogs(this.isTraceAndErrorLogRequested);
            }
        }
        catch (Exception exception) {
            String string = "The following logs could not be fetched...";
            if (this.isTraceAndErrorLogRequested) {
                string = string + "\n  Trace and Error log";
            }
            string = string + "\n\nReason:";
            string = string + "\n  " + exception.getMessage();
            this.getOperable().getCvSession().getCvSessionController().showErrorDialog(string, exception);
        }
        if (this.postMortemCheckBox.isSelected()) {
            this.obtainPostMortemLog();
        }
        if (this.availabilityCheckBox.isSelected()) {
            this.obtainAvailabilityLog();
        }
    }

    private void obtainPostMortemLog() {
        this.getOperable().obtainPostMortemLog(this.getLdn(), this);
    }

    private void obtainBoardLogs(boolean bl) throws Exception {
        this.getOperable().obtainBoardLogs(bl, false, this);
    }

    private void obtainHttpLog(String string, String string2, String string3) {
        try {
            URL uRL = null;
            uRL = this.useStubForTest() ? new URL(string2) : new URL(this.getUrl(string));
            String string4 = this.getFileContentsFromNode(uRL);
            this.displayLogs.displayLog(this.getAlteredViewableObjectName(this.getOperable()) + string3, string4);
        }
        catch (MalformedURLException malformedURLException) {
            Trace.error(this, "Wrong URL format ", malformedURLException);
        }
    }

    private void obtainAvailabilityLog() {
        FtpFactory ftpFactory = this.operable.getCvSession().getFtpFactory();
        String string = this.operable.getCvSession().getNealManager().getIpAddress();
        this.fetcher = new AvailabilityLogFetcher(ftpFactory);
        this.fetcher.addListener(this);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SaveLogs.this.fetcher != null) {
                    SaveLogs.this.fetcher.removeListeners();
                    SaveLogs.this.fetcher.interrupt();
                }
                if (SaveLogs.this.progressDialog != null) {
                    SaveLogs.this.progressDialog.setVisible(false);
                    SaveLogs.this.progressDialog = null;
                }
            }
        };
        this.progressDialog = new ProgressDialog((Frame)this.operable.getCvSession().getCvSessionController().getMainWindofFrame(), "Fetching availability log", actionListener);
        this.progressDialog.setVisible(true);
        this.fetcher.start();
    }

    @Override
    public void availabilityLogFetchComplete(final LogFetchEvent logFetchEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SaveLogs.this.progressDialog != null) {
                    SaveLogs.this.progressDialog.setVisible(false);
                    SaveLogs.this.progressDialog = null;
                }
                SaveLogs.this.fetcher = null;
                if (logFetchEvent.wasSuccessful()) {
                    SaveLogs.this.displayLogs.displayLog(SaveLogs.AVAILABILITY_LOG, logFetchEvent.getLog());
                } else {
                    SaveLogs.this.showError(logFetchEvent.getErrorMessage(), logFetchEvent.getException());
                }
            }
        });
    }

    private boolean useStubForTest() {
        String string = System.getProperty("use_cabv_stub");
        return string != null && string.equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveTheLog(String string, String string2) {
        SaveLogs saveLogs = this;
        synchronized (saveLogs) {
            String string3 = this.getDialogTitleFromNameSuffix(string2);
            this.fileChooser.setContents(string);
            this.fileChooser.showSaveDialog(string3, string2);
            Trace.observation(this, "Save logs: " + this.operable.getViewableObjectName());
        }
    }

    private String getDialogTitleFromNameSuffix(String string) {
        String string2 = "";
        if (string.endsWith(DEFAULT_SUFFIX_POST_MORTEM_LOG)) {
            string2 = HEADER_SAVE_POST_MORTEM_LOG;
        } else if (string.endsWith(DEFAULT_SUFFIX_SAVE_TRACE_AND_ERROR_LOG)) {
            string2 = HEADER_SAVE_TRACE_AND_ERROR_LOG;
        } else if (string.endsWith(DEFAULT_SUFFIX_RESTART_LOG)) {
            string2 = HEADER_SAVE_RESTART_LOG;
        } else if (string.endsWith(DEFAULT_SUFFIX_ALARM_LOG)) {
            string2 = HEADER_SAVE_ALARM_LOG;
        } else if (string.endsWith(DEFAULT_SUFFIX_EVENT_LOG)) {
            string2 = HEADER_SAVE_EVENT_LOG;
        }
        return string2;
    }

    protected String getLdn() {
        return this.ldn;
    }

    protected Mo getMo() {
        return this.mo;
    }

    private void disableUnsupportedCheckboxes() {
        if (!this.supportsSavingTraceAndErrorLog()) {
            this.traceAndErrorCheckBox.setEnabled(false);
        }
        if (!this.supportsSavingNodeLogs()) {
            this.postMortemCheckBox.setEnabled(false);
            this.alarmCheckBox.setEnabled(false);
            this.eventCheckBox.setEnabled(false);
            this.availabilityCheckBox.setEnabled(false);
        }
    }

    private boolean supportsSavingNodeLogs() {
        return this.getOperable().supportsSavingPostMortemLog();
    }

    private boolean supportsSavingTraceAndErrorLog() {
        return this.getOperable().supportsSavingTraceAndErrorLog();
    }

    private String getFileContentsFromNode(URL uRL) {
        String string = "";
        try {
            string = new DownloadManager().downloadToString(uRL, (DownloadListener)new StubbedDownloadListener());
        }
        catch (DownloadException downloadException) {
            Trace.error(this, "Unable to download file " + uRL.toString(), downloadException);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            Trace.error(this, "SocketTimeoutException when open file " + uRL.toString(), socketTimeoutException);
        }
        catch (IOException iOException) {
            Trace.error(this, "Unable to open file " + uRL.toString(), iOException);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContents(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string2 = System.getProperty("line.separator", "\n");
            do {
                if ((string = bufferedReader.readLine()) == null) continue;
                stringBuffer.append(string + string2);
            } while (string != null);
        }
        catch (IOException iOException) {
            Trace.warning(null, "Unable to read file", iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    Trace.warning(null, "Unable to close file", iOException);
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getUrl(String string) {
        Object object;
        Mo mo;
        String string2 = "http://";
        String string3 = ":80";
        String string4 = this.getOperable().getCvSession().getIpAddress();
        if (string4.contains(":")) {
            string4 = string4.substring(0, string4.indexOf(":"));
        }
        if ((mo = this.getOperable().getCvSession().getNealManager().getNode().getCmService().getMo("ManagedElement=1,SystemFunctions=1,Security=1")) != null) {
            object = mo.getAttribute("webServer", null);
            if (object == null) {
                Trace.error(this, "Cannot get attribute webServe from MO Security.");
            } else {
                Integer n = object.getIntValue();
                if (n != null && n.equals(HTTPS)) {
                    string2 = "https://";
                    string3 = ":443";
                }
                Trace.observation(this, "Get attribute webServe from CachedMO Security, now this attribute is:" + n);
            }
        } else {
            Trace.warning(this, "Get MO Security, securityList is null");
        }
        object = new StringBuffer();
        ((StringBuffer)object).append(string2);
        ((StringBuffer)object).append(string4);
        ((StringBuffer)object).append(string3);
        ((StringBuffer)object).append("/");
        ((StringBuffer)object).append(string);
        Trace.warning(this, "GetUrl:" + ((StringBuffer)object).toString());
        return ((StringBuffer)object).toString();
    }

    @Override
    public void postMortemLogObtained(String string) {
        try {
            URL uRL = new URL(this.getUrl(string));
            String string2 = this.getFileContentsFromNode(uRL);
            this.saveTheLog(string2, this.getAlteredViewableObjectName(this.getOperable()) + DEFAULT_SUFFIX_POST_MORTEM_LOG);
        }
        catch (MalformedURLException malformedURLException) {
            Trace.error(this, "Mal formed URL", malformedURLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void boardLogsObtained(Operable operable) {
        SaveLogs saveLogs = this;
        synchronized (saveLogs) {
            String string = operable.getTraceAndErrorLog();
            if (string != null && this.isTraceAndErrorLogRequested) {
                if (string.indexOf("The Trace & Error Log is already being read") != -1) {
                    JOptionPane.showMessageDialog(this.fileChooser, "The Rbs node is busy processing \nan other Trace & Error Log request.\n\nPlease try again in a few moments!", "Save Logs", 0);
                } else {
                    this.displayLogs.displayLog(this.getAlteredViewableObjectName(operable) + DEFAULT_SUFFIX_SAVE_TRACE_AND_ERROR_LOG, string);
                }
            }
        }
    }

    @Override
    public void boardLogsFailed(Exception exception) {
        if (this.isTraceAndErrorLogRequested) {
            String string = null;
            string = exception instanceof ColiCongestionException ? "The Rbs node is busy processing other CLI requests.\nPlease try again in a few moments!" : "Unable to read the Trace & Error log from the RBS node.";
            this.showErrorFromThread(string, exception);
        }
    }

    private String getAlteredViewableObjectName(Operable operable) {
        String string = operable.getViewableObjectName();
        string = string.replace(':', '-');
        return string;
    }
}

