/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer;

import java.util.List;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CacheManager;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.MoMatchedData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.MoRelationship;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.ViewableObject;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoTemplate;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.AbstractSectorViewerManager;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.SectorBranchData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.SectorViewerModelLte;

public class SectorViewerManagerLte
extends AbstractSectorViewerManager {
    public SectorViewerManagerLte(CacheManager cacheManager, List<CachedMo> list, String[] stringArray) {
        super(cacheManager, list, SectorBranchData.RADIO_STANDARD.LTE, stringArray);
        this.setInitialData();
    }

    @Override
    protected void setInitialData() {
        this.model = new SectorViewerModelLte(this.getSectorNames(), this.getBranchNames(), SectorBranchData.RADIO_STANDARD.LTE);
    }

    @Override
    public void doMatching(List<VoTemplate> list, List<ViewableObject> list2) {
        for (CachedMo cachedMo : this.listOfsectorMo) {
            String string = cachedMo.getName();
            for (VoTemplate voTemplate : list) {
                MoRelationship moRelationship = voTemplate.getMoRelationShip();
                MoMatchedData moMatchedData = moRelationship.getMoMatchedData(cachedMo);
                if (moMatchedData.isEmpty()) continue;
                this.model.addCachedMosWithProperties(string, this.branchNames[0], moMatchedData);
                Trace.observation(this, "SectorViewer did successful match towards XML-file: " + voTemplate.getNameOfXML() + " with sector name: " + string);
            }
        }
        this.model.addVosWithProperties(list2);
        this.traceObservation();
    }
}

