/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.converter;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import se.ericsson.wcdma.rbs.cabinetviewer.common.NameValue;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.mim.CabinetViewerMimModel;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoTemplate;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.converter.Converter;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.converter.DomContainer;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.converter.TemplateConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.AbstractModel;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.ModelException;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.ModelLoadingException;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.equipment.AbstractEquipment;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.equipment.EquipmentElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.equipment.EquipmentXmlSchemaInfo;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.equipment.FallBackVoTemplateElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.equipment.UseTemplateElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.AbstractStatement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.property.PropertyElement;

public class EquipmentConverter
implements Converter,
EquipmentXmlSchemaInfo {
    private EquipmentElement equipment;
    private TemplateConverter templateConverter;
    private DomContainer domTemplates;
    private CabinetViewerMimModel model;
    private List<VoTemplate> templatesToUse = new ArrayList<VoTemplate>();
    private List<VoTemplate> fallbackVoTemplates = new ArrayList<VoTemplate>();

    public EquipmentConverter(CabinetViewerMimModel cabinetViewerMimModel, DomContainer domContainer) {
        this.model = cabinetViewerMimModel;
        this.domTemplates = domContainer;
    }

    protected void setMoTypeForSector() {
        String string = this.equipment.getMoTypeForSector();
        if (string == null) {
            return;
        }
        this.model.setMoTypeForSectors(string);
    }

    protected void addAdditionalAttributes() {
        NameValue[] nameValueArray = this.equipment.getAdditionalAttributes();
        if (nameValueArray == null) {
            return;
        }
        for (NameValue nameValue : nameValueArray) {
            this.model.add(nameValue.getName(), nameValue.getValue().toString());
        }
    }

    @Override
    public void load(Hashtable hashtable, Node node) {
        Object object;
        Object object2;
        Hashtable hashtable2;
        Object object3;
        this.templateConverter = new TemplateConverter(this.model);
        Node node2 = node;
        if (node2 == null || !node2.hasChildNodes()) {
            throw new ModelException("The XML file \"se/ericsson/wcdma/rbs/cabinetviewer/model/Equipment.xml does NOT contain any xml elements. ");
        }
        this.equipment = new EquipmentElement(hashtable, node2);
        this.setMoTypeForSector();
        this.addAdditionalAttributes();
        List<UseTemplateElement> list = this.equipment.getUseTemplates();
        for (UseTemplateElement object42 : list) {
            object3 = object42.getTemplateName();
            hashtable2 = object42.getParams();
            if (object3 == null) {
                this.logNotFoundTemplateWarning("useTemplate", "");
                continue;
            }
            object2 = null;
            object = object42.getProperty();
            if (object != null) {
                object2 = ((AbstractStatement)object).getKeysAndValues();
            }
            this.createVoTemplateToUse(hashtable2, (Hashtable)object2, (String)object3);
        }
        List<FallBackVoTemplateElement> list2 = this.equipment.getFallbackVoTemplates();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object3 = (FallBackVoTemplateElement)iterator.next();
            hashtable2 = ((AbstractModel)object3).getParams();
            object2 = ((FallBackVoTemplateElement)object3).getTemplateToUse();
            if (object2 == null) {
                this.logNotFoundTemplateWarning("fallbackVoTemplate", "");
                continue;
            }
            object = ((UseTemplateElement)object2).getTemplateName();
            Hashtable hashtable3 = ((AbstractModel)object2).getParams();
            if (object == null) {
                this.logNotFoundTemplateWarning("useTemplate", "");
                continue;
            }
            Hashtable hashtable4 = null;
            PropertyElement propertyElement = ((AbstractEquipment)object2).getProperty();
            if (propertyElement != null) {
                hashtable4 = propertyElement.getKeysAndValues();
            }
            this.createFallbackVoTemplate(hashtable2, hashtable3, hashtable4, (String)object);
        }
    }

    @Override
    public void load(Hashtable hashtable, Node node, boolean bl) {
        this.load(hashtable, node);
    }

    protected void logNotFoundTemplateWarning(String string, String string2) {
        Trace.warning(this, "The xml element " + string + " is missing in XML file \"" + "se/ericsson/wcdma/rbs/cabinetviewer/model/Equipment.xml" + string2);
    }

    protected void createVoTemplateToUse(Hashtable hashtable, Hashtable hashtable2, String string) {
        try {
            Document document = this.domTemplates.getDocument(string);
            if (document != null) {
                this.templateConverter.load(hashtable, document);
                VoTemplate voTemplate = null;
                try {
                    voTemplate = this.templateConverter.createVoTemplate(hashtable2);
                    this.templatesToUse.add(voTemplate);
                }
                catch (ModelLoadingException modelLoadingException) {
                    Trace.observation(this, "Template file \"" + string + "\" was NOT loaded. " + modelLoadingException.getMessage());
                }
            } else {
                Trace.warning(this, "Template file \"" + string + "\" is missing.");
            }
        }
        catch (ModelException modelException) {
            Trace.warning(this, "Error when using template file \"" + string + "\". " + modelException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            Trace.warning(this, "Error when using template file \"" + string + "\". " + runtimeException.getMessage(), runtimeException);
        }
    }

    protected void createFallbackVoTemplate(Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3, String string) {
        try {
            Document document = this.domTemplates.getDocument(string);
            if (document != null) {
                this.templateConverter.load(hashtable2, document);
                VoTemplate voTemplate = null;
                try {
                    voTemplate = this.templateConverter.createVoTemplate(hashtable3);
                    Object v = hashtable.get("moType");
                    voTemplate.setMoType(v.toString());
                    this.fallbackVoTemplates.add(voTemplate);
                }
                catch (ModelLoadingException modelLoadingException) {
                    Trace.observation(this, "Template file \"" + string + "\" was NOT loaded. " + modelLoadingException.getMessage());
                }
            } else {
                Trace.warning(this, "Template file \"" + string + "\" is missing.");
            }
        }
        catch (ModelException modelException) {
            Trace.warning(this, "Error when using template file \"" + string + "\". " + modelException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            Trace.warning(this, "Error when using template file \"" + string + "\". " + runtimeException.getMessage(), runtimeException);
        }
    }

    public List<VoTemplate> getVoTemplatesToUse() {
        return this.templatesToUse;
    }

    public List<VoTemplate> getFallbackVoTemplates() {
        return this.fallbackVoTemplates;
    }
}

