/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.FormPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.converters.ChainingValueConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.converters.ValueConverter;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary.AbstractSummary;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary.SourceElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary.SourceGroupElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.util.Helper;

public class FormItemElement
extends AbstractSummary {
    private String label;
    private SourceGroupElement sourceGroup;
    private SourceElement sourceElement;
    private List<String> nameOfConverters = new ArrayList<String>();
    private boolean optional = false;

    public FormItemElement(Node node) {
        super(node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("label")) {
                this.label = Helper.getDataInFirstTextNode(null, node2);
                continue;
            }
            if (string.equals("sourceGroup")) {
                this.sourceGroup = new SourceGroupElement(node2);
                continue;
            }
            if (string.equals("source")) {
                this.sourceElement = new SourceElement(node2);
                continue;
            }
            if (string.equals("converter")) {
                this.nameOfConverters.add(Helper.getDataInFirstTextNode(null, node2));
                continue;
            }
            if (!string.equals("optional")) continue;
            this.optional = true;
        }
    }

    protected void addFormPanelItems(FormPanel formPanel, Hashtable hashtable) {
        ValueConverter valueConverter = null;
        if (this.nameOfConverters.size() == 1) {
            valueConverter = this.findConverter(this.nameOfConverters.get(0), hashtable);
        } else if (this.nameOfConverters.size() > 0) {
            ChainingValueConverter chainingValueConverter = new ChainingValueConverter();
            for (String string : this.nameOfConverters) {
                ValueConverter valueConverter2 = this.findConverter(string, hashtable);
                if (valueConverter2 == null) continue;
                chainingValueConverter.addConverter(valueConverter2);
            }
            valueConverter = chainingValueConverter;
        }
        if (this.sourceGroup != null) {
            this.sourceGroup.addSource(formPanel, valueConverter, this.label, this.optional);
        }
        if (this.sourceElement != null) {
            this.sourceElement.addSource(formPanel, valueConverter, this.label, this.optional);
        }
    }

    private ValueConverter findConverter(String string, Hashtable hashtable) {
        Object v = hashtable.get(string);
        if (v == null || !(v instanceof ValueConverter)) {
            Trace.warning(this, "There is an error in \"Summary.xml\". The Converter \"" + string + "\" is NOT found " + " in xml element <" + "converter" + ">.");
        }
        return (ValueConverter)v;
    }
}

