/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem;

import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.check.ReportEntry;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AbstractAntennaSystemCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AntennaBranchRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AntennaFeederRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AlarmConfigurationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CellAndCarrierListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAntFeederCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAntennaBranch;
import se.ericsson.wcdma.rbs.bem.common.mim.nonautogenerated.MimAntennaBranchDef;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.CableMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class AntennaSystemTmaCI
extends AbstractAntennaSystemCI {
    private static final String _EXT = "_EXT";
    private final MoHandler moHandler;

    public AntennaSystemTmaCI(Rbs rbs, boolean bl) {
        this(rbs, bl, 1);
    }

    public AntennaSystemTmaCI(Rbs rbs, boolean bl, int n) {
        super(rbs, !bl, !bl, false, false, n);
        this.moHandler = rbs.getMoHandler();
    }

    public AntennaSystemTmaCI(Rbs rbs, boolean bl, boolean bl2) {
        super(rbs, bl, bl2, false, false);
        this.moHandler = rbs.getMoHandler();
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            return true;
        }
        super.open();
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            this.createAntennaFeederRI(nArray[i]);
        }
        this.cellCarrP.addCellAndCarrierListener(new SectorInUseListener());
        this.isOpen = true;
        return true;
    }

    public List getRIsToUninstall() throws BemException {
        List list = super.getRIsToUninstall();
        boolean bl = false;
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            CustomerParameterImpl[] customerParameterImplArray;
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            if (this.sectorExist(n) && !this.sectorEquipped(n)) {
                customerParameterImplArray = super.getAntennaFeederRIs(i, true);
                list.addAll(customerParameterImplArray);
            } else if (this.sectorExist(n) && this.sectorEquipped(n)) {
                for (int j = 0; j < this.getLoadedNumOfSectorAntennas(n); ++j) {
                    if (this.antennaTypeParam[i][j] == null) continue;
                    String string = this.antennaTypeParam[i][j].getValue();
                    String string2 = this.antennaTypeParam[i][j].getLoadedValue();
                    if (string2 == null || string == null || string2.equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.cellCarrP.requestUninitiateSector(n, this);
                    this.cellCarrP.requestInitiateSector(n, this);
                    bl = false;
                }
            }
            customerParameterImplArray = (CustomerParameterImpl[])this.cellCarrP.getNumOfRxBranchesPerCarrierParameter(n);
            for (int j = 0; j < customerParameterImplArray.length; ++j) {
                int n2;
                int n3;
                CustomerParameterImpl cfr_ignored_0 = customerParameterImplArray[j];
                if (customerParameterImplArray[j].getLoadedValue().equals("##UNDEFINED") || (n3 = Integer.parseInt(customerParameterImplArray[j].getLoadedValue())) <= (n2 = Integer.parseInt(customerParameterImplArray[j].getValue()))) continue;
                for (int k = n2; k < n3; ++k) {
                    if (this.antennaFeeder[i][k] == null) continue;
                    for (int i2 = 0; i2 < this.antennaFeeder[i][k].length; ++i2) {
                        if (this.antennaFeeder[i][k][i2] == null || list.contains(this.antennaFeeder[i][k][i2])) continue;
                        list.add(this.antennaFeeder[i][k][i2]);
                    }
                }
            }
        }
        return list;
    }

    protected boolean checkConsistency(int n) throws CustomerParameterException {
        if (!super.checkConsistency(n)) {
            return false;
        }
        try {
            if (this.sectorExist(n) && this.sectorEquipped(n)) {
                int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
                for (int i = 0; i < this.getNumOfSectorAntennas(n); ++i) {
                    boolean bl;
                    String string = this.antennaTypeParam[n2][i].getValue();
                    String string2 = this.antennaTypeParam[n2][i].getLoadedValue();
                    if (string2 == null || string == null || string2.equals(string) || (bl = this.cellCarrP.areCellsOffline(n))) continue;
                    return false;
                }
            }
        }
        catch (BemException bemException) {
            throw new CustomerParameterException(bemException.toString(), null);
        }
        return true;
    }

    private void createAntFeederPerBranch(int n, String string, boolean bl) throws BemException {
        Object object;
        AntennaBranchRI antennaBranchRI = null;
        AntennaFeederRI[] antennaFeederRIArray = null;
        MoInstance[] moInstanceArray = null;
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        for (int i = 0; i < AntennaSystemTmaCI.getMaxNumberOfBranches(); ++i) {
            if (!string.equals(AntennaSystemTmaCI.getBranchType(i))) continue;
            antennaBranchRI = this.antennaBranch[n2][i];
            antennaFeederRIArray = this.antennaFeeder[n2][i];
            moInstanceArray = this.antFeederMois[n2][i];
            break;
        }
        if (antennaBranchRI == null && antennaFeederRIArray == null && moInstanceArray == null) {
            throw new BemException("Error in AntennaSystemTmaCI.createAntFeederPerBranch(" + n + ", " + string + ")");
        }
        String string2 = bl ? this.radioEP.getLoadedTerminationObject(n, string) : this.radioEP.getTerminationObject(n, string);
        RadioEquipmentProviderWithRbb radioEquipmentProviderWithRbb = (RadioEquipmentProviderWithRbb)this.rbs.getProvider(RadioEquipmentProviderWithRbb.class, this.getDuwSlotNumbers());
        if (radioEquipmentProviderWithRbb != null && radioEquipmentProviderWithRbb.getRadioSharedBySectorArray() != null && this.isConfigRadioSharedBy(n2, (int[])(object = radioEquipmentProviderWithRbb.getRadioSharedBySectorArray()))) {
            String string3 = null;
            string3 = bl ? this.getLoadedTerminationObject(n, string, (int[])object) : this.getTerminationObject(n, string, (int[])object);
            String string4 = string2 = null == string3 ? string2 : string3;
        }
        if (string2 == null) {
            return;
        }
        BemMo bemMo = this.moHandler.getMo(string2);
        BemMo bemMo2 = this.moHandler.getMo(antennaBranchRI.getLdn());
        object = SectorUtil.getSectorPrefix(n);
        for (int i = 0; i < moInstanceArray.length; ++i) {
            MoInstance moInstance = moInstanceArray[i];
            if (moInstance == null) continue;
            int n3 = bl ? this.radioEP.getLoadedTerminationConnectors(n, string)[i].intValue() : this.radioEP.getTerminationConnectors(n, string)[i].intValue();
            antennaFeederRIArray[i] = new AntennaFeederRI(this.rbs, (String)object, n2, string, bemMo, n3, bemMo2, moInstance.getLdn());
            antennaFeederRIArray[i].setLoadedValues();
        }
    }

    protected void createAntennaFeederRI(int n) throws BemException {
        this.createAntennaFeederRI(n, false);
    }

    protected void createAntennaFeederRI(int n, boolean bl) throws BemException {
        if (this.antennaFeeder == null) {
            this.antennaFeeder = new AntennaFeederRI[this.maxNoOfSectors][AntennaSystemTmaCI.getMaxNumberOfBranches()][2];
        }
        int n2 = bl ? this.getLoadedNumOfSupportedAntennaBranches(n) : this.getNumOfSupportedAntennaBranches(n);
        for (int i = 0; i < n2; ++i) {
            this.createAntFeederPerBranch(n, AntennaSystemTmaCI.getBranchType(i), bl);
        }
    }

    protected String[] getSectorRdns() throws BemException {
        String[] stringArray = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
        try {
            BemMo bemMo = this.moHandler.getMo(this.rbs.getEquipmentMoi().getLdn());
            BemMo[] bemMoArray = this.moHandler.getChildren(bemMo, 1, MimAntFeederCable.MOTYPENAME, "");
            if (bemMoArray.length > 0) {
                block2: for (int i = 0; i < this.maxNoOfSectors; ++i) {
                    int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
                    Integer[] integerArray = this.radioEP.getTerminationConnectors(n, MimAntennaBranchDef.BRANCH_A);
                    Integer n2 = integerArray != null ? integerArray[0] : null;
                    String string = this.radioEP.getTerminationObject(n, MimAntennaBranchDef.BRANCH_A);
                    if (n2 == null || string == null) continue;
                    BemMo bemMo2 = this.moHandler.getMo(string);
                    for (int j = 0; j < bemMoArray.length; ++j) {
                        String string2;
                        BemMo[] bemMoArray2;
                        BemMo bemMo3;
                        String string3;
                        BemMo bemMo4;
                        String string4;
                        BemMo bemMo5;
                        Integer n3 = (Integer)bemMoArray[j].getAttribute("objectAConnector");
                        if (!n3.equals(n2) || !(bemMo5 = (BemMo)bemMoArray[j].getAttribute("connectedToObjectARef")).getDN().equals(bemMo2.getDN()) || !(string4 = (bemMo4 = (BemMo)bemMoArray[j].getAttribute("antennaBranchRef")).getType()).equals(string3 = MimAntennaBranch.MOTYPENAME) || !(bemMo3 = bemMo4.getParent()).isExisting() || !(bemMoArray2 = (BemMo[])bemMo3.getAttribute("reservedBy"))[0].isExisting()) continue;
                        stringArray[n - 1] = string2 = bemMoArray2[0].getId();
                        continue block2;
                    }
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(this.getClass() + " getSectorRdns() ", (Throwable)moHandlerException);
        }
        return stringArray;
    }

    protected void initialiseMoiResources(int n) throws BemException {
        this.initialiseMoiResources(n, false);
    }

    protected void initialiseMoiResources(int n, boolean bl) throws BemException {
        this.retCic.initialiseMoiResources(n, bl);
        int n2 = bl ? this.getLoadedNumOfSupportedAntennaBranches(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber)) : this.getNumOfSupportedAntennaBranches(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber));
        for (int i = 0; i < n2; ++i) {
            this.antFeederMois[n][i] = this.createAntennaFeederMois(n, AntennaSystemTmaCI.getBranchType(i), bl);
        }
    }

    private CableMoi[] createAntennaFeederMois(int n, String string) throws BemException {
        return this.createAntennaFeederMois(n, string, false);
    }

    private CableMoi[] createAntennaFeederMois(int n, String string, boolean bl) throws BemException {
        int n2 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
        Integer[] integerArray = bl ? this.radioEP.getLoadedTerminationConnectors(n2, string) : this.radioEP.getTerminationConnectors(n2, string);
        CableMoi[] cableMoiArray = new CableMoi[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            CharSequence charSequence;
            Object object;
            Integer n3 = integerArray[i];
            Integer n4 = new Integer(0);
            Object[] objectArray = new Object[]{n3, n4};
            String string2 = bl ? this.radioEP.getLoadedTerminationObject(n2, string) : this.radioEP.getTerminationObject(n2, string);
            RadioEquipmentProviderWithRbb radioEquipmentProviderWithRbb = (RadioEquipmentProviderWithRbb)this.rbs.getProvider(class$se$ericsson$wcdma$rbs$bem$common$config$configitem$provider$RadioEquipmentProviderWithRbb == null ? AntennaSystemTmaCI.class$("se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb") : class$se$ericsson$wcdma$rbs$bem$common$config$configitem$provider$RadioEquipmentProviderWithRbb, this.getDuwSlotNumbers());
            if (radioEquipmentProviderWithRbb != null && radioEquipmentProviderWithRbb.getRadioSharedBySectorArray() != null && this.isConfigRadioSharedBy(n, (int[])(object = radioEquipmentProviderWithRbb.getRadioSharedBySectorArray()))) {
                charSequence = null;
                charSequence = bl ? this.getLoadedTerminationObject(n2, string, (int[])object) : this.getTerminationObject(n2, string, (int[])object);
                CharSequence charSequence2 = string2 = null == charSequence ? string2 : charSequence;
            }
            if (string2 == null) {
                return null;
            }
            object = this.moHandler.getMo(string2);
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(String.valueOf(n2)).append(string);
            if (n3 == 20 || n3 == 21) {
                ((StringBuffer)charSequence).append(_EXT);
            }
            cableMoiArray[i] = new CableMoi(MimAntFeederCable.MOTYPENAME, "B", null, null, null, null, "connectedToObjectARef", (BemMo)object, "objectAConnector", objectArray, ((StringBuffer)charSequence).toString());
        }
        return cableMoiArray;
    }

    public ConfigurationCheckReport checkConfiguration(ConfigurationCheckReport configurationCheckReport) throws BemException {
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            String string = this.sectorRdns[nArray[i] - 1];
            String string2 = String.valueOf(nArray[i]);
            int n = SectorUtil.getSectorIndexFromSectorNumber(nArray[i], this.startingSectorNumber);
            int n2 = this.getNumOfSectorAntennas(nArray[i]) * 2;
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < this.antFeederMois[n][j].length; ++k) {
                    String string3;
                    BemMo bemMo;
                    MoInstance moInstance = this.antFeederMois[n][j][k];
                    if (moInstance == null || (bemMo = this.moHandler.getMo(string3 = moInstance.getLdn())).isExisting() || string.equals(string2)) continue;
                    ReportEntry reportEntry = new ReportEntry("Error", "", string, string2, "No antenna feeder cable found for this RDN");
                    configurationCheckReport.addReportEntry(reportEntry);
                }
            }
        }
        return configurationCheckReport;
    }

    protected void updateSectorParameters(int n, boolean bl) throws BemException {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        this.initialiseMoiResources(n2, bl);
        this.createAntennaBranchRI(n, bl);
        this.createAntennaFeederRI(n, bl);
        this.retCic.createRetRI(n);
        this.retCic.setRestriction4RetCP(n);
    }

    protected void createNewSetOfAntFeederCableRis(int n) throws BemException {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (this.sectorEquipped(n)) {
            boolean bl = false;
            for (int i = 0; i < this.getMaxNoOfSectorAntennasPerSector(); ++i) {
                if (this.antennaBranch == null || !this.isNewAntennaBranchRINeeded(n2, this.antennaBranch[n2][i * 2]) || !this.isNewAntennaBranchRINeeded(n2, this.antennaBranch[n2][i * 2 + 1])) continue;
                bl = true;
            }
            if (bl) {
                this.createAntennaFeederRI(n);
            }
        }
    }

    private boolean isNewAntennaBranchRINeeded(int n, AntennaBranchRI antennaBranchRI) {
        return antennaBranchRI != null;
    }

    private String getTerminationObject(int n, String string, int[] nArray) throws BemException {
        int n2;
        String string2 = null;
        if (string.equals("A")) {
            string2 = this.radioEP.getTerminationObject(n, string);
        } else if (string.equals("B") && (n2 = this.getSharedSectorNumber(nArray, n)) != 0) {
            string2 = this.radioEP.getTerminationObject(n2, string);
        }
        return string2;
    }

    private String getLoadedTerminationObject(int n, String string, int[] nArray) throws BemException {
        int n2;
        String string2 = null;
        if (string.equals("A")) {
            string2 = this.radioEP.getLoadedTerminationObject(n, string);
        } else if (string.equals("B") && (n2 = this.getSharedSectorNumber(nArray, n)) != 0) {
            string2 = this.radioEP.getLoadedTerminationObject(n2, string);
        }
        return string2;
    }

    private int getSharedSectorNumber(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            n2 = i + 1;
            break;
        }
        return n2;
    }

    private boolean isConfigRadioSharedBy(int n, int[] nArray) {
        boolean bl = false;
        int n2 = nArray[n];
        if (n2 > 0) {
            bl = true;
        }
        return bl;
    }

    public void updateAntFeederParameters() throws BemException {
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            int n = SectorUtil.getSectorIndexFromSectorNumber(nArray[i], this.startingSectorNumber);
            if (!this.sectorExist(nArray[i])) {
                int n2 = this.getNumOfSupportedAntennaBranches(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber));
                for (int j = 0; j < n2; ++j) {
                    this.antFeederMois[n][j] = this.createAntennaFeederMois(n, AntennaSystemTmaCI.getBranchType(j));
                }
            }
            this.createAntennaFeederRI(nArray[i]);
        }
    }

    public void updateSectorAntennaParameters() throws BemException {
        int[] nArray = this.radioEP.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            int n = SectorUtil.getSectorIndexFromSectorNumber(nArray[i], this.startingSectorNumber);
            this.initAntennaMois(n, false);
            int n2 = this.getNumOfSupportedAntennaBranches(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber));
            for (int j = 0; j < n2; ++j) {
                this.antFeederMois[n][j] = this.createAntennaFeederMois(n, AntennaSystemTmaCI.getBranchType(j));
            }
            this.createSectorAntennaRI(nArray[i], false);
            this.createAntennaBranchRI(nArray[i], false);
            this.createAntennaFeederRI(nArray[i]);
        }
    }

    private class SectorInUseListener
    implements CellAndCarrierListener {
        private SectorInUseListener() {
        }

        public void update(int n) {
            boolean bl = AntennaSystemTmaCI.this.cellCarrP.isSectorInUse(n);
            int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, AntennaSystemTmaCI.this.startingSectorNumber);
            if (bl) {
                AntennaSystemTmaCI.this.sectorUsedRestriction[n2].setAccessLevel(3);
            } else {
                AntennaSystemTmaCI.this.sectorUsedRestriction[n2].setAccessLevel(1);
                try {
                    AlarmConfigurationProvider alarmConfigurationProvider = AntennaSystemTmaCI.this.rbs.getAlarmConfigurationProvider();
                    alarmConfigurationProvider.setConfigureAlarmForRruw(n, false);
                }
                catch (BemException bemException) {
                    Nal.getLog().nalTrace(2, this.getClass(), "Exception when trying to disable RRUW alarmson unused sector " + n + ".\nMessage: " + bemException.getMessage());
                }
            }
        }
    }
}

