/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractCableRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRdiCable;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class RdiCableRI
extends AbstractCableRI {
    private static final String name = "RdiCable";
    private String objectALdn;
    private int objectAConnector;
    private String objectBLdn;
    private String ldn;

    public RdiCableRI(Rbs rbs, String string, int n, String string2, String string3) throws BemException {
        super(rbs, name);
        this.objectALdn = string;
        this.objectAConnector = n;
        this.objectBLdn = string2;
        this.ldn = rbs.getEquipmentMoi().getLdn() + "," + MimRdiCable.MOTYPENAME + "=" + string3;
    }

    public void install(String string) throws BemException {
        if (string.equals("CabinetCableCreationPhase")) {
            this.checkPreConditions(this.rbs);
            this.performInstall(this.rbs);
        }
    }

    private void checkPreConditions(Rbs rbs) throws BemException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        try {
            object = rbs.getMoHandler();
            BemMo bemMo = object.getMo(this.objectALdn);
            BemMo bemMo2 = object.getMo(this.objectBLdn);
            bl = object.isExisting(bemMo);
            bl2 = object.isExisting(bemMo2);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("Could not access node: " + moHandlerException);
        }
        if (!bl || !bl2) {
            object = "B";
            if (!bl) {
                object = "A";
            }
            throw new BemException("Both boards must exist, Object" + (String)object + " does not exist.\n" + "Rdicable: " + this.ldn + " could not be created.\n" + "Object A ldn: " + this.objectALdn + "\n" + "Object B ldn: " + this.objectBLdn);
        }
    }

    private void performInstall(Rbs rbs) throws BemException {
        MoHandler moHandler = rbs.getMoHandler();
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        BemMo bemMo = moHandler.getMo(this.objectALdn);
        nalNameValue = Nal.getFactory().getNameValue("connectedToObjectARef", bemMo);
        vector.add(nalNameValue);
        BemMo bemMo2 = moHandler.getMo(this.objectBLdn);
        nalNameValue = Nal.getFactory().getNameValue("connectedToObjectBRef", bemMo2);
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("objectAConnector", new Integer(this.objectAConnector));
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("alarmStatus", new Integer(0));
        vector.add(nalNameValue);
        this.createMoIfNotExisting(this.ldn, vector);
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("CabinetCableDeletionPhase")) {
            this.deleteMoIfNotExisting(this.ldn);
        }
    }

    public String getDisplayName() {
        return "RdiCable:" + this.ldn;
    }

    public String getLdn() {
        return this.ldn;
    }

    public boolean isInstalled() throws BemException {
        boolean bl = super.isInstalled();
        if (bl) {
            try {
                MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
                BemMo bemMo = moHandlerImpl.getMo(this.ldn);
                BemMo bemMo2 = (BemMo)moHandlerImpl.getAttribute(bemMo, "connectedToObjectARef");
                BemMo bemMo3 = moHandlerImpl.getMo(this.objectALdn);
                boolean bl2 = ((Object)bemMo2).equals(bemMo3);
                BemMo bemMo4 = (BemMo)moHandlerImpl.getAttribute(bemMo, "connectedToObjectBRef");
                BemMo bemMo5 = moHandlerImpl.getMo(this.objectBLdn);
                boolean bl3 = ((Object)bemMo4).equals(bemMo5);
                Integer n = (Integer)moHandlerImpl.getAttribute(bemMo, "objectAConnector");
                boolean bl4 = n == this.objectAConnector;
                bl = bl2 && bl3 && bl4;
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException(moHandlerException.getAction(), moHandlerException.getLdn(), (Throwable)moHandlerException);
            }
        }
        return bl;
    }
}

