/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.AbstractRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.RbsUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimHwGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRiu;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSectorAntenna;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTpaDevice;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTpaDeviceSet;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.LdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.common.util.AntennaSystemUtil;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class SectorAntennaRI
extends AbstractResourceItem {
    public static final String name = "SectorAntenna";
    private static final String[] myInstallationPhases = new String[]{"SectorAntennaSettingsPhase"};
    private final String ldn;
    private final MoInstance riuMoi;
    private int sectorNumber;
    private int antNo;

    public SectorAntennaRI(Rbs rbs, int n, String string, int n2) {
        super(name, rbs, new String[]{"SectorAntennaSettingsPhase"});
        this.ldn = string;
        this.sectorNumber = n;
        this.antNo = n2;
        LdnMoi ldnMoi = new LdnMoi(this.ldn);
        this.riuMoi = new SingleChildMoi(ldnMoi, MimRiu.MOTYPENAME, "1");
    }

    public boolean isInstalled() throws BemException {
        return super.isExisting(this.ldn);
    }

    public void install(String string) throws BemException {
        BemMo bemMo;
        if (super.containsPhase(myInstallationPhases, string) && (bemMo = this.getMo(this.ldn)).isExisting()) {
            Object object;
            CustomerParameter customerParameter;
            String string2 = this.getSectorPrefix();
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string2 + "antennaType" + (this.antNo > 1 ? String.valueOf(this.antNo) : ""));
            Integer n = Integer.valueOf((String)customerParameterServer.getValueMom());
            if (customerParameterServer.hasValueChanged()) {
                this.setAttribute(this.ldn, "antennaType", (Object)n);
            }
            String string3 = MessageFormat.format("SEQ{0}_", new Integer(1));
            String string4 = string2 + string3 + "antennaType" + (this.antNo > 1 ? String.valueOf(this.antNo) : "");
            String string5 = string2 + string3 + "userLabel" + (this.antNo > 1 ? String.valueOf(this.antNo) : "");
            if (this.rbs.isParameterSupported(string4) && (customerParameter = this.rbs.getCustomerParameterObject(string4)).getAccessLevel() != 1 && customerParameter.hasValueChanged() && customerParameter.isValidValue() && !customerParameter.isDefault()) {
                object = Integer.valueOf(customerParameter.getValue());
                this.setAttribute(this.ldn, "antennaType", object);
            }
            if (this.rbs.isParameterSupported(string5) && (customerParameter = this.rbs.getCustomerParameterObject(string5)).hasValueChanged()) {
                this.setAttribute(this.ldn, "userLabel", (Object)customerParameter.getValue());
            }
            if ((customerParameter = this.rbs.getCustomerParameterObject(string2 + "riuInstalled" + (this.antNo > 1 ? String.valueOf(this.antNo) : ""))).getAccessLevel() != 1) {
                if (customerParameter.getValue().equals("YES")) {
                    this.createMoIfNotExisting(this.riuMoi.getLdn());
                } else if (customerParameter.getValue().equals("NO")) {
                    this.deleteMoIfExisting(this.riuMoi.getLdn());
                }
            }
            if (AntennaSystemUtil.isPsiSector(this.rbs, this.sectorNumber)) {
                customerParameterServer = this.rbs.getCustomerParameterServerObject(BemUtil.getCustomerParameterName(string2, "beamDirection", this.antNo));
                object = (String)customerParameterServer.getValueMom();
                if (customerParameterServer.hasValueChanged()) {
                    this.setAttribute(this.ldn, "beamDirection", object);
                }
            } else {
                this.setAttribute(this.ldn, "beamDirection", (Object)MimSectorAntenna.DEFAULT_BEAMDIRECTION);
            }
            this.setTxPowerPersistentLockAndMaxTotalOutputPowerAttributes();
            this.setPositionInfo(bemMo);
        }
    }

    private void setTxPowerPersistentLockAndMaxTotalOutputPowerAttributes() throws BemException {
        CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(this.getSectorPrefix() + "lockSectorOutputPowerLow");
        boolean bl = Boolean.valueOf(customerParameterServer.getLoadedValue());
        if (bl) {
            BemLog.log(2, this.getClass() + "Ignoring the set of attributes: txPowerPersistentLock, maxTotalOutputPower and maxTotalOutputPowerLow!");
            return;
        }
        AbstractRuRI[] abstractRuRIArray = this.getRadioUnits();
        if (abstractRuRIArray != null) {
            String string;
            Iterator iterator;
            Object object;
            int n;
            customerParameterServer = this.rbs.getCustomerParameterServerObject(this.getSectorPrefix() + "sectorOutputPower");
            int n2 = Integer.parseInt((String)customerParameterServer.getValueMom());
            List list = this.getTpaDeviceLDNs(abstractRuRIArray);
            if (customerParameterServer.hasValueChanged()) {
                n = this.computeMaxOutputPowerPerTpa(n2, list.size());
                object = list.iterator();
                while (object.hasNext()) {
                    iterator = (String)object.next();
                    this.setAttribute((String)((Object)iterator), "maxTotalOutputPower", (Object)new Integer(n));
                }
            }
            customerParameterServer = this.rbs.getCustomerParameterServerObject(this.getSectorPrefix() + "sectorOutputPowerLow");
            n = Integer.parseInt((String)customerParameterServer.getValueMom());
            if (customerParameterServer.hasValueChanged()) {
                int n3 = this.computeMaxOutputPowerPerTpa(n, list.size());
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    this.setAttribute(string, "maxTotalOutputPowerLow", (Object)new Integer(n3));
                }
            }
            customerParameterServer = this.rbs.getCustomerParameterServerObject(this.getSectorPrefix() + "lockSectorOutputPowerLow");
            object = Boolean.valueOf((String)customerParameterServer.getValueMom());
            if (customerParameterServer.hasValueChanged()) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    this.setAttribute(string, "txPowerPersistentLock", object);
                }
            }
        }
    }

    private List getTpaDeviceLDNs(AbstractRuRI[] abstractRuRIArray) throws BemException {
        ArrayList<String> arrayList = new ArrayList<String>();
        CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(this.getSectorPrefix() + "radioBuildingBlock");
        String string = customerParameterServer.getValueMom().toString();
        for (int i = 0; i < abstractRuRIArray.length; ++i) {
            LdnMoi ldnMoi = new LdnMoi(abstractRuRIArray[i].getLdn());
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(ldnMoi, MimTpaDeviceSet.MOTYPENAME, "1");
            int n = AbstractRbb.getTpaIndex(string, abstractRuRIArray[i]);
            for (int j = 0; j < abstractRuRIArray[i].getTpaDeviceCount(); ++j) {
                FixedRdnMoi fixedRdnMoi2 = new FixedRdnMoi(fixedRdnMoi, MimTpaDevice.MOTYPENAME, String.valueOf(j + n));
                arrayList.add(fixedRdnMoi2.getLdn());
            }
        }
        return arrayList;
    }

    private AbstractRuRI[] getRadioUnits() throws BemException {
        RadioEquipmentProviderWithRbb radioEquipmentProviderWithRbb = (RadioEquipmentProviderWithRbb)this.rbs.getProvider(RadioEquipmentProviderWithRbb.class);
        return radioEquipmentProviderWithRbb == null ? null : radioEquipmentProviderWithRbb.getSectorRadioUnits(this.sectorNumber);
    }

    private int computeMaxOutputPowerPerTpa(int n, int n2) throws BemException {
        int n3 = -1;
        if (n != -1) {
            n3 = n / n2;
        }
        return n3 == 0 ? 1 : n3;
    }

    private void loadPositionInfo() throws BemException {
        if (!RbsUtil.isApcLightSupported(this.rbs)) {
            return;
        }
        BemMo bemMo = this.getMo(this.getLdn());
        String string = PrefixUtil.getPosPrefix(this.sectorNumber, "Antenna", this.antNo);
        if (this.isExisting(bemMo)) {
            String string2 = string + "positionInformation";
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string2);
            String string3 = (String)bemMo.getAttribute("positionInformation");
            customerParameterServer.setLoadedValue(string3);
            string2 = string + "hwGroupId";
            customerParameterServer = this.rbs.getCustomerParameterServerObject(string2);
            BemMo bemMo2 = (BemMo)bemMo.getAttribute("positionRef");
            if (null != bemMo2 && MimHwGroup.MOTYPENAME.equals(bemMo2.getType())) {
                customerParameterServer.setLoadedValue(bemMo2.getId());
            }
        }
    }

    private void setPositionInfo(BemMo bemMo) throws BemException {
        if (!RbsUtil.isApcLightSupported(this.rbs)) {
            return;
        }
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        String string = PrefixUtil.getPosPrefix(this.sectorNumber, "Antenna", this.antNo);
        String string2 = string + "positionInformation";
        CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string2);
        if (customerParameterServer.hasValueChanged()) {
            vector.add(Nal.getFactory().getNameValue("positionInformation", customerParameterServer.getValueMom()));
        }
        if ((customerParameterServer = this.rbs.getCustomerParameterServerObject(string2 = string + "hwGroupId")).hasValueChanged()) {
            String string3 = (String)customerParameterServer.getValueMom();
            MoInstance moInstance = null;
            moInstance = string3.equals("") ? new LdnMoi(null) : new FixedRdnMoi(this.rbs.getEquipmentMoi(), MimHwGroup.MOTYPENAME, string3);
            BemMo bemMo2 = this.getMo(moInstance.getLdn());
            vector.add(Nal.getFactory().getNameValue("positionRef", bemMo2));
        }
        if (vector.size() > 0) {
            this.setAttributes(bemMo, vector);
        }
    }

    public void setLoadedValues() throws BemException {
        BemMo bemMo = this.getMo(this.ldn);
        if (this.isExisting(bemMo)) {
            String string = this.getSectorPrefix();
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string + "antennaType" + (this.antNo > 1 ? String.valueOf(this.antNo) : ""));
            Integer n = (Integer)this.getAttribute(bemMo, "antennaType");
            customerParameterServer.setLoadedValue(n);
            String string2 = MessageFormat.format("SEQ{0}_", new Integer(1));
            String string3 = BemUtil.getCustomerParameterName(string + string2, "antennaType", this.antNo);
            if (this.rbs.isParameterSupported(string3)) {
                customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                customerParameterServer.setLoadedValue(n);
            }
            Object object = this.getAttribute(bemMo, "userLabel");
            String string4 = BemUtil.getCustomerParameterName(string + string2, "userLabel", this.antNo);
            if (this.rbs.isParameterSupported(string4)) {
                customerParameterServer = this.rbs.getCustomerParameterServerObject(string4);
                customerParameterServer.setLoadedValue(object.toString());
            }
            BemMo[] bemMoArray = bemMo.getChildren();
            BemMo bemMo2 = this.getMo(this.riuMoi.getLdn());
            if (this.isExisting(bemMo2)) {
                customerParameterServer = this.rbs.getCustomerParameterServerObject(string + "riuInstalled" + (this.antNo == 1 ? "" : String.valueOf(this.antNo)));
                customerParameterServer.setLoadedValue("YES");
            } else if (bemMoArray.length > 1) {
                customerParameterServer = this.rbs.getCustomerParameterServerObject(string + "riuInstalled" + (this.antNo == 1 ? "" : String.valueOf(this.antNo)));
                customerParameterServer.setLoadedValue("NO");
            }
            if (AntennaSystemUtil.isPsiSector(this.rbs, this.sectorNumber)) {
                customerParameterServer = this.rbs.getCustomerParameterServerObject(string + "beamDirection" + (this.antNo == 1 ? "" : String.valueOf(this.antNo)));
                String string5 = (String)this.getAttribute(bemMo, "beamDirection");
                customerParameterServer.setLoadedValue(string5);
            }
        }
        this.setSectorOutputPowerLoadedValues();
        this.setLockSectorOutputPowerLowLoadedValue();
        this.loadPositionInfo();
    }

    private void setLockSectorOutputPowerLowLoadedValue() throws BemException {
        Object object;
        boolean bl = false;
        AbstractRuRI[] abstractRuRIArray = this.getRadioUnits();
        if (abstractRuRIArray != null) {
            object = this.getTpaDeviceLDNs(abstractRuRIArray);
            Iterator iterator = object.iterator();
            while (iterator.hasNext() && !bl) {
                String string = (String)iterator.next();
                BemMo bemMo = this.getMo(string);
                if (!bemMo.isExisting()) continue;
                bl = (Boolean)bemMo.getAttribute("txPowerPersistentLock");
            }
        }
        object = this.rbs.getCustomerParameterServerObject(this.getSectorPrefix() + "lockSectorOutputPowerLow");
        if (!bl) {
            object.setLoadedValue("FALSE");
        } else {
            object.setLoadedValue("TRUE");
            BemLog.log(2, this.getClass() + "Attribute txPowerPersistentLock was loaded as true, " + "txPowerPersistentLock, maxTotalOutputPower and maxTotalOutputPowerLow will be ignored while setting!");
        }
    }

    private void setSectorOutputPowerLoadedValues() throws BemException {
        int n = -1;
        int n2 = -1;
        AbstractRuRI[] abstractRuRIArray = this.getRadioUnits();
        if (abstractRuRIArray != null) {
            Object object;
            String string;
            int n3 = 0;
            int n4 = 0;
            List list = this.getTpaDeviceLDNs(abstractRuRIArray);
            if (list.size() > 1) {
                for (int i = 0; i < list.size() - 1; ++i) {
                    string = (String)list.get(i);
                    object = (String)list.get(i + 1);
                    BemMo bemMo = this.getMo(string);
                    BemMo bemMo2 = this.getMo((String)object);
                    if (!bemMo.isExisting() || !bemMo2.isExisting()) continue;
                    int n5 = (Integer)bemMo.getAttribute("maxTotalOutputPower");
                    int n6 = (Integer)bemMo2.getAttribute("maxTotalOutputPower");
                    int n7 = (Integer)bemMo.getAttribute("maxTotalOutputPowerLow");
                    int n8 = (Integer)bemMo2.getAttribute("maxTotalOutputPowerLow");
                    if ((n5 == -1 || n8 == -1) && (n6 == -1 || n7 == -1)) continue;
                    CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(this.getSectorPrefix() + "sectorOutputPower");
                    customerParameterServer.setLoadedValue(new Integer(-1));
                    customerParameterServer = this.rbs.getCustomerParameterServerObject(this.getSectorPrefix() + "sectorOutputPowerLow");
                    customerParameterServer.setLoadedValue(new Integer(-1));
                    BemLog.log(2, this.getClass() + "Incorrect configuration: maxTotalOutputPower and maxTotalOutputPowerLow could not be defined value at same time for TpaDevice in same radio unit!");
                    return;
                }
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n9;
                string = (String)iterator.next();
                object = this.getMo(string);
                if (!object.isExisting()) continue;
                int n10 = (Integer)object.getAttribute("maxTotalOutputPower");
                if (n10 != -1) {
                    n3 += n10;
                }
                if ((n9 = ((Integer)object.getAttribute("maxTotalOutputPowerLow")).intValue()) == -1) continue;
                n4 += n9;
            }
            if (n3 != 0) {
                n = n3;
            }
            if (n4 != 0) {
                n2 = n4;
            }
        }
        CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(this.getSectorPrefix() + "sectorOutputPower");
        customerParameterServer.setLoadedValue(new Integer(n));
        customerParameterServer = this.rbs.getCustomerParameterServerObject(this.getSectorPrefix() + "sectorOutputPowerLow");
        customerParameterServer.setLoadedValue(new Integer(n2));
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "SectorAntenna: " + this.getLdn();
    }

    public String getSectorPrefix() {
        return SectorUtil.getSectorPrefix(this.sectorNumber);
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("AuxUnitDbControlledDeletionPhase")) {
            this.deleteMoIfNotExisting(this.riuMoi.getLdn());
        }
    }
}

