/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.AbstractTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimE1Ttp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimOs155SpiTtp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSts1SpeTtp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimT1Ttp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVc12Ttp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVc4Ttp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVt15Ttp;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class Etmc41TerminationUtil {
    private static final String RESERVEDBY = "reservedBy";

    public static void createTermination(AbstractTerminationRI abstractTerminationRI, String string, String string2) throws BemException {
        Vector<NalNameValue> vector = new Vector<NalNameValue>(0, 1);
        NalNameValue nalNameValue = Nal.getFactory().getNameValue("lineNo", new Integer(string2));
        vector.add(nalNameValue);
        Integer n = null;
        if (string.equals("ETSI")) {
            n = new Integer(1);
        } else if (string.equals("ANSI")) {
            n = new Integer(0);
        }
        NalNameValue nalNameValue2 = Nal.getFactory().getNameValue("standardMode", n);
        vector.add(nalNameValue2);
        NalNameValue nalNameValue3 = Nal.getFactory().getNameValue("muxMode", new Integer(1));
        vector.add(nalNameValue3);
        String string3 = abstractTerminationRI.generateTerminationLdn(MimOs155SpiTtp.MOTYPENAME, string2);
        abstractTerminationRI.createRiMoIfNotExisting(string3, vector);
    }

    public static void deleteTermination(AbstractTerminationRI abstractTerminationRI, MoHandler moHandler) throws BemException {
        String[] stringArray = abstractTerminationRI.getLinesToUnInstall();
        boolean bl = true;
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String string = abstractTerminationRI.getLdnFromLine(stringArray[0]);
        String string2 = abstractTerminationRI.getSubLdn(string, MimOs155SpiTtp.MOTYPENAME);
        if (string2 == null) {
            return;
        }
        ArrayList arrayList = Etmc41TerminationUtil.getAllTerminations(string2, moHandler);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (abstractTerminationRI.hasChildren(string)) {
                bl = false;
                break;
            }
            ArrayList arrayList2 = abstractTerminationRI.getReferencesToOtherMOs(string, RESERVEDBY);
            String string3 = abstractTerminationRI.getSubLdn(string, MimVc4Ttp.MOTYPENAME);
            ArrayList arrayList3 = abstractTerminationRI.getReferencesToOtherMOs(string3, RESERVEDBY);
            if (!arrayList2.isEmpty() || !arrayList3.isEmpty()) {
                bl = false;
                break;
            }
            if (!abstractTerminationRI.isConnectedToSync(string2)) continue;
            bl = false;
            break;
        }
        if (bl) {
            abstractTerminationRI.deleteRiMoIfNotExisting(string2);
        }
    }

    private static ArrayList getAllTerminations(String string, MoHandler moHandler) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BemMo bemMo = moHandler.getMo(string);
        if (bemMo != null) {
            int n;
            BemMo[] bemMoArray;
            try {
                bemMoArray = moHandler.getChildren(bemMo, 5, MimE1Ttp.MOTYPENAME, "");
                if (bemMoArray != null && bemMoArray.length > 0) {
                    for (n = 0; n < bemMoArray.length; ++n) {
                        arrayList.add(bemMoArray[n].getDN());
                    }
                }
            }
            catch (MoHandlerException moHandlerException) {
                // empty catch block
            }
            try {
                bemMoArray = moHandler.getChildren(bemMo, 5, MimT1Ttp.MOTYPENAME, "");
                if (bemMoArray != null && bemMoArray.length > 0) {
                    for (n = 0; n < bemMoArray.length; ++n) {
                        arrayList.add(bemMoArray[n].getDN());
                    }
                }
            }
            catch (MoHandlerException moHandlerException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static String[] getTerminationLdns(AbstractTerminationRI abstractTerminationRI, String string) {
        String[] stringArray = abstractTerminationRI.getSelectedLines();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = Etmc41TerminationUtil.getLdn(stringArray[i], abstractTerminationRI, string);
        }
        return stringArray2;
    }

    private static String getLdn(String string, AbstractTerminationRI abstractTerminationRI, String string2) {
        String string3 = abstractTerminationRI.getLdnFromLine(string);
        if (string3 == null) {
            String string4 = abstractTerminationRI.generateTerminationLdn(MimOs155SpiTtp.MOTYPENAME, string2);
            String string5 = abstractTerminationRI.getSelectedStandard();
            if (string5.equals("ETSI")) {
                string3 = string4 + "," + MimVc4Ttp.MOTYPENAME + "=1," + MimVc12Ttp.MOTYPENAME + "=" + string + "," + MimE1Ttp.MOTYPENAME + "=1";
            } else if (string5.equals("ANSI")) {
                String string6 = Etmc41TerminationUtil.getSts1SpeTtpId(string);
                String string7 = Etmc41TerminationUtil.getVt15TtpId(string);
                string3 = string4 + "," + MimSts1SpeTtp.MOTYPENAME + "=" + string6 + "," + MimVt15Ttp.MOTYPENAME + "=" + string7 + "," + MimT1Ttp.MOTYPENAME + "=1";
            }
        }
        return string3;
    }

    private static String getSts1SpeTtpId(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
        String string2 = n <= 28 ? "1" : (n <= 56 ? "2" : "3");
        return string2;
    }

    private static String getVt15TtpId(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
        String string2 = n <= 28 ? String.valueOf(n) : (n <= 56 ? String.valueOf(n - 28) : String.valueOf(n - 56));
        return string2;
    }

    public static String getSubLineId(AbstractTerminationRI abstractTerminationRI) throws BemException {
        return Etmc41TerminationUtil.getSubLineId(abstractTerminationRI, false);
    }

    public static String getSubLineId(AbstractTerminationRI abstractTerminationRI, boolean bl) throws BemException {
        String string = "";
        String[] stringArray = abstractTerminationRI.getSelectedLines();
        if (stringArray.length > 0) {
            String string2 = abstractTerminationRI.getSelectedStandard();
            if (string2.equals("ETSI")) {
                string = stringArray[0];
            } else {
                string = Etmc41TerminationUtil.getSts1SpeTtpId(stringArray[0]);
                string = string + "-";
                string = string + Etmc41TerminationUtil.getVt15TtpId(stringArray[0]);
            }
        }
        return string;
    }

    public static String generateTerminationLdn(AbstractTerminationRI abstractTerminationRI, String string, String string2) {
        String string3 = abstractTerminationRI.generateTerminationLdn(MimOs155SpiTtp.MOTYPENAME, string2);
        String string4 = abstractTerminationRI.getLdnFromLine(string);
        if (string4 != null) {
            int n;
            int n2 = string4.indexOf(MimOs155SpiTtp.MOTYPENAME);
            if (n2 != -1 && (n = string4.indexOf(",", n2)) != -1) {
                string4 = string4.substring(0, n);
            }
            string3 = string4;
        }
        return string3;
    }

    public static String generateSynchTerminationLdn(AbstractTerminationRI abstractTerminationRI, String string, String string2) {
        String string3 = abstractTerminationRI.generateTerminationLdn(MimOs155SpiTtp.MOTYPENAME, string2);
        return string3;
    }

    public static String getSynchTerminationMoType() {
        return MimOs155SpiTtp.MOTYPENAME;
    }
}

