/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.check.ReportEntry;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.LocationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.EcPortConstants;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.HubPositionConverter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.IntegerConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.ControlSystemProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.SyncRefInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsData;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimConfigurationVersion;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDownlinkBaseBandPool;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipmentSupportFunction;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEthernetLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExternalNode;
import se.ericsson.wcdma.rbs.bem.common.mim.MimGeneralProcessorUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimHwUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpOam;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpRoutingTable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPmService;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwManagement;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwitchCoreUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSystemFunctions;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTimingUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTransportNetwork;
import se.ericsson.wcdma.rbs.bem.common.mim.MimUplinkBaseBandPool;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.HubSubrackMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public abstract class AbstractCabinetBasicCI
extends AbstractConfigurationItem
implements AtfProvider,
ControlSystemProvider,
CustomerParameterListener,
EcPortCustomerParameterProvider {
    public static final String name = "CabinetBasicCI";
    public static final int MAX_NO_EXTERNAL_NODES = 7;
    public static final int MAX_NO_ECPORTS_PER_EXTERNAL_NODE = 2;
    protected int noOfGpb = 0;
    protected int noOfScbInHub = 0;
    protected int noOfTub = 0;
    private ConfigurationCheckReport report;
    private ReportEntry entry;
    private RbsData rbsData;
    private HashMap definedBoardPositions;
    private String hubSubrackLdn;
    private MoHandler moHandler;
    private BemMo hubSubrackMo;
    private HubSubrackMoi hubSubrackMoi;
    private MoInstance managedElementMoi;
    private MoInstance equipmentMoi;
    protected SingleChildMoi fcuMoi;
    private SingleChildMoi ipOamMoi;
    private SingleChildMoi ipMoi;
    private SingleChildMoi ethernetLinkMoi;
    private SingleChildMoi ipRoutingTableMoi;
    private SingleChildMoi swManagementMoi;
    private SingleChildMoi configurationVersionMoi;
    private SingleChildMoi uplinkBBPoolMoi;
    private SingleChildMoi downlinkBBPoolMoi;
    private SingleChildMoi transportNetworkMoi;
    private SingleChildMoi systemFunctionMoi;
    private SingleChildMoi pmServiceMoi;
    private MoInstance gpuMoi;
    protected LocationProvider locationProvider;
    private List ecPortCustomerParams = new ArrayList();
    protected ParameterRestriction ecPortReadOnlyRestriction = new ParameterRestriction("The customer parameter is loaded from node and can therefore not be changed", 0);
    protected ParameterRestriction ecPortIgnoredRestriction = new ParameterRestriction("The customer parameter was removed from customer parameter list and should therefore be ignored", 1);
    protected ParameterRestriction ecPortUnitTypeRestrictionExtDuw = new ParameterRestriction("", new EnumeratedRange(new String[]{"DUW", "EXTNODE"}), true);
    protected ParameterRestriction ecPortUnitTypeRestrictionExtCbu = new ParameterRestriction("", new EnumeratedRange(new String[]{"CBU", "EXTNODE"}), true);
    protected ParameterRestriction ecPortUnitTypeRestrictionDuw = new ParameterRestriction("", new EnumeratedRange(new String[]{"DUW"}), true);
    protected ParameterRestriction ecPortUnitTypeRestrictionCbu = new ParameterRestriction("", new EnumeratedRange(new String[]{"CBU"}), true);
    private EnumeratedRange cbuHubPositionRange = new EnumeratedRange(new String[]{"", "A0", "B0"});
    private EnumeratedRange rbs6000NodeHubPositionRange = new EnumeratedRange(new String[]{"", "A0", "B0", "B1", "A2", "A3", "A5", "A6", "A7", "EC_A", "EC_B", "EC_C", "D", "E", "X", "Y", "Z"});
    private EnumeratedRange extNodePortNumberRange = new EnumeratedRange(new String[]{"1", "2"});
    private EnumeratedRange duwPortNumberRange = new EnumeratedRange(new String[]{"1"});
    private EnumeratedRange cbuPortNumberRange = new EnumeratedRange(new String[]{"1"});
    private EnumeratedRange extNodeUnitNumberRange;
    private EnumeratedRange sDuwUnitNumberRange;
    private EnumeratedRange dDuwUnitNumberRange;
    private EnumeratedRange cbuUnitNumberRange;
    private boolean supportSystemControl;

    public AbstractCabinetBasicCI(Rbs rbs) {
        super(rbs);
        String[] stringArray = new String[7];
        for (int i = 0; i < 7; ++i) {
            stringArray[i] = String.valueOf(i + 1);
        }
        this.extNodeUnitNumberRange = new EnumeratedRange(stringArray);
        this.sDuwUnitNumberRange = new EnumeratedRange(new String[]{"1"});
        this.dDuwUnitNumberRange = new EnumeratedRange(new String[]{"1", "2"});
        this.cbuUnitNumberRange = new EnumeratedRange(new String[]{"1", "2"});
        this.supportSystemControl = true;
        this.initializeMoiResources();
    }

    public ConfigurationCheckReport checkConfiguration() throws BemException {
        this.definedBoardPositions = this.rbsData.getBoardPositions();
        Object[] objectArray = this.definedBoardPositions.keySet().toArray();
        this.hubSubrackLdn = this.hubSubrackMoi.getLdn();
        this.moHandler = this.rbs.getMoHandler();
        this.hubSubrackMo = this.moHandler.getMo(this.hubSubrackLdn);
        this.report = new ConfigurationCheckReport();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                int n;
                BemMo[] bemMoArray = null;
                String[] stringArray = null;
                List<String> list = null;
                stringBuffer.append((String)objectArray[i] + " in slot ");
                bemMoArray = this.moHandler.getChildren(this.hubSubrackMo, 3, (String)objectArray[i], "");
                if (objectArray[i].equals(MimGeneralProcessorUnit.MOTYPENAME)) {
                    this.noOfGpb = bemMoArray.length;
                }
                if (objectArray[i].equals(MimSwitchCoreUnit.MOTYPENAME)) {
                    this.noOfScbInHub = bemMoArray.length;
                }
                if (objectArray[i].equals(MimTimingUnit.MOTYPENAME)) {
                    this.noOfTub = bemMoArray.length;
                }
                stringArray = (String[])this.definedBoardPositions.get(objectArray[i]);
                list = Arrays.asList(stringArray);
                for (n = 0; n < stringArray.length - 1; ++n) {
                    stringBuffer.append(stringArray[n] + ", ");
                }
                stringBuffer.append(stringArray[stringArray.length - 1]);
                for (n = 0; n < bemMoArray.length; ++n) {
                    String string = bemMoArray[n].getParent().getParent().getId();
                    String string2 = bemMoArray[n].getParent().getParent().getDN();
                    if (list.contains(string)) continue;
                    String string3 = bemMoArray[n].getType() + " in slot " + string;
                    this.entry = new ReportEntry("Error", string2, string3, stringBuffer.toString(), "Not a valid slot for the board type Hub Subrack");
                    this.report.addReportEntry(this.entry);
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
            String string = moHandlerException.getAction();
            String string4 = moHandlerException.getAdditionalInfo();
            throw new BemException(string, "checkConfiguration", this.hubSubrackLdn, string4, moHandlerException);
        }
        return this.report;
    }

    public String getName() {
        return name;
    }

    public void setRbsData(RbsData rbsData) {
        this.rbsData = rbsData;
    }

    public RbsData getRbsData() {
        return this.rbsData;
    }

    public MoInstance getManagedElementMoi() {
        return this.managedElementMoi;
    }

    public MoInstance getEquipmentMoi() {
        return this.equipmentMoi;
    }

    public MoInstance getHubSubrackMoi() {
        return this.hubSubrackMoi;
    }

    public HubSubrackMoi getSubrackMoi() {
        return this.hubSubrackMoi;
    }

    public SingleChildMoi getTransportNetworkMoi() {
        return this.transportNetworkMoi;
    }

    public SingleChildMoi getConfigurationVersionMoi() {
        return this.configurationVersionMoi;
    }

    public SingleChildMoi getUpLinlBaseBandPoolMoi() {
        return this.uplinkBBPoolMoi;
    }

    public SingleChildMoi getDownlinkBBPoolMoi() {
        return this.downlinkBBPoolMoi;
    }

    public String getTransportNetworkLdn() throws BemException {
        return this.transportNetworkMoi.getLdn();
    }

    public String getConfigurationVersionLdn() throws BemException {
        return this.configurationVersionMoi.getLdn();
    }

    public String getIpOamLdn() throws BemException {
        return this.ipOamMoi.getLdn();
    }

    public String getIpLdn() throws BemException {
        return this.ipMoi.getLdn();
    }

    public String getEthernetLinkLdn() throws BemException {
        return this.ethernetLinkMoi.getLdn();
    }

    public String getIpRoutingTableLdn() throws BemException {
        return this.ipRoutingTableMoi.getLdn();
    }

    public String getPmServiceLdn() throws BemException {
        return this.pmServiceMoi.getLdn();
    }

    private void initializeMoiResources() {
        this.managedElementMoi = new RootMoi();
        this.equipmentMoi = this.rbs.getEquipmentMoi();
        this.ipOamMoi = new SingleChildMoi(this.managedElementMoi, MimIpOam.MOTYPENAME, "1");
        this.ipMoi = new SingleChildMoi(this.ipOamMoi, MimIp.MOTYPENAME, "1");
        this.ethernetLinkMoi = new SingleChildMoi(this.ipMoi, MimEthernetLink.MOTYPENAME, "1");
        this.ipRoutingTableMoi = new SingleChildMoi(this.ipMoi, MimIpRoutingTable.MOTYPENAME, "1");
        this.hubSubrackMoi = new HubSubrackMoi(this.equipmentMoi);
        this.transportNetworkMoi = new SingleChildMoi(this.managedElementMoi, MimTransportNetwork.MOTYPENAME, "1");
        this.swManagementMoi = new SingleChildMoi(this.managedElementMoi, MimSwManagement.MOTYPENAME, "1");
        this.configurationVersionMoi = new SingleChildMoi(this.swManagementMoi, MimConfigurationVersion.MOTYPENAME, "1");
        this.downlinkBBPoolMoi = new SingleChildMoi(this.hubSubrackMoi, MimDownlinkBaseBandPool.MOTYPENAME, "1");
        this.uplinkBBPoolMoi = new SingleChildMoi(this.hubSubrackMoi, MimUplinkBaseBandPool.MOTYPENAME, "1");
        this.systemFunctionMoi = new SingleChildMoi(this.managedElementMoi, MimSystemFunctions.MOTYPENAME, "1");
        this.pmServiceMoi = new SingleChildMoi(this.systemFunctionMoi, MimPmService.MOTYPENAME, "1");
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.hubSubrackMoi, MimSlot.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi = new SingleChildMoi(fixedRdnMoi, MimPlugInUnit.MOTYPENAME, "1");
        this.gpuMoi = new SingleChildMoi(singleChildMoi, MimGeneralProcessorUnit.MOTYPENAME, "1");
    }

    public MoInstance getGpuMoi() {
        return this.gpuMoi;
    }

    protected abstract AtfProvider getAtfProvider();

    protected abstract AtfProvider getAtfProvider(int var1);

    public String getPrimaryAtfLdn(String string) throws BemException {
        return this.getPrimaryAtfLdn(string, 0);
    }

    public String getPrimaryAtfLdn(String string, int n) throws BemException {
        AtfProvider atfProvider = this.getAtfProvider(n);
        return atfProvider.getPrimaryAtfLdn(string);
    }

    public String getSecondaryAtfLdn(String string) throws BemException {
        return this.getSecondaryAtfLdn(string, 0);
    }

    public String getSecondaryAtfLdn(String string, int n) throws BemException {
        AtfProvider atfProvider = this.getAtfProvider(n);
        return atfProvider.getSecondaryAtfLdn(string);
    }

    public boolean isAtfRoleSupported(String string) {
        return this.isAtfRoleSupported(string, 0);
    }

    public boolean isAtfRoleSupported(String string, int n) {
        AtfProvider atfProvider = this.getAtfProvider(n);
        return atfProvider.isAtfRoleSupported(string);
    }

    public String getAtfReport() {
        AtfProvider atfProvider = this.getAtfProvider();
        return atfProvider.getAtfReport();
    }

    public CustomerParameter getAddDuwBoardSlotCustomerParameter() {
        return null;
    }

    public void checkConsistency() throws BemException {
        super.checkConsistency();
        HashMap<String, EcPortInfo> hashMap = new HashMap<String, EcPortInfo>();
        EcPortInfo[] ecPortInfoArray = this.getEcPortCustomerParameters();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < ecPortInfoArray.length; ++i) {
            String string;
            EcPortInfo ecPortInfo = ecPortInfoArray[i];
            String string2 = ecPortInfo.getReferredCabinetNumberValue();
            String string3 = ecPortInfo.getUnitTypeValue();
            String string4 = ecPortInfo.getHubPositionValue();
            if (!this.rbs.isCabinetWiz()) {
                if (string3.equals("DUW")) {
                    if (!string2.equals("##UNDEFINED")) {
                        string = "The referredCabinetNumber attribute in EcPort element cannot be configured when the value of unitType attribute is \"DUW\"." + ecPortInfo.toString();
                        throw new CustomerParameterException(string, ecPortInfo.getReferredCabinetNumberParameter());
                    }
                } else if (string3.equals("EXTNODE")) {
                    if (string2.equals("##UNDEFINED")) {
                        string = "The referredCabinetNumber attribute in EcPort element must be configured when the value of unitType attribute is \"EXTNODE\"." + ecPortInfo.toString();
                        throw new CustomerParameterException(string, ecPortInfo.getReferredCabinetNumberParameter());
                    }
                    string = string2 + "+" + string4;
                    if (hashSet.contains(string)) {
                        String string5 = "The hubPosition attribute of different EcPort instances referring to the same cabinet must be unique." + ecPortInfo.toString();
                        throw new CustomerParameterException(string5, ecPortInfo.getReferredCabinetNumberParameter());
                    }
                    hashSet.add(string);
                }
            }
            string = ecPortInfo.getUnitTypeValue() + ecPortInfo.getUnitNumberValue() + ecPortInfo.getPortNumberValue();
            if (ecPortInfo.getUnitTypeValue().equals("DUW") && !"0".equals(ecPortInfo.getCascadingOrderValue())) {
                arrayList.add(ecPortInfo.getCascadingOrderValue());
                arrayList2.add(ecPortInfo.getUnitNumberValue());
            }
            if (hashMap.containsKey(string)) {
                String string6 = MessageFormat.format("EcPort with Unit Type={0}, Unit Number={1} and Port Number={2} is already defined.", ecPortInfo.getUnitTypeValue(), ecPortInfo.getUnitNumberValue(), ecPortInfo.getPortNumberValue());
                throw new CustomerParameterException(string6, ecPortInfo.getUnitTypeParameter(), null);
            }
            hashMap.put(string, ecPortInfo);
        }
        if (this.isDuwV2In6601() && !this.isCascadingValueSupport(arrayList, arrayList2)) {
            throw new BemException("The configuratoion value of Cascading Order is not supported.");
        }
        hashMap.clear();
    }

    public void afterOpen() throws BemException {
        if (this.rbs.isParameterSupported("supportSystemControl")) {
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject("supportSystemControl");
            customerParameter.addCustomerParameterListener(this);
            this.supportSystemControl = customerParameter.getValue().equals("TRUE");
            this.updateEcPortCustomerParameters();
        }
    }

    private boolean isEcPortNeedLoaded() throws BemException, MoHandlerException {
        BemMo bemMo;
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.rbs.getRootMoi(), MimEquipmentSupportFunction.MOTYPENAME, String.valueOf(1));
        MoHandler moHandler = this.rbs.getMoHandler();
        if (!moHandler.isExisting(bemMo = moHandler.getMo(fixedRdnMoi.getLdn()))) {
            return false;
        }
        Boolean bl = (Boolean)bemMo.getAttribute("supportSystemControl");
        return bl;
    }

    protected void createEcPortCustomerParametersExternalNode() throws BemException {
        try {
            MoHandler moHandler = this.rbs.getMoHandler();
            for (int i = 1; i <= 7; ++i) {
                FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.getEquipmentMoi(), MimExternalNode.MOTYPENAME, String.valueOf(i));
                BemMo bemMo = moHandler.getMo(fixedRdnMoi.getLdn());
                if (!moHandler.isExisting(bemMo)) continue;
                for (int j = 1; j <= 2; ++j) {
                    FixedRdnMoi fixedRdnMoi2 = new FixedRdnMoi(fixedRdnMoi, MimEcPort.MOTYPENAME, String.valueOf(j));
                    BemMo bemMo2 = moHandler.getMo(fixedRdnMoi2.getLdn());
                    if (!moHandler.isExisting(bemMo2) || !this.isEcPortNeedLoaded()) continue;
                    EcPortInfo ecPortInfo = this.createEcPortCustomerParameter("EXTNODE");
                    Enumeration enumeration = ecPortInfo.getUnitTypeParameter();
                    enumeration.setLoadedValue("EXTNODE");
                    enumeration.addRestriction(this.ecPortReadOnlyRestriction);
                    Enumeration enumeration2 = ecPortInfo.getUnitNumberParameter();
                    enumeration2.setLoadedValue(String.valueOf(i));
                    enumeration2.addRestriction(this.ecPortReadOnlyRestriction);
                    Enumeration enumeration3 = ecPortInfo.getPortNumberParameter();
                    enumeration3.setLoadedValue(String.valueOf(j));
                    enumeration3.addRestriction(this.ecPortReadOnlyRestriction);
                    Enumeration enumeration4 = ecPortInfo.getHubPositionParameter();
                    enumeration4.setLoadedValue((String)bemMo2.getAttribute("hubPosition"));
                    Enumeration enumeration5 = ecPortInfo.getCascadingOrderParameter();
                    enumeration5.setLoadedValue((Integer)bemMo2.getAttribute("cascadingOrder"));
                    Enumeration enumeration6 = ecPortInfo.getReferredCabinetNumberParameter();
                    enumeration6.setLoadedValue(this.getReferredCabinetNumber(moHandler, bemMo2));
                    enumeration.addCustomerParameterListener(this);
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException);
        }
    }

    protected String getReferredCabinetNumber(MoHandler moHandler, BemMo bemMo) {
        BemMo bemMo2 = null;
        String string = "##UNDEFINED";
        Object[] objectArray = null;
        BemMo bemMo3 = (BemMo)bemMo.getAttribute("ecBusRef");
        if (bemMo3.isExisting()) {
            objectArray = (Object[])bemMo3.getAttribute("reservedBy");
        }
        if (objectArray != null && objectArray.length > 0 && objectArray instanceof BemMo[]) {
            BemMo[] bemMoArray = (BemMo[])objectArray;
            for (int i = objectArray.length - 1; i >= 0; --i) {
                BemMo bemMo4 = bemMoArray[i];
                if (!bemMo4.getType().equals(MimEcPort.MOTYPENAME)) continue;
                bemMo2 = bemMo4;
                Integer n = null;
                BemMo bemMo5 = bemMo2.getParent();
                if (!bemMo5.getType().equals(MimHwUnit.MOTYPENAME)) continue;
                n = (Integer)bemMo2.getAttribute("cascadingOrder");
                if (!bemMo.getAttribute("cascadingOrder").equals(n)) continue;
                BemMo bemMo6 = (BemMo)bemMo5.getAttribute("positionRef");
                string = bemMo6.getId();
                break;
            }
        }
        return string;
    }

    protected void setEcPortCustomerParameters(ServiceValue serviceValue) throws BemException {
        int n = 0;
        while (true) {
            Enumeration enumeration;
            Enumeration enumeration2;
            Enumeration enumeration3;
            String string = this.getEcPortPrefix(++n);
            String string2 = serviceValue.getValue(string + "unitType");
            String string3 = serviceValue.getValue(string + "unitNumber");
            String string4 = serviceValue.getValue(string + "hubPosition");
            String string5 = serviceValue.getValue(string + "portNumber");
            String string6 = serviceValue.getValue(string + "cascadingOrder");
            String string7 = serviceValue.getValue(string + "referredCabinetNumber");
            if (string2 == null || string3 == null || string5 == null) break;
            EcPortInfo ecPortInfo = this.getEcPortCustomerParameter(string2, string3, string5);
            if (ecPortInfo == null) {
                ecPortInfo = this.createEcPortCustomerParameter(string2);
                enumeration3 = ecPortInfo.getUnitTypeParameter();
                enumeration3.setValue(string2);
                enumeration2 = ecPortInfo.getUnitNumberParameter();
                enumeration2.setValue(string3);
                enumeration = ecPortInfo.getHubPositionParameter();
                if (string4 != null) {
                    enumeration.setValue(string4);
                }
                Enumeration enumeration4 = ecPortInfo.getPortNumberParameter();
                enumeration4.setValue(string5);
                Enumeration enumeration5 = ecPortInfo.getCascadingOrderParameter();
                if (string6 != null) {
                    enumeration5.setValue(string6);
                }
                Enumeration enumeration6 = ecPortInfo.getReferredCabinetNumberParameter();
                if (string7 != null) {
                    enumeration6.setValue(string7);
                }
                enumeration3.addCustomerParameterListener(this);
                continue;
            }
            enumeration3 = ecPortInfo.getHubPositionParameter();
            if (string4 != null) {
                enumeration3.setValue(string4);
            }
            enumeration2 = ecPortInfo.getCascadingOrderParameter();
            if (string6 != null) {
                enumeration2.setValue(string6);
            }
            enumeration = ecPortInfo.getReferredCabinetNumberParameter();
            if (string7 == null) continue;
            enumeration.setValue(string7);
        }
    }

    protected EcPortInfo createEcPortCustomerParameter(String string) throws BemException {
        String string2;
        EnumeratedRange enumeratedRange;
        EnumeratedRange enumeratedRange2;
        EnumeratedRange enumeratedRange3;
        EnumeratedRange enumeratedRange4 = new EnumeratedRange(new String[]{"EXTNODE", "DUW", "CBU"});
        EnumeratedRange enumeratedRange5 = new EnumeratedRange(EcPortConstants.getCascadingOrderRange(this.rbs.getRbsType(), string));
        List list = this.rbs.getCabinetNumberList();
        String[] stringArray = new String[list.size()];
        Object[] objectArray = list.toArray();
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = objectArray[i].toString();
        }
        EnumeratedRange enumeratedRange6 = new EnumeratedRange(stringArray);
        if (string.equals("EXTNODE")) {
            enumeratedRange3 = this.extNodeUnitNumberRange;
            enumeratedRange2 = this.extNodePortNumberRange;
            enumeratedRange = this.rbs6000NodeHubPositionRange;
            string2 = "";
        } else if (string.equals("DUW")) {
            enumeratedRange = this.rbs6000NodeHubPositionRange;
            enumeratedRange3 = DuwUtil.hasDualDuws() ? this.dDuwUnitNumberRange : this.sDuwUnitNumberRange;
            enumeratedRange2 = this.duwPortNumberRange;
            string2 = "";
        } else {
            enumeratedRange3 = this.cbuUnitNumberRange;
            enumeratedRange2 = this.cbuPortNumberRange;
            enumeratedRange = this.cbuHubPositionRange;
            string2 = "A0";
        }
        Enumeration enumeration = new Enumeration(this.getEcPortPrefix(this.ecPortCustomerParams.size()) + "unitType", enumeratedRange4);
        enumeration.addRestriction(this.getUnitTypeRestriction());
        super.addParameter(enumeration);
        Enumeration enumeration2 = new Enumeration(this.getEcPortPrefix(this.ecPortCustomerParams.size()) + "unitNumber", enumeratedRange3);
        super.addParameter(enumeration2);
        Enumeration enumeration3 = new Enumeration(this.getEcPortPrefix(this.ecPortCustomerParams.size()) + "portNumber", enumeratedRange2);
        enumeration3.setDefaultValue("1");
        super.addParameter(enumeration3);
        Enumeration enumeration4 = new Enumeration(this.getEcPortPrefix(this.ecPortCustomerParams.size()) + "hubPosition", enumeratedRange);
        enumeration4.setDefaultValue(string2);
        enumeration4.setMomConverter(new HubPositionConverter());
        super.addParameter(enumeration4);
        Enumeration enumeration5 = new Enumeration(this.getEcPortPrefix(this.ecPortCustomerParams.size()) + "cascadingOrder", enumeratedRange5);
        enumeration5.setDefaultValue("0");
        enumeration5.setMomConverter(new IntegerConversion(MimEcPort.MOTYPENAME, "cascadingOrder"));
        super.addParameter(enumeration5);
        Enumeration enumeration6 = new Enumeration(this.getEcPortPrefix(this.ecPortCustomerParams.size()) + "referredCabinetNumber", enumeratedRange6);
        super.addParameter(enumeration6);
        EcPortInfo ecPortInfo = new EcPortInfo(enumeration, enumeration2, enumeration3, enumeration4, enumeration5, enumeration6);
        this.ecPortCustomerParams.add(ecPortInfo);
        return ecPortInfo;
    }

    public EcPortInfo getEcPortCustomerParameter(String string, String string2, String string3) {
        Nal.getLog().nalTrace(6, this.getClass(), "getEcPortCustomerParameter(" + string + ", " + string2 + ", " + string3 + ")");
        EcPortInfo ecPortInfo = null;
        EcPortInfo[] ecPortInfoArray = this.getEcPortCustomerParameters(string, string2);
        for (int i = 0; i < ecPortInfoArray.length; ++i) {
            EcPortInfo ecPortInfo2 = ecPortInfoArray[i];
            if (!ecPortInfo2.getPortNumberValue().equals(string3)) continue;
            ecPortInfo = ecPortInfo2;
            break;
        }
        return ecPortInfo;
    }

    public EcPortInfo[] getEcPortCustomerParameters(String string, String string2) {
        Nal.getLog().nalTrace(6, this.getClass(), "getEcPortCustomerParameter(" + string + ", " + string2 + ")");
        ArrayList<EcPortInfo> arrayList = new ArrayList<EcPortInfo>();
        EcPortInfo[] ecPortInfoArray = this.getEcPortCustomerParameters();
        for (int i = 0; i < ecPortInfoArray.length; ++i) {
            EcPortInfo ecPortInfo = ecPortInfoArray[i];
            if (!ecPortInfo.getUnitTypeValue().equals(string) || !ecPortInfo.getUnitNumberValue().equals(string2)) continue;
            arrayList.add(ecPortInfo);
        }
        return arrayList.toArray(new EcPortInfo[0]);
    }

    public EcPortInfo getEcPortCustomerParameter(String string) {
        Nal.getLog().nalTrace(6, this.getClass(), "getEcPortCustomerParameter(" + string + ")");
        EcPortInfo ecPortInfo = null;
        EcPortInfo[] ecPortInfoArray = this.getEcPortCustomerParameters();
        for (int i = 0; i < ecPortInfoArray.length; ++i) {
            EcPortInfo ecPortInfo2 = ecPortInfoArray[i];
            if (!ecPortInfo2.getUnitTypeName().startsWith(string)) continue;
            ecPortInfo = ecPortInfo2;
            break;
        }
        return ecPortInfo;
    }

    public EcPortInfo[] getEcPortCustomerParameters() {
        Nal.getLog().nalTrace(6, this.getClass(), "getEcPortCustomerParameters()");
        ArrayList<EcPortInfo> arrayList = new ArrayList<EcPortInfo>();
        Iterator iterator = this.ecPortCustomerParams.iterator();
        while (iterator.hasNext()) {
            EcPortInfo ecPortInfo = (EcPortInfo)iterator.next();
            Enumeration enumeration = ecPortInfo.getUnitTypeParameter();
            if (enumeration.getAccessLevel() == 1) continue;
            arrayList.add(ecPortInfo);
        }
        return arrayList.toArray(new EcPortInfo[0]);
    }

    public EcPortInfo createEcPortCustomerParameter() throws BemException {
        Nal.getLog().nalTrace(6, this.getClass(), "createEcPortCustomerParameter()");
        String string = this.supportSystemControl ? "EXTNODE" : (DuwUtil.hasDuw() ? "DUW" : "CBU");
        EcPortInfo ecPortInfo = this.createEcPortCustomerParameter(string);
        Enumeration enumeration = ecPortInfo.getUnitTypeParameter();
        enumeration.setValue(string);
        enumeration.addCustomerParameterListener(this);
        return ecPortInfo;
    }

    public void removeEcPortCustomerParameter(String string) throws BemException {
        Nal.getLog().nalTrace(6, this.getClass(), "removeEcPortCustomerParameter(" + string + ")");
        EcPortInfo ecPortInfo = this.getEcPortCustomerParameter(string);
        if (ecPortInfo == null) {
            throw new BemException("Found no EcPort customer parameter prefixed by " + string);
        }
        ecPortInfo.removeCustomerParameterListener(this);
        ecPortInfo.addRestriction(this.ecPortIgnoredRestriction);
    }

    private String getEcPortPrefix(int n) {
        return MessageFormat.format("EcPort{0}_", String.valueOf(n));
    }

    private void updateEcPortCustomerParameters() throws BemException {
        EcPortInfo[] ecPortInfoArray = this.getEcPortCustomerParameters();
        for (int i = 0; i < ecPortInfoArray.length; ++i) {
            EcPortInfo ecPortInfo = ecPortInfoArray[i];
            Enumeration enumeration = ecPortInfo.getUnitTypeParameter();
            if (enumeration.getValue().equals("EXTNODE") && !this.supportSystemControl) {
                String string = enumeration.getName().substring(0, enumeration.getName().indexOf("unitType"));
                this.removeEcPortCustomerParameter(string);
                continue;
            }
            if (enumeration.getRestrictions().contains(this.ecPortUnitTypeRestrictionDuw)) {
                enumeration.removeRestriction(this.ecPortUnitTypeRestrictionDuw);
            } else if (enumeration.getRestrictions().contains(this.ecPortUnitTypeRestrictionExtDuw)) {
                enumeration.removeRestriction(this.ecPortUnitTypeRestrictionExtDuw);
            } else if (enumeration.getRestrictions().contains(this.ecPortUnitTypeRestrictionCbu)) {
                enumeration.removeRestriction(this.ecPortUnitTypeRestrictionCbu);
            } else if (enumeration.getRestrictions().contains(this.ecPortUnitTypeRestrictionExtCbu)) {
                enumeration.removeRestriction(this.ecPortUnitTypeRestrictionExtCbu);
            }
            enumeration.addRestriction(this.getUnitTypeRestriction());
        }
    }

    private ParameterRestriction getUnitTypeRestriction() throws BemException {
        ParameterRestriction parameterRestriction = DuwUtil.hasDuw() ? (this.supportSystemControl ? this.ecPortUnitTypeRestrictionExtDuw : this.ecPortUnitTypeRestrictionDuw) : (this.supportSystemControl ? this.ecPortUnitTypeRestrictionExtCbu : this.ecPortUnitTypeRestrictionCbu);
        return parameterRestriction;
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (parameterEvent.isValueChanged()) {
            String string = customerParameter.getName();
            if (string.startsWith("EcPort")) {
                if (string.endsWith("unitType")) {
                    String string2 = string.substring(0, string.indexOf("unitType"));
                    EcPortInfo ecPortInfo = this.getEcPortCustomerParameter(string2);
                    if (ecPortInfo != null) {
                        ecPortInfo.getUnitNumberParameter().removeAllRestrictions();
                        ecPortInfo.getPortNumberParameter().removeAllRestrictions();
                        ecPortInfo.getHubPositionParameter().removeAllRestrictions();
                        String string3 = customerParameter.getValue();
                        if (string3.equals("EXTNODE")) {
                            ecPortInfo.getUnitNumberParameter().addRestriction(new ParameterRestriction("", this.extNodeUnitNumberRange, true));
                            ecPortInfo.getPortNumberParameter().addRestriction(new ParameterRestriction("", this.extNodePortNumberRange, true));
                            ecPortInfo.getHubPositionParameter().addRestriction(new ParameterRestriction("", this.rbs6000NodeHubPositionRange, true));
                        } else if (string3.equals("DUW")) {
                            if (DuwUtil.hasDualDuws()) {
                                ecPortInfo.getUnitNumberParameter().addRestriction(new ParameterRestriction("", this.dDuwUnitNumberRange, true));
                            } else {
                                ecPortInfo.getUnitNumberParameter().addRestriction(new ParameterRestriction("", this.sDuwUnitNumberRange, true));
                            }
                            ecPortInfo.getPortNumberParameter().addRestriction(new ParameterRestriction("", this.duwPortNumberRange, true));
                            ecPortInfo.getHubPositionParameter().addRestriction(new ParameterRestriction("", this.rbs6000NodeHubPositionRange, true));
                        } else {
                            ecPortInfo.getUnitNumberParameter().addRestriction(new ParameterRestriction("", this.cbuUnitNumberRange, true));
                            ecPortInfo.getPortNumberParameter().addRestriction(new ParameterRestriction("", this.cbuPortNumberRange, true));
                            ecPortInfo.getHubPositionParameter().addRestriction(new ParameterRestriction("", this.cbuHubPositionRange, true));
                        }
                    } else {
                        Nal.getLog().nalTraceError(this.getClass(), "Could not find EcPort with prefix " + string2);
                    }
                }
            } else if (string.equals("supportSystemControl")) {
                String string4 = customerParameter.getValue();
                this.supportSystemControl = string4.equals("TRUE");
                try {
                    this.updateEcPortCustomerParameters();
                }
                catch (BemException bemException) {
                    Nal.getLog().nalTrace(1, this.getClass(), "Failed in updateEcPortCustomerParameters()", bemException);
                }
            }
        }
    }

    private boolean isCascadingValueSupport(ArrayList arrayList, ArrayList arrayList2) {
        int n = arrayList.size();
        int n2 = arrayList2.size();
        boolean bl = false;
        boolean bl2 = true;
        for (int i = 0; i < n; ++i) {
            if (arrayList.get(i).equals("0")) continue;
            bl2 = false;
            break;
        }
        Collections.sort(arrayList);
        Collections.sort(arrayList2);
        ArrayList arrayList3 = new ArrayList();
        if (!bl2) {
            for (int i = 0; i < (n < n2 ? n : n2); ++i) {
                if (!arrayList.get(i).equals(arrayList2.get(i)) || arrayList3.contains(arrayList.get(i))) {
                    bl = false;
                    break;
                }
                bl = true;
                arrayList3.add(arrayList.get(i));
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean isDuwV2In6601() throws BemException {
        return DuwUtil.isDualDuwAndPrimaryIsV2() && RbsInfo.RBS_6601W.NAME.equals(this.rbs.getRbsType());
    }

    public String[] getGpsSynchRefLdns(String string) throws BemException {
        String[] stringArray = new String[]{};
        return stringArray;
    }

    public SyncRefInfo[] getGpsSyncRefs(String string) throws BemException {
        SyncRefInfo[] syncRefInfoArray = new SyncRefInfo[]{};
        return syncRefInfoArray;
    }
}

