/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic;

import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.ReconnectDialogProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractSwHandlingRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalProgress;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class JvmRI
extends AbstractSwHandlingRI {
    public static final String name = "JVM";
    static final String[] WIZARD_REPERTOIRE_JVM = new String[]{"RBS_APC_MAIN2", "RBS_OAM_MAIN1"};
    public static final String WIZARD_SWALLOC_ROLE_JVM = "RBS_JVM";
    private static final String[] myInstallationPhases = new String[]{"JvmRestartingPhase"};
    protected MoInstance jvmMoi;
    protected BemMo jvmMo;
    private static final int MAX_ATTEMPTS_WITH_GUI = 10;

    public JvmRI(Rbs rbs, MoInstance moInstance, String string) {
        super(name, rbs, myInstallationPhases);
        int n;
        super.setRoleForSwAllocation(WIZARD_SWALLOC_ROLE_JVM);
        if (string == null) {
            for (n = 0; n < WIZARD_REPERTOIRE_JVM.length; ++n) {
                super.addRepertoiresToInstall(WIZARD_REPERTOIRE_JVM[n]);
            }
        } else {
            super.addRepertoiresToInstall(string);
            for (n = 0; n < WIZARD_REPERTOIRE_JVM.length; ++n) {
                super.addRepertoiresToUninstall(WIZARD_REPERTOIRE_JVM[n]);
            }
        }
        try {
            this.jvmMo = this.getMo(moInstance.getLdn());
        }
        catch (BemException bemException) {
            bemException.printStackTrace();
        }
    }

    public void install(String string) throws BemException {
        if (string.equals("JvmRestartingPhase")) {
            int n;
            this.creatSwAllocationIfNotExisting();
            this.addRepertoireToSwAllocation();
            String[] stringArray = new String[]{"SOAM", "GOAM"};
            boolean bl = false;
            for (n = 0; n < stringArray.length; ++n) {
                if (super.checkIfLoadModuleIsInstalled(stringArray[n])) continue;
                bl = true;
                break;
            }
            if (bl) {
                Integer n2 = null;
                for (int i = 0; i < WIZARD_REPERTOIRE_JVM.length; ++i) {
                    boolean bl2 = false;
                    while (!bl2) {
                        if (this.isInterrupted()) {
                            return;
                        }
                        n2 = super.nonBlockingInstall(WIZARD_REPERTOIRE_JVM[i], this.jvmMo);
                        bl2 = super.waitForInstallationToComplete(n2);
                        if (bl2) continue;
                        this.delay_ms(500);
                    }
                }
            }
            for (n = 0; n < stringArray.length; ++n) {
                this.updateAdmClasspathAttribute(stringArray[n]);
            }
            this.restartJvm();
        }
    }

    private void creatSwAllocationIfNotExisting() throws BemException {
        super.createSwAllocationIfNotExisting();
    }

    private void addRepertoireToSwAllocation() throws BemException {
        super.updateSwAllocation();
    }

    private void updateAdmClasspathAttribute(String string) throws BemException {
        int n;
        Object object;
        BemMo bemMo = null;
        this.setConfigurationVersionMo();
        BemMo bemMo2 = (BemMo)this.configVersionMo.getAttribute("currentUpgradePackage");
        BemMo[] bemMoArray = (BemMo[])bemMo2.getAttribute("loadModuleList");
        if (bemMoArray != null && bemMoArray.length != 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                String string2;
                String string3;
                object = (NalStruct)bemMoArray[i].getAttribute("productData");
                if (object == null) continue;
                try {
                    string3 = (String)object.getMemberValue("productName");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new BemException(noSuchFieldException.getCause());
                }
                if (string3.toUpperCase().indexOf(string) == -1 || !(string2 = (String)bemMoArray[i].getAttribute("loadModuleFilePath")).endsWith(".jar")) continue;
                bemMo = bemMoArray[i];
                break;
            }
        }
        if (bemMo == null) {
            throw new BemException(this.getClass() + "Could not find the " + string + " loadmodule on current UGP !");
        }
        BemMo[] bemMoArray2 = (BemMo[])this.jvmMo.getAttribute("admClasspath");
        object = new BemMo[bemMoArray2.length + 1];
        for (n = 0; n < bemMoArray2.length; ++n) {
            object[n] = bemMoArray2[n];
        }
        object[((Object)object).length - 1] = bemMo;
        BemLog.logNotify("Setting JVM classpath to:");
        for (n = 0; n < ((Object)object).length; ++n) {
            BemLog.logNotify(object[n].getDN());
        }
        this.setAttribute(this.jvmMo, "admClasspath", object);
    }

    private void restartJvm() throws BemException {
        try {
            BemLog.log(6, this.getClass() + "about to restart Jvm");
            final NalTransaction nalTransaction = Nal.getFactory().createTransaction();
            this.jvmMo.action("restart", new NalNameValue[0], nalTransaction);
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        nalTransaction.commit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            Thread thread = new Thread(runnable, "JvmRI restart suicide commitThread " + nalTransaction);
            thread.start();
        }
        catch (Exception exception) {
            BemLog.log(6, this.getClass() + "", exception);
        }
        this.reconnect();
    }

    public String getDisplayName() {
        return name;
    }

    public String getLdn() {
        if (this.jvmMoi != null) {
            try {
                return this.jvmMoi.getLdn();
            }
            catch (BemException bemException) {
                bemException.printStackTrace();
            }
        }
        return null;
    }

    private void reconnect() throws BemException {
        Nal.getLog().nalTrace(3, this.getClass(), "");
        this.rbs.reportProgress("Reonnecting to node after JVM restart");
        final ReconnectDialogProvider reconnectDialogProvider = this.rbs.getReconnectDialogProvider();
        NalProgress nalProgress = null;
        if (reconnectDialogProvider != null) {
            nalProgress = new NalProgress(){

                public void reportProgress(int n, String string) {
                    reconnectDialogProvider.reportReconnectProgress(string);
                }
            };
            reconnectDialogProvider.launchReconnectProgressDialog();
        }
        int n = 1;
        while (true) {
            String string = Nal.getFactory().getHost();
            try {
                Nal.getFactory().reconnectMib(string, nalProgress);
                String string2 = "Done reconnecting to node after JVM restart";
                Nal.getLog().nalTrace(3, this.getClass(), string2);
                this.rbs.reportProgress(string2);
                if (reconnectDialogProvider != null) {
                    reconnectDialogProvider.closeReconnectProgressDialog(string2);
                }
                return;
            }
            catch (NalCmException nalCmException) {
                String string3 = "Failed reconnecting to the node after JVM restart: " + string;
                Nal.getLog().nalTrace(4, this.getClass(), string3 + " Time to retry?");
                if (reconnectDialogProvider == null || n >= 10) {
                    BemException bemException = new BemException(string3 + " after attempt #" + n, (Throwable)nalCmException);
                    bemException.setProperty("Problem", "Failed reconnecting to the node after JVM restart");
                    bemException.setProperty("Additional Info", "Nodes ipAddress=" + string);
                    throw bemException;
                }
                reconnectDialogProvider.reportReconnectProgress(nalCmException.toString() + ", attempt #" + n + " of " + 10);
                ++n;
                continue;
            }
            break;
        }
    }
}

