/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.resource;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.CellAndCarrierCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.CustomParaName;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AntennaSystemProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCarrier;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsLocalCell;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSector;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.ChildWithAttributeValues;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class CarrierRI
extends AbstractResourceItem {
    public static final String name = "Carrier";
    private static final String[] myInstallationPhases = new String[]{"CarrierCreationPhase"};
    private String sectorLdn;
    private String carrierLdn;
    private int sectorNumber;
    private int cellNumber;
    private int numberOfSupportedRxBranches = 2;
    private MoInstance nodeBFunctionMoi;
    private FixedRdnMoi sectorMoi;
    private ChildWithAttributeValues carrierMoi;
    private BemMo rbsLocalCellMo;
    private MoHandler theMoHandler = null;
    private String cellRange;
    private String localCellId;
    private String hsCodeResourceId;
    private String nuOfTxBranchesId;
    private String numOfRxBranchesId;
    private String useCell = "NO";
    private String cellIdentityName;
    private String cellRangeName;
    private String useCellName;
    private String hsCodeResourceIdName;
    private String nuOfTxBranchesName;
    private String numOfRxBranchesName;
    private String txBranchConfiguredName;
    private String txBranchConfigured2Name;
    private static final int BITPOSITION_DEPENDENCY_FAILED = 10;
    private static final int BITPOSITION_DEPENDENCY_LOCKED = 9;
    private static final int BITPOSITION_NOT_INSTALLED = 7;
    private static final int BITPOSITION_DEPENDENCY = 5;
    private static final int BITPOSITION_CELLOFFLINE = 3;
    private static final int BITPOSITION_POWER_OFF = 2;
    private static final int BITPOSITION_FAILED = 1;
    private static final int BITPOSITION_IN_TEST = 0;
    private String DEFAULT_RDN_CARRIER;
    public BemMo carrierMo;
    private String basebandPoolIdName;
    private String baseBandPoolId;
    private CustomParaName customerParameterNames;
    private String downlinkBaseBandPoolRef;

    public CarrierRI(Rbs rbs, int n, int n2, CustomParaName customParaName) throws BemException {
        super(name, rbs, myInstallationPhases);
        this.sectorNumber = n;
        this.cellNumber = n2;
        this.customerParameterNames = customParaName;
        this.theMoHandler = rbs.getMoHandler();
        this.DEFAULT_RDN_CARRIER = "" + this.cellNumber;
        this.createLdn();
        this.initializeRI();
    }

    private void createLdn() throws BemException {
        this.nodeBFunctionMoi = this.rbs.getNodeBFunctionMoi();
        int n = 0;
        if (this.rbs.isPantherHybridRbs() && this.sectorNumber >= 7) {
            n = 1;
        }
        AntennaSystemProvider antennaSystemProvider = this.rbs.getAntennaSystemProvider(n);
        this.sectorLdn = antennaSystemProvider.getSectorLdn(this.sectorNumber);
        BemMo bemMo = this.theMoHandler.getMo(this.sectorLdn);
        String string = bemMo.getId();
        this.sectorMoi = new FixedRdnMoi(this.nodeBFunctionMoi, MimSector.MOTYPENAME, string);
        this.carrierMoi = new ChildWithAttributeValues(this.sectorMoi, MimCarrier.MOTYPENAME, "frequencyPlane", new Integer(this.cellNumber), this.DEFAULT_RDN_CARRIER);
        try {
            this.sectorLdn = this.sectorMoi.getLdn();
            this.carrierLdn = this.carrierMoi.getLdn();
        }
        catch (BemException bemException) {
            throw new BemException("Fail to create Ldn: Sector=" + this.sectorNumber + ", CellNumber=" + this.cellNumber);
        }
    }

    private void initializeRI() throws BemException {
        block3: {
            this.carrierMo = this.theMoHandler.getMo(this.carrierLdn);
            try {
                BemMo[] bemMoArray;
                if (!this.carrierMo.isExisting() || (bemMoArray = (BemMo[])this.theMoHandler.getAttribute(this.carrierMo, "reservedBy")) == null || bemMoArray.length == 0) break block3;
                for (int i = 0; i < bemMoArray.length; ++i) {
                    if (!bemMoArray[i].getType().equals(MimRbsLocalCell.MOTYPENAME)) continue;
                    this.rbsLocalCellMo = bemMoArray[i];
                    break;
                }
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException(moHandlerException.toString());
            }
        }
        this.initializeCustomerParameterName();
    }

    public boolean isInstalled() throws BemException {
        boolean bl = false;
        if (this.carrierMo.isExisting()) {
            bl = true;
        }
        return bl;
    }

    public boolean rbsRuleCheck(String string) throws BemException {
        boolean bl = true;
        if (this.isInstalled() && (this.rbsLocalCellMo == null || !((Object)this.rbsLocalCellMo).toString().equals(string))) {
            bl = false;
        }
        return bl;
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            try {
                this.installCarrier();
            }
            catch (NalCmException nalCmException) {
                throw new BemException("Can not install cellAndCarrierRI at: Sector = " + this.sectorNumber + "Cell Number = " + this.cellNumber);
            }
        }
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("CarrierDeletionPhase")) {
            this.uninstallCarrier();
        }
    }

    private void uninstallCarrier() throws BemException {
        try {
            if (this.carrierMo.isExisting()) {
                this.theMoHandler.delete(this.carrierMo);
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException.toString());
        }
        catch (NalCmException nalCmException) {
            throw new BemException(nalCmException.toString());
        }
    }

    private void installCarrier() throws BemException, NalCmException {
        BemMo bemMo = this.getAvailableCarrierMo();
        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(this.nuOfTxBranchesName);
        CustomerParameter customerParameter2 = this.rbs.getCustomerParameterObject(this.numOfRxBranchesName);
        if (!this.isInstalled() && bemMo != null) {
            this.createCarrierMo(bemMo);
        } else if (customerParameter.hasValueChanged() || customerParameter2.hasValueChanged()) {
            Integer n;
            String string;
            BemMo bemMo2;
            if (customerParameter.hasValueChanged()) {
                bemMo2 = this.theMoHandler.getMo(this.carrierMoi.getLdn());
                string = customerParameter.getValue();
                n = new Integer(string);
                try {
                    this.theMoHandler.setAttribute(bemMo2, "numberOfTxBranches", n);
                }
                catch (MoHandlerException moHandlerException) {
                    throw new BemException(this.sectorNumber + "MoHandlerException: ", (Throwable)moHandlerException);
                }
            }
            if (customerParameter2.hasValueChanged()) {
                bemMo2 = this.theMoHandler.getMo(this.carrierLdn);
                string = customerParameter2.getValue();
                n = new Integer(string);
                try {
                    this.theMoHandler.setAttribute(bemMo2, "numberOfRxBranches", n);
                }
                catch (Exception exception) {
                    throw new BemException("CellAndCarrierRI.installCarrierAndCell()", "installCarrierAndCell()", this.carrierLdn, null, exception);
                }
            }
        } else {
            throw new BemException("Can not install cellAndCarrierRI at: Sector = " + this.sectorNumber + "; Cell Number = " + this.cellNumber);
        }
    }

    public BemMo getAvailableCarrierMo() throws BemException, NalCmException {
        BemMo bemMo = null;
        BemMo bemMo2 = this.theMoHandler.getMo(this.carrierLdn);
        if (!bemMo2.isExisting()) {
            bemMo = bemMo2;
        }
        return bemMo;
    }

    private boolean createCarrierMo(BemMo bemMo) throws BemException {
        try {
            this.setNuOfTxBranchesId(this.rbs.getCustomerParameter(this.nuOfTxBranchesName));
            this.setNumOfRxBranchesId(this.rbs.getCustomerParameter(this.numOfRxBranchesName));
            this.setCellRange(this.rbs.getCustomerParameter(this.cellRangeName));
            this.setCellId(this.rbs.getCustomerParameter(this.cellIdentityName));
            this.setUsedCell(this.rbs.getCustomerParameter(this.useCellName));
            this.setHsCodeResourceId(this.rbs.getCustomerParameter(this.hsCodeResourceIdName));
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("numberOfTxBranches", new Integer(this.nuOfTxBranchesId)));
            vector.add(Nal.getFactory().getNameValue("numberOfRxBranches", new Integer(this.numOfRxBranchesId)));
            vector.add(Nal.getFactory().getNameValue("cellRange", new Integer(this.cellRange)));
            if (this.rbs.getRbsData().isRbs6000()) {
                String string = this.rbs.getRadioEquipmentProvider().getCarrierAllocationMode();
                if (string.equals("Advanced")) {
                    String string2 = this.getDuiDeviceGroupLdn(bemMo);
                    if (!string2.equals("")) {
                        String string3 = string2.equals(DuwUtil.getPrimaryDuiLdn()) ? "ManagedElement=1,Equipment=1,Subrack=1,DownlinkBaseBandPool=1" : "ManagedElement=1,Equipment=1,Subrack=1,DownlinkBaseBandPool=2";
                        vector.add(Nal.getFactory().getNameValue("downlinkBaseBandPoolRef", this.theMoHandler.getMo(string3)));
                    }
                } else if (string.equals("Flexible")) {
                    Object object;
                    String string4 = this.rbs.getCustomerParameter(this.basebandPoolIdName);
                    if (string4 != null && !string4.equals("##UNDEFINED") && !string4.equals("")) {
                        object = "ManagedElement=1,Equipment=1,Subrack=1,DownlinkBaseBandPool=" + string4;
                        vector.add(Nal.getFactory().getNameValue("downlinkBaseBandPoolRef", this.theMoHandler.getMo((String)object)));
                    }
                    object = new int[2];
                    CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(this.txBranchConfiguredName);
                    object[0] = (Integer)customerParameterServer.getValueMom();
                    customerParameterServer = this.rbs.getCustomerParameterServerObject(this.txBranchConfigured2Name);
                    object[1] = (Integer)customerParameterServer.getValueMom();
                    if (object[0] != 0 || object[1] != 0) {
                        NalNameValue nalNameValue = Nal.getFactory().getNameValue("txBranchesConfigured", object);
                        vector.add(nalNameValue);
                    }
                }
            }
            int n = Integer.parseInt(bemMo.getId());
            vector.add(Nal.getFactory().getNameValue("frequencyPlane", new Integer(n)));
            this.theMoHandler.create(bemMo, vector);
            return true;
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("Failed creatRbsLocalCell for sectorNumber=" + this.sectorNumber + "  cellNumber=" + this.cellNumber, (Throwable)moHandlerException);
        }
        catch (Exception exception) {
            throw new BemException("Failed creatRbsLocalCell for sectorNumber=" + this.sectorNumber + "  cellNumber=" + this.cellNumber, (Throwable)exception);
        }
    }

    private String getDuiDeviceGroupLdn(BemMo bemMo) throws BemException {
        String string = "";
        RadioEquipmentProvider radioEquipmentProvider = (RadioEquipmentProvider)this.rbs.getProvider(RadioEquipmentProvider.class);
        int[] nArray = radioEquipmentProvider.getEquippedSectors();
        if (this.rbs.getCustomerParameter("carrierAllocationMode").equals("Advanced")) {
            CellAndCarrierCI cellAndCarrierCI = (CellAndCarrierCI)this.rbs.getCellAndCarrierProvider();
            int n = cellAndCarrierCI.getNumberOfCellsInSector(this.sectorNumber - 1);
            boolean bl = nArray[nArray.length - 1] <= 3 && n == 3;
            int n2 = Integer.parseInt(bemMo.getId());
            string = bl || nArray[nArray.length - 1] > 3 ? (this.sectorNumber > 3 ? DuwUtil.getSecondaryDuiLdn() : (n2 < 3 ? DuwUtil.getPrimaryDuiLdn() : DuwUtil.getSecondaryDuiLdn())) : (n2 == 2 ? DuwUtil.getSecondaryDuiLdn() : DuwUtil.getPrimaryDuiLdn());
        }
        return string;
    }

    private void initializeCustomerParameterName() {
        this.cellIdentityName = this.customerParameterNames.getCellIdentityName(this.sectorNumber, this.cellNumber);
        this.cellRangeName = this.customerParameterNames.getCellRangePseudoName(this.sectorNumber, this.cellNumber);
        this.useCellName = this.customerParameterNames.getUseCellPseudoName(this.sectorNumber, this.cellNumber);
        this.hsCodeResourceIdName = this.customerParameterNames.getHsCodeResourceIdPseudoName(this.sectorNumber, this.cellNumber);
        this.nuOfTxBranchesName = this.customerParameterNames.getNuOfTxBranchesPseudoName(this.sectorNumber, this.cellNumber);
        this.numOfRxBranchesName = this.customerParameterNames.getNumOfRxBranchesPseudoName(this.sectorNumber, this.cellNumber);
        this.basebandPoolIdName = this.customerParameterNames.getBasebandPoolIdPseudoName(this.sectorNumber, this.cellNumber);
        this.txBranchConfiguredName = this.customerParameterNames.getTxBranchConfiguredPseudoName(this.sectorNumber, this.cellNumber);
        this.txBranchConfigured2Name = this.customerParameterNames.getTxBranchConfigured2PseudoName(this.sectorNumber, this.cellNumber);
    }

    public boolean checkMoBitValue(BemMo bemMo, String string, int n) throws BemException {
        boolean bl;
        block6: {
            int n2 = 1;
            bl = false;
            MoHandler moHandler = this.rbs.getMoHandler();
            try {
                if (bemMo != null && bemMo.isExisting()) {
                    Object object = moHandler.getAttribute(bemMo, string);
                    if (object != null) {
                        int n3 = (Integer)object;
                        if (((n3 >>= n) & n2) == 1) {
                            bl = true;
                        }
                        break block6;
                    }
                    throw new BemException("Can not find the attribute" + string);
                }
                throw new BemException("The Mo = null or not existing!!!");
            }
            catch (NalCmException nalCmException) {
                throw new BemException("The Mo is not existing: " + nalCmException);
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException("" + moHandlerException);
            }
        }
        return bl;
    }

    public boolean isCellOffline() throws BemException {
        boolean bl = false;
        int n = 3;
        int[] nArray = new int[]{7, 2, 0, 9, 5, 10, 1, n};
        if (this.isInstalled()) {
            for (int i = 0; i < nArray.length && !(bl = this.checkMoBitValue(this.rbsLocalCellMo, "availabilityStatus", nArray[i])); ++i) {
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public int getSectorNumber() {
        return this.sectorNumber;
    }

    public int getCellNumber() {
        return this.cellNumber;
    }

    public String getCellId() {
        return this.localCellId;
    }

    public void setCellId(String string) {
        this.localCellId = string;
    }

    public String getCellRange() {
        return this.cellRange;
    }

    public void setCellRange(String string) {
        this.cellRange = string;
    }

    public String getNuOfTxBranchesId() {
        return this.nuOfTxBranchesId;
    }

    public String getNumOfRxBranchesId() {
        return this.numOfRxBranchesId;
    }

    public void setNumOfRxBranchesId(String string) {
        this.numOfRxBranchesId = string;
    }

    public void setNuOfTxBranchesId(String string) {
        this.nuOfTxBranchesId = string;
    }

    public String getUsedCell() {
        return this.useCell;
    }

    public void setUsedCell(String string) {
        this.useCell = string;
    }

    public void setHsCodeResourceId(String string) {
        this.hsCodeResourceId = string;
    }

    public String getLdn() {
        return "";
    }

    public int getNumberOfSupportedRxBranches() {
        return this.numberOfSupportedRxBranches;
    }

    public String getSectorLdn() {
        return this.sectorLdn;
    }

    public String getCarrierLdn() {
        return this.carrierLdn;
    }

    public BemMo getRbsLocalCellMo() {
        return this.rbsLocalCellMo;
    }

    public String getDisplayName() {
        return "Carrier:";
    }

    public void getNodeValues() throws BemException {
        String string = "0";
        String string2 = "0";
        int[] nArray = null;
        if (this.isInstalled()) {
            try {
                BemMo bemMo;
                String string3 = "YES";
                BemMo bemMo2 = this.theMoHandler.getMo(this.carrierLdn);
                String string4 = ((Integer)this.theMoHandler.getAttribute(bemMo2, "cellRange")).toString();
                String string5 = ((Integer)this.theMoHandler.getAttribute(bemMo2, "numberOfTxBranches")).toString();
                String string6 = ((Integer)this.theMoHandler.getAttribute(bemMo2, "numberOfRxBranches")).toString();
                if (DuwUtil.hasDuw() && this.rbs.getRbsData().isRbs6000() && (nArray = (int[])this.theMoHandler.getAttribute(bemMo2, "txBranchesConfigured")) != null && nArray.length > 0) {
                    string = String.valueOf(nArray[0]);
                    string2 = String.valueOf(nArray[1]);
                    if (!((Integer)this.theMoHandler.getAttribute(bemMo2, "txBranchConfigured")).equals(MimCarrier.DEFAULT_TXBRANCHCONFIGURED) && nArray[0] == MimCarrier.DEFAULT_TXBRANCHCONFIGURED) {
                        string = ((Integer)this.theMoHandler.getAttribute(bemMo2, "txBranchConfigured")).toString();
                    }
                }
                if ((bemMo = (BemMo)this.theMoHandler.getAttribute(bemMo2, "downlinkBaseBandPoolRef")) != null) {
                    this.setDownlinkBaseBandPoolRef(bemMo.getDN());
                }
                this.setBaseBandPoolId();
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(this.useCellName);
                customerParameterServer.setLoadedValue(string3);
                customerParameterServer = this.rbs.getCustomerParameterServerObject(this.cellRangeName);
                customerParameterServer.setLoadedValue(string4);
                customerParameterServer = this.rbs.getCustomerParameterServerObject(this.nuOfTxBranchesName);
                customerParameterServer.setLoadedValue(string5);
                customerParameterServer = this.rbs.getCustomerParameterServerObject(this.numOfRxBranchesName);
                customerParameterServer.setLoadedValue(string6);
                customerParameterServer = this.rbs.getCustomerParameterServerObject(this.txBranchConfiguredName);
                customerParameterServer.setLoadedValue(string);
                customerParameterServer = this.rbs.getCustomerParameterServerObject(this.txBranchConfigured2Name);
                customerParameterServer.setLoadedValue(string2);
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException(moHandlerException.toString());
            }
        } else {
            throw new BemException("CarrierMO is not installed: Sector = " + this.sectorNumber + " CellNumber = " + this.cellNumber);
        }
    }

    private void setBaseBandPoolId() {
        if (this.downlinkBaseBandPoolRef != null && !this.downlinkBaseBandPoolRef.equals("")) {
            int n = this.downlinkBaseBandPoolRef.lastIndexOf("DownlinkBaseBandPool=");
            this.baseBandPoolId = this.downlinkBaseBandPoolRef.substring(n + 21);
        }
    }

    public String getHsCodeResourceId() {
        return this.hsCodeResourceId;
    }

    private void setDownlinkBaseBandPoolRef(String string) {
        this.downlinkBaseBandPoolRef = string;
    }

    public String getDownlinkBaseBandPoolRef() {
        return this.downlinkBaseBandPoolRef;
    }

    public int[] getSectorConfiguration() throws BemException {
        BemMo bemMo = super.getMo(this.sectorLdn);
        int[] nArray = (int[])super.getAttribute(bemMo, "sectorConfiguration");
        if (nArray != null) {
            return nArray;
        }
        return new int[0];
    }

    public String getBaseBandPoolId() {
        return this.baseBandPoolId;
    }

    public void setRbsLocalCell(String string) {
        if (string != null && string != "") {
            this.rbsLocalCellMo = this.theMoHandler.getMo(string);
        }
    }
}

