/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource;

import java.util.ArrayList;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerSystemUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimBatteryBackup;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;

public class BatteryBackupRI
extends AbstractResourceItem {
    private static final String NAME = "BatteryBackup";
    private static final String[] myInstallationPhases = new String[]{"CommonPowerSystemCreationPhase"};
    private int cabinetNumber;
    private String ldn = null;

    public BatteryBackupRI(Rbs rbs, MoInstance moInstance, int n) throws BemException {
        super(NAME, rbs, myInstallationPhases);
        this.cabinetNumber = n;
        this.setupMoi(moInstance);
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(myInstallationPhases, string)) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            BemMo bemMo = super.getMo(this.ldn);
            boolean bl = bemMo.isExisting();
            String string2 = PrefixUtil.getCabinetPrefix(String.valueOf(this.cabinetNumber));
            Enumeration enumeration = (Enumeration)this.rbs.getCustomerParameterObject(string2 + "batteryType");
            NalNameValue nalNameValue = Nal.getFactory().getNameValue("batteryType", enumeration.getValueMom());
            vector.add(nalNameValue);
            this.addCustomerParameterValueToAttrList("sharedBattery", vector);
            this.addCustomerParameterValueToAttrList("chargingMode", vector);
            this.addCustomerParameterValueToAttrList("testMode", vector);
            TrueFalseCustomerParameter trueFalseCustomerParameter = (TrueFalseCustomerParameter)this.rbs.getCustomerParameterObject(string2 + "sharedBattery");
            Enumeration enumeration2 = (Enumeration)this.rbs.getCustomerParameterObject(string2 + "testMode");
            if ((Integer)enumeration2.getValueMom() == 1) {
                if (trueFalseCustomerParameter.getBooleanValue()) {
                    this.addCustomerParameterValueToAttrList("minimumBackupTime", vector);
                } else {
                    this.addCustomerParameterValueToAttrList("minimumStateOfHealth", vector);
                }
                this.addCustomerParameterValueToAttrList("testStartDay", vector);
                this.addCustomerParameterValueToAttrList("testStartTime", vector);
                this.addTestStartMonthsToAttrList(vector);
            }
            this.addCustomerParameterValueToAttrList("batteryInstallationDate", vector);
            Enumeration enumeration3 = (Enumeration)this.rbs.getCustomerParameterObject(string2 + "chargingMode");
            if ((Integer)enumeration3.getValueMom() == 1) {
                this.addCustomerParameterValueToAttrList("chargingVoltage", vector);
                this.addCustomerParameterValueToAttrList("tempCompVoltageSlope", vector);
                this.addCustomerParameterValueToAttrList("nominalTemp", vector);
                this.addCustomerParameterValueToAttrList("tempCompMinVoltage", vector);
                this.addCustomerParameterValueToAttrList("tempCompMaxVoltage", vector);
                this.addCustomerParameterValueToAttrList("increasedChargeVoltage", vector);
                this.addCustomerParameterValueToAttrList("boostChargeTime", vector);
                this.addCustomerParameterValueToAttrList("boostChargeTriggerVoltage", vector);
                this.addCustomerParameterValueToAttrList("equalizeChargeTime", vector);
                this.addCustomerParameterValueToAttrList("equalizeChargeCyclicInterval", vector);
                this.addCustomerParameterValueToAttrList("intermittentChargeConnectVoltage", vector);
                this.addCustomerParameterValueToAttrList("intermittentChargeConnectTime", vector);
                this.addCustomerParameterValueToAttrList("intermittentChargeDisconnectTime", vector);
            }
            PowerSystemUtil.addControlDomainRef(vector, "controlDomainRef", this.cabinetNumber, this.rbs);
            if (!bl) {
                super.createMoIfNotExisting(this.ldn, vector);
            } else {
                super.setAttributes(bemMo, vector);
            }
        }
    }

    private void addCustomerParameterValueToAttrList(String string, Vector vector) throws BemException {
        String string2 = PrefixUtil.getCabinetPrefix(String.valueOf(this.cabinetNumber));
        CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string2 + string);
        if (customerParameterServer.hasValueChanged()) {
            NalNameValue nalNameValue = null;
            nalNameValue = Nal.getFactory().getNameValue(string, customerParameterServer.getValueMom());
            vector.add(nalNameValue);
        }
    }

    private void addTestStartMonthsToAttrList(Vector vector) throws BemException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String string = PrefixUtil.getCabinetPrefix(String.valueOf(this.cabinetNumber));
        for (int i = 0; i < 12; ++i) {
            int n = i + 1;
            YesNoCustomerParameter yesNoCustomerParameter = (YesNoCustomerParameter)this.rbs.getCustomerParameterServerObject(string + "testStartMonths" + n);
            if (!yesNoCustomerParameter.getValue().equalsIgnoreCase("YES")) continue;
            arrayList.add(new Integer(n));
        }
        if (arrayList.size() > 0) {
            arrayList.trimToSize();
            NalNameValue nalNameValue = Nal.getFactory().getNameValue("testStartMonths", arrayList.toArray(new Integer[0]));
            vector.add(nalNameValue);
        }
    }

    public String getDisplayName() {
        return "BatteryBackup: " + this.getLdn();
    }

    public String getLdn() {
        return this.ldn;
    }

    private void setupMoi(MoInstance moInstance) throws BemException {
        String string = String.valueOf(this.cabinetNumber);
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(moInstance, MimBatteryBackup.MOTYPENAME, string);
        this.ldn = fixedRdnMoi.getLdn();
    }
}

