/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.atm;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.atm.IubOverAtmManager;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVclTp;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class UserDataProtocolStackRI
extends AbstractResourceItem {
    public static final String name = "UserDataProtocolStack";
    private static final String[] myPhases = new String[]{"UserDataProtocolStackCreationPhase"};
    private String atmId;
    private static final String ATM_TRAFFIC_DESCRIPTOR_ID = "C1P3800";
    private Integer ingressAtmPcr = new Integer(3800);
    private Integer egressAtmPcr = new Integer(3800);
    private static final Integer INGRESS_ATM_QOS = new Integer(1);
    private static final Integer EGRESS_ATM_QOS = new Integer(1);
    private static final Integer SERVICE_CATEGORY = new Integer(1);
    private Integer[] atmPcrs;
    private static final String VPC_TP_ID = "1";
    private static final String VPL_TP_ID = "vp1";
    private static final Integer EXTERNAL_VCI = new Integer(39);
    private static final String EXTERNAL_VCL_TP_ID = "vc39";
    private Integer[] vcis;
    private Integer[] aal2Paths;
    private static final String AAL2_PATH_VCC_TP_ID = "ba1";
    private static final String AAL2_QOS_PROFILE_ID = "ad8";
    private static final Integer TIMER_CU = new Integer(10);
    private static final Integer AAL2_PATH_ID = new Integer(25);
    private static final Boolean AAL2_PATH_OWNER = false;

    public UserDataProtocolStackRI(Rbs rbs) {
        super(name, rbs, myPhases);
    }

    private void initialiseMois() throws BemException {
        CustomerParameter[] customerParameterArray = this.rbs.getCustomerParameterObjectsWithPseudo("aal2PathId");
        this.aal2Paths = new Integer[customerParameterArray.length];
        for (int i = 0; i < customerParameterArray.length; ++i) {
            this.aal2Paths[i] = Integer.valueOf(customerParameterArray[i].getValue());
        }
        CustomerParameter[] customerParameterArray2 = this.rbs.getCustomerParameterObjectsWithPseudo("vci");
        this.vcis = new Integer[customerParameterArray2.length];
        for (int i = 0; i < customerParameterArray2.length; ++i) {
            this.vcis[i] = Integer.valueOf(customerParameterArray2[i].getValue());
        }
        CustomerParameter[] customerParameterArray3 = this.rbs.getCustomerParameterObjectsWithPseudo("userDataATMPcr");
        this.atmPcrs = new Integer[customerParameterArray3.length];
        for (int i = 0; i < customerParameterArray3.length; ++i) {
            this.atmPcrs[i] = Integer.valueOf(customerParameterArray3[i].getValue());
        }
        String string = this.rbs.getCustomerParameter("IubNpcTestConfiguration_etbSlot");
        this.atmId = "1-" + string + "-1";
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            this.initialiseMois();
            this.configureMos(ATM_TRAFFIC_DESCRIPTOR_ID);
        }
    }

    private void configureMos(String string) throws BemException {
        String string2 = IubOverAtmManager.getAal2QosProfileLdn(AAL2_QOS_PROFILE_ID);
        BemMo bemMo = this.createAal2QosProfileIfNotExisting(string2);
        String string3 = IubOverAtmManager.getVpcTpLdn(VPL_TP_ID, VPC_TP_ID, this.atmId);
        if (this.aal2Paths.length > 0) {
            for (int i = 0; i < this.aal2Paths.length; ++i) {
                String string4 = IubOverAtmManager.getAtmTrafficDescriptorLdn("C1P" + this.atmPcrs[i]);
                this.ingressAtmPcr = this.atmPcrs[i];
                this.egressAtmPcr = this.atmPcrs[i];
                BemMo bemMo2 = this.configureAtmTrafficDescriptor(string4);
                String string5 = "vc" + this.vcis[i];
                String string6 = string3 + "," + MimVclTp.MOTYPENAME + "=" + string5;
                Vector vector = IubOverAtmManager.getVclTpAttributes(this.vcis[i], bemMo2);
                BemMo bemMo3 = this.getMo(string6);
                this.createMoIfNotExisting(string6, vector);
                String string7 = "ba" + this.aal2Paths[i];
                String string8 = IubOverAtmManager.getAal2PathVccTpLdn(string7);
                this.createAal2PathVccTpIfNotExisting(string8, bemMo3, bemMo, this.aal2Paths[i]);
            }
        } else {
            String string9 = IubOverAtmManager.getAtmTrafficDescriptorLdn(string);
            BemMo bemMo4 = this.configureAtmTrafficDescriptor(string9);
            String string10 = string3 + "," + MimVclTp.MOTYPENAME + "=" + EXTERNAL_VCL_TP_ID;
            Vector vector = IubOverAtmManager.getVclTpAttributes(EXTERNAL_VCI, bemMo4);
            BemMo bemMo5 = this.getMo(string10);
            this.createMoIfNotExisting(string10, vector);
            String string11 = IubOverAtmManager.getAal2PathVccTpLdn(AAL2_PATH_VCC_TP_ID);
            this.createAal2PathVccTpIfNotExisting(string11, bemMo5, bemMo, AAL2_PATH_ID);
        }
    }

    private BemMo configureAtmTrafficDescriptor(String string) throws BemException {
        BemMo bemMo = null;
        bemMo = this.getMo(string);
        boolean bl = bemMo.isExisting();
        if (!bl) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("ingressAtmPcr", this.ingressAtmPcr));
            vector.add(Nal.getFactory().getNameValue("egressAtmPcr", this.egressAtmPcr));
            vector.add(Nal.getFactory().getNameValue("ingressAtmQos", INGRESS_ATM_QOS));
            vector.add(Nal.getFactory().getNameValue("egressAtmQos", EGRESS_ATM_QOS));
            vector.add(Nal.getFactory().getNameValue("serviceCategory", SERVICE_CATEGORY));
            this.create(bemMo, vector);
        }
        return bemMo;
    }

    private BemMo createAal2PathVccTpIfNotExisting(String string, BemMo bemMo, BemMo bemMo2, Integer n) throws BemException {
        BemMo bemMo3 = this.getMo(string);
        boolean bl = this.isExisting(bemMo3);
        if (!bl) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("timerCu", TIMER_CU));
            vector.add(Nal.getFactory().getNameValue("vclTpId", bemMo));
            vector.add(Nal.getFactory().getNameValue("aal2PathId", n));
            vector.add(Nal.getFactory().getNameValue("aal2PathOwner", AAL2_PATH_OWNER));
            vector.add(Nal.getFactory().getNameValue("aal2QoSProfileId", bemMo2));
            this.create(bemMo3, vector);
        }
        return bemMo3;
    }

    private BemMo createAal2QosProfileIfNotExisting(String string) throws BemException {
        BemMo bemMo = this.getMo(string);
        boolean bl = this.isExisting(bemMo);
        if (!bl) {
            Vector vector = new Vector();
            this.create(bemMo, vector);
        }
        return bemMo;
    }

    public String getLdn() {
        return null;
    }

    public String getDisplayName() {
        return name;
    }
}

