/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.ip;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.SubnetMaskParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEthernetSwitch;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpAccessHostEt;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpAccessSctp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpInterface;
import se.ericsson.wcdma.rbs.bem.common.mim.MimReliableProgramUniter;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSctp;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.ReferencedMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class IubOverIpRI
extends AbstractResourceItem {
    public static final String name = "IubOverIp";
    private static final String[] myPhases = new String[]{"IpInterfaceCreationPhase"};
    private MoInstance rpuMoi;
    private MoInstance ethernetInterfaceMoi;
    private MoInstance exchangeTerminalIpMoi;
    private MoInstance ipInterfaceMoi;
    private MoInstance ipAccessHostEtMoi;
    private MoInstance ipAccessSctpMoi;
    private MoInstance sctpMoi;

    public IubOverIpRI(Rbs rbs) {
        super(name, rbs, myPhases);
    }

    private void initialiseMois() {
        this.ipInterfaceMoi = new SingleChildMoi(this.ethernetInterfaceMoi, MimIpInterface.MOTYPENAME, "1");
        MoInstance moInstance = this.rbs.getMoiRefs().getIpSystemMoi();
        this.ipAccessSctpMoi = new SingleChildMoi(moInstance, MimIpAccessSctp.MOTYPENAME, "1");
        this.ipAccessHostEtMoi = new ReferencedMoi(moInstance, MimIpAccessHostEt.MOTYPENAME, "ipInterfaceMoRef", this.ipInterfaceMoi, "1");
        MoInstance moInstance2 = this.rbs.getMoiRefs().getTransportNetworkMoi();
        this.sctpMoi = new SingleChildMoi(moInstance2, MimSctp.MOTYPENAME, "1");
        MoInstance moInstance3 = this.rbs.getMoiRefs().getSwManagementMoi();
        this.rpuMoi = new FixedRdnMoi(moInstance3, MimReliableProgramUniter.MOTYPENAME, "sctp_adm");
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            if (null == this.ethernetInterfaceMoi) {
                throw new BemException("IubOverIp.install(): A valid EthernetPort or GigaBitEthernet could not be found, a possible reason: no Ip Capable board inserted.");
            }
            this.initialiseMois();
            this.installIubOverIp();
        }
    }

    private void installIubOverIp() throws BemException {
        this.createInternalEthernetPort();
        this.createIpInterfaceMo();
        this.createIpAccessHostEtMo();
        this.createIpAccessSctpMo();
        this.createSctpMo();
    }

    private void createInternalEthernetPort() throws BemException {
        if (!DuwUtil.hasDuw()) {
            SingleChildMoi singleChildMoi = new SingleChildMoi(this.exchangeTerminalIpMoi, MimEthernetSwitch.MOTYPENAME, "1");
            BemMo bemMo = this.getMo(this.ethernetInterfaceMoi.getLdn());
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            if (!this.isExisting(bemMo)) {
                BemMo bemMo2 = this.getMo(singleChildMoi.getLdn());
                vector.add(Nal.getFactory().getNameValue("ethernetSwitchRef", bemMo2));
                this.create(bemMo, vector);
            }
        }
    }

    private void createIpAccessSctpMo() throws BemException {
        BemMo bemMo = this.getMo(this.ipAccessSctpMoi.getLdn());
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        BemMo bemMo2 = this.getMo(this.ipAccessHostEtMoi.getLdn());
        vector.add(Nal.getFactory().getNameValue("ipAccessHostEtRef1", bemMo2));
        this.create(bemMo, vector);
    }

    private void createIpInterfaceMo() throws BemException {
        BemMo bemMo = this.getMo(this.ipInterfaceMoi.getLdn());
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        String string = "rps";
        Object object = false;
        vector.add(Nal.getFactory().getNameValue(string, object));
        string = "defaultRouter0";
        object = this.rbs.getCustomerParameter("IpIubTestConfiguration_defaultRouter");
        vector.add(Nal.getFactory().getNameValue(string, object));
        string = "networkPrefixLength";
        SubnetMaskParameter subnetMaskParameter = (SubnetMaskParameter)this.rbs.getCustomerParameterObject("IpIubTestConfiguration_subnetMask");
        object = subnetMaskParameter.getNetworkPrefixLengthValue();
        vector.add(Nal.getFactory().getNameValue(string, object));
        this.create(bemMo, vector);
    }

    private void createIpAccessHostEtMo() throws BemException {
        BemMo bemMo = this.getMo(this.ipAccessHostEtMoi.getLdn());
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        String string = "ipInterfaceMoRef";
        BemMo bemMo2 = this.getMo(this.ipInterfaceMoi.getLdn());
        vector.add(Nal.getFactory().getNameValue(string, bemMo2));
        string = "ipAddress";
        String string2 = this.rbs.getCustomerParameter("IpIubTestConfiguration_etIpAddress");
        vector.add(Nal.getFactory().getNameValue(string, string2));
        this.create(bemMo, vector);
    }

    private void createSctpMo() throws BemException {
        BemMo bemMo = this.getMo(this.sctpMoi.getLdn());
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        String string = "ipAccessSctpRef";
        BemMo bemMo2 = this.getMo(this.ipAccessSctpMoi.getLdn());
        vector.add(Nal.getFactory().getNameValue(string, bemMo2));
        string = "numberOfAssociations";
        Integer n = new Integer(2);
        vector.add(Nal.getFactory().getNameValue(string, n));
        string = "rpuId";
        BemMo bemMo3 = this.getMo(this.rpuMoi.getLdn());
        vector.add(Nal.getFactory().getNameValue(string, bemMo3));
        this.create(bemMo, vector);
    }

    public String getDisplayName() {
        return name;
    }

    public String getLdn() {
        return null;
    }

    public void setEthernetInterfaceMoi(MoInstance moInstance) {
        this.ethernetInterfaceMoi = moInstance;
    }

    public void setEtmBoard(MoInstance moInstance) {
        this.exchangeTerminalIpMoi = moInstance;
    }
}

