/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.networksync;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Set;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.AtmPortProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.PhysicalTerminationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.termination.TerminationData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.GpsOutEnabledParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.provider.GigabitEthernetSyncRefProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.provider.IpSyncRefProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.provider.PacketFrequencySyncRefProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.networksync.EtbSlotParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.networksync.NetworkSyncCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.ControlSystemProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.SyncRefInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.IubUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.BooleanCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.mim.MimGigaBitEthernet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimGpsSyncRef;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpAccessHostEt;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSyncRef;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSystem;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPacketFrequencySyncRef;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTimingUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTuSyncRef;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.LdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceCommon;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class SynchronizationRI
extends AbstractResourceItem
implements CustomerParameterListener {
    public static final String name = "Syncronization";
    private static String[] phases = new String[]{"TuSyncRefCreationPhase", "TuSyncRefDeletionPhase", "NetworkSyncSettingsPhase", "UnlockPhase", "GpsSyncRefCreationPhase", "GpsSyncRefDeletionPhase"};
    public static final String NO_GIVEN_VALUE = "-";
    private static final String ET_BOARD = "ETB";
    private static final String CBU_BOARD = "CBU";
    private static final String DUW_BOARD = "DUW";
    private static final String NO_GIVEN_BOARD = "";
    private static final String CBU_BOARD_IDENTIFIER = ",Cbu=";
    private static final String IP_SYNC_REF_PORT_NULL = "0";
    static final int NO_OF_SYNCS = 8;
    private final String[] LINES_FOR_NO_GIVEN_VALUE = new String[]{"-"};
    private final String ldn;
    private IntegerParameter[] priorityParameters = null;
    private EtbSlotParameter[] slotParameters = null;
    private ParameterRestriction[] slotAllowedRangeRestriction = new ParameterRestriction[8];
    private StringParameter[] boardParameters = null;
    private Enumeration[] portParameters = null;
    private Enumeration[] actionParameters = null;
    private final ControlSystemProvider controlSystemProvider;
    private final PhysicalTerminationProvider physicalTerminationProvider;
    private final AtmPortProvider atmPortProvider;
    private final IpSyncRefProvider ipSyncRefProvider;
    private PacketFrequencySyncRefProvider packetFrequencySyncRefProvider;
    GigabitEthernetSyncRefProvider gigabitEthernetSyncRefProvider;
    private Hashtable slotToBoardMapping = null;
    private Hashtable slotToPortMapping = null;
    private Hashtable currentAllowedRangeForPortRestriction = null;
    private String[] slotsSupportedRange = null;
    private String[] slotsAllowedRange = null;
    private final String[] portsSupportedRange = new String[]{"-", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private ParameterRestriction[] portParameterRestrictions = null;
    private final String[] actionSupportedRange = new String[]{"ADD", "DELETE"};
    private BemMo[] nodeSyncArray = null;
    private int[] nodeSyncPrioArray = null;
    private boolean hasAnyNodeValues = false;
    private final ParameterRestriction readOnlyRestriction = new ParameterRestriction("", 0);
    private final ParameterRestriction boardReadOnlyRestriction = new ParameterRestriction("", 0);
    private final ParameterRestriction restrictionSlotOptional = new ParameterRestriction("", 2);
    private final ParameterRestriction restrictionPortOptional = new ParameterRestriction("", 2);
    private final NetworkSyncCI networkSyncCI;
    private static final int NO_NODE_SYNC = 0;
    public static final String DUW_SYNC_PORT_SIX = "6";
    public static final String DUW_SYNC_PORT_FIVE = "5";
    private BemMo[] syncRefsLoadedValue = null;
    private int[] syncRefPriorityLoadedValue = new int[8];

    public SynchronizationRI(Rbs rbs, NetworkSyncCI networkSyncCI, PhysicalTerminationProvider physicalTerminationProvider, ControlSystemProvider controlSystemProvider, AtmPortProvider atmPortProvider, IpSyncRefProvider ipSyncRefProvider) throws BemException {
        super(name, rbs, phases);
        this.networkSyncCI = networkSyncCI;
        this.physicalTerminationProvider = physicalTerminationProvider;
        this.controlSystemProvider = controlSystemProvider;
        this.atmPortProvider = atmPortProvider;
        this.ipSyncRefProvider = ipSyncRefProvider;
        this.ldn = rbs.getMoiRefs().getSynchronizationMoi().getLdn();
        this.setupSlotsSupportedRange();
        this.setupMappings();
        this.createPortParameterRestrictions();
        this.createCustomerParameters();
        this.setParameterRestrictionsOnAllSlotCustomerParameters();
    }

    public SynchronizationRI(Rbs rbs, NetworkSyncCI networkSyncCI, PhysicalTerminationProvider physicalTerminationProvider, ControlSystemProvider controlSystemProvider, AtmPortProvider atmPortProvider, IpSyncRefProvider ipSyncRefProvider, PacketFrequencySyncRefProvider packetFrequencySyncRefProvider, GigabitEthernetSyncRefProvider gigabitEthernetSyncRefProvider) throws BemException {
        super(name, rbs, phases);
        this.networkSyncCI = networkSyncCI;
        this.physicalTerminationProvider = physicalTerminationProvider;
        this.controlSystemProvider = controlSystemProvider;
        this.atmPortProvider = atmPortProvider;
        this.ipSyncRefProvider = ipSyncRefProvider;
        this.packetFrequencySyncRefProvider = packetFrequencySyncRefProvider;
        this.gigabitEthernetSyncRefProvider = gigabitEthernetSyncRefProvider;
        this.ldn = rbs.getMoiRefs().getSynchronizationMoi().getLdn();
        this.setupSlotsSupportedRange();
        this.setupMappings();
        this.createPortParameterRestrictions();
        this.createCustomerParameters();
        this.setParameterRestrictionsOnAllSlotCustomerParameters();
    }

    void refreshRI() throws BemException {
        this.setupMappings();
        this.setParameterRestrictionsOnAllSlotCustomerParameters();
        boolean bl = false;
        for (int i = 0; i < 8; ++i) {
            String string = this.slotParameters[i].getValue();
            if (string.equals(NO_GIVEN_VALUE)) continue;
            if (!this.isValueInArray(string, this.slotsAllowedRange)) {
                this.slotParameters[i].setValue(NO_GIVEN_VALUE);
                continue;
            }
            String[] stringArray = (String[])this.slotToPortMapping.get(string);
            String string2 = this.portParameters[i].getValue();
            if (!this.isValueInArray(string2, stringArray)) {
                this.slotParameters[i].setValue(NO_GIVEN_VALUE);
                continue;
            }
            bl = true;
            EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
            this.portParameterRestrictions[i].setRange(enumeratedRange, true);
        }
        if (!bl) {
            this.setDefaultValues();
        }
    }

    private void setParameterRestrictionsOnAllSlotCustomerParameters() {
        EnumeratedRange enumeratedRange = new EnumeratedRange(this.slotsAllowedRange);
        ParameterRestriction parameterRestriction = new ParameterRestriction("Depending on allowed slots", enumeratedRange, true);
        parameterRestriction.setRange(enumeratedRange, true);
        for (int i = 0; i < 8; ++i) {
            if (this.slotAllowedRangeRestriction[i] != null) {
                this.slotParameters[i].removeRestriction(this.slotAllowedRangeRestriction[i]);
            }
            this.slotParameters[i].addRestriction(parameterRestriction);
            this.slotAllowedRangeRestriction[i] = parameterRestriction;
        }
    }

    private void createPortParameterRestrictions() {
        this.portParameterRestrictions = new ParameterRestriction[8];
        for (int i = 0; i < 8; ++i) {
            EnumeratedRange enumeratedRange = new EnumeratedRange(this.LINES_FOR_NO_GIVEN_VALUE);
            ParameterRestriction parameterRestriction = new ParameterRestriction("Depending on slot", enumeratedRange, true);
            parameterRestriction.setRange(enumeratedRange, true);
            this.portParameterRestrictions[i] = parameterRestriction;
        }
    }

    private void setupMappings() throws BemException {
        this.createAllMAppingStructures();
        this.setupNoGivenValueMappings();
        this.setupTubMappings();
        if (DuwUtil.hasDuw()) {
            this.setupDuwMappings();
        } else {
            this.setupEtbAndCbuMappings();
        }
        this.setupIpEtbMappings();
        this.setupSlotsAllowedRange();
    }

    private void setupDuwMappings() throws BemException {
        String[] stringArray = this.physicalTerminationProvider.getConfiguredPhysTermSlots();
        String[] stringArray2 = this.getDuwSlotsFromCabinet();
        String string = DUW_BOARD;
        if ((stringArray = this.mergeStringArraysRemoveDuplicates(stringArray, stringArray2)) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String[] stringArray3 = this.physicalTerminationProvider.getConfiguredSynchPorts(string2);
                stringArray3 = this.addGpsLines(stringArray3, string2);
                this.slotToBoardMapping.put(string2, string);
                stringArray3 = this.sortAndAddNoGivenValue(stringArray3);
                this.slotToPortMapping.put(string2, stringArray3);
            }
        }
    }

    private String[] getDuwSlotsFromCabinet() throws BemException {
        String[] stringArray = new String[]{};
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = this.controlSystemProvider.getSlotsWithTuSynchRef();
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                String string = stringArray2[i];
                if (!this.isDuwSlot(string)) continue;
                arrayList.add(string);
            }
        }
        if (arrayList.size() > 0) {
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    private boolean isDuwSlot(String string) throws BemException {
        boolean bl = false;
        if (DuwUtil.hasDuw() && !this.isCbuSlot(string)) {
            bl = true;
        }
        return bl;
    }

    private void setupSlotsSupportedRange() throws BemException {
        int n = this.rbs.getHubSubrackNoOfSlots();
        this.slotsSupportedRange = new String[n + 1];
        this.slotsSupportedRange[0] = NO_GIVEN_VALUE;
        for (int i = 1; i <= n; ++i) {
            this.slotsSupportedRange[i] = NO_GIVEN_BOARD + i;
        }
    }

    private void setupSlotsAllowedRange() {
        ArrayList arrayList = this.getSortedAllowedSlots();
        this.slotsAllowedRange = arrayList.toArray(new String[0]);
    }

    private ArrayList getSortedAllowedSlots() {
        Set set = this.slotToPortMapping.keySet();
        int n = set.size();
        String[] stringArray = set.toArray(new String[0]);
        ArrayList arrayList = new ArrayList(n);
        this.addAllValues(arrayList, stringArray);
        Collections.sort(arrayList, new ComboBoxComparator());
        return arrayList;
    }

    private void addAllValues(ArrayList arrayList, String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                arrayList.add(string);
            }
        }
    }

    private void createCustomerParameters() throws BemException {
        int n;
        this.priorityParameters = new IntegerParameter[8];
        this.slotParameters = new EtbSlotParameter[8];
        this.boardParameters = new StringParameter[8];
        this.portParameters = new Enumeration[8];
        this.actionParameters = new Enumeration[8];
        Integer n2 = null;
        String string = null;
        for (n = 0; n < 8; ++n) {
            n2 = new Integer(n + 1);
            string = MessageFormat.format("Y_{0}_", n2);
            String string2 = string + "synchPriority";
            int n3 = n + 1;
            this.priorityParameters[n] = new IntegerParameter(string2, new IntegerRange(n3, n3));
            this.priorityParameters[n].setLoadedValue(NO_GIVEN_BOARD + n3);
            String string3 = string + "synchSlot";
            this.slotParameters[n] = new EtbSlotParameter(string3, this.slotsSupportedRange);
            this.slotParameters[n].setValue(NO_GIVEN_VALUE);
            this.slotParameters[n].setLoadedValue(NO_GIVEN_VALUE);
            string3 = string + "synchGuiBoard";
            StringRange stringRange = new StringRange(new Integer(1), new Integer(3));
            this.boardParameters[n] = new StringParameter(string3, stringRange);
            this.boardParameters[n].setLoadedValue(NO_GIVEN_BOARD);
            string3 = string + "synchPort";
            this.portParameters[n] = new Enumeration(string3, this.portsSupportedRange);
            this.portParameters[n].setValue(NO_GIVEN_VALUE);
            this.portParameters[n].setLoadedValue(NO_GIVEN_VALUE);
            this.portParameters[n].addRestriction(this.portParameterRestrictions[n]);
            string3 = string + "action";
            this.actionParameters[n] = new Enumeration(string3, this.actionSupportedRange);
        }
        this.hasAnyNodeValues = this.initiateCPWithNodeValues();
        if (!this.hasAnyNodeValues) {
            this.setDefaultValues();
        }
        for (n = 0; n < 8; ++n) {
            this.networkSyncCI.addParameter(this.priorityParameters[n]);
            this.priorityParameters[n].addRestriction(this.readOnlyRestriction);
            this.networkSyncCI.addParameter(this.slotParameters[n]);
            this.slotParameters[n].addRestriction(this.restrictionSlotOptional);
            this.slotParameters[n].addCustomerParameterListener(this);
            this.networkSyncCI.addParameter(this.boardParameters[n]);
            this.boardParameters[n].addRestriction(this.boardReadOnlyRestriction);
            this.networkSyncCI.addParameter(this.portParameters[n]);
            this.portParameters[n].addRestriction(this.restrictionPortOptional);
            this.networkSyncCI.addParameter(this.actionParameters[n]);
        }
    }

    private void setDefaultValues() throws BemException {
        String string;
        Object object;
        Object object2;
        String string2;
        String[] stringArray;
        boolean bl = false;
        String string3 = this.rbs.getRbsStep();
        if (string3.equals("STEP_CABINET") || string3.equals("STEP_SITE") || string3.equals("STEP_EXPANSION")) {
            return;
        }
        if (this.rbs.getRbsData().isRbs6000() && this.rbs.isParameterSupported("gpsOutEnabled") && (stringArray = (String[])this.rbs.getCustomerParameterObject("gpsOutEnabled")).getBooleanValue()) {
            return;
        }
        if (!bl) {
            TerminationData terminationData = this.atmPortProvider.getIpOverAtmLinkTerminationData(0);
            String string4 = terminationData.getSlotNumber();
            string2 = NO_GIVEN_BOARD;
            object2 = "";
            object2 = DuwUtil.hasDuw() ? DUW_BOARD : ET_BOARD;
            if (string4 != null) {
                String[] stringArray2 = terminationData.getLineNumbers();
                object = stringArray2[0];
                string2 = string4 + (String)object;
                bl = true;
                this.setDefaultValue(string4, (String)object, 0, "1", (String)object2);
            }
            if ((object = this.atmPortProvider.getIpOverAtmLinkTerminationData(1)) != null && (string = ((TerminationData)object).getSlotNumber()) != null) {
                String[] stringArray3 = ((TerminationData)object).getLineNumbers();
                String string5 = stringArray3[0];
                String string6 = string + string5;
                if (!string2.equals(string6)) {
                    bl = true;
                    this.setDefaultValue(string, string5, 1, "2", (String)object2);
                }
            }
        }
        if (!bl && this.ipSyncRefProvider != null && (stringArray = this.ipSyncRefProvider.getAvailableIpSynRefSlots()) != null && stringArray.length > 0) {
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                object2 = this.ipSyncRefProvider.getIpSyncRefs(string2);
                for (int j = 0; j < ((SyncRefInfo[])object2).length; ++j) {
                    object = String.valueOf(object2[j].port);
                    bl = true;
                    this.setDefaultValue(string2, (String)object, n, String.valueOf(n + 1), object2[j].boardName);
                    ++n;
                }
            }
        }
        if (!bl && DuwUtil.hasDuw() && this.packetFrequencySyncRefProvider != null && (stringArray = this.packetFrequencySyncRefProvider.getAvailablePacketFrequencySyncRefSlots()) != null && stringArray.length > 0) {
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                object2 = this.packetFrequencySyncRefProvider.getPacketFrequencySyncRefs(string2);
                for (int j = 0; j < ((SyncRefInfo[])object2).length; ++j) {
                    object = String.valueOf(object2[j].port);
                    bl = true;
                    this.setDefaultValue(string2, (String)object, n, String.valueOf(n + 1), object2[j].boardName);
                    ++n;
                }
            }
        }
        if (!bl && (stringArray = this.controlSystemProvider.getSlotsWithTuSynchRef()) != null && stringArray.length > 0) {
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                object2 = this.controlSystemProvider.getTuSyncRefs(string2);
                for (int j = 0; j < ((SyncRefInfo[])object2).length; ++j) {
                    bl = true;
                    object = String.valueOf(n + 1);
                    string = String.valueOf(object2[j].port);
                    this.setDefaultValue(string2, string, n, (String)object, object2[j].boardName);
                    ++n;
                }
            }
        }
        if (!bl && this.gigabitEthernetSyncRefProvider != null && (stringArray = this.gigabitEthernetSyncRefProvider.getAvailableGigabitEthernetSyncRefSlots()) != null && stringArray.length > 0) {
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                object2 = ServiceCommon.DUWV2_SYNCE_PORT;
                bl = true;
                this.setDefaultValue(string2, (String)object2, n, String.valueOf(n + 1), DUW_BOARD);
                ++n;
            }
        }
    }

    private void setDefaultValue(String string, String string2, int n, String string3, String string4) {
        this.slotParameters[n].setValue(string);
        this.setPortRange(string3);
        this.portParameters[n].setValue(string2);
        this.boardParameters[n].setLoadedValue(string4);
    }

    private boolean initiateCPWithNodeValues() throws BemException {
        boolean bl = false;
        BemMo bemMo = this.getMo(this.ldn);
        this.nodeSyncArray = (BemMo[])this.getAttribute(bemMo, "syncReference");
        int[] nArray = (int[])this.getAttribute(bemMo, "useReceivedQl");
        int[] nArray2 = (int[])this.getAttribute(bemMo, "adminQuality");
        this.nodeSyncPrioArray = (int[])this.getAttribute(bemMo, "syncRefPriority");
        if (this.nodeSyncPrioArray != null && this.nodeSyncArray != null && this.nodeSyncPrioArray.length > 0) {
            this.syncRefsLoadedValue = this.nodeSyncArray;
            for (int i = 0; i < this.nodeSyncPrioArray.length; ++i) {
                if (this.nodeSyncPrioArray[i] == 0) continue;
                this.syncRefPriorityLoadedValue[i] = this.nodeSyncPrioArray[i];
                BemMo bemMo2 = this.nodeSyncArray[i];
                if (bemMo2 != null) {
                    bl = true;
                    String string = bemMo2.getDN();
                    if (BemUtil.isLdnOfType(string, MimIpSyncRef.MOTYPENAME) && IubUtil.isDualStackNode()) continue;
                    if (BemUtil.isLdnOfType(string, MimGigaBitEthernet.MOTYPENAME) && nArray2 != null) {
                        Enumeration enumeration;
                        boolean bl2;
                        boolean bl3 = bl2 = nArray2[i] != 16;
                        if (bl2) {
                            enumeration = (YesNoCustomerParameter)this.rbs.getCustomerParameterObject("emscSupport");
                            ((YesNoCustomerParameter)enumeration).setLoadedValue("TRUE");
                        }
                        enumeration = (Enumeration)this.rbs.getCustomerParameterObject("useReceivedQl");
                        enumeration.setLoadedValue(new Integer(nArray[i]));
                        Enumeration enumeration2 = (Enumeration)this.rbs.getCustomerParameterObject("adminQuality");
                        enumeration2.setLoadedValue(new Integer(nArray2[i]));
                    }
                }
                int n = this.nodeSyncPrioArray[i];
                this.setCPForNodeValue(n, this.nodeSyncArray[i]);
            }
        }
        return bl;
    }

    private void setCPForNodeValue(int n, BemMo bemMo) throws BemException {
        String string = bemMo.getDN();
        String string2 = this.getSlotForLdn(string);
        String string3 = null;
        String string4 = null;
        SyncRefInfo[] syncRefInfoArray = null;
        SyncRefInfo syncRefInfo = null;
        boolean bl = false;
        syncRefInfoArray = this.controlSystemProvider.getTuSyncRefs(string2);
        syncRefInfo = this.findSyncRef(string, syncRefInfoArray);
        if (syncRefInfo != null) {
            string4 = syncRefInfo.boardName;
            string3 = String.valueOf(syncRefInfo.port);
            bl = true;
        }
        if (!bl) {
            if (this.ipSyncRefProvider != null) {
                syncRefInfoArray = this.ipSyncRefProvider.getIpSyncRefs(string2);
                syncRefInfo = this.findSyncRef(string, syncRefInfoArray);
                if (syncRefInfo != null) {
                    string4 = syncRefInfo.boardName;
                    string3 = String.valueOf(syncRefInfo.port);
                    bl = true;
                } else if (DuwUtil.hasDuw() && this.canBeTolerableErrorIpSyncRef(string)) {
                    string4 = DUW_BOARD;
                    string3 = IP_SYNC_REF_PORT_NULL;
                    bl = true;
                }
            } else if (BemUtil.isLdnOfType(string, MimIpSyncRef.MOTYPENAME)) {
                string4 = DuwUtil.hasDuw() ? DUW_BOARD : ET_BOARD;
                string3 = BemUtil.getRdn(string);
                bl = true;
            }
            if (DuwUtil.hasDuw() && this.packetFrequencySyncRefProvider != null) {
                syncRefInfoArray = this.packetFrequencySyncRefProvider.getPacketFrequencySyncRefs(string2);
                syncRefInfo = this.findSyncRef(string, syncRefInfoArray);
                if (syncRefInfo != null) {
                    string4 = syncRefInfo.boardName;
                    string3 = String.valueOf(syncRefInfo.port);
                    bl = true;
                }
            } else if (BemUtil.isLdnOfType(string, MimPacketFrequencySyncRef.MOTYPENAME)) {
                string4 = DuwUtil.hasDuw() ? DUW_BOARD : ET_BOARD;
                string3 = BemUtil.getRdn(string);
                bl = true;
            }
            if (this.gigabitEthernetSyncRefProvider != null) {
                syncRefInfoArray = this.gigabitEthernetSyncRefProvider.getGigabitEthernetSyncRefs(string2);
                syncRefInfo = this.findSyncRef(string, syncRefInfoArray);
                if (syncRefInfo != null) {
                    string4 = syncRefInfo.boardName;
                    string3 = String.valueOf(syncRefInfo.port);
                    bl = true;
                }
            } else if (BemUtil.isLdnOfType(string, MimGigaBitEthernet.MOTYPENAME)) {
                string4 = DuwUtil.hasDuw() ? DUW_BOARD : ET_BOARD;
                string3 = ServiceCommon.DUWV2_SYNCE_PORT;
                bl = true;
            }
        }
        if (!bl && BemUtil.isLdnOfType(string, MimGpsSyncRef.MOTYPENAME)) {
            string4 = DuwUtil.hasDuw() ? DUW_BOARD : CBU_BOARD;
            string3 = DUW_SYNC_PORT_FIVE;
            bl = true;
        }
        if (!bl && this.physicalTerminationProvider.isCbuBoard(string2)) {
            string4 = CBU_BOARD;
            string3 = this.physicalTerminationProvider.getConfiguredLine(string);
            bl = true;
        }
        if (!bl) {
            string4 = DuwUtil.hasDuw() ? DUW_BOARD : ET_BOARD;
            String string5 = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminal=1,Os155SpiTtp";
            if (string.startsWith(string5) && DuwUtil.hasDuw()) {
                string3 = "9";
                string = this.physicalTerminationProvider.getConfiguredPhysTermLdn(string2, "9");
            } else {
                string3 = this.physicalTerminationProvider.getConfiguredLine(string);
            }
            if (string3 == null) {
                string3 = "1";
            }
        }
        this.verifyNodeValues(string2, string4, string3, string);
        this.setLoadedValues(n, string2, string4, string3);
    }

    private boolean canBeTolerableErrorIpSyncRef(String string) throws BemException {
        int n;
        String[] stringArray = new String[6];
        for (n = 0; n < 6; ++n) {
            stringArray[n] = this.getIpSyncRefLdn(NO_GIVEN_BOARD + (n + 1));
        }
        if (DuwUtil.hasDuw()) {
            for (n = 0; n < stringArray.length; ++n) {
                if (!string.equalsIgnoreCase(stringArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    private SyncRefInfo findSyncRef(String string, SyncRefInfo[] syncRefInfoArray) {
        for (int i = 0; i < syncRefInfoArray.length; ++i) {
            if (!syncRefInfoArray[i].ldn.equals(string)) continue;
            return syncRefInfoArray[i];
        }
        return null;
    }

    private boolean isCbuSlot(String string) throws BemException {
        int n;
        String string2;
        String[] stringArray;
        boolean bl = false;
        String[] stringArray2 = this.controlSystemProvider.getSlotsWithTuSynchRef();
        boolean bl2 = false;
        if (stringArray2 != null && this.isValueInArray(string, stringArray2)) {
            bl2 = true;
        }
        if (bl2 && (stringArray = this.controlSystemProvider.getTuSynchRefLdns(string)) != null && stringArray.length > 0 && (string2 = stringArray[0]) != null && (n = string2.indexOf(CBU_BOARD_IDENTIFIER)) != -1) {
            bl = true;
        }
        return bl;
    }

    private boolean isValueInArray(String string, String[] stringArray) {
        boolean bl = false;
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private String[] mergeArrays(String[] stringArray, String[] stringArray2) {
        int n;
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n] = stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[stringArray.length + n] = stringArray2[n];
        }
        return stringArray3;
    }

    private void verifyNodeValues(String string, String string2, String string3, String string4) throws BemException {
        if (string == null || string3 == null || string2 == null) {
            String string5 = NO_GIVEN_BOARD;
            if (string == null) {
                string5 = string5 + "slot ";
            }
            if (string2 == null) {
                string5 = string5 + "board ";
            }
            if (string3 == null) {
                string5 = string5 + "port ";
            }
            throw new BemException("Can not obtain " + string5 + "for reference " + string4);
        }
    }

    private void setLoadedValues(int n, String string, String string2, String string3) {
        int n2 = n - 1;
        this.slotParameters[n2].setLoadedValue(string);
        String string4 = String.valueOf(n);
        this.setPortRange(string4);
        this.boardParameters[n2].setLoadedValue(string2);
        this.portParameters[n2].setLoadedValue(string3);
    }

    private void setupNoGivenValueMappings() {
        this.slotToBoardMapping.put(NO_GIVEN_VALUE, NO_GIVEN_BOARD);
        this.slotToPortMapping.put(NO_GIVEN_VALUE, this.LINES_FOR_NO_GIVEN_VALUE);
    }

    private void setupTubMappings() throws BemException {
        String[] stringArray = this.controlSystemProvider.getSlotsWithTuSynchRef();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                SyncRefInfo[] syncRefInfoArray = this.controlSystemProvider.getTuSyncRefs(stringArray[i]);
                String[] stringArray2 = this.getPorts(syncRefInfoArray);
                String string = NO_GIVEN_BOARD;
                if (syncRefInfoArray.length > 0) {
                    string = syncRefInfoArray[0].boardName;
                }
                stringArray2 = this.sortAndAddNoGivenValue(stringArray2);
                this.slotToPortMapping.put(stringArray[i], stringArray2);
                this.slotToBoardMapping.put(stringArray[i], string);
            }
        }
    }

    private String[] getPorts(SyncRefInfo[] syncRefInfoArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < syncRefInfoArray.length; ++i) {
            arrayList.add(String.valueOf(syncRefInfoArray[i].port));
        }
        return arrayList.toArray(new String[0]);
    }

    private String[] getCbuSlotsFromCabinet() throws BemException {
        String[] stringArray = new String[]{};
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = this.controlSystemProvider.getSlotsWithTuSynchRef();
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                String string = stringArray2[i];
                if (!this.isCbuSlot(string)) continue;
                arrayList.add(string);
            }
        }
        if (arrayList.size() > 0) {
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    private String[] sortAndAddNoGivenValue(String[] stringArray) {
        int n = stringArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(stringArray[i]);
        }
        Collections.sort(arrayList, new ComboBoxComparator());
        String[] stringArray2 = new String[n + 1];
        stringArray2[0] = NO_GIVEN_VALUE;
        for (int i = 0; i < n; ++i) {
            stringArray2[i + 1] = (String)arrayList.get(i);
        }
        return stringArray2;
    }

    private void setupEtbAndCbuMappings() throws BemException {
        String[] stringArray = this.physicalTerminationProvider.getConfiguredPhysTermSlots();
        String[] stringArray2 = this.getCbuSlotsFromCabinet();
        if ((stringArray = this.mergeStringArraysRemoveDuplicates(stringArray, stringArray2)) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = ET_BOARD;
                String string2 = stringArray[i];
                String[] stringArray3 = this.physicalTerminationProvider.getConfiguredSynchPorts(string2);
                if (this.physicalTerminationProvider.isCbuBoard(string2) || this.isCbuSlot(string2)) {
                    string = CBU_BOARD;
                    stringArray3 = this.addGpsLines(stringArray3, string2);
                }
                this.slotToBoardMapping.put(string2, string);
                stringArray3 = this.sortAndAddNoGivenValue(stringArray3);
                this.slotToPortMapping.put(string2, stringArray3);
            }
        }
    }

    private void setupIpEtbMappings() throws BemException {
        String[] stringArray;
        String string;
        String[] stringArray2;
        Object[] objectArray;
        Object object;
        int n;
        String[] stringArray3;
        if (this.ipSyncRefProvider != null && (stringArray3 = this.ipSyncRefProvider.getAvailableIpSynRefSlots()) != null) {
            for (n = 0; n < stringArray3.length; ++n) {
                object = stringArray3[n];
                objectArray = this.ipSyncRefProvider.getIpSyncRefs((String)object);
                if (objectArray.length == 0) continue;
                stringArray2 = this.getPorts((SyncRefInfo[])objectArray);
                string = objectArray[0].boardName;
                stringArray = (String[])this.slotToPortMapping.get(object);
                if (stringArray != null) {
                    stringArray2 = this.mergeArrays(stringArray2, stringArray);
                }
                this.slotToBoardMapping.put(object, string);
                stringArray2 = this.sortAndAddNoGivenValue(stringArray2);
                this.slotToPortMapping.put(object, stringArray2);
            }
        }
        if (DuwUtil.hasDuw() && this.packetFrequencySyncRefProvider != null && (stringArray3 = this.packetFrequencySyncRefProvider.getAvailablePacketFrequencySyncRefSlots()) != null) {
            for (n = 0; n < stringArray3.length; ++n) {
                object = stringArray3[n];
                objectArray = this.packetFrequencySyncRefProvider.getPacketFrequencySyncRefs((String)object);
                if (objectArray.length == 0) continue;
                stringArray2 = this.getPorts((SyncRefInfo[])objectArray);
                string = objectArray[0].boardName;
                stringArray = (String[])this.slotToPortMapping.get(object);
                if (stringArray != null) {
                    stringArray2 = this.mergeArrays(stringArray2, stringArray);
                }
                this.slotToBoardMapping.put(object, string);
                stringArray2 = this.sortAndAddNoGivenValue(stringArray2);
                this.slotToPortMapping.put(object, stringArray2);
            }
        }
        if (this.gigabitEthernetSyncRefProvider != null && (stringArray3 = this.gigabitEthernetSyncRefProvider.getAvailableGigabitEthernetSyncRefSlots()) != null && stringArray3.length > 0) {
            String string2 = DUW_BOARD;
            this.slotToBoardMapping.put(stringArray3[0], string2);
            object = new String[]{ServiceCommon.DUWV2_SYNCE_PORT};
            objectArray = (String[])this.slotToPortMapping.get(stringArray3[0]);
            if (objectArray != null) {
                object = this.mergeArrays((String[])object, (String[])objectArray);
            }
            object = this.sortAndAddNoGivenValue((String[])object);
            this.slotToPortMapping.put(stringArray3[0], object);
        }
    }

    private String[] mergeStringArraysRemoveDuplicates(String[] stringArray, String[] stringArray2) {
        int n;
        String[] stringArray3 = new String[]{};
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            if (this.isExistingInArrayList(stringArray2[n], arrayList)) continue;
            arrayList.add(stringArray2[n]);
        }
        if (arrayList.size() > 0) {
            stringArray3 = arrayList.toArray(stringArray3);
        }
        return stringArray3;
    }

    private boolean isExistingInArrayList(String string, ArrayList arrayList) {
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private String[] addGpsLines(String[] stringArray, String string) throws BemException {
        String[] stringArray2;
        block10: {
            block9: {
                boolean bl;
                if (stringArray == null) {
                    stringArray = new String[]{};
                }
                stringArray2 = stringArray;
                if (!DuwUtil.hasDuw() || !this.rbs.getRbsData().isRbs6000()) break block9;
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject("absoluteTimeSynchEnabled");
                GpsOutEnabledParameter gpsOutEnabledParameter = (GpsOutEnabledParameter)this.rbs.getCustomerParameterObject("gpsOutEnabled");
                boolean bl2 = customerParameter.getValue().equals("YES");
                boolean bl3 = bl = !gpsOutEnabledParameter.getBooleanValue();
                if (!bl) break block10;
                if (bl2) {
                    int n = stringArray2.length;
                    stringArray2 = new String[n + 1];
                    stringArray2[0] = DUW_SYNC_PORT_FIVE;
                    for (int i = 0; i < n; ++i) {
                        stringArray2[i + 1] = stringArray[i];
                    }
                } else {
                    int n = stringArray2.length;
                    stringArray2 = new String[n + 2];
                    stringArray2[0] = DUW_SYNC_PORT_FIVE;
                    stringArray2[1] = DUW_SYNC_PORT_SIX;
                    for (int i = 0; i < n; ++i) {
                        stringArray2[i + 2] = stringArray[i];
                    }
                }
                break block10;
            }
            if (DuwUtil.hasDuw()) {
                int n = stringArray2.length;
                stringArray2 = new String[n + 2];
                stringArray2[0] = DUW_SYNC_PORT_FIVE;
                stringArray2[1] = DUW_SYNC_PORT_SIX;
                for (int i = 0; i < n; ++i) {
                    stringArray2[i + 2] = stringArray[i];
                }
            } else {
                int n = stringArray2.length;
                stringArray2 = new String[n + 1];
                stringArray2[0] = DUW_SYNC_PORT_FIVE;
                for (int i = 0; i < n; ++i) {
                    stringArray2[i + 1] = stringArray[i];
                }
            }
        }
        return stringArray2;
    }

    public boolean isInstalled() throws BemException {
        return true;
    }

    boolean shouldRiBeInstalled() throws BemException {
        Object object;
        Object object2;
        boolean bl = false;
        String string = this.rbs.getRbsStep();
        if (!(string.equals("STEP_CABINET") || string.equals("STEP_SITE") || string.equals("STEP_INT_SITE"))) {
            object2 = this.getChangedPriorities();
            boolean bl2 = false;
            if (DuwUtil.hasDuw()) {
                CustomerParameter customerParameter = this.getCustomerParameter("IPoverGigabitEthernet_{0}_syncServerType", 7);
                object = this.getCustomerParameter("IPoverGigabitEthernet_{0}_syncServerType", 8);
                boolean bl3 = bl2 = customerParameter.hasValueChanged() || object.hasValueChanged();
            }
            if (((Object)object2).length > 0 || bl2) {
                bl = true;
            }
        }
        if (this.rbs.isParameterSupported("gpsOutEnabled") && ((CustomerParameterImpl)(object2 = (GpsOutEnabledParameter)this.rbs.getCustomerParameterObject("gpsOutEnabled"))).hasValueChanged() && !((BooleanCustomerParameter)object2).getBooleanValue()) {
            bl = true;
        }
        if (string.equals("STEP_EXPANSION")) {
            object2 = null;
            String string2 = null;
            for (int i = 0; i < NetworkSyncCI.getNumberOfSyncs(); ++i) {
                object2 = Integer.valueOf(String.valueOf(i + 1));
                string2 = MessageFormat.format("Y_{0}_", object2);
                object = this.rbs.getCustomerParameter(string2 + "action");
                String string3 = this.rbs.getCustomerParameter(string2 + "synchPort");
                if (((String)object).equals("ADD") && !string3.equals(NO_GIVEN_VALUE)) {
                    bl = true;
                    break;
                }
                if (!((String)object).equals("DELETE")) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    boolean shouldRiBeUninstalled() throws BemException {
        Comparable comparable;
        boolean bl = false;
        if (this.rbs.isParameterSupported("gpsOutEnabled") && (comparable = (GpsOutEnabledParameter)this.rbs.getCustomerParameterObject("gpsOutEnabled")).hasValueChanged() && comparable.getBooleanValue()) {
            bl = true;
        }
        comparable = null;
        String string = null;
        String string2 = this.rbs.getRbsStep();
        for (int i = 0; i < NetworkSyncCI.getNumberOfSyncs(); ++i) {
            Object object;
            comparable = Integer.valueOf(String.valueOf(i + 1));
            string = MessageFormat.format("Y_{0}_", comparable);
            if (string2.equals("STEP_OAM") && this.rbs.isParameterSupported(string + "synchPort") && ((object = this.rbs.getCustomerParameterObject(string + "synchPort")).getValue().equalsIgnoreCase(String.valueOf(DUW_SYNC_PORT_SIX)) || object.getValue().equalsIgnoreCase(String.valueOf(DUW_SYNC_PORT_FIVE)))) {
                bl = true;
            }
            if (!string2.equals("STEP_EXPANSION")) continue;
            object = this.rbs.getCustomerParameter(string + "action");
            if (!((String)object).equals("DELETE")) {
                if (!((String)object).equals("ADD")) continue;
            }
            bl = true;
        }
        return bl;
    }

    private String[] getChangedPriorities() throws BemException {
        String[] stringArray = new String[]{};
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 8; ++i) {
            if (!this.slotParameters[i].hasValueChanged() && !this.portParameters[i].hasValueChanged()) continue;
            String string = NO_GIVEN_BOARD + (i + 1);
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    private String[] getAllPrioritiesWithTerminations() {
        String[] stringArray = new String[]{};
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 8; ++i) {
            String string = this.slotParameters[i].getValue();
            if (string.equals(NO_GIVEN_VALUE)) continue;
            String string2 = NO_GIVEN_BOARD + (i + 1);
            arrayList.add(string2);
        }
        if (arrayList.size() > 0) {
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public void install(String string) throws BemException {
        if (string.equals("TuSyncRefCreationPhase")) {
            this.createTuSyncRefMoIfNeeded();
        } else if (string.equals("GpsSyncRefCreationPhase")) {
            this.createGpsSyncRefMoIfNeeded();
        } else if (string.equals("NetworkSyncSettingsPhase")) {
            this.installAllSyncRefs();
        } else if (string.equals("UnlockPhase")) {
            this.unlockAllSyncRefs();
        }
    }

    private void createTuSyncRefMoIfNeeded() throws BemException {
        String string;
        Integer n = null;
        String string2 = null;
        String string3 = this.rbs.getRbsStep();
        BemMo bemMo = this.rbs.getMoHandler().getMo("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,Cbu=1");
        if (bemMo.isExisting() && (string = this.getTuSynchRefLdnsOnFirstSlot()) != null) {
            super.createMoIfNotExisting(string);
        }
        if (DuwUtil.hasDuw()) {
            for (int i = 0; i < NetworkSyncCI.getNumberOfSyncs(); ++i) {
                String string4;
                n = Integer.valueOf(String.valueOf(i + 1));
                string2 = MessageFormat.format("Y_{0}_", n);
                if (!this.rbs.isParameterSupported(string2 + "synchPort")) continue;
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string2 + "synchPort");
                CustomerParameter customerParameter2 = this.rbs.getCustomerParameterObject(string2 + "action");
                if (!customerParameter.getValue().equalsIgnoreCase(String.valueOf(DUW_SYNC_PORT_SIX))) continue;
                if (string3.equals("STEP_EXPANSION")) {
                    if (customerParameter2.getValue().equals("DELETE")) continue;
                }
                if ((string4 = this.getTuSynchRefLdnsOnFirstSlot()) == null) continue;
                super.createMoIfNotExisting(string4);
            }
        }
    }

    private void createGpsSyncRefMoIfNeeded() throws BemException {
        Integer n = null;
        String string = null;
        String string2 = this.rbs.getRbsStep();
        if (DuwUtil.hasDuw()) {
            for (int i = 0; i < NetworkSyncCI.getNumberOfSyncs(); ++i) {
                String string3;
                n = Integer.valueOf(String.valueOf(i + 1));
                string = MessageFormat.format("Y_{0}_", n);
                if (!this.rbs.isParameterSupported(string + "synchPort")) continue;
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string + "synchPort");
                CustomerParameter customerParameter2 = this.rbs.getCustomerParameterObject(string + "action");
                if (!customerParameter.getValue().equalsIgnoreCase(String.valueOf(DUW_SYNC_PORT_FIVE))) continue;
                if (string2.equals("STEP_EXPANSION")) {
                    if (customerParameter2.getValue().equals("DELETE")) continue;
                }
                if ((string3 = this.getGpsSynchRefLdnsOnFirstSlot()) == null) continue;
                super.createMoIfNotExisting(string3);
            }
        }
    }

    public void uninstall(String string) throws BemException {
        String string2;
        if (string.equals("TuSyncRefDeletionPhase")) {
            this.removeSyncRefResources(MimTuSyncRef.MOTYPENAME);
            string2 = this.getTuSynchRefLdnsOnFirstSlot();
            if (string2 != null) {
                super.deleteMoIfNotExisting(string2);
            }
        }
        if (string.equals("GpsSyncRefDeletionPhase")) {
            this.removeSyncRefResources(MimGpsSyncRef.MOTYPENAME);
            string2 = this.getGpsSynchRefLdnsOnFirstSlot();
            if (string2 != null) {
                super.deleteMoIfNotExisting(string2);
            }
        }
    }

    private BemMo getFirstDuwTimingUnitMOs() throws BemException {
        BemMo bemMo = null;
        MoInstance moInstance = this.rbs.getMoiRefs().getHubSubrackMoi();
        BemMo bemMo2 = this.getMo(moInstance.getLdn());
        BemMo[] bemMoArray = this.getChildren(bemMo2, 4, MimTimingUnit.MOTYPENAME, NO_GIVEN_BOARD);
        for (int i = 0; i < bemMoArray.length; ++i) {
            if (bemMoArray[i].getDN().indexOf("Slot=1") == -1) continue;
            bemMo = bemMoArray[i];
        }
        return bemMo;
    }

    private String getTuSynchRefLdnsOnFirstSlot() throws BemException {
        BemMo bemMo = this.getFirstDuwTimingUnitMOs();
        String string = null;
        if (bemMo != null) {
            LdnMoi ldnMoi = new LdnMoi(bemMo.getDN());
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(ldnMoi, MimTuSyncRef.MOTYPENAME, String.valueOf(1));
            string = fixedRdnMoi.getLdn();
        }
        return string;
    }

    private String getGpsSynchRefLdnsOnFirstSlot() throws BemException {
        BemMo bemMo = this.getFirstDuwTimingUnitMOs();
        String string = null;
        if (bemMo != null) {
            LdnMoi ldnMoi = new LdnMoi(bemMo.getDN());
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(ldnMoi, MimGpsSyncRef.MOTYPENAME, String.valueOf(1));
            string = fixedRdnMoi.getLdn();
        }
        return string;
    }

    private void unlockAllSyncRefs() throws BemException {
        String[] stringArray = this.getAllPrioritiesWithTerminations();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2 = stringArray[i];
            String string3 = this.getSyncRefLdn(string2);
            BemMo bemMo = this.getMo(string3);
            Integer n = (Integer)this.getAttribute(bemMo, string = "administrativeState");
            if (n == null || n != 0) continue;
            this.setAttribute(bemMo, string, (Object)new Integer(1));
        }
    }

    private void installAllSyncRefs() throws BemException {
        this.removeSyncRefResources();
        this.addSyncRefResources();
    }

    private void removeSyncRefResources() throws BemException {
        if (!this.hasAnyNodeValues) {
            return;
        }
        BemMo bemMo = this.getMo(this.ldn);
        this.nodeSyncArray = (BemMo[])this.getAttribute(bemMo, "syncReference");
        this.nodeSyncPrioArray = (int[])this.getAttribute(bemMo, "syncRefPriority");
        int n = this.nodeSyncArray.length;
        int n2 = this.nodeSyncPrioArray.length;
        for (int i = 0; i < 8 && i < n && i < n2; ++i) {
            if (this.nodeSyncPrioArray[i] == 0) continue;
            NalNameValue nalNameValue = Nal.getFactory().getNameValue("syncReference", this.nodeSyncArray[i]);
            this.action(bemMo, "removeSyncRefResource", new NalNameValue[]{nalNameValue});
        }
    }

    private void removeSyncRefResources(String string) throws BemException {
        if (!this.hasAnyNodeValues) {
            return;
        }
        BemMo bemMo = this.getMo(this.ldn);
        int n = this.nodeSyncArray.length;
        int n2 = this.nodeSyncPrioArray.length;
        for (int i = 0; i < 8 && i < n && i < n2; ++i) {
            BemMo bemMo2;
            if (this.nodeSyncPrioArray[i] == 0 || (bemMo2 = this.nodeSyncArray[i]).getDN() == null || !BemUtil.isLdnOfType(bemMo2.getDN(), string)) continue;
            NalNameValue nalNameValue = Nal.getFactory().getNameValue("syncReference", bemMo2);
            this.action(bemMo, "removeSyncRefResource", new NalNameValue[]{nalNameValue});
            break;
        }
    }

    private void addSyncRefResources() throws BemException {
        String[] stringArray = this.getAllPrioritiesWithTerminations();
        for (int i = 0; i < stringArray.length; ++i) {
            YesNoCustomerParameter yesNoCustomerParameter;
            String string = stringArray[i];
            String string2 = this.getSyncRefLdn(string);
            BemMo bemMo = this.getMo(string2);
            NalNameValue nalNameValue = Nal.getFactory().getNameValue("syncReference", bemMo);
            Integer n = new Integer(string);
            NalNameValue nalNameValue2 = Nal.getFactory().getNameValue("syncPriority", n);
            NalNameValue[] nalNameValueArray = new NalNameValue[]{nalNameValue, nalNameValue2};
            BemMo bemMo2 = this.getMo(this.ldn);
            if (string2.indexOf(MimGigaBitEthernet.MOTYPENAME) > -1 && (yesNoCustomerParameter = (YesNoCustomerParameter)this.getRbs().getCustomerParameterObject("emscSupport")).getBooleanValue()) {
                Enumeration enumeration = (Enumeration)this.getRbs().getCustomerParameterObject("useReceivedQl");
                Enumeration enumeration2 = (Enumeration)this.getRbs().getCustomerParameterObject("adminQuality");
                NalNameValue[] nalNameValueArray2 = new NalNameValue[]{nalNameValue, nalNameValue2, Nal.getFactory().getNameValue("useReceivedQl", enumeration.getValueMom()), Nal.getFactory().getNameValue("adminQuality", enumeration2.getValueMom())};
                this.action(bemMo2, "addSyncRefResourceQl", nalNameValueArray2);
                continue;
            }
            this.action(bemMo2, "addSyncRefResource", nalNameValueArray);
        }
        if (this.isRestoreNeeded()) {
            this.restoreIpSyncRefs();
        }
    }

    private boolean isRestoreNeeded() throws BemException {
        String[] stringArray = this.getAllPrioritiesWithTerminations();
        block0: for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = 0;
            while (true) {
                int n2;
                boolean bl;
                if (n >= 8) continue block0;
                if (this.isIpSyncRefsConfigured(n) && this.canBeTolerableErrorIpSyncRef(this.syncRefsLoadedValue[n].getDN()) && (bl = string.equalsIgnoreCase(String.valueOf(n2 = this.syncRefPriorityLoadedValue[n])))) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private void restoreIpSyncRefs() throws BemException {
        int n = 0;
        while (true) {
            if (n >= 8) break;
            NalNameValue[] nalNameValueArray = null;
            BemMo bemMo = this.getMo(this.ldn);
            if (this.isIpSyncRefsConfigured(n) && this.canBeTolerableErrorIpSyncRef(this.syncRefsLoadedValue[n].getDN())) {
                int n2 = this.syncRefPriorityLoadedValue[n];
                NalNameValue nalNameValue = Nal.getFactory().getNameValue("syncReference", this.syncRefsLoadedValue[n]);
                Integer n3 = new Integer(n2);
                NalNameValue nalNameValue2 = Nal.getFactory().getNameValue("syncPriority", n3);
                nalNameValueArray = new NalNameValue[]{nalNameValue, nalNameValue2};
                this.action(bemMo, "addSyncRefResource", nalNameValueArray);
            }
            ++n;
        }
    }

    private String getSyncRefLdn(String string) throws BemException {
        String string2 = null;
        int n = Integer.parseInt(string) - 1;
        String string3 = this.slotParameters[n].getValue();
        String string4 = this.boardParameters[n].getValue();
        String string5 = this.portParameters[n].getValue();
        SyncRefInfo[] syncRefInfoArray = null;
        syncRefInfoArray = this.controlSystemProvider.getTuSyncRefs(string3);
        if (syncRefInfoArray.length > 0) {
            string2 = this.findLdn(string5, syncRefInfoArray);
        }
        if (string2 == null && DuwUtil.hasDuw() && (syncRefInfoArray = this.controlSystemProvider.getGpsSyncRefs(string3)).length > 0) {
            string2 = this.findLdn(string5, syncRefInfoArray);
        }
        int n2 = Integer.parseInt(string5);
        CustomerParameter customerParameter = null;
        if (n2 == 7 || n2 == 8) {
            customerParameter = this.getCustomerParameter("IPoverGigabitEthernet_{0}_syncServerType", n2);
            if (string2 == null && this.ipSyncRefProvider != null && (syncRefInfoArray = this.ipSyncRefProvider.getIpSyncRefs(string3)).length > 0 && customerParameter != null && customerParameter.getValue().equals("NTP")) {
                string2 = this.findLdn(string5, syncRefInfoArray);
            }
            if (string2 == null && DuwUtil.hasDuw() && this.packetFrequencySyncRefProvider != null && (syncRefInfoArray = this.packetFrequencySyncRefProvider.getPacketFrequencySyncRefs(string3)).length > 0 && customerParameter != null && customerParameter.getValue().equals("PTP")) {
                string2 = this.findLdn(string5, syncRefInfoArray);
            }
        } else if (string2 == null && this.ipSyncRefProvider != null && (syncRefInfoArray = this.ipSyncRefProvider.getIpSyncRefs(string3)).length > 0) {
            string2 = this.findLdn(string5, syncRefInfoArray);
        }
        if (string2 == null && this.gigabitEthernetSyncRefProvider != null && (syncRefInfoArray = this.gigabitEthernetSyncRefProvider.getGigabitEthernetSyncRefs(string3)).length > 0) {
            string2 = this.findLdn(string5, syncRefInfoArray);
        }
        if (string2 == null) {
            string2 = string4.equals(CBU_BOARD) ? this.physicalTerminationProvider.getConfiguredPhysTermLdn(string3, string5) : this.physicalTerminationProvider.getConfiguredSynchPhysTermLdn(string3, string5);
        }
        if (string2 == null) {
            throw new BemException("SynchronizationRI.getSyncRefLdn() can not obtain ref for slot=" + string3 + " port=" + string5);
        }
        return string2;
    }

    private String findLdn(String string, SyncRefInfo[] syncRefInfoArray) {
        int n = Integer.parseInt(string);
        for (int i = 0; i < syncRefInfoArray.length; ++i) {
            if (syncRefInfoArray[i].port != n) continue;
            return syncRefInfoArray[i].ldn;
        }
        return null;
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return name;
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (parameterEvent.isValueChanged()) {
            String string = customerParameter.getName();
            String string2 = NO_GIVEN_BOARD;
            int n = "Y_".length();
            string2 = string.substring(n, n + 1);
            this.setPortValueToNoGivenValue(string2);
            this.setPortRange(string2);
            this.setBoardValue(string2);
        }
    }

    private void setPortValueToNoGivenValue(String string) {
        int n = Integer.parseInt(string) - 1;
        this.portParameters[n].setValue(NO_GIVEN_VALUE);
    }

    private void setPortRange(String string) {
        int n = Integer.parseInt(string) - 1;
        String string2 = this.slotParameters[n].getValue();
        String[] stringArray = (String[])this.slotToPortMapping.get(string2);
        if (stringArray == null) {
            stringArray = (String[])this.slotToPortMapping.get(NO_GIVEN_VALUE);
        }
        EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
        this.portParameterRestrictions[n].setRange(enumeratedRange, true);
    }

    private void setBoardValue(String string) {
        int n = Integer.parseInt(string) - 1;
        String string2 = this.slotParameters[n].getValue();
        String string3 = (String)this.slotToBoardMapping.get(string2);
        if (string3 == null) {
            string3 = NO_GIVEN_BOARD;
        }
        this.boardParameters[n].setLoadedValue(string3);
    }

    void checkConsistency() throws BemException {
        String[] stringArray = new String[]{null, null, null, null, null, null, null, null};
        boolean bl = false;
        for (int i = 0; i < 8; ++i) {
            String string = NO_GIVEN_BOARD + (i + 1);
            String string2 = this.slotParameters[i].getValue();
            String string3 = this.portParameters[i].getValue();
            if (string2.equals(NO_GIVEN_VALUE)) continue;
            if (string3.equals(NO_GIVEN_VALUE)) {
                throw new BemException("Slot number " + string2 + " is set for priority " + string + " but no port is set");
            }
            bl = true;
            String string4 = string2 + string3;
            for (int j = 0; j < 8; ++j) {
                if (stringArray[j] == null) continue;
                if (stringArray[j].equals(string4)) {
                    throw new BemException("This combination of slot and port is already used\nslot=" + string2 + "  port=" + string3 + "  (found for priority=" + string + ")" + "\nEach combination of slot and port for a board must be unique");
                }
                if (string3.equalsIgnoreCase(DUW_SYNC_PORT_FIVE) && stringArray[j].endsWith(DUW_SYNC_PORT_SIX)) {
                    throw new BemException("When other priority's port choose 6(TuSyncRef),+ the current port can't choose 5(GpsSyncRef).+ TuSyncRef can't co-exist with GpsSyncRef");
                }
                if (!string3.equalsIgnoreCase(DUW_SYNC_PORT_SIX) || !stringArray[j].endsWith(DUW_SYNC_PORT_FIVE)) continue;
                throw new BemException("When other priority's port can't choose 5(GpsSyncRef), the current port can't choose 6(TuSyncRef). TuSyncRef can't co-exist with GpsSyncRef");
            }
            stringArray[i] = string4;
        }
        if (!bl) {
            this.setDefaultValues();
        }
    }

    private boolean isIpSyncRefsConfigured(int n) {
        return this.syncRefsLoadedValue != null && this.syncRefsLoadedValue[n] != null && this.syncRefsLoadedValue[n].getDN() != null;
    }

    private void createAllMAppingStructures() {
        this.slotToBoardMapping = new Hashtable();
        this.slotToPortMapping = new Hashtable();
        this.currentAllowedRangeForPortRestriction = new Hashtable();
    }

    private String getSlotForLdn(String string) throws BemException {
        String string2;
        Object object;
        String string3 = null;
        if (this.ipSyncRefProvider != null) {
            string3 = this.ipSyncRefProvider.getSlotForSyncRefLdn(string);
        }
        if (string3 == null && DuwUtil.hasDuw() && this.packetFrequencySyncRefProvider != null) {
            string3 = this.packetFrequencySyncRefProvider.getSlotForPtpSyncRefLdn(string);
        }
        if (string.indexOf(MimIpAccessHostEt.MOTYPENAME) != -1) {
            object = BemUtil.extractLdn(string, MimIpAccessHostEt.MOTYPENAME);
            BemMo bemMo = super.getMo((String)object);
            BemMo bemMo2 = (BemMo)bemMo.getAttribute("ipInterfaceMoRef");
            String string4 = bemMo2.getDN();
            string2 = BemUtil.extractLdn(string4, MimSlot.MOTYPENAME);
            if (string2 == NO_GIVEN_BOARD) {
                BemMo bemMo3 = (BemMo)bemMo2.getAttribute("ipAccessHostEtRef");
                BemMo bemMo4 = (BemMo)bemMo3.getAttribute("ipInterfaceMoRef");
                String string5 = bemMo4.getDN();
                string2 = BemUtil.extractLdn(string5, MimSlot.MOTYPENAME);
            }
        } else if (string.indexOf(MimPacketFrequencySyncRef.MOTYPENAME) != -1) {
            object = super.getMo(string);
            BemMo bemMo = (BemMo)object.getAttribute("ipAccessHostEtRef");
            BemMo bemMo5 = (BemMo)bemMo.getAttribute("ipInterfaceMoRef");
            String string6 = bemMo5.getDN();
            string2 = BemUtil.extractLdn(string6, MimSlot.MOTYPENAME);
        } else {
            string2 = BemUtil.extractLdn(string, MimSlot.MOTYPENAME);
        }
        if (!BemUtil.isLdnOfType(string2, MimSlot.MOTYPENAME)) {
            object = new ExceptionProperties();
            ((ExceptionProperties)object).setProperty("Exception message header", "Reference Error!");
            ((ExceptionProperties)object).setProperty("Problem", "Failed while loading old values from node");
            ((ExceptionProperties)object).setProperty("Problem, Low Level", "Failed to extract slot from LDN");
            ((ExceptionProperties)object).setProperty("ManagedObject", string);
            ((ExceptionProperties)object).setProperty("Additional Info", "LDN is not of type Slot, slotLdn=" + string2);
            ((ExceptionProperties)object).setProperty("ResourceItem  (RI)", "SynchronizationRI");
            ((ExceptionProperties)object).setProperty("Failing Method", "SynchronizationRI.getSlotForLdn()");
            throw new BemException("Reference Error!", (ExceptionProperties)object);
        }
        string3 = BemUtil.getRdn(string2);
        return string3;
    }

    Hashtable getSlotToBoardMapping() {
        return this.slotToBoardMapping;
    }

    Hashtable getSlotToPortMapping() {
        return this.slotToPortMapping;
    }

    Hashtable getCurrentAllowedRangeForPortRestriction() {
        return this.currentAllowedRangeForPortRestriction;
    }

    String[] getSlotsAllowedRange() {
        return this.slotsAllowedRange;
    }

    private CustomerParameter getCustomerParameter(String string, int n) throws BemException {
        String string2 = MessageFormat.format(string, new Integer(n));
        return this.rbs.getCustomerParameterObject(string2);
    }

    private String getIpSyncRefLdn(String string) throws BemException {
        String string2 = string;
        RootMoi rootMoi = new RootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimIpSystem.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimIpAccessHostEt.MOTYPENAME, "1");
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(singleChildMoi2, MimIpSyncRef.MOTYPENAME, string2);
        String string3 = fixedRdnMoi.getLdn();
        return string3;
    }

    static class ComboBoxComparator
    implements Comparator {
        ComboBoxComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = -1;
            try {
                String string = (String)object;
                String string2 = (String)object2;
                if (string.equals(SynchronizationRI.NO_GIVEN_VALUE)) {
                    n = -1;
                } else if (string2.equals(SynchronizationRI.NO_GIVEN_VALUE)) {
                    n = 1;
                } else {
                    int n2;
                    int n3 = Integer.parseInt(string);
                    if (n3 < (n2 = Integer.parseInt(string2))) {
                        n = -1;
                    }
                    n = n3 > n2 ? 1 : 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return n;
        }
    }
}

