/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.DigitalCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.XcuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class DuwXcuResourceManager {
    private static final int ELECTRICAL_DELAY_NOT_USED = -1;
    private Rbs rbs;
    private XcuRI[] xcu;
    private DigitalCableRI[] duwXcuDigitalCable;
    private String[] duwPiuLdn;

    public DuwXcuResourceManager(Rbs rbs, int n) throws BemException {
        this.rbs = rbs;
        this.xcu = new XcuRI[n];
        this.duwXcuDigitalCable = new DigitalCableRI[n];
        this.duwPiuLdn = new String[n];
        this.storeDuwPiuLdns();
        this.createResourceItems();
    }

    private void createResourceItems() throws BemException {
        for (int i = 0; i < this.xcu.length; ++i) {
            this.xcu[i] = new XcuRI(this.rbs, i, this.getDuwPiuLdn(i));
            this.duwXcuDigitalCable[i] = new DigitalCableRI(this.rbs, this.getDuwPiuLdn(i), 9, this.xcu[i].getLdn(), 1, -1);
        }
    }

    private void storeDuwPiuLdns() throws BemException {
        if (this.duwPiuLdn.length > 0) {
            this.duwPiuLdn[0] = DuwUtil.getPrimaryDuwPiuLdn();
        }
        if (this.duwPiuLdn.length > 1) {
            this.duwPiuLdn[1] = DuwUtil.getSecondaryDuwPiuLdn();
        }
    }

    public XcuRI getXcuRI(int n) {
        XcuRI xcuRI = null;
        if (n < this.xcu.length) {
            xcuRI = this.xcu[n];
        }
        return xcuRI;
    }

    public DigitalCableRI getDuwXcuDigitalCableRI(int n) {
        DigitalCableRI digitalCableRI = null;
        if (n < this.duwXcuDigitalCable.length) {
            digitalCableRI = this.duwXcuDigitalCable[n];
        }
        return digitalCableRI;
    }

    public List getResourceItems(int n) {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        if (n < this.xcu.length) {
            arrayList.add(this.getXcuRI(n));
            arrayList.add(this.getDuwXcuDigitalCableRI(n));
        }
        return arrayList;
    }

    public String getDuwPiuLdn(int n) {
        String string = null;
        if (n < this.duwPiuLdn.length) {
            string = this.duwPiuLdn[n];
        }
        return string;
    }
}

